/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.utils;

import io.swagger.annotations.Api;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassScannerUtil {
    public static void main(String[] args) {
        Set<Class<?>> classes = ClassScannerUtil.getAnnotationClasses("com.dtyunxi.yundt.**.api", Api.class);
        System.out.println(classes.size());
        for (Class<?> cClass : classes) {
            System.out.println(cClass.getSimpleName());
        }
    }

    public static Set<Class<?>> getAnnotationClasses(String pack, Class annotationClass) {
        int position = pack.indexOf(".*");
        Set<Class<?>> classes = null;
        if (position > 0) {
            String searchPack = pack.substring(0, position);
            String matchPack = pack.substring(pack.lastIndexOf("*") + 1);
            classes = ClassScannerUtil.getClasses(searchPack);
            if (classes != null && classes.size() > 0) {
                Iterator<Class<?>> iterator = classes.iterator();
                while (iterator.hasNext()) {
                    Class<?> tClass = iterator.next();
                    if (tClass.getName().substring(0, tClass.getName().lastIndexOf(".")).contains(matchPack)) continue;
                    iterator.remove();
                }
            }
        } else {
            classes = ClassScannerUtil.getClasses(pack);
        }
        if (classes != null && classes.size() > 0) {
            Iterator<Class<?>> iterator = classes.iterator();
            while (iterator.hasNext()) {
                Class<?> tClass = iterator.next();
                if (tClass.getAnnotation(annotationClass) != null) continue;
                iterator.remove();
            }
        }
        return classes;
    }

    public static Set<Class<?>> getClasses(String pack) {
        LinkedHashSet classes = new LinkedHashSet();
        boolean recursive = true;
        String packageName = pack;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ClassScannerUtil.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            if ("AppStartedListener".equals(className)) continue;
                            classes.add(Class.forName(packageName + '.' + className));
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, Set<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                ClassScannerUtil.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

