/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.api.dto.enums;

import org.apache.commons.lang3.StringUtils;

public enum CurrencyEnum {
    RMB(0, "\u4eba\u6c11\u5e01", "CNY"),
    MY(1, "\u7f8e\u5143", "USD"),
    RY(2, "\u65e5\u5143", "JPY"),
    OY(3, "\u6b27\u5143", "EUR"),
    YB(4, "\u82f1\u9551", "GBP"),
    AY(5, "\u6fb3\u5143", "AUD"),
    GY(6, "\u6e2f\u5143", "HKD"),
    AMY(7, "\u6fb3\u95e8\u5143", "MOP");

    private Integer type;
    private String desc;
    private String abbreviation;

    private CurrencyEnum(Integer type, String desc, String abbreviation) {
        this.type = type;
        this.desc = desc;
        this.abbreviation = abbreviation;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public static Integer getTypeByAbbreviation(String abbreviation) {
        if (StringUtils.isNotBlank((CharSequence)abbreviation)) {
            for (CurrencyEnum value : CurrencyEnum.values()) {
                if (!value.getAbbreviation().equals(abbreviation)) continue;
                return value.getType();
            }
        }
        return null;
    }

    public static String getAbbreviationByType(Integer type) {
        if (type != null) {
            for (CurrencyEnum b : CurrencyEnum.values()) {
                if (!b.getType().equals(type)) continue;
                return b.getAbbreviation();
            }
        }
        return null;
    }

    public static String getNameByType(Integer type) {
        if (type != null) {
            for (CurrencyEnum b : CurrencyEnum.values()) {
                if (!b.getType().equals(type)) continue;
                return b.getDesc();
            }
        }
        return null;
    }

    public static Integer getTypeByName(String name) {
        if (name != null) {
            for (CurrencyEnum b : CurrencyEnum.values()) {
                if (!b.getDesc().equals(name)) continue;
                return b.getType();
            }
        }
        return -1;
    }
}

