/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.adapter;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerReqExtDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IPcpCustomerExtService;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractPcpCustomerExtServiceImpl
implements IPcpCustomerExtService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPcpCustomerExtServiceImpl.class);
    @Resource
    private CustomerDas customerDas;

    @Override
    public void updateCustomer(CustomerReqDto reqDto) {
        logger.info("PCP\u66f4\u65b0\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (ObjectUtil.isEmpty((Object)reqDto) || ObjectUtil.isEmpty((Object)reqDto.getId())) {
            throw new BizException("-1", "\u53c2\u6570\u8bf7\u6c42\u6709\u8bef\uff0cID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CustomerEo customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(reqDto.getId());
        AssertUtil.isTrue((boolean)ObjectUtil.isNotEmpty((Object)customerEo), (String)("\u627e\u4e0d\u5230\u5ba2\u6237\u4fe1\u606f\uff1a" + reqDto.getId()));
        CustomerEo updateEo = new CustomerEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)updateEo);
        updateEo.setId(customerEo.getId());
        this.customerDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveCustomer(CustomerReqExtDto reqDto) {
        this.verificationParams(reqDto);
        CustomerEo eo = new CustomerEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)eo);
        if (reqDto.getId() != null && reqDto.getId() > 0L) {
            CustomerEo customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(reqDto.getId());
            if (customerEo == null) {
                throw new BizException("\u7f16\u8f91\u6240\u4f20\u5ba2\u6237id\u4e0d\u6b63\u786e");
            }
            eo.setEasCode(eo.getCode());
            this.customerDas.updateSelective((BaseEo)eo);
        } else {
            Integer count = ((ExtQueryChainWrapper)this.customerDas.filter().eq((Object)"code", (Object)reqDto.getCode())).count();
            if (count != null && count >= 1) {
                throw new BizException("\u5ba2\u6237\u7f16\u53f7\u91cd\u590d");
            }
            eo.setType(Integer.valueOf(2));
            eo.setAuditStatus("AUDIT_PASS");
            eo.setEasCode(eo.getCode());
            this.customerDas.insert((BaseEo)eo);
            reqDto.setId(eo.getId());
        }
        return reqDto.getId();
    }

    @Override
    public CustomerRespDto queryById(Long id) {
        CustomerEo customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(id);
        CustomerRespDto dto = new CustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)customerEo, (BaseVo)dto);
        return dto;
    }

    private void verificationParams(CustomerReqExtDto reqDto) {
        if (StringUtils.isBlank((CharSequence)reqDto.getCode())) {
            throw new BizException("\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqDto.getCode().length() > 50) {
            throw new BizException("\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u8d85\u8fc750\u5b57\u7b26");
        }
        if (StringUtils.isBlank((CharSequence)reqDto.getName())) {
            throw new BizException("\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqDto.getName().length() > 50) {
            throw new BizException("\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc750\u5b57\u7b26");
        }
        if (reqDto.getFinancialPrint() == null) {
            throw new BizException("\u662f\u5426\u6253\u5370\u91d1\u989d\u8054\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqDto.getReportsPrint() == null) {
            throw new BizException("\u662f\u5426\u6253\u5370\u8d28\u68c0\u62a5\u9ad8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqDto.getReportsPrint() == null) {
            throw new BizException("\u662f\u5426\u6253\u5370\u8d28\u68c0\u62a5\u544a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqDto.getExtraMaterial() == null) {
            throw new BizException("\u662f\u5426\u6709\u989d\u5916\u8d44\u6599\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

