/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.mkld;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerChannelReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerChannelRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.adapter.AbstractCustomerChannelServiceImpl;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerChannelDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerChannelEo;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="mkld_ICustomerChannelService")
public class MkldCustomerChannelServiceImpl
extends AbstractCustomerChannelServiceImpl {
    @Resource
    private CustomerChannelDas customerChannelDas;

    @Override
    public PageInfo<CustomerChannelRespDto> queryByPage(CustomerChannelReqDto customerChannelReqDto) {
        ExtQueryChainWrapper filter = this.customerChannelDas.filter();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)customerChannelReqDto.getOrganizationCode()), (String)"\u90e8\u95e8\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        if (ObjectUtils.isNotEmpty((Object)customerChannelReqDto.getChannelName())) {
            filter.like((Object)"channel_name", (Object)("%" + customerChannelReqDto.getChannelName() + "%"));
        }
        if (ObjectUtils.isNotEmpty((Object)customerChannelReqDto.getOrganizationCode())) {
            filter.eq((Object)"organization_code", (Object)customerChannelReqDto.getOrganizationCode());
        }
        PageInfo eoPageInfo = filter.page(customerChannelReqDto.getPageNum(), customerChannelReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerChannelRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void batchCustomerChannel(List<CustomerChannelReqDto> list) {
        ArrayList<CustomerChannelEo> eoList = new ArrayList<CustomerChannelEo>();
        ArrayList<CustomerChannelEo> updateList = new ArrayList<CustomerChannelEo>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (CustomerChannelReqDto channelReqDto : list) {
                CustomerChannelEo customerChannelEo;
                CustomerChannelEo channelEo = new CustomerChannelEo();
                channelEo.setOrganizationCode(channelReqDto.getOrganizationCode());
                channelEo.setChannelCode(channelReqDto.getChannelCode());
                channelEo.setChannelCode2(channelReqDto.getChannelCode2());
                channelEo.setChannelCode3(channelReqDto.getChannelCode3());
                List channelEoList = this.customerChannelDas.select((BaseEo)channelEo);
                if (CollectionUtils.isNotEmpty((Collection)channelEoList)) {
                    customerChannelEo = new CustomerChannelEo();
                    DtoHelper.dto2Eo((BaseVo)channelReqDto, (BaseEo)customerChannelEo);
                    customerChannelEo.setId(((CustomerChannelEo)channelEoList.get(0)).getId());
                    updateList.add(customerChannelEo);
                    continue;
                }
                customerChannelEo = new CustomerChannelEo();
                DtoHelper.dto2Eo((BaseVo)channelReqDto, (BaseEo)customerChannelEo);
                eoList.add(customerChannelEo);
            }
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.customerChannelDas.updateBatchByIds(updateList);
        }
        if (CollectionUtils.isNotEmpty(eoList)) {
            this.customerChannelDas.insertBatch(eoList);
        }
    }

    @Override
    public PageInfo<CustomerChannelRespDto> queryOrganizationPage(CustomerChannelReqDto customerChannelReqDto) {
        ExtQueryChainWrapper filter = this.customerChannelDas.filter();
        if (ObjectUtils.isNotEmpty((Object)customerChannelReqDto.getOrganizationName())) {
            filter.like((Object)"organization_name", (Object)("%" + customerChannelReqDto.getOrganizationName() + "%"));
        }
        if (ObjectUtils.isNotEmpty((Object)customerChannelReqDto.getOrganizationCode())) {
            filter.like((Object)"organization_code", (Object)("%" + customerChannelReqDto.getOrganizationCode() + "%"));
        }
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)filter.groupBy((Object)"organization_code")).page(customerChannelReqDto.getPageNum(), customerChannelReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerChannelRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public CustomerChannelRespDto queryByChannelCode(String channelCode) {
        CustomerChannelEo customerChannelEo = new CustomerChannelEo();
        customerChannelEo.setChannelCode(channelCode);
        List customerChannelEo1 = this.customerChannelDas.select((BaseEo)customerChannelEo);
        CustomerChannelRespDto customerChannelRespDto = new CustomerChannelRespDto();
        if (CollectionUtils.isNotEmpty((Collection)customerChannelEo1)) {
            DtoHelper.eo2Dto((BaseEo)((BaseEo)customerChannelEo1.get(0)), (BaseVo)customerChannelRespDto);
        }
        return customerChannelRespDto;
    }
}

