/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.core.util.CronExpression;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.IsDealEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckConfigReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckConfigRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckConfigService;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckConfigDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerCheckConfigEo;
import com.github.pagehelper.PageInfo;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerCheckConfigServiceImpl
implements ICustomerCheckConfigService {
    @Resource
    private CustomerCheckConfigDas customerCheckConfigDas;

    @Override
    public Long addCustomerCheckConfig(CustomerCheckConfigReqDto addReqDto) {
        CustomerCheckConfigEo customerCheckConfigEo = new CustomerCheckConfigEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerCheckConfigEo);
        this.customerCheckConfigDas.insert((BaseEo)customerCheckConfigEo);
        return customerCheckConfigEo.getId();
    }

    @Override
    public void modifyCustomerCheckConfig(CustomerCheckConfigReqDto modifyReqDto) {
        CustomerCheckConfigEo customerCheckConfigEo = new CustomerCheckConfigEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerCheckConfigEo);
        this.customerCheckConfigDas.updateSelective((BaseEo)customerCheckConfigEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerCheckConfig(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerCheckConfigDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CustomerCheckConfigRespDto queryById(Long id) {
        CustomerCheckConfigEo customerCheckConfigEo = (CustomerCheckConfigEo)this.customerCheckConfigDas.selectByPrimaryKey(id);
        CustomerCheckConfigRespDto customerCheckConfigRespDto = new CustomerCheckConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)customerCheckConfigEo, (BaseVo)customerCheckConfigRespDto);
        return customerCheckConfigRespDto;
    }

    @Override
    public PageInfo<CustomerCheckConfigRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerCheckConfigReqDto customerCheckConfigReqDto = (CustomerCheckConfigReqDto)JSON.parseObject((String)filter, CustomerCheckConfigReqDto.class);
        CustomerCheckConfigEo customerCheckConfigEo = new CustomerCheckConfigEo();
        DtoHelper.dto2Eo((BaseVo)customerCheckConfigReqDto, (BaseEo)customerCheckConfigEo);
        PageInfo eoPageInfo = this.customerCheckConfigDas.selectPage((BaseEo)customerCheckConfigEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerCheckConfigRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public CustomerCheckConfigRespDto queryEnableConfig() {
        CustomerCheckConfigRespDto customerCheckConfigReqDto = new CustomerCheckConfigRespDto();
        try {
            CustomerCheckConfigEo customerCheckConfigEo = new CustomerCheckConfigEo();
            customerCheckConfigEo.setValid(IsDealEnum.NOT_DEAL.getCode());
            CustomerCheckConfigEo customerCheckConfig = (CustomerCheckConfigEo)this.customerCheckConfigDas.selectOne((BaseEo)customerCheckConfigEo);
            CronExpression cronExpression = new CronExpression(customerCheckConfig.getCronExpression());
            DtoHelper.eo2Dto((BaseEo)customerCheckConfig, (BaseVo)customerCheckConfigReqDto);
            Date date = DateUtil.parseDate((String)DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)new Date()), (String)"yyyy-MM-dd");
            customerCheckConfigReqDto.setEnable(cronExpression.isSatisfiedBy(date) ? IsDealEnum.IS_DEAL.getCode() : IsDealEnum.NOT_DEAL.getCode());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return customerCheckConfigReqDto;
    }
}

