/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.TbPersonPartnerRelReqDto;
import com.dtyunxi.tcbj.api.query.ITbPersonPartnerRelQueryApi;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.BizChannelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreCheckErrorEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckRelationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckRelationService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.impl.StoreAndSalesmanHelper;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckRelationDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerCheckRelationEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.biz.service.ICustomerQueryService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CustomerCheckRelationServiceImpl
implements ICustomerCheckRelationService {
    @Resource
    private CustomerCheckRelationDas customerCheckRelationDas;
    @Resource
    private StoreAndSalesmanHelper storeAndSalesmanHelper;
    @Resource
    private ICustomerQueryService customerQueryService;
    @Resource
    private ITbPersonPartnerRelQueryApi tbPersonPartnerRelQueryApi;

    @Override
    public Long addCustomerCheckRelation(CustomerCheckRelationReqDto addReqDto) {
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerCheckRelationEo);
        this.customerCheckRelationDas.insert((BaseEo)customerCheckRelationEo);
        return customerCheckRelationEo.getId();
    }

    @Override
    public void modifyCustomerCheckRelation(CustomerCheckRelationReqDto modifyReqDto) {
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerCheckRelationEo);
        this.customerCheckRelationDas.updateSelective((BaseEo)customerCheckRelationEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerCheckRelation(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerCheckRelationDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CustomerCheckRelationRespDto queryById(Long id) {
        CustomerCheckRelationEo customerCheckRelationEo = (CustomerCheckRelationEo)this.customerCheckRelationDas.selectByPrimaryKey(id);
        CustomerCheckRelationRespDto customerCheckRelationRespDto = new CustomerCheckRelationRespDto();
        DtoHelper.eo2Dto((BaseEo)customerCheckRelationEo, (BaseVo)customerCheckRelationRespDto);
        return customerCheckRelationRespDto;
    }

    @Override
    public PageInfo<CustomerCheckRelationRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerCheckRelationReqDto customerCheckRelationReqDto = (CustomerCheckRelationReqDto)JSON.parseObject((String)filter, CustomerCheckRelationReqDto.class);
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)customerCheckRelationReqDto, (BaseEo)customerCheckRelationEo);
        PageInfo eoPageInfo = this.customerCheckRelationDas.selectPage((BaseEo)customerCheckRelationEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerCheckRelationRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<CustomerCheckRelationRespDto> queryByStoreIds(CustomerCheckRelationReqDto customerCheckRelationReqDto) {
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        customerCheckRelationEo.setOrgId(customerCheckRelationReqDto.getOrgId());
        customerCheckRelationEo.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        customerCheckRelationEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"store_id", (Object)customerCheckRelationReqDto.getStoreIds())}));
        List results = this.customerCheckRelationDas.select((BaseEo)customerCheckRelationEo);
        ArrayList customerCheckRelationRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)results, (Collection)customerCheckRelationRespDtos, CustomerCheckRelationRespDto.class);
        return customerCheckRelationRespDtos;
    }

    @Override
    public void bindStoreAndSalesmanRelation(CustomerCheckRelationReqDto addReqDto) {
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)addReqDto.getOrgId()) ? 1 : 0) != 0, (String)"\u7ec4\u7ec7ID\u4e3a\u7a7a!");
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)addReqDto.getStoreId()) ? 1 : 0) != 0, (String)"\u95e8\u5e97ID\u4e3a\u7a7a!");
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)addReqDto.getSalesmanId()) ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458ID\u4e3a\u7a7a!");
        AssertUtil.isTrue((!StringUtils.isEmpty((Object)addReqDto.getThirdPartyId()) ? 1 : 0) != 0, (String)"\u7ecf\u9500\u5546ID\u4e3a\u7a7a!");
        AssertUtil.isTrue((!StringUtils.isEmpty((Object)addReqDto.getStatus()) ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u72b6\u6001\u4e3a\u7a7a!");
        CustomerCheckStatusEnum customerCheckStatusEnum = CustomerCheckStatusEnum.enumOfStatus((Integer)addReqDto.getStatus());
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)customerCheckStatusEnum) ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u4e1a\u52a1\u65b9\u5f0f\uff01");
        BizChannelEnum bizChannelEnum = this.storeAndSalesmanHelper.calculateBizChannel(addReqDto.getThirdPartyId());
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        customerCheckRelationEo.setBizType(Long.valueOf(bizChannelEnum.getCode().intValue()));
        customerCheckRelationEo.setStoreId(addReqDto.getStoreId());
        List list = this.customerCheckRelationDas.select((BaseEo)customerCheckRelationEo);
        switch (customerCheckStatusEnum) {
            case BOUND: {
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
                    tbPersonPartnerRelReqDto.setRowIds(Arrays.asList(addReqDto.getSalesmanId().toString()));
                    PageInfo tbPersonPartnerRelRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString((Object)tbPersonPartnerRelReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
                    List rowIds = tbPersonPartnerRelRespDtoPageInfo.getList().stream().map(c -> c.getRowId()).collect(Collectors.toList());
                    list.stream().filter(c -> !rowIds.contains(c.getSalesmanId())).forEach(c -> {
                        c.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                        int result = this.customerCheckRelationDas.update((BaseEo)c);
                        AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u53d8\u66f4\u5931\u8d25\uff01");
                    });
                    long count = list.stream().filter(c -> rowIds.contains(c.getSalesmanId())).count();
                    CustomerCheckRelationEo customerCheckRelation = (CustomerCheckRelationEo)list.stream().findFirst().get();
                    CustomerRespDto customerRespDto = this.customerQueryService.queryByOrgInfoId(customerCheckRelation.getOrgId());
                    AssertUtil.isTrue((count > 0L ? 1 : 0) != 0, (String)String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)customerCheckRelation.getBizType().toString()).getDesc(), customerRespDto.getName()));
                }
                DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerCheckRelationEo);
                customerCheckRelationEo.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
                this.customerCheckRelationDas.insert((BaseEo)customerCheckRelationEo);
                break;
            }
            case NOT_BOUND: {
                if (CollectionUtils.isEmpty((Collection)list)) break;
                AssertUtil.isTrue((list.size() > 1 ? 1 : 0) != 0, (String)"\u8003\u6838\u95e8\u5e97\u5173\u7cfb\u5b58\u5728\u5f02\u5e38\uff01");
                CustomerCheckRelationEo customerCheckRelation = (CustomerCheckRelationEo)list.stream().findFirst().get();
                AssertUtil.isTrue((boolean)customerCheckRelation.getOrgId().equals(addReqDto.getOrgId()), (String)"\u5f53\u524d\u89e3\u7ed1\u5173\u7cfb\u4e0e\u6240\u5c5e\u516c\u53f8\u4e0d\u4e00\u81f4\uff01");
                AssertUtil.isTrue((boolean)customerCheckRelation.getStoreId().equals(addReqDto.getStoreId()), (String)"\u89e3\u7ed1\u95e8\u5e97\u4e0e\u5f53\u524d\u7ed1\u5b9a\u95e8\u5e97\u4e0d\u4e00\u81f4\uff01");
                AssertUtil.isTrue((boolean)customerCheckRelation.getSalesmanId().equals(addReqDto.getSalesmanId()), (String)"\u89e3\u7ed1\u4e1a\u52a1\u5458\u4e0e\u5f53\u524d\u7ed1\u5b9a\u4e1a\u52a1\u5458\u4e0d\u4e00\u81f4\uff01");
                DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerCheckRelationEo);
                customerCheckRelationEo.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
                this.customerCheckRelationDas.updateSelective((BaseEo)customerCheckRelationEo);
            }
        }
    }
}

