/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.AuditInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AddressTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.StatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.AddressRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerSalesmanRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerExtService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.AddressDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerStatusDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerExtDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.AddressEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerStatusEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.CustomerExtReqDto;
import com.yx.tcbj.center.customer.api.dto.request.PCPCustomerSearchReqDto;
import com.yx.tcbj.center.customer.api.dto.response.CustomerIdsRespDto;
import com.yx.tcbj.center.customer.biz.service.ICustomerQueryService;
import com.yx.tcbj.center.customer.biz.service.ICustomerSalesmanExtService;
import com.yx.tcbj.center.customer.biz.util.RestUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="CustomerQueryService")
public class CustomerQueryServiceImpl
implements ICustomerQueryService {
    @Resource
    private CustomerDas customerDas;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private AddressDas addressDas;
    @Resource
    private IContext context;
    @Resource
    private ICustomerExtService customerExtService;
    @Resource
    private CustomerStatusDas customerStatusDas;
    @Resource
    private ICustomerSalesmanExtService customerSalesmanExtService;
    private CustomerExtDas customerExtDas;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<CustomerRespDto> queryPCPCustomerDetail(PCPCustomerSearchReqDto searchReqDto) {
        this.logger.info("PCP\u5ba2\u6237\u8be6\u60c5-\u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJsonString((Object)searchReqDto));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (Objects.nonNull(searchReqDto.getId())) {
            queryWrapper.eq(BaseEo::getId, (Object)searchReqDto.getId());
        }
        if (Objects.nonNull(searchReqDto.getCode())) {
            queryWrapper.eq(StdCustomerEo::getCode, (Object)searchReqDto.getCode());
        }
        if (Objects.nonNull(searchReqDto.getKeyword())) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.like(StdCustomerEo::getName, (Object)searchReqDto.getKeyword())).or()).like(StdCustomerEo::getCode, (Object)searchReqDto.getKeyword());
        }
        if (CollectionUtils.isNotEmpty((Collection)searchReqDto.getIds())) {
            queryWrapper.in(BaseEo::getId, (Collection)searchReqDto.getIds());
        }
        if (Objects.nonNull(searchReqDto.getThirdPartyId())) {
            queryWrapper.eq(StdCustomerEo::getThirdPartyId, (Object)searchReqDto.getThirdPartyId());
        }
        if (Objects.nonNull(searchReqDto.getThirdParentPartyId())) {
            queryWrapper.eq(StdCustomerEo::getThirdParentPartyId, (Object)searchReqDto.getThirdParentPartyId());
        }
        queryWrapper.eq(BaseEo::getDr, (Object)"0");
        List customerEoInfo = this.customerDas.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList<CustomerRespDto> customerRespDto = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEoInfo, customerRespDto, CustomerRespDto.class);
        this.logger.info("PCP\u5ba2\u6237\u8be6\u60c5-\u63a5\u53e3\u8fd4\u56de:{}", (Object)JSON.toJsonString(customerRespDto));
        return customerRespDto;
    }

    @Override
    public List<CustomerRespDto> queryByThirdPartyIds(List<String> thirdPartyIds) {
        CustomerEo customerEo = new CustomerEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"third_party_id", (Object)StringUtils.join(thirdPartyIds, (String)",")));
        customerEo.setSqlFilters(sqlFilters);
        List customerEoInfo = this.customerDas.select((BaseEo)customerEo);
        ArrayList<CustomerRespDto> customerRespDto = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEoInfo, customerRespDto, CustomerRespDto.class);
        return customerRespDto;
    }

    @Override
    public List<CustomerRespDto> queryCustomerByOrgId(List<Long> orgIds) {
        QueryWrapper filter = new QueryWrapper();
        if (!CollectionUtils.isEmpty(orgIds)) {
            filter.in((Object)"org_info_id", orgIds);
        }
        List customerEos = this.customerDas.getMapper().selectList((Wrapper)filter);
        ArrayList<CustomerRespDto> customerRespDto = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEos, customerRespDto, CustomerRespDto.class);
        return customerRespDto;
    }

    @Override
    public CustomerRespDto queryByOrgInfoId(Long orgInfoId) {
        CustomerEo customerEo = (CustomerEo)((ExtQueryChainWrapper)this.customerDas.filter().eq((Object)"org_info_id", (Object)orgInfoId)).one();
        CustomerRespDto customerRespDto = new CustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)customerEo, (BaseVo)customerRespDto);
        return customerRespDto;
    }

    @Override
    public List<CustomerNameSimpleRespDto> queryCustomerName() {
        ArrayList dtos = Lists.newArrayList();
        List customerEos = this.customerDas.selectAll();
        CubeBeanUtils.copyCollection((Collection)dtos, (Collection)customerEos, CustomerNameSimpleRespDto.class);
        return dtos;
    }

    @Override
    public List<CustomerRespDto> queryCustomerByCodes(List<String> codes) {
        QueryWrapper filter = new QueryWrapper();
        if (!CollectionUtils.isEmpty(codes)) {
            filter.in((Object)"code", codes);
        }
        List customerEos = this.customerDas.getMapper().selectList((Wrapper)filter);
        ArrayList<CustomerRespDto> customerRespDto = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEos, customerRespDto, CustomerRespDto.class);
        return customerRespDto;
    }

    @Override
    public List<CustomerRespDto> queryCustomerByCodesAndOrg(List<String> codes, String merchantId) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        CustomerEo customerEo = new CustomerEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", codes));
        if (StringUtils.isNotBlank((CharSequence)merchantId)) {
            sqlFilters.add(SqlFilter.eq((String)"merchant_id", (Object)merchantId));
        }
        customerEo.setSqlFilters(sqlFilters);
        List customerEoList = this.customerDas.select((BaseEo)customerEo);
        if (CollectionUtils.isEmpty((Collection)customerEoList)) {
            return Lists.newArrayList();
        }
        ArrayList<CustomerRespDto> customerRespDtoList = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEoList, customerRespDtoList, CustomerRespDto.class);
        return customerRespDtoList;
    }

    @Override
    public CustomerRespDto queryCustomerByCode(String code) {
        CustomerEo customerEo = new CustomerEo();
        customerEo.setCode(code);
        customerEo = (CustomerEo)this.customerDas.selectOne((BaseEo)customerEo);
        CustomerRespDto customerRespDto = new CustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)customerEo, (BaseVo)customerRespDto);
        if (customerRespDto.getSalesmanId() != null) {
            this.setCustomerSalesman(customerRespDto);
        }
        return customerRespDto;
    }

    @Override
    public List<CustomerRespDto> queryCustomerList(Integer type) {
        CustomerEo customerEo = new CustomerEo();
        customerEo.setType(type);
        List customerEos = this.customerDas.select((BaseEo)customerEo);
        ArrayList<CustomerRespDto> customerRespDtos = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEos, customerRespDtos, CustomerRespDto.class);
        return customerRespDtos;
    }

    @Override
    public List<CustomerRespDto> queryCustomerByUserId(Long userId) {
        CustomerEo customerEo = new CustomerEo();
        customerEo.setUserId(userId);
        List customerEos = this.customerDas.selectList((BaseEo)customerEo);
        ArrayList<CustomerRespDto> customerRespDtos = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEos, customerRespDtos, CustomerRespDto.class);
        return customerRespDtos;
    }

    @Override
    public PageInfo<CustomerRespDto> queryCustomerInfoList(CustomerExtReqDto reqDto) {
        PageInfo pageInfo = (PageInfo)RestUtil.checkResponse(this.organizationQueryApi.queryUserOrgRelation(reqDto.getUserId(), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        if (Objects.isNull(pageInfo) || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return new PageInfo();
        }
        List organizationDtos = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)organizationDtos)) {
            return new PageInfo();
        }
        List orgIds = organizationDtos.stream().map(OrganizationDto::getId).distinct().collect(Collectors.toList());
        this.logger.info("\u7ec4\u7ec7ID\u96c6\u5408\uff1a{} ", (Object)JSONObject.toJSONString(orgIds));
        CustomerEo queryEo = new CustomerEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (CollectionUtils.isEmpty((Collection)reqDto.getAuditStatuss())) {
            sqlFilters.add(SqlFilter.in((String)"audit_status", (Object)reqDto.getAuditStatuss()));
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            sqlFilters.add(SqlFilter.in((String)"org_info_id", orgIds));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getCodes())) {
            sqlFilters.add(SqlFilter.in((String)"code", (Object)reqDto.getCodes()));
        }
        queryEo.setSqlFilters(sqlFilters);
        PageInfo customerEoPageInfo = this.customerDas.selectPage((BaseEo)queryEo);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)customerEoPageInfo, (String[])new String[0]);
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)customerEoPageInfo.getList(), dtoList, CustomerRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public CustomerExtDetailRespDto queryCustomerDetails(Long id) {
        CustomerExtDetailRespDto customerDetailRespDto = new CustomerExtDetailRespDto();
        CustomerRespDto customerRespDto = (CustomerRespDto)RestUtil.checkResponse(this.customerQueryApi.queryById(id));
        BeanUtils.copyProperties((Object)customerRespDto, (Object)customerDetailRespDto);
        OrgAdvDetailRespDto orgAdvDetailRespDto = (OrgAdvDetailRespDto)RestUtil.checkResponse(this.organizationQueryExtApi.queryById(customerRespDto.getOrgInfoId()));
        CompanyInfoDto companyInfoDto = new CompanyInfoDto();
        OrgAdvInfoRespDto orgAdvInfoRespDto = orgAdvDetailRespDto.getOrgAdvInfoRespDto();
        if (Objects.nonNull(orgAdvInfoRespDto)) {
            BeanUtils.copyProperties((Object)orgAdvInfoRespDto, (Object)companyInfoDto);
        }
        companyInfoDto.setOrgInfoId(customerRespDto.getOrgInfoId());
        List<AddressRespDto> addressList = this.queryAddressList(companyInfoDto.getOrgInfoId(), Lists.newArrayList((Object[])new String[]{AddressTypeEnum.COMPANY.getCode()}));
        if (!CollectionUtils.isEmpty(addressList)) {
            BeanUtils.copyProperties((Object)addressList.get(0), (Object)companyInfoDto);
        }
        customerDetailRespDto.setCompanyInfoDto(companyInfoDto);
        AuditInfoDto auditInfoDto = new AuditInfoDto();
        auditInfoDto.setAuditDesc(customerDetailRespDto.getAuditDesc());
        auditInfoDto.setApplyTime(customerDetailRespDto.getCreateTime());
        auditInfoDto.setApplyPerson(customerDetailRespDto.getCreatePerson());
        auditInfoDto.setAuditPerson(customerDetailRespDto.getCreatePerson());
        auditInfoDto.setAuditTime(customerDetailRespDto.getAuditTime());
        auditInfoDto.setAuditStatus(customerDetailRespDto.getAuditStatus());
        auditInfoDto.setApplyType("ADD");
        customerDetailRespDto.setAuditInfo(auditInfoDto);
        return customerDetailRespDto;
    }

    @Override
    public List<CustomerRespDto> queryCustomerListByCodes(List<String> codeList) {
        return this.queryCustomerListByCodesAndOrg(codeList, null);
    }

    @Override
    public List<CustomerRespDto> queryCustomerListByCodesAndOrg(List<String> codeList, String merchantId) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Lists.newArrayList();
        }
        CustomerEo customerEo = new CustomerEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", codeList));
        if (StringUtils.isNotBlank((CharSequence)merchantId)) {
            sqlFilters.add(SqlFilter.eq((String)"merchant_id", (Object)merchantId));
        }
        customerEo.setSqlFilters(sqlFilters);
        List customerEoList = this.customerDas.select((BaseEo)customerEo);
        if (CollectionUtils.isEmpty((Collection)customerEoList)) {
            return Lists.newArrayList();
        }
        ArrayList<CustomerRespDto> customerRespDtoList = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEoList, customerRespDtoList, CustomerRespDto.class);
        return customerRespDtoList;
    }

    @Override
    public List<CustomerRespDto> queryCustomerListByIds(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Lists.newArrayList();
        }
        CustomerEo customerEo = new CustomerEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", idList));
        customerEo.setSqlFilters(sqlFilters);
        List customerEoList = this.customerDas.select((BaseEo)customerEo);
        if (CollectionUtils.isEmpty((Collection)customerEoList)) {
            return Lists.newArrayList();
        }
        ArrayList<CustomerRespDto> customerRespDtoList = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEoList, customerRespDtoList, CustomerRespDto.class);
        return customerRespDtoList;
    }

    public List<AddressRespDto> queryAddressList(Long orgInfoId, List<String> addressTypes) {
        AddressEo addressEo = new AddressEo();
        addressEo.setOrgInfoId(orgInfoId);
        if (CollectionUtils.isNotEmpty(addressTypes)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"address_type", addressTypes));
            addressEo.setSqlFilters(sqlFilters);
        }
        List addressEoList = this.addressDas.select((BaseEo)addressEo);
        ArrayList<AddressRespDto> addressDtoList = new ArrayList<AddressRespDto>();
        DtoHelper.eoList2DtoList((Collection)addressEoList, addressDtoList, AddressRespDto.class);
        return addressDtoList;
    }

    @Override
    public List<Long> queryCustomerIds() {
        Long attachment = this.customerExtService.getCurrentUserOrgId();
        if (ObjectUtils.isEmpty((Object)attachment)) {
            throw new BizException("\u83b7\u53d6\u53c2\u6570\u5f02\u5e38");
        }
        CustomerEo params = new CustomerEo();
        params.setMerchantId(Long.valueOf(attachment));
        params.setDr(0);
        List customerEos = this.customerDas.select((BaseEo)params);
        if (CollectionUtil.isEmpty((Collection)customerEos)) {
            return new ArrayList<Long>();
        }
        List<Long> collect = customerEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<Long> queryCustomerIdsByThirdParentId(String thirdParentId) {
        if (StringUtils.isEmpty((CharSequence)thirdParentId)) {
            return null;
        }
        CustomerEo params = new CustomerEo();
        params.setThirdParentPartyId(thirdParentId);
        params.setDr(0);
        List customerEos = this.customerDas.select((BaseEo)params);
        if (CollectionUtil.isEmpty((Collection)customerEos)) {
            return new ArrayList<Long>();
        }
        return customerEos.stream().map(BaseEo::getId).collect(Collectors.toList());
    }

    private void setCustomerSalesman(CustomerRespDto customerRespDto) {
        CustomerSalesmanRespDto customerSalesmanRespDto = this.customerSalesmanExtService.queryById(customerRespDto.getSalesmanId());
        if (ObjectUtils.isNotEmpty((Object)customerSalesmanRespDto)) {
            customerRespDto.setSalesmanName(customerSalesmanRespDto.getSellerName());
        }
    }

    @Override
    public CustomerIdsRespDto queryCustomerIdsBySalesmanName(String salesmanName) {
        CustomerIdsRespDto dto = new CustomerIdsRespDto();
        dto.setCustomerIds(this.customerExtDas.queryCustomerIdsBySalesmanName(salesmanName));
        return dto;
    }

    @Override
    public List<CustomerRespDto> queryUpstreamOrgIdsByUserId(Long userId) {
        ServiceContext serviceContext;
        String object;
        if (userId == null) {
            userId = this.context.userId();
        }
        if (userId == null) {
            return Lists.newArrayList();
        }
        if (userId.equals(this.context.userId()) && StringUtils.isNotEmpty((CharSequence)(object = (String)(serviceContext = ServiceContext.getContext()).get("yes.req.cus.b2b.sellerorgid")))) {
            Long customerId;
            CustomerEo customerEo;
            CustomerStatusEo customerStatusEo;
            String customer = (String)serviceContext.get("yes.req.cus.b2b.customerid");
            if (StringUtils.isNotEmpty((CharSequence)customer) && (customerStatusEo = (CustomerStatusEo)this.customerStatusDas.selectByPrimaryKey((customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(customerId = Long.valueOf(customer))).getStatusId())) != null && StatusEnum.ENABLED.getCode().equals(customerStatusEo.getRecordStatus()) && StatusEnum.ENABLED.getCode().equals(customerStatusEo.getAccountStatus())) {
                CustomerRespDto customerRespDto = new CustomerRespDto();
                BeanUtils.copyProperties((Object)customerEo, (Object)customerRespDto);
                customerRespDto.setCustomerId(customerEo.getId());
                return Collections.singletonList(customerRespDto);
            }
            return Lists.newArrayList();
        }
        Long currentUserOrgId = this.customerExtService.queryOrgIdByUserId(userId);
        AssertUtil.isTrue((currentUserOrgId != null ? 1 : 0) != 0, (String)(" \u627e\u4e0d\u5230userId\u5bf9\u5e94\u7684\u673a\u6784id,userId:" + userId));
        List customerEoList = ((ExtQueryChainWrapper)this.customerDas.filter().eq((Object)"org_info_id", (Object)currentUserOrgId)).list();
        if (CollectionUtils.isEmpty((Collection)customerEoList)) {
            return Lists.newArrayList();
        }
        ArrayList customerRespDtoList = Lists.newArrayList();
        Map statusMap = ((ExtQueryChainWrapper)this.customerStatusDas.filter().in((Object)"id", (Collection)customerEoList.stream().map(StdCustomerEo::getStatusId).collect(Collectors.toSet()))).list().stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (CustomerEo customerEo : customerEoList) {
            CustomerStatusEo customerStatusEo = (CustomerStatusEo)statusMap.get(customerEo.getStatusId());
            if (customerStatusEo == null || !StatusEnum.ENABLED.getCode().equals(customerStatusEo.getRecordStatus()) || !StatusEnum.ENABLED.getCode().equals(customerStatusEo.getAccountStatus())) continue;
            CustomerRespDto customerRespDto = new CustomerRespDto();
            BeanUtils.copyProperties((Object)customerEo, (Object)customerRespDto);
            customerRespDto.setCustomerId(customerEo.getId());
            customerRespDtoList.add(customerRespDto);
        }
        return customerRespDtoList;
    }
}

