/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.BizChannelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CheckPatternTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckRelationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckPatternRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckPatternService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckRelationService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.impl.StoreAndSalesmanHelper;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckPatternDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerCheckPatternEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.biz.service.ICustomerQueryService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CustomerCheckPatternServiceImpl
implements ICustomerCheckPatternService {
    private static final Logger log = LoggerFactory.getLogger(CustomerCheckPatternServiceImpl.class);
    @Resource
    private CustomerCheckPatternDas customerCheckPatternDas;
    @Resource
    private ICustomerQueryService customerQueryService;
    @Resource
    private StoreAndSalesmanHelper storeAndSalesmanHelper;
    @Resource
    private ICustomerCheckRelationService customerCheckRelationService;

    @Override
    public void addCustomerCheckPattern(CustomerCheckPatternReqDto addReqDto) {
        log.info("\u6dfb\u52a0\u7ecf\u9500\u5546\u8003\u6838\u65b9\u5f0f params => {} ", (Object)JSON.toJSONString((Object)addReqDto));
        CheckPatternTypeEnum reqCheckPatternTypeEnum = CheckPatternTypeEnum.enumOfType((Integer)addReqDto.getPatternType());
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)reqCheckPatternTypeEnum) ? 1 : 0) != 0, (String)"\u8003\u6838\u65b9\u5f0f\u4e0d\u5b58\u5728\uff01");
        AssertUtil.isTrue((!StringUtils.isEmpty((Object)addReqDto.getCustomerCode()) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<CustomerRespDto> customerRespDtoList = this.customerQueryService.queryCustomerListByCodes(Arrays.asList(addReqDto.getCustomerCode()));
        AssertUtil.isTrue((boolean)CollectionUtils.isEmpty(customerRespDtoList), (String)"\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoList.stream().findFirst().get();
        BizChannelEnum bizChannelEnum = this.storeAndSalesmanHelper.calculateBizChannel(customerRespDto.getThirdPartyId());
        AssertUtil.isTrue((boolean)bizChannelEnum.getCheckPatternTypes().contains(reqCheckPatternTypeEnum), (String)"\u5f53\u524d\u4e1a\u52a1\u7ebf\u4e0d\u5b58\u5728\u8be5\u8003\u6838\u6a21\u5f0f");
        switch (reqCheckPatternTypeEnum) {
            case SEPARATE_CHECK: 
            case ALONE_CHECK: {
                CustomerCheckPatternEo customerCheckPattern = new CustomerCheckPatternEo();
                customerCheckPattern.setPatternType(reqCheckPatternTypeEnum.getType());
                customerCheckPattern.setCustomerCode(customerRespDto.getCode());
                customerCheckPattern.setCustomerName(customerRespDto.getCustomerName());
                customerCheckPattern.setOrgId(customerRespDto.getOrgInfoId());
                int result = this.customerCheckPatternDas.insert((BaseEo)customerCheckPattern);
                AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u8003\u6838\u89c4\u5219\u5931\u8d25\uff01");
                break;
            }
            case MERGE_CHECK: {
                AssertUtil.isTrue((!StringUtils.isEmpty((Object)addReqDto.getMergeCustomerCodes()) ? 1 : 0) != 0, (String)"\u5408\u5e76\u8003\u6838\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                List<CustomerRespDto> mergeCustomerRespDtoList = this.customerQueryService.queryCustomerListByCodes(addReqDto.getMergeCustomerCodes());
                AssertUtil.isTrue((boolean)CollectionUtils.isEmpty(mergeCustomerRespDtoList), (String)"\u7ed1\u5b9a\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
                List customerCheckPatterns = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(addReqDto.getCustomerCode());
                this.extracted(reqCheckPatternTypeEnum, mergeCustomerRespDtoList, customerCheckPatterns);
                customerCheckPatterns.forEach(c -> this.customerCheckPatternDas.logicDeleteById(c.getId()));
                List addCustomerCheckPatterns = mergeCustomerRespDtoList.stream().map(c -> {
                    CustomerCheckPatternEo customerCheckPatternEo = new CustomerCheckPatternEo();
                    customerCheckPatternEo.setPatternType(reqCheckPatternTypeEnum.getType());
                    customerCheckPatternEo.setCustomerCode(customerRespDto.getCode());
                    customerCheckPatternEo.setCustomerName(customerRespDto.getCustomerName());
                    customerCheckPatternEo.setOrgId(customerRespDto.getOrgInfoId());
                    customerCheckPatternEo.setMergeCustomerCode(c.getCode());
                    customerCheckPatternEo.setMergeCustomerName(c.getCustomerName());
                    customerCheckPatternEo.setMergeOrgId(c.getOrgInfoId());
                    return customerCheckPatternEo;
                }).collect(Collectors.toList());
                int results = this.customerCheckPatternDas.insertBatch(addCustomerCheckPatterns);
                AssertUtil.isTrue((results > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u8003\u6838\u89c4\u5219\u5931\u8d25\uff01");
                break;
            }
            default: {
                throw new BizException("0001", "\u4e0d\u5b58\u5728\u5f53\u524d\u64cd\u4f5c\u7c7b\u578b");
            }
        }
    }

    private void extracted(CheckPatternTypeEnum reqCheckPatternTypeEnum, List<CustomerRespDto> mergeCustomerRespDtoList, List<CustomerCheckPatternEo> customerCheckPatterns) {
        if (!CollectionUtils.isEmpty(customerCheckPatterns)) {
            return;
        }
        CustomerCheckPatternEo customerCheckPattern = (CustomerCheckPatternEo)customerCheckPatterns.stream().findFirst().get();
        CheckPatternTypeEnum checkPatternTypeEnum = CheckPatternTypeEnum.enumOfType((Integer)customerCheckPattern.getPatternType());
        AssertUtil.notNull((Object)checkPatternTypeEnum, (String)"\u5f53\u524d\u8003\u6838\u65b9\u5f0f\u4e0d\u5b58\u5728\uff01");
        if (checkPatternTypeEnum.equals((Object)CheckPatternTypeEnum.SEPARATE_CHECK) && reqCheckPatternTypeEnum.equals((Object)CheckPatternTypeEnum.MERGE_CHECK)) {
            Map<BizChannelEnum, List<CustomerRespDto>> customerGroupByChannel = mergeCustomerRespDtoList.stream().collect(Collectors.groupingBy(key -> this.storeAndSalesmanHelper.calculateBizChannel(key.getThirdPartyId())));
            List<CustomerRespDto> orDefault = customerGroupByChannel.getOrDefault(BizChannelEnum.LIFE_SPACE, Lists.newArrayList());
            List orgIds = orDefault.stream().map(c -> c.getOrgInfoId()).collect(Collectors.toList());
            CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
            customerCheckRelationReqDto.setOrgIds(orgIds);
            List<CustomerCheckRelationRespDto> customerCheckRelationRespDtos = this.customerCheckRelationService.queryByStoreIds(customerCheckRelationReqDto);
            if (!CollectionUtils.isEmpty(customerCheckRelationRespDtos)) {
                customerCheckRelationRespDtos.forEach(c -> {
                    CustomerCheckRelationReqDto checkRelationReqDto = new CustomerCheckRelationReqDto();
                    CubeBeanUtils.copyProperties((Object)checkRelationReqDto, (Object)c, (String[])new String[0]);
                    this.customerCheckRelationService.modifyCustomerCheckRelation(checkRelationReqDto);
                });
            }
        }
    }

    @Override
    public void modifyCustomerCheckPattern(CustomerCheckPatternReqDto modifyReqDto) {
        CustomerCheckPatternEo customerCheckPatternEo = new CustomerCheckPatternEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerCheckPatternEo);
        this.customerCheckPatternDas.updateSelective((BaseEo)customerCheckPatternEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerCheckPattern(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerCheckPatternDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CustomerCheckPatternRespDto queryById(Long id) {
        CustomerCheckPatternEo customerCheckPatternEo = (CustomerCheckPatternEo)this.customerCheckPatternDas.selectByPrimaryKey(id);
        CustomerCheckPatternRespDto customerCheckPatternRespDto = new CustomerCheckPatternRespDto();
        DtoHelper.eo2Dto((BaseEo)customerCheckPatternEo, (BaseVo)customerCheckPatternRespDto);
        return customerCheckPatternRespDto;
    }

    @Override
    public PageInfo<CustomerCheckPatternRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerCheckPatternReqDto customerCheckPatternReqDto = (CustomerCheckPatternReqDto)JSON.parseObject((String)filter, CustomerCheckPatternReqDto.class);
        CustomerCheckPatternEo customerCheckPatternEo = new CustomerCheckPatternEo();
        DtoHelper.dto2Eo((BaseVo)customerCheckPatternReqDto, (BaseEo)customerCheckPatternEo);
        PageInfo eoPageInfo = this.customerCheckPatternDas.selectPage((BaseEo)customerCheckPatternEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerCheckPatternRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

