/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.service.impl;

import cn.hutool.core.lang.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AddressTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AuditStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.SettleStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CustomerAddResultDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.RCustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IAddressService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IBillInfoService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IContactsInfoService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IRCustomerSalesmanService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.impl.CustomerExtServiceImpl;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.util.PinyinHelperUtil;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerExportRecordDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerGroupDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerLevelDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerStatusDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerTypeDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.RCustomerRegionDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerTypeEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvOpRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Primary
@Service(value="customerV2Service")
public class CustomerExt1ServiceImpl
extends CustomerExtServiceImpl {
    private Logger logger = LoggerFactory.getLogger(CustomerExtServiceImpl.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private CustomerDas customerDas;
    @Resource
    private CustomerTypeDas customerTypeDas;
    @Resource
    private CustomerExportRecordDas customerExportRecordDas;
    @Resource
    private IContext context;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private CustomerStatusDas customerStatusDas;
    @Resource
    private CustomerGroupDas customerGroupDas;
    @Resource
    private RCustomerRegionDas rCustomerRegionDas;
    @Resource
    private CustomerLevelDas customerLevelDas;
    @Resource
    private IOrganizationExtApi organizationExtApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Value(value="${yundt.cube.customer.orgRootId}")
    private Long orgRootId;
    @Resource
    private IUserApi userApi;
    @Resource
    private ICustomerService customerService;
    @Resource
    private IContactsInfoService contactsInfoService;
    @Resource
    private IBillInfoService billInfoService;
    @Resource
    private IAddressService addressService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Value(value="${yundt.cube.customer.dealerRoleCode}")
    private String dealerRoleCode;
    @Value(value="${yundt.cube.customer.mallPattern:1}")
    private Integer mallPattern;
    @Value(value="${yundt.cube.customer.generate.code:false}")
    private Boolean generateCustomerCode;
    @Autowired
    private IRCustomerSalesmanService rCustomerSalesmanService;
    @Resource
    private ISellerQueryApi sellerQueryApi;

    public CustomerAddResultDto add(CustomerReqDto reqDto) {
        OrganizationInfoDto organizationInfoDto;
        RestResponse listRestResponse;
        CustomerEo customerEo;
        Long orgInfoId;
        RestResponse pageInfoRestResponse;
        String code = reqDto.getCode();
        reqDto.setId((Long)null);
        if (this.generateCustomerCode.booleanValue()) {
            code = this.generateCustomerCode(reqDto);
            reqDto.setCode(code);
        }
        this.validCustomerCode(reqDto, reqDto.getTenantId());
        Assert.notNull((Object)reqDto.getCompanyInfoDto(), (String)"\u516c\u53f8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CompanyInfoDto companyInfoDto = reqDto.getCompanyInfoDto();
        if (companyInfoDto != null && !StringUtils.equals((CharSequence)"zooid", (CharSequence)companyInfoDto.getSubjectType())) {
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getCreditCode(), (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getLegalName(), (String)"\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)"zooid", (CharSequence)companyInfoDto.getSubjectType())) {
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getLegalCardNum(), (String)"\u8eab\u4efd\u8bc1\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        Long currentUserOrgId = reqDto.getOrgId();
        if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
            if (Objects.isNull(currentUserOrgId)) {
                currentUserOrgId = this.getCurrentUserOrgId();
            }
            reqDto.setMerchantId(currentUserOrgId);
        } else if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
            if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getChannel())) {
                if (Objects.isNull(currentUserOrgId)) {
                    currentUserOrgId = this.getCurrentUserOrgId();
                }
                reqDto.setMerchantId(currentUserOrgId);
            }
            Assert.notNull((Object)reqDto.getMerchantId(), (String)"\u6240\u5c5e\u5546\u5bb6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (Objects.isNull(reqDto.getCompanyInfoDto().getOrgInfoId())) {
            OrgAdvAddReqDto orgAdvAddReqDto = new OrgAdvAddReqDto();
            OrgAdvInfoReqDto orgAdvInfoReqDto = new OrgAdvInfoReqDto();
            CubeBeanUtils.copyProperties((Object)orgAdvInfoReqDto, (Object)reqDto.getCompanyInfoDto(), (String[])new String[0]);
            orgAdvAddReqDto.setOrgAdvInfoReqDto(orgAdvInfoReqDto);
            orgAdvAddReqDto.setCode(code);
            orgAdvAddReqDto.setName(reqDto.getCompanyInfoDto().getOrgName());
            orgAdvAddReqDto.setEntityPropCode("company");
            orgAdvAddReqDto.setType("2");
            orgAdvAddReqDto.setParentId(this.orgRootId);
            pageInfoRestResponse = this.organizationExtApi.add(orgAdvAddReqDto);
            if (!"0".equals(pageInfoRestResponse.getResultCode())) {
                if (pageInfoRestResponse.getResultMsg().equals(CustomerExceptionCode.ORG_NAME_EXISTS.getMsg())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.COMPANY_NAME_EXISTS.getCode(), CustomerExceptionCode.COMPANY_NAME_EXISTS.getMsg());
                }
                throw new BizException(pageInfoRestResponse.getResultCode(), pageInfoRestResponse.getResultMsg());
            }
            orgInfoId = ((OrgAdvOpRespDto)pageInfoRestResponse.getData()).getOrgId();
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getCompanyInfoDto().getProvinceCode())) {
                AddressAddReqDto addressReqDto = new AddressAddReqDto();
                CubeBeanUtils.copyProperties((Object)addressReqDto, (Object)reqDto.getCompanyInfoDto(), (String[])new String[0]);
                addressReqDto.setOrgInfoId(orgInfoId);
                addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
                this.addressService.addAddress(addressReqDto);
            }
        } else {
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            customerEo = CustomerEo.newInstance();
            customerEo.setOrgInfoId(reqDto.getCompanyInfoDto().getOrgInfoId());
            customerEo.setMerchantId(reqDto.getMerchantId());
            List customerEoList = this.customerDas.select((BaseEo)customerEo);
            if (!CollectionUtils.isEmpty((Collection)customerEoList)) {
                if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getCode(), String.format(CustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getMsg(), ((CustomerEo)customerEoList.get(0)).getCode()));
                }
                if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getCode(), String.format(CustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getMsg(), ((CustomerEo)customerEoList.get(0)).getCode()));
                }
                code = customerEo.getCode();
                Long i = this.cacheService.incr(code);
                String str = String.format("%01d", i);
                reqDto.setCode(str);
            }
            this.updateOrgInfo(reqDto.getCompanyInfoDto());
            this.addressService.removeAddressByOrgInfoIdAndType(reqDto.getCompanyInfoDto().getOrgInfoId(), AddressTypeEnum.COMPANY.getCode());
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getCompanyInfoDto().getProvinceCode())) {
                AddressAddReqDto addressReqDto = new AddressAddReqDto();
                CubeBeanUtils.copyProperties((Object)addressReqDto, (Object)reqDto.getCompanyInfoDto(), (String[])new String[0]);
                addressReqDto.setOrgInfoId(reqDto.getCompanyInfoDto().getOrgInfoId());
                addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
                this.addressService.addAddress(addressReqDto);
            }
            orgInfoId = reqDto.getCompanyInfoDto().getOrgInfoId();
        }
        reqDto.setOrgInfoId(orgInfoId);
        customerEo = CustomerEo.newInstance();
        this.initCustomerEo(reqDto, customerEo);
        customerEo.setAuditStatus(AuditStatusEnum.DRAFT.getCode());
        customerEo.setSettleStatus(SettleStatusEnum.UNSETTLE.getCode());
        UserOrgRelationQueryReqDto relationQueryReqDto = new UserOrgRelationQueryReqDto();
        relationQueryReqDto.setOrgId(orgInfoId);
        pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(relationQueryReqDto, Integer.valueOf(1), Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (!CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            customerEo.setUserId(((UserRespDto)pageInfo.getList().get(0)).getId());
        }
        if (!CollectionUtils.isEmpty((Collection)((Collection)(listRestResponse = this.organizationQueryApi.queryOrgAndOrgInfoByIds((List)Lists.newArrayList((Object[])new Long[]{orgInfoId}))).getData())) && (organizationInfoDto = ((OrgAndOrgInfoRespDto)((List)listRestResponse.getData()).get(0)).getOrganizationInfoDto()) != null && StringUtils.isNotEmpty((CharSequence)organizationInfoDto.getCreditCode())) {
            customerEo.setIfCertification(Integer.valueOf(1));
        }
        if (StringUtils.isEmpty((CharSequence)customerEo.getThirdParentPartyId()) && Objects.nonNull(customerEo.getMerchantId())) {
            SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryById(customerEo.getMerchantId()));
            CustomerEo finalCustomerEo = customerEo;
            Optional.ofNullable(sellerRespDto).ifPresent(r -> finalCustomerEo.setThirdParentPartyId(r.getCode()));
        }
        this.customerDas.insert((BaseEo)customerEo);
        if (!CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList())) {
            ArrayList<RCustomerRegionEo> customerRegionEos = new ArrayList<RCustomerRegionEo>(reqDto.getRegionCodeList().size());
            for (String regionCode : reqDto.getRegionCodeList()) {
                RCustomerRegionEo customerRegionEo = new RCustomerRegionEo();
                customerRegionEo.setCustomerId(customerEo.getId());
                customerRegionEo.setRegionCode(regionCode);
                customerRegionEos.add(customerRegionEo);
            }
            this.rCustomerRegionDas.insertBatch(customerRegionEos);
        }
        CustomerAddResultDto resultDto = new CustomerAddResultDto();
        resultDto.setCustomerId(customerEo.getId());
        resultDto.setOrgInfoId(orgInfoId);
        if (!CollectionUtils.isEmpty((Collection)reqDto.getSalesmanIds())) {
            RCustomerSalesmanReqDto salesmanReqDto = new RCustomerSalesmanReqDto();
            salesmanReqDto.setCustomerId(reqDto.getId());
            salesmanReqDto.setSalesmanIds(reqDto.getSalesmanIds());
            salesmanReqDto.setOrgId(currentUserOrgId);
            this.rCustomerSalesmanService.add(salesmanReqDto);
        }
        return resultDto;
    }

    private void updateOrgInfo(CompanyInfoDto companyInfoDto) {
        OrgAdvModifyReqDto orgAdvModifyReqDto = new OrgAdvModifyReqDto();
        orgAdvModifyReqDto.setName(companyInfoDto.getOrgName());
        orgAdvModifyReqDto.setCode(companyInfoDto.getOrgCode());
        orgAdvModifyReqDto.setId(companyInfoDto.getOrgInfoId());
        orgAdvModifyReqDto.setEntityPropCode("company");
        orgAdvModifyReqDto.setTenantId(companyInfoDto.getTenantId());
        OrgAdvInfoReqDto orgAdvInfoReqDto = new OrgAdvInfoReqDto();
        CubeBeanUtils.copyProperties((Object)orgAdvInfoReqDto, (Object)companyInfoDto, (String[])new String[0]);
        orgAdvModifyReqDto.setOrgAdvInfoReqDto(orgAdvInfoReqDto);
        RestResponse modify = this.organizationExtApi.modify(orgAdvModifyReqDto);
        if (!"0".equals(modify.getResultCode())) {
            if (modify.getResultMsg().equals(CustomerExceptionCode.ORG_NAME_EXISTS.getMsg())) {
                throw new CustomerBusinessRuntimeException(CustomerExceptionCode.COMPANY_NAME_EXISTS.getCode(), CustomerExceptionCode.COMPANY_NAME_EXISTS.getMsg());
            }
            throw new BizException(modify.getResultCode(), modify.getResultMsg());
        }
        if (StringUtils.isNotEmpty((CharSequence)companyInfoDto.getCreditCode())) {
            CustomerEo customerEo = new CustomerEo();
            customerEo.setOrgInfoId(companyInfoDto.getOrgInfoId());
            List customerEoList = this.customerDas.select((BaseEo)customerEo);
            customerEoList.forEach(n -> {
                n.setIfCertification(Integer.valueOf(1));
                this.customerDas.updateSelective((BaseEo)n);
            });
        }
    }

    private void initCustomerEo(CustomerReqDto reqDto, CustomerEo customerEo) {
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerEo);
        if (Objects.nonNull(reqDto.getCompanyInfoDto()) && StringUtils.isNotEmpty((CharSequence)reqDto.getCompanyInfoDto().getCreditCode())) {
            customerEo.setIfCertification(Integer.valueOf(1));
        }
    }

    private String generateCustomerCode(CustomerReqDto reqDto) {
        Long customerTypeId = reqDto.getCustomerTypeId();
        String name = ((CustomerTypeEo)this.customerTypeDas.selectByPrimaryKey(customerTypeId)).getName();
        Random random = new Random(6L);
        long randomNum = random.nextLong();
        String code = PinyinHelperUtil.getPinYinHeadChar((String)name) + randomNum;
        Long i = this.cacheService.incr(code);
        String str = String.format("%06d", i);
        return str;
    }

    private void validCustomerCode(CustomerReqDto reqDto, Long tenantId) {
        if (Objects.nonNull(reqDto)) {
            Assert.notNull((Object)reqDto.getCode(), (String)CustomerExceptionCode.CUSTOMER_CODE_NULL.getMsg(), (Object[])new Object[0]);
            CustomerEo customerEo = CustomerEo.newInstance();
            customerEo.setTenantId(tenantId);
            customerEo.setCode(reqDto.getCode());
            customerEo = (CustomerEo)this.customerDas.selectOne((BaseEo)customerEo);
            if (customerEo != null) {
                if (reqDto.getId() == null) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
                if (reqDto.getId() != null && !customerEo.getId().equals(reqDto.getId())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
            }
        }
    }
}

