/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.RCustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerSalesmanRespDto;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerSalesmanDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.RCustomerSalesmanDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerSalesmanEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerSalesmanEo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.biz.service.ICustomerSalesmanExtService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CustomerSalesmanExtExtServiceImpl
implements ICustomerSalesmanExtService {
    @Resource
    private CustomerSalesmanDas customerSalesmanDas;
    @Resource
    private CustomerDas customerDas;
    @Resource
    private RCustomerSalesmanDas rCustomerSalesmanDas;

    @Override
    public CustomerSalesmanRespDto queryById(Long id) {
        CustomerSalesmanEo customerSalesmanEo = (CustomerSalesmanEo)this.customerSalesmanDas.selectByPrimaryKey(id);
        CustomerSalesmanRespDto customerSalesmanRespDto = new CustomerSalesmanRespDto();
        DtoHelper.eo2Dto((BaseEo)customerSalesmanEo, (BaseVo)customerSalesmanRespDto);
        return customerSalesmanRespDto;
    }

    @Override
    public RCustomerSalesmanReqDto queryByCustomerId(Long customerId) {
        CustomerEo customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(customerId);
        if (Objects.isNull(customerEo)) {
            throw new BizException("\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u4fe1\u606f\uff0c\u5ba2\u6237ID\uff1a{}", JSONObject.toJSONString((Object)customerId));
        }
        RCustomerSalesmanEo rCustomerSalesmanEoQuery = new RCustomerSalesmanEo();
        ArrayList rSqlFilters = Lists.newArrayList();
        rSqlFilters.add(SqlFilter.eq((String)"customer_id", (Object)customerId));
        rSqlFilters.add(SqlFilter.eq((String)"org_id", (Object)customerEo.getMerchantId()));
        rCustomerSalesmanEoQuery.setSqlFilters((List)rSqlFilters);
        RCustomerSalesmanEo rCustomerSalesmanEo = (RCustomerSalesmanEo)this.rCustomerSalesmanDas.selectOne((BaseEo)rCustomerSalesmanEoQuery);
        RCustomerSalesmanReqDto reqDto = new RCustomerSalesmanReqDto();
        DtoHelper.eo2Dto((BaseEo)rCustomerSalesmanEo, (BaseVo)reqDto);
        return reqDto;
    }

    @Override
    public CustomerSalesmanRespDto queryByEmpNo(String empNo) {
        if (StringUtils.isEmpty((CharSequence)empNo)) {
            return null;
        }
        CustomerSalesmanEo customerSalesmanEo = new CustomerSalesmanEo();
        customerSalesmanEo.setJobNumber(empNo);
        CustomerSalesmanEo salesmanEo = (CustomerSalesmanEo)this.customerSalesmanDas.selectOne((BaseEo)customerSalesmanEo);
        if (salesmanEo == null) {
            return null;
        }
        CustomerSalesmanRespDto customerSalesmanRespDto = new CustomerSalesmanRespDto();
        DtoHelper.eo2Dto((BaseEo)salesmanEo, (BaseVo)customerSalesmanRespDto);
        return customerSalesmanRespDto;
    }
}

