/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.map.MapUtil;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.mj.biz.commons.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AuditStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.StatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.RCustomerSalesmanRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.entity.NacosPropertiesOrgEntity;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerImportReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeNumCountReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerImportDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerImportRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeNumCountRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IRCustomerSalesmanService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IEmployeeCustomerService;
import com.dtyunxi.yundt.cube.center.customer.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerGroupDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerAreaMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerLevelMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerTypeMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.RCustomerRegionMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.das.EmployeeCustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.EmployeeRegionDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.EmployeeCustomerBlacklistEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.EmployeeCustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.EmployeeRegionEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerAreaEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerGroupEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerLevelEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.customer.dao.mapper.EmployeeCustomerBlacklistMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.mapper.EmployeeCustomerMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.mapper.EmployeeRegionMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerAreaEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdRCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeExtRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.CustomerExtReqDto;
import com.yx.tcbj.center.shop.api.dto.request.SellerExtQueryReqDto;
import com.yx.tcbj.center.shop.api.query.ISellerExpandQueryApi;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EmployeeCustomerServiceImpl
implements IEmployeeCustomerService {
    public final Logger logger = LoggerFactory.getLogger(EmployeeCustomerServiceImpl.class);
    @Resource
    private EmployeeCustomerDas employeeCustomerDas;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private CustomerDas customerDas;
    @Resource
    private RCustomerRegionMapper rCustomerRegionMapper;
    @Resource
    private CustomerAreaMapper customerAreaMapper;
    @Resource
    private EmployeeCustomerMapper employeeCustomerMapper;
    @Resource
    private EmployeeRegionMapper employeeRegionMapper;
    @Resource
    private EmployeeCustomerBlacklistMapper employeeCustomerBlacklistMapper;
    @Resource
    private EmployeeRegionDas employeeRegionDas;
    @Resource
    private CustomerGroupDas customerGroupDas;
    @Resource
    private CustomerLevelMapper customerLevelMapper;
    @Resource
    private ISellerExpandQueryApi sellerExpandQueryApi;
    @Resource
    private NacosPropertiesOrgEntity nacosPropertiesOrgEntity;
    @Resource
    private HttpServletRequest request;
    @Resource
    private IEmployeeExpandQueryApi employeeExpandQueryApi;
    @Resource
    private CustomerTypeMapper customerTypeMapper;
    @Autowired
    private IRCustomerSalesmanService rCustomerSalesmanService;
    @Resource
    ICacheService cacheService;

    public String getHeaderOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        this.logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    @Override
    public Long addEmployeeCustomer(EmployeeCustomerReqDto addReqDto) {
        EmployeeCustomerEo employeeCustomerEo = new EmployeeCustomerEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)employeeCustomerEo);
        this.employeeCustomerDas.insert((BaseEo)employeeCustomerEo);
        return employeeCustomerEo.getId();
    }

    @Override
    public void modifyEmployeeCustomer(EmployeeCustomerReqDto modifyReqDto) {
        EmployeeCustomerEo employeeCustomerEo = new EmployeeCustomerEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)employeeCustomerEo);
        this.employeeCustomerDas.updateSelective((BaseEo)employeeCustomerEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeEmployeeCustomer(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.employeeCustomerDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public EmployeeCustomerRespDto queryById(Long id) {
        EmployeeCustomerEo employeeCustomerEo = (EmployeeCustomerEo)this.employeeCustomerDas.selectByPrimaryKey(id);
        EmployeeCustomerRespDto employeeCustomerRespDto = new EmployeeCustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)employeeCustomerEo, (BaseVo)employeeCustomerRespDto);
        return employeeCustomerRespDto;
    }

    @Override
    public PageInfo<EmployeeCustomerRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        EmployeeCustomerReqDto employeeCustomerReqDto = (EmployeeCustomerReqDto)JSON.parseObject((String)filter, EmployeeCustomerReqDto.class);
        EmployeeCustomerEo employeeCustomerEo = new EmployeeCustomerEo();
        DtoHelper.dto2Eo((BaseVo)employeeCustomerReqDto, (BaseEo)employeeCustomerEo);
        PageInfo eoPageInfo = this.employeeCustomerDas.selectPage((BaseEo)employeeCustomerEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, EmployeeCustomerRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public EmployeeCustomerImportRespDto customerImport(EmployeeCustomerImportReqDto importReqDto) {
        this.logger.info("\u5bfc\u5165\u5ba2\u6237:{}", (Object)importReqDto.getFileUrl());
        String fileUrl = importReqDto.getFileUrl();
        AssertUtil.assertNotBlank((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        String orgIdStr = this.getHeaderOrgId();
        if (StringUtils.isBlank((CharSequence)orgIdStr)) {
            orgIdStr = this.nacosPropertiesOrgEntity.orgId();
            this.logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
        }
        com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil.assertNotBlank((String)orgIdStr, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        EmployeeCustomerImportRespDto resultDto = new EmployeeCustomerImportRespDto();
        List importDtos = Lists.newArrayList();
        try {
            InputStream is = this.getInputStream(fileUrl);
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, EmployeeCustomerImportDto.class);
            importDtos = objectExcelImportResult.getList();
            importDtos = BeanPropertyNullUtil.getAllFieldNullList((List)importDtos);
        }
        catch (Exception e) {
            throw new BizException("\u5bfc\u5165\u5ba2\u6237\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        this.logger.info("\u5bfc\u5165\u7684\u6570\u636e==>{}", (Object)JSONObject.toJSONString((Object)importDtos));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)importDtos)) {
            throw new BizException("\u5bfc\u5165\u7684\u8868\u683c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8868\u683c\u540e\u91cd\u65b0\u5bfc\u5165");
        }
        resultDto.setTotalSize(importDtos.size());
        importDtos = importDtos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EmployeeCustomerImportDto>(Comparator.comparing(EmployeeCustomerImportDto::getCustomerCode))), ArrayList::new));
        List<String> customerCodeList = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode())).map(EmployeeCustomerImportDto::getCustomerCode).distinct().collect(Collectors.toList());
        List<CustomerRespDto> customerDtoList = this.queryCustomerByCodeList(customerCodeList);
        Map<Object, Object> customerDtoMap = new HashMap(customerDtoList.size() * 4 / 3 + 2);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerDtoList)) {
            customerDtoMap = customerDtoList.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList resultList = Lists.newArrayList();
        for (EmployeeCustomerImportDto importDto : importDtos) {
            if (StringUtils.isEmpty((CharSequence)importDto.getCustomerCode())) {
                importDto.setErrorReason("\u5ba2\u6237\u7f16\u53f7\u4e3a\u7a7a;");
                continue;
            }
            if (customerDtoMap.isEmpty() || !customerDtoMap.containsKey(importDto.getCustomerCode())) {
                importDto.setErrorReason("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728;");
                continue;
            }
            CustomerRespDto customerDto = (CustomerRespDto)customerDtoMap.get(importDto.getCustomerCode());
            String merchantId = customerDto.getMerchantId().toString();
            if (!Objects.equals(orgIdStr, merchantId)) {
                importDto.setErrorReason("\u5ba2\u6237\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5546\u5bb6;");
                continue;
            }
            resultList.add(customerDto);
        }
        resultDto.setResultList((List)resultList);
        List list = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        resultDto.setFailSize(list.size());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            String title = "\u5bfc\u5165\u5ba2\u6237\u8fd4\u56de\u7ed3\u679c";
            String fileName = title + System.currentTimeMillis();
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(list, EmployeeCustomerImportDto.class, title, fileName, "xls");
                resultDto.setErrorFileUrl(exportUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BizException("\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        resultDto.setSuccessSize(resultDto.getTotalSize() - resultDto.getFailSize());
        return resultDto;
    }

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn.getInputStream();
    }

    private List<CustomerRespDto> queryCustomerByList(List<String> codeList, List<Long> idList) {
        List customerNameSimpleRespDtos;
        if (org.apache.commons.collections.CollectionUtils.isEmpty(codeList) && org.apache.commons.collections.CollectionUtils.isEmpty(idList)) {
            throw new BizException("\u5fc5\u4f20id\u96c6\u5408\u6216code\u96c6\u5408\u53c2\u6570\u4e3a\u7a7a");
        }
        QueryWrapper customerEoQueryWrapper = new QueryWrapper();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(codeList)) {
            customerEoQueryWrapper.in((Object)"code", codeList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(idList)) {
            customerEoQueryWrapper.in((Object)"id", idList);
        }
        customerEoQueryWrapper.eq((Object)"dr", (Object)"0");
        List customerEos = this.customerMapper.selectList((Wrapper)customerEoQueryWrapper);
        Map<Object, Object> customerRegionMap = new HashMap();
        Map<Object, Object> areaEoMap = new HashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerEos)) {
            List customerIds = customerEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            QueryWrapper customerRegionEoQueryWrapper = new QueryWrapper();
            customerRegionEoQueryWrapper.in((Object)"customer_id", customerIds);
            customerRegionEoQueryWrapper.eq((Object)"dr", (Object)"0");
            List rCustomerRegionEos = this.rCustomerRegionMapper.selectList((Wrapper)customerRegionEoQueryWrapper);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)rCustomerRegionEos)) {
                customerRegionMap = rCustomerRegionEos.stream().collect(Collectors.groupingBy(StdRCustomerRegionEo::getCustomerId));
                List regionCodeList = rCustomerRegionEos.stream().map(StdRCustomerRegionEo::getRegionCode).distinct().collect(Collectors.toList());
                QueryWrapper areaEoQueryWrapper = new QueryWrapper();
                areaEoQueryWrapper.in((Object)"code", regionCodeList);
                areaEoQueryWrapper.eq((Object)"dr", (Object)"0");
                List customerAreaEos = this.customerAreaMapper.selectList((Wrapper)areaEoQueryWrapper);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerAreaEos)) {
                    areaEoMap = customerAreaEos.stream().collect(Collectors.toMap(StdCustomerAreaEo::getCode, Function.identity(), (k1, k2) -> k1));
                }
            }
        }
        Map<Object, Object> customerTypeMap = new HashMap();
        List customerTypeIdList = customerEos.stream().filter(dto -> Objects.nonNull(dto.getCustomerTypeId())).map(StdCustomerEo::getCustomerTypeId).distinct().collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerTypeIdList) && CollectionUtils.isNotEmpty((Collection)(customerNameSimpleRespDtos = this.customerTypeMapper.queryCustomerTyperNameListByIds(customerTypeIdList)))) {
            customerTypeMap = customerNameSimpleRespDtos.stream().collect(Collectors.toMap(CustomerNameSimpleRespDto::getId, Function.identity()));
        }
        ArrayList respDtoList = Lists.newArrayList();
        for (CustomerEo customerEo : customerEos) {
            CustomerRespDto respDto = new CustomerRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)customerEo, (String[])new String[0]);
            if (!customerTypeMap.isEmpty() && customerTypeMap.containsKey(respDto.getCustomerTypeId())) {
                CustomerNameSimpleRespDto customerNameSimpleRespDto = (CustomerNameSimpleRespDto)customerTypeMap.get(respDto.getCustomerTypeId());
                respDto.setCustomerTypeName(customerNameSimpleRespDto.getName());
            }
            if (!customerRegionMap.isEmpty() && customerRegionMap.containsKey(customerEo.getId())) {
                List rCustomerRegionEos = (List)customerRegionMap.get(customerEo.getId());
                String regionNames = "";
                for (RCustomerRegionEo rCustomerRegionEo : rCustomerRegionEos) {
                    if (areaEoMap.isEmpty() || !areaEoMap.containsKey(rCustomerRegionEo.getRegionCode())) continue;
                    if ("".equals(regionNames)) {
                        regionNames = ((CustomerAreaEo)areaEoMap.get(rCustomerRegionEo.getRegionCode())).getName();
                        continue;
                    }
                    regionNames = regionNames + ";" + ((CustomerAreaEo)areaEoMap.get(rCustomerRegionEo.getRegionCode())).getName();
                }
                respDto.setRegionNames(regionNames);
                respDto.setRegionCodeList(rCustomerRegionEos.stream().map(StdRCustomerRegionEo::getRegionCode).collect(Collectors.toList()));
            }
            respDtoList.add(respDto);
        }
        return respDtoList;
    }

    @Override
    public List<CustomerRespDto> queryCustomerByIdList(List<Long> idList) {
        return this.queryCustomerByList(null, idList);
    }

    @Override
    public List<CustomerRespDto> queryCustomerByCodeList(List<String> codeList) {
        return this.queryCustomerByList(codeList, null);
    }

    @Override
    public List<EmployeeCustomerRespDto> queryEmployeeCustomerList(EmployeeCustomerQueryReqDto queryReqDto) {
        this.logger.info("\u67e5\u8be2\u4eba\u5458\u5173\u8054\u5ba2\u6237\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)queryReqDto));
        String attachment = ServiceContext.getContext().getAttachment("yes-req-cus-b2b-organizationId");
        if (Objects.isNull(queryReqDto.getMerchantId()) && StringUtils.isNotEmpty((CharSequence)attachment)) {
            queryReqDto.setMerchantId(Long.valueOf(attachment));
        }
        EmployeeCustomerEo employeeCustomerEo = EmployeeCustomerEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)employeeCustomerEo);
        List eoList = this.employeeCustomerDas.select((BaseEo)employeeCustomerEo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)eoList)) {
            return Lists.newArrayList();
        }
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eoList, (Collection)respDtos, EmployeeCustomerRespDto.class);
        List<Long> customerIdList = respDtos.stream().map(EmployeeCustomerRespDto::getCustomerId).distinct().collect(Collectors.toList());
        List<CustomerRespDto> customerDtoList = this.queryCustomerByIdList(customerIdList);
        Map<Object, Object> customerDtoMap = new HashMap(customerDtoList.size() * 4 / 3 + 2);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerDtoList)) {
            customerDtoMap = customerDtoList.stream().collect(Collectors.toMap(BaseRespDto::getId, Function.identity(), (k1, k2) -> k1));
        }
        for (EmployeeCustomerRespDto respDto : respDtos) {
            if (customerDtoMap.isEmpty() || !customerDtoMap.containsKey(respDto.getCustomerId())) continue;
            CustomerRespDto customerRespDto = (CustomerRespDto)customerDtoMap.get(respDto.getCustomerId());
            respDto.setCustomerCode(customerRespDto.getCode());
            respDto.setCustomerName(customerRespDto.getName());
            respDto.setCustomerRegionNames(customerRespDto.getRegionNames());
        }
        return respDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveEmployeeBindInfo(EmployeeCustomerAddReqDto addReqDto) {
        List customerBlackList;
        Date date;
        String dateFormat;
        List customerInfoList;
        Date date2;
        String dateFormat2;
        List regionInfoList;
        this.logger.info("\u66f4\u65b0\u4eba\u5458\u7ed1\u5b9a\u5ba2\u6237\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)addReqDto));
        AssertUtil.notNull((Object)addReqDto, (String)"\u5fc5\u4f20\u53c2\u6570DTO\u4e3a\u7a7a");
        AssertUtil.notNull((Object)addReqDto.getEmployeeId(), (String)"\u5fc5\u4f20\u53c2\u6570\u4eba\u5458ID\u4e3a\u7a7a");
        AssertUtil.notNull((Object)addReqDto.getMerchantId(), (String)"\u5fc5\u4f20\u53c2\u6570\u5546\u5bb6ID\u4e3a\u7a7a");
        QueryWrapper employeeRegionQuery = new QueryWrapper();
        employeeRegionQuery.eq((Object)"employee_id", (Object)addReqDto.getEmployeeId());
        employeeRegionQuery.eq((Object)"merchant_id", (Object)addReqDto.getMerchantId());
        employeeRegionQuery.eq((Object)"dr", (Object)0);
        Integer employeeRegionNum = this.employeeRegionMapper.selectCount((Wrapper)employeeRegionQuery);
        this.logger.info("\u66f4\u65b0\u4eba\u5458\u7ed1\u5b9a\u533a\u57df\u67e5\u8be2\u6761\u6570:{}", (Object)JSON.toJSONString((Object)employeeRegionNum));
        if (employeeRegionNum > 0) {
            int deleteNum = this.employeeRegionMapper.delete((Wrapper)employeeRegionQuery);
            this.logger.info("\u66f4\u65b0\u4eba\u5458\u7ed1\u5b9a\u533a\u57df\u5220\u9664\u6761\u6570:{}", (Object)JSON.toJSONString((Object)deleteNum));
            if (deleteNum != employeeRegionNum) {
                throw new BizException("\u5220\u9664\u4eba\u5458\u7ed1\u5b9a\u533a\u57df\u9519\u8bef");
            }
        }
        QueryWrapper employeeCustomerQuery = new QueryWrapper();
        employeeCustomerQuery.eq((Object)"employee_id", (Object)addReqDto.getEmployeeId());
        employeeCustomerQuery.eq((Object)"merchant_id", (Object)addReqDto.getMerchantId());
        employeeCustomerQuery.eq((Object)"dr", (Object)0);
        Integer employeeCustomerNum = this.employeeCustomerMapper.selectCount((Wrapper)employeeCustomerQuery);
        this.logger.info("\u66f4\u65b0\u4eba\u5458\u7ed1\u5b9a\u5ba2\u6237\u67e5\u8be2\u6761\u6570:{}", (Object)JSON.toJSONString((Object)employeeCustomerNum));
        if (employeeCustomerNum > 0) {
            int deleteNum = this.employeeCustomerMapper.delete((Wrapper)employeeCustomerQuery);
            this.logger.info("\u66f4\u65b0\u4eba\u5458\u7ed1\u5b9a\u5ba2\u6237\u5220\u9664\u6761\u6570:{}", (Object)JSON.toJSONString((Object)deleteNum));
            if (deleteNum != employeeCustomerNum) {
                throw new BizException("\u5220\u9664\u4eba\u5458\u5ba2\u6237\u4fe1\u606f\u9519\u8bef");
            }
        }
        QueryWrapper employeeCustomerBlackQuery = new QueryWrapper();
        employeeCustomerBlackQuery.eq((Object)"employee_id", (Object)addReqDto.getEmployeeId());
        employeeCustomerBlackQuery.eq((Object)"merchant_id", (Object)addReqDto.getMerchantId());
        employeeCustomerBlackQuery.eq((Object)"dr", (Object)0);
        Integer employeeCustomerBlackNum = this.employeeCustomerBlacklistMapper.selectCount((Wrapper)employeeCustomerBlackQuery);
        this.logger.info("\u66f4\u65b0\u4eba\u5458\u7ed1\u5b9a\u5ba2\u6237\u9ed1\u540d\u5355\u67e5\u8be2\u6761\u6570:{}", (Object)JSON.toJSONString((Object)employeeCustomerBlackNum));
        if (employeeCustomerBlackNum > 0) {
            int deleteNum = this.employeeCustomerBlacklistMapper.delete((Wrapper)employeeCustomerBlackQuery);
            this.logger.info("\u66f4\u65b0\u4eba\u5458\u7ed1\u5b9a\u5ba2\u6237\u9ed1\u540d\u5355\u5220\u9664\u6761\u6570:{}", (Object)JSON.toJSONString((Object)deleteNum));
            if (deleteNum != employeeCustomerBlackNum) {
                throw new BizException("\u5220\u9664\u4eba\u5458\u5ba2\u6237\u9ed1\u540d\u5355\u4fe1\u606f\u9519\u8bef");
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(regionInfoList = addReqDto.getRegionInfoList()))) {
            ArrayList addList = Lists.newArrayList();
            for (EmployeeRegionReqDto employeeRegionReqDto : regionInfoList) {
                Date endTime;
                EmployeeRegionEo addEo = EmployeeRegionEo.newInstance();
                CubeBeanUtils.copyProperties((Object)addEo, (Object)employeeRegionReqDto, (String[])new String[0]);
                Date startTime = addEo.getStartTime();
                if (Objects.nonNull(startTime)) {
                    String dateFormat3 = DateUtil.getDateFormat((Date)startTime, (String)"yyyy-MM-dd");
                    Date date3 = DateUtil.parseDate((String)dateFormat3, (String)"yyyy-MM-dd");
                    addEo.setStartTime(date3);
                }
                if (Objects.nonNull(endTime = addEo.getEndTime())) {
                    dateFormat2 = DateUtil.getDateFormat((Date)endTime, (String)"yyyy-MM-dd");
                    date2 = DateUtil.parseDate((String)dateFormat2, (String)"yyyy-MM-dd");
                    addEo.setEndTime(date2);
                }
                addEo.setEmployeeId(addReqDto.getEmployeeId());
                addEo.setUserId(addReqDto.getUserId());
                addEo.setMerchantId(addReqDto.getMerchantId());
                addList.add(addEo);
            }
            this.employeeRegionMapper.insertBatch((List)addList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(customerInfoList = addReqDto.getCustomerInfoList()))) {
            ArrayList addList = Lists.newArrayList();
            for (EmployeeCustomerReqDto addDto : customerInfoList) {
                Date endTime;
                EmployeeCustomerEo addEo = EmployeeCustomerEo.newInstance();
                CubeBeanUtils.copyProperties((Object)addEo, (Object)addDto, (String[])new String[0]);
                Date startTime = addEo.getStartTime();
                if (Objects.nonNull(startTime)) {
                    dateFormat2 = DateUtil.getDateFormat((Date)startTime, (String)"yyyy-MM-dd");
                    date2 = DateUtil.parseDate((String)dateFormat2, (String)"yyyy-MM-dd");
                    addEo.setStartTime(date2);
                }
                if (Objects.nonNull(endTime = addEo.getEndTime())) {
                    dateFormat = DateUtil.getDateFormat((Date)endTime, (String)"yyyy-MM-dd");
                    date = DateUtil.parseDate((String)dateFormat, (String)"yyyy-MM-dd");
                    addEo.setEndTime(date);
                }
                addEo.setEmployeeId(addReqDto.getEmployeeId());
                addEo.setUserId(addReqDto.getUserId());
                addEo.setMerchantId(addReqDto.getMerchantId());
                addList.add(addEo);
            }
            this.employeeCustomerMapper.insertBatch((List)addList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(customerBlackList = addReqDto.getCustomerBlackList()))) {
            ArrayList addList = Lists.newArrayList();
            for (EmployeeCustomerBlacklistReqDto addDto : customerBlackList) {
                Date endTime;
                EmployeeCustomerBlacklistEo addEo = EmployeeCustomerBlacklistEo.newInstance();
                CubeBeanUtils.copyProperties((Object)addEo, (Object)addDto, (String[])new String[0]);
                Date startTime = addEo.getStartTime();
                if (Objects.nonNull(startTime)) {
                    dateFormat = DateUtil.getDateFormat((Date)startTime, (String)"yyyy-MM-dd");
                    date = DateUtil.parseDate((String)dateFormat, (String)"yyyy-MM-dd");
                    addEo.setStartTime(date);
                }
                if (Objects.nonNull(endTime = addEo.getEndTime())) {
                    String dateFormat4 = DateUtil.getDateFormat((Date)endTime, (String)"yyyy-MM-dd");
                    Date date4 = DateUtil.parseDate((String)dateFormat4, (String)"yyyy-MM-dd");
                    addEo.setEndTime(date4);
                }
                addEo.setEmployeeId(addReqDto.getEmployeeId());
                addEo.setUserId(addReqDto.getUserId());
                addEo.setMerchantId(addReqDto.getMerchantId());
                addList.add(addEo);
            }
            this.employeeCustomerBlacklistMapper.insertBatch((List)addList);
        }
    }

    @Override
    public PageInfo<CustomerRespDto> queryValidCustomerPage(CustomerSearchExtReqDto searchReqDto) {
        List customerNameSimpleRespDtos;
        List customerLevelEos;
        UserDto userDto;
        Integer adminFlag;
        this.logger.info("\u67e5\u8be2\u6709\u6548\u5ba2\u6237\u5206\u9875\u5217\u8868\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)searchReqDto));
        if (searchReqDto.getListFlag().booleanValue()) {
            searchReqDto.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
        }
        if (Objects.isNull(adminFlag = (Integer)this.cacheService.hget("COMMON", "USER_ADMIN_KEY", ServiceContext.getContext().getRequestUserId() + "", Integer.class)) && Objects.equals((userDto = (UserDto)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)this.userQueryApi.queryById(ServiceContext.getContext().getRequestUserId(), "{}"))).getUserType(), 11)) {
            adminFlag = 1;
            this.cacheService.hset("COMMON", "USER_ADMIN_KEY", ServiceContext.getContext().getRequestUserId() + "", (Object)1, 0);
        }
        if (Objects.nonNull(searchReqDto.getSalesmanId())) {
            List orgIdList;
            List<Object> orgIdAllList = Lists.newArrayList();
            List rCustomerSalesmanRespDtos = this.rCustomerSalesmanService.queryByUserId(searchReqDto.getSalesmanId());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)rCustomerSalesmanRespDtos)) {
                orgIdList = rCustomerSalesmanRespDtos.stream().map(RCustomerSalesmanRespDto::getOrgId).collect(Collectors.toList());
                orgIdAllList.addAll(orgIdList);
            }
            orgIdList = (List)RestResponseHelper.extractData((RestResponse)this.employeeExpandQueryApi.getEmployeeOrgIdByUserId(searchReqDto.getSalesmanId()));
            this.logger.info("\u67e5\u8be2\u5f53\u524d\u4eba\u5458\u6709\u6548\u7684\u7ec4\u7ec7id:{}", (Object)JSON.toJSONString((Object)orgIdList));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orgIdList)) {
                orgIdAllList.addAll(orgIdList);
            }
            if (Objects.nonNull(searchReqDto.getMerchantId())) {
                orgIdAllList = orgIdAllList.stream().distinct().filter(t -> t.equals(searchReqDto.getMerchantId())).collect(Collectors.toList());
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orgIdAllList)) {
                return new PageInfo();
            }
            orgIdAllList = orgIdAllList.stream().distinct().collect(Collectors.toList());
            searchReqDto.setMerchantIds((List)orgIdAllList);
            if (!Objects.equals(adminFlag, 1) && Objects.nonNull(searchReqDto.getMerchantId()) && Objects.nonNull(ServiceContext.getContext().getRequestUserId())) {
                EmployeeExtQueryReqDto reqDto = new EmployeeExtQueryReqDto();
                reqDto.setOrganizationId(searchReqDto.getMerchantId());
                reqDto.setUserIds((List)Lists.newArrayList((Object[])new Long[]{ServiceContext.getContext().getRequestUserId()}));
                List employeeExtRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.employeeExpandQueryApi.getEmployeeByUserOrgList(reqDto));
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)employeeExtRespDtos)) {
                    return new PageInfo();
                }
                searchReqDto.setEmpId(((EmployeeExtRespDto)employeeExtRespDtos.get(0)).getId());
            } else if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)searchReqDto.getOrgInfoIds())) {
                searchReqDto.getMerchantIds().addAll(searchReqDto.getOrgInfoIds());
            }
        }
        String toDayTime = DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd");
        if (Objects.nonNull(searchReqDto.getSalesmanId())) {
            if (!Objects.equals(adminFlag, 1)) {
                List<String> areaCodeList = this.employeeCustomerDas.queryValidAreaCodeList(searchReqDto.getSalesmanId(), toDayTime, searchReqDto.getMerchantId());
                QueryWrapper areaEoQueryWrapper = new QueryWrapper();
                areaEoQueryWrapper.in((Object)"org_info_id", (Collection)searchReqDto.getMerchantIds());
                areaEoQueryWrapper.eq((Object)"dr", (Object)0);
                List customerAreaEos = this.customerAreaMapper.selectList((Wrapper)areaEoQueryWrapper);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerAreaEos)) {
                    List<String> allCodeList = areaCodeList;
                    allCodeList = this.doGetCustomerAreaList(allCodeList, areaCodeList, customerAreaEos);
                    searchReqDto.setRegionCodes(allCodeList);
                }
            } else {
                QueryWrapper areaEoQueryWrapper = new QueryWrapper();
                areaEoQueryWrapper.in((Object)"org_info_id", (Collection)searchReqDto.getMerchantIds());
                areaEoQueryWrapper.eq((Object)"dr", (Object)0);
                List customerAreaEos = this.customerAreaMapper.selectList((Wrapper)areaEoQueryWrapper);
                searchReqDto.setRegionCodes(customerAreaEos.stream().map(StdCustomerAreaEo::getCode).distinct().collect(Collectors.toList()));
            }
        }
        searchReqDto.setToDayTime(toDayTime);
        PageInfo customerPage = this.employeeCustomerDas.queryValidCustomerPage(searchReqDto);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customerPage.getList())) {
            return customerPage;
        }
        Map<Object, Object> customerRegionMap = new HashMap();
        Map<Object, Object> areaEoMap = new HashMap();
        List customerIds = customerPage.getList().stream().map(BaseRespDto::getId).collect(Collectors.toList());
        QueryWrapper customerRegionEoQueryWrapper = new QueryWrapper();
        customerRegionEoQueryWrapper.in((Object)"customer_id", customerIds);
        customerRegionEoQueryWrapper.eq((Object)"dr", (Object)"0");
        List rCustomerRegionEos = this.rCustomerRegionMapper.selectList((Wrapper)customerRegionEoQueryWrapper);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)rCustomerRegionEos)) {
            customerRegionMap = rCustomerRegionEos.stream().collect(Collectors.groupingBy(StdRCustomerRegionEo::getCustomerId));
            List regionCodeList = rCustomerRegionEos.stream().map(StdRCustomerRegionEo::getRegionCode).distinct().collect(Collectors.toList());
            QueryWrapper areaEoQueryWrapper = new QueryWrapper();
            areaEoQueryWrapper.in((Object)"code", regionCodeList);
            areaEoQueryWrapper.eq((Object)"dr", (Object)"0");
            List customerAreaEos = this.customerAreaMapper.selectList((Wrapper)areaEoQueryWrapper);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerAreaEos)) {
                areaEoMap = customerAreaEos.stream().collect(Collectors.toMap(StdCustomerAreaEo::getCode, Function.identity(), (k1, k2) -> k1));
            }
        }
        Map<Object, Object> levelEoMap = new HashMap();
        List levelIdList = customerPage.getList().stream().map(CustomerRespDto::getLevelId).distinct().collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(levelIdList) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(customerLevelEos = this.customerLevelMapper.selectBatchIds(levelIdList)))) {
            levelEoMap = customerLevelEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        }
        Map<Object, Object> orgSellerMap = new HashMap();
        List merchantIdList = customerPage.getList().stream().filter(dto -> Objects.nonNull(dto.getMerchantId())).map(CustomerRespDto::getMerchantId).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(merchantIdList)) {
            merchantIdList = merchantIdList.stream().distinct().collect(Collectors.toList());
            SellerExtQueryReqDto queryReqDto = new SellerExtQueryReqDto();
            queryReqDto.setOrgIdList(merchantIdList);
            List orgSellerList = (List)RestResponseHelper.extractData((RestResponse)this.sellerExpandQueryApi.queryBatchSellerList(queryReqDto));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orgSellerList)) {
                orgSellerMap = orgSellerList.stream().collect(Collectors.toMap(SellerRespDto::getOrganizationId, Function.identity(), (k1, k2) -> k1));
            }
        }
        Map<Object, Object> customerTypeMap = new HashMap();
        List customerTypeIdList = customerPage.getList().stream().map(CustomerRespDto::getCustomerTypeId).distinct().collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerTypeIdList) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(customerNameSimpleRespDtos = this.customerTypeMapper.queryCustomerTyperNameListByIds(customerTypeIdList)))) {
            customerTypeMap = customerNameSimpleRespDtos.stream().collect(Collectors.toMap(CustomerNameSimpleRespDto::getId, Function.identity(), (k1, k2) -> k1));
        }
        List customerRespDtos = customerPage.getList();
        for (CustomerRespDto customerRespDto : customerRespDtos) {
            CustomerGroupEo customerGroupEo;
            if (customerRespDto.getParentCustomerId() != null) {
                CustomerEo customerEo1 = (CustomerEo)this.customerDas.selectByPrimaryKey(customerRespDto.getParentCustomerId());
                customerEo1 = customerEo1 == null ? new CustomerEo() : customerEo1;
                customerRespDto.setParentCustomerName(customerEo1.getName());
            }
            if (StatusEnum.ENABLED.getCode().equals(customerRespDto.getRecordStatus()) && StatusEnum.ENABLED.getCode().equals(customerRespDto.getAccountStatus())) {
                customerRespDto.setValetFlag(StatusEnum.ENABLED.getCode());
            } else {
                customerRespDto.setValetFlag(StatusEnum.DISABLED.getCode());
            }
            if (null != customerRespDto.getCustomerGroupId() && null != (customerGroupEo = (CustomerGroupEo)this.customerGroupDas.selectByPrimaryKey(customerRespDto.getCustomerGroupId()))) {
                customerRespDto.setCustomerGroupName(customerGroupEo.getGroupName());
            }
            if (!levelEoMap.isEmpty() && levelEoMap.containsKey(customerRespDto.getLevelId())) {
                CustomerLevelEo customerLevelEo = (CustomerLevelEo)levelEoMap.get(customerRespDto.getLevelId());
                customerRespDto.setLevelName(customerLevelEo.getName());
            }
            if (!customerTypeMap.isEmpty() && customerTypeMap.containsKey(customerRespDto.getCustomerTypeId())) {
                CustomerNameSimpleRespDto simpleRespDto = (CustomerNameSimpleRespDto)customerTypeMap.get(customerRespDto.getCustomerTypeId());
                customerRespDto.setCustomerTypeName(simpleRespDto.getName());
            }
            if (!customerRegionMap.isEmpty() && customerRegionMap.containsKey(customerRespDto.getId())) {
                List customerRegionEos = (List)customerRegionMap.get(customerRespDto.getId());
                String regionNames = "";
                for (RCustomerRegionEo rCustomerRegionEo : customerRegionEos) {
                    if (areaEoMap.isEmpty() || !areaEoMap.containsKey(rCustomerRegionEo.getRegionCode())) continue;
                    if ("".equals(regionNames)) {
                        regionNames = ((CustomerAreaEo)areaEoMap.get(rCustomerRegionEo.getRegionCode())).getName();
                        continue;
                    }
                    regionNames = regionNames + ";" + ((CustomerAreaEo)areaEoMap.get(rCustomerRegionEo.getRegionCode())).getName();
                }
                customerRespDto.setRegionNames(regionNames);
                customerRespDto.setRegionCodeList(customerRegionEos.stream().map(StdRCustomerRegionEo::getRegionCode).distinct().collect(Collectors.toList()));
            }
            if (orgSellerMap.isEmpty() || !orgSellerMap.containsKey(customerRespDto.getMerchantId())) continue;
            SellerRespDto sellerRespDto = (SellerRespDto)orgSellerMap.get(customerRespDto.getMerchantId());
            customerRespDto.setMerchantName(sellerRespDto.getName());
        }
        return customerPage;
    }

    private List<String> doGetCustomerAreaList(List<String> allCodeList, List<String> areaCodeList, List<CustomerAreaEo> customerAreaEos) {
        List chlidCodeList = customerAreaEos.stream().filter(eo -> areaCodeList.contains(eo.getParentCode())).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(chlidCodeList)) {
            return allCodeList;
        }
        List<String> child = chlidCodeList.stream().map(StdCustomerAreaEo::getCode).collect(Collectors.toList());
        allCodeList.addAll(child);
        return this.doGetCustomerAreaList(allCodeList, child, customerAreaEos);
    }

    @Override
    public List<EmployeeCustomerRespDto> queryEmployee(CustomerExtReqDto reqDto) {
        this.logger.info("\u8fdb\u5165\u4eba\u5458\u67e5\u8be2\u81ea\u5b9a\u4e49\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        QueryWrapper<CustomerEo> queryWrapper = this.buildQueryWrapper(reqDto);
        List customerEos = this.customerMapper.selectList(queryWrapper);
        this.logger.info("\u67e5\u5ba2\u6237\u7f16\u7801\u6216\u5ba2\u6237\u540d\u79f0:{}", (Object)JSON.toJSONString((Object)customerEos));
        List employeeRegionEos = null;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqDto.getRegionCodeList())) {
            QueryWrapper regionQueryWrapper = new QueryWrapper();
            regionQueryWrapper.eq((Object)"merchant_id", (Object)reqDto.getMerchantId());
            regionQueryWrapper.eq((Object)"instance_id", (Object)reqDto.getInstanceId());
            regionQueryWrapper.in((Object)"region_code", (Collection)reqDto.getRegionCodeList());
            employeeRegionEos = this.employeeRegionMapper.selectList((Wrapper)regionQueryWrapper);
        }
        this.logger.info("\u67e5\u5ba2\u6237\u533a\u57df:{}", (Object)JSON.toJSONString(employeeRegionEos));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customerEos) && org.apache.commons.collections.CollectionUtils.isEmpty(employeeRegionEos)) {
            return null;
        }
        QueryWrapper employeeCustomerQueryWrapper = new QueryWrapper();
        employeeCustomerQueryWrapper.eq(Objects.nonNull(reqDto.getInstanceId()), (Object)"instance_id", (Object)reqDto.getInstanceId());
        employeeCustomerQueryWrapper.eq(Objects.nonNull(reqDto.getMerchantId()), (Object)"merchant_id", (Object)reqDto.getMerchantId());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerEos)) {
            employeeCustomerQueryWrapper.in((Object)"customer_id", (Collection)customerEos.stream().map(BaseEo::getId).collect(Collectors.toList()));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)employeeRegionEos)) {
            employeeCustomerQueryWrapper.in((Object)"employee_id", (Collection)employeeRegionEos.stream().map(EmployeeRegionEo::getEmployeeId).collect(Collectors.toList()));
        }
        List eos = this.employeeCustomerMapper.selectList((Wrapper)employeeCustomerQueryWrapper);
        this.logger.info("\u67e5\u4eba\u5458\u4e0e\u5ba2\u6237\u5173\u7cfb\u8868:{}", (Object)JSON.toJSONString((Object)eos));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)eos)) {
            return null;
        }
        List customerEoList = this.customerMapper.selectBatchIds((Collection)eos.stream().map(EmployeeCustomerEo::getCustomerId).collect(Collectors.toList()));
        this.logger.info("\u6279\u91cf\u6839\u636e\u5ba2\u6237ID\u67e5\u8be2:{}", (Object)JSON.toJSONString((Object)customerEoList));
        ArrayList<EmployeeCustomerRespDto> respDtos = new ArrayList<EmployeeCustomerRespDto>(32);
        for (EmployeeCustomerEo eo : eos) {
            EmployeeCustomerRespDto respDto = new EmployeeCustomerRespDto();
            respDto.setCustomerId(eo.getCustomerId());
            respDto.setMerchantId(eo.getMerchantId());
            respDto.setEmployeeId(eo.getEmployeeId());
            respDto.setUserId(eo.getUserId());
            respDto.setStartTime(eo.getStartTime());
            respDto.setEndTime(eo.getEndTime());
            respDto.setInstanceId(eo.getInstanceId());
            respDto.setTenantId(eo.getTenantId());
            if (Objects.nonNull(eo.getCustomerId()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerEoList)) {
                for (CustomerEo customerEo : customerEoList) {
                    if (!Objects.nonNull(customerEo) || !Objects.nonNull(customerEo.getId()) || eo.getCustomerId().longValue() != customerEo.getId().longValue()) continue;
                    respDto.setCustomerCode(StringUtils.isBlank((CharSequence)customerEo.getCode()) ? "" : customerEo.getCode());
                    respDto.setCustomerName(StringUtils.isBlank((CharSequence)customerEo.getName()) ? "" : customerEo.getName());
                }
            }
            respDtos.add(respDto);
        }
        return respDtos;
    }

    private QueryWrapper<CustomerEo> buildQueryWrapper(CustomerExtReqDto reqDto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        if (Objects.nonNull(reqDto.getOrgInfoId())) {
            queryWrapper.eq((Object)"org_info_id", (Object)reqDto.getOrgInfoId());
        }
        if (Objects.nonNull(reqDto.getMerchantId())) {
            queryWrapper.eq((Object)"merchant_id", (Object)reqDto.getMerchantId());
        }
        if (Objects.nonNull(reqDto.getUserId())) {
            queryWrapper.eq((Object)"user_id", (Object)reqDto.getUserId());
        }
        if (Objects.nonNull(reqDto.getInstanceId())) {
            queryWrapper.eq((Object)"instance_id", (Object)reqDto.getInstanceId());
        }
        if (Objects.nonNull(reqDto.getTenantId())) {
            queryWrapper.eq((Object)"tenant_id", (Object)reqDto.getTenantId());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getAuditStatus())) {
            queryWrapper.eq((Object)"audit_status", (Object)reqDto.getAuditStatus());
        }
        if (Objects.nonNull(reqDto.getType())) {
            queryWrapper.eq((Object)"type", (Object)reqDto.getType());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCode())) {
            queryWrapper.like((Object)"code", (Object)reqDto.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getName())) {
            queryWrapper.like((Object)"name", (Object)reqDto.getName());
        }
        this.logger.info("\u6784\u5efa\u81ea\u5b9a\u4e49\u4eba\u5458\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)queryWrapper));
        return queryWrapper;
    }

    @Override
    public List<EmployeeNumCountRespDto> queryCountByEmployeeId(EmployeeNumCountReqDto reqDto) {
        List customerEos;
        List regionEos;
        ArrayList<EmployeeNumCountRespDto> respDtos = new ArrayList<EmployeeNumCountRespDto>();
        if (Objects.isNull(reqDto) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqDto.getEmployeeIds()) || Objects.isNull(reqDto.getOrgId())) {
            return respDtos;
        }
        List employeeIds = reqDto.getEmployeeIds();
        Map<Long, Long> regionMap = null;
        Map<Long, Long> customerMap = null;
        QueryWrapper regionQueryWrapper = new QueryWrapper();
        regionQueryWrapper.in((Object)"employee_id", (Collection)employeeIds);
        regionQueryWrapper.eq((Object)"dr", (Object)"0");
        if (Objects.nonNull(reqDto.getOrgId())) {
            regionQueryWrapper.eq((Object)"merchant_id", (Object)reqDto.getOrgId());
        }
        if (Objects.nonNull(reqDto.getInstanceId())) {
            regionQueryWrapper.eq((Object)"instance_id", (Object)reqDto.getInstanceId());
        }
        if (Objects.nonNull(reqDto.getTenantId())) {
            regionQueryWrapper.eq((Object)"tenant_id", (Object)reqDto.getTenantId());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(regionEos = this.employeeRegionMapper.selectList((Wrapper)regionQueryWrapper)))) {
            regionMap = regionEos.stream().collect(Collectors.groupingBy(EmployeeRegionEo::getEmployeeId, Collectors.counting()));
        }
        QueryWrapper customerQueryWrapper = new QueryWrapper();
        customerQueryWrapper.in((Object)"employee_id", (Collection)employeeIds);
        customerQueryWrapper.eq((Object)"dr", (Object)"0");
        if (Objects.nonNull(reqDto.getOrgId())) {
            customerQueryWrapper.eq((Object)"merchant_id", (Object)reqDto.getOrgId());
        }
        if (Objects.nonNull(reqDto.getInstanceId())) {
            customerQueryWrapper.eq((Object)"instance_id", (Object)reqDto.getInstanceId());
        }
        if (Objects.nonNull(reqDto.getTenantId())) {
            customerQueryWrapper.eq((Object)"tenant_id", (Object)reqDto.getTenantId());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(customerEos = this.employeeCustomerMapper.selectList((Wrapper)customerQueryWrapper)))) {
            customerMap = customerEos.stream().collect(Collectors.groupingBy(EmployeeCustomerEo::getEmployeeId, Collectors.counting()));
        }
        for (Long employeeId : employeeIds) {
            EmployeeNumCountRespDto respDto = new EmployeeNumCountRespDto();
            respDto.setEmployeeId(employeeId);
            if (MapUtil.isNotEmpty(regionMap)) {
                respDto.setRegionNum(Long.valueOf(Objects.isNull(regionMap.get(employeeId)) ? 0L : regionMap.get(employeeId)));
            } else {
                respDto.setRegionNum(Long.valueOf(0L));
            }
            if (MapUtil.isNotEmpty(customerMap)) {
                respDto.setCustomerNum(Long.valueOf(Objects.isNull(customerMap.get(employeeId)) ? 0L : customerMap.get(employeeId)));
            } else {
                respDto.setCustomerNum(Long.valueOf(0L));
            }
            respDtos.add(respDto);
        }
        return respDtos;
    }

    @Override
    public PageInfo<CustomerRespDto> getCustomerByKeyword(CustomerSearchExtReqDto searchReqDto) {
        this.logger.info("\u9009\u62e9\u5ba2\u6237\u4fe1\u606f\u5206\u9875\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)searchReqDto));
        if (searchReqDto.getListFlag().booleanValue()) {
            searchReqDto.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
        }
        PageInfo customerPage = this.employeeCustomerDas.getCustomerByKeyword(searchReqDto);
        return customerPage;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveEmployeeBindInfoBatch(List<EmployeeCustomerAddReqDto> addReqDtoList) {
        for (EmployeeCustomerAddReqDto addReqDto : addReqDtoList) {
            this.saveEmployeeBindInfo(addReqDto);
        }
    }
}

