/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CheckPatternTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckRelationSourceOperateTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreGovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternConfigReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckPatternConfigDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckPatternConfigRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckPatternConfigService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckRelationService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreAreaService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernContentService;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckPatternConfigDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckPatternDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckRelationDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerCheckPatternConfigEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerCheckPatternEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerCheckRelationEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.biz.service.ICustomerQueryService;
import com.yx.tcbj.center.customer.biz.service.IStoreService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CustomerCheckPatternConfigServiceImpl
implements ICustomerCheckPatternConfigService {
    private static final Logger log = LoggerFactory.getLogger(CustomerCheckPatternConfigServiceImpl.class);
    @Resource
    private CustomerCheckPatternConfigDas customerCheckPatternConfigDas;
    @Resource
    private CustomerCheckPatternDas customerCheckPatternDas;
    @Resource
    private ICustomerQueryService customerQueryService;
    @Resource
    private IStoreSellerGovernContentService storeSellerGovernContentService;
    @Resource
    private IStoreAreaService storeAreaService;
    @Resource
    private CustomerCheckRelationDas customerCheckRelationDas;
    @Resource
    private IStoreService storeService;
    @Resource
    private ICustomerCheckRelationService customerCheckRelationService;

    @Override
    public Long addCustomerCheckPatternConfig(CustomerCheckPatternConfigReqDto addReqDto) {
        CustomerCheckPatternConfigEo customerCheckPatternConfigEo = new CustomerCheckPatternConfigEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerCheckPatternConfigEo);
        this.customerCheckPatternConfigDas.insert((BaseEo)customerCheckPatternConfigEo);
        return customerCheckPatternConfigEo.getId();
    }

    @Override
    public void saveOrUpdateCustomerCheckPatternConfig(CustomerCheckPatternConfigReqDto addReqDto) {
        log.info("\u767d\u540d\u5355\u914d\u7f6e\u8bf7\u6c42 params : {} .", (Object)JSON.toJSONString((Object)addReqDto));
        StoreGovernTypeEnum storeGovernTypeEnum = StoreGovernTypeEnum.enumOfCode((String)addReqDto.getConfigType());
        Assert.isTrue((null != storeGovernTypeEnum ? 1 : 0) != 0, (String)"0001", (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u914d\u7f6e\u7c7b\u578b");
        CustomerRespDto customerRespDto = this.customerQueryService.queryByOrgInfoId(addReqDto.getOrganizationId());
        CustomerCheckPatternReqDto reqDto = new CustomerCheckPatternReqDto();
        reqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{customerRespDto.getCode()}));
        List patternEoList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto);
        List<Long> orgIds = this.calculateOrgIds(patternEoList);
        List<String> delStoreList = this.verifyHistoryConfig(orgIds, addReqDto, storeGovernTypeEnum);
        CustomerCheckPatternConfigEo customerCheckPatternConfigEo = new CustomerCheckPatternConfigEo();
        customerCheckPatternConfigEo.setConfigType(storeGovernTypeEnum.getCode());
        customerCheckPatternConfigEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"organization_id", orgIds)}));
        this.customerCheckPatternConfigDas.delete((BaseEo)customerCheckPatternConfigEo);
        List collect = addReqDto.getConfigContentLists().stream().map(config -> {
            CustomerCheckPatternConfigEo customerCheckPatternConfig = new CustomerCheckPatternConfigEo();
            customerCheckPatternConfig.setConfigType(storeGovernTypeEnum.getCode());
            customerCheckPatternConfig.setConfigContent(config);
            customerCheckPatternConfig.setOrganizationId(addReqDto.getOrganizationId());
            return customerCheckPatternConfig;
        }).collect(Collectors.toList());
        if (storeGovernTypeEnum.getCode().equals(StoreGovernTypeEnum.BLACKLIST.getCode())) {
            this.restRelation(storeGovernTypeEnum, orgIds, addReqDto.getConfigContentLists());
        }
        if (!CollectionUtils.isEmpty(collect)) {
            int result = this.customerCheckPatternConfigDas.insertBatch(collect);
            Assert.isTrue((result > 0 ? 1 : 0) != 0, (String)"0001", (String)"\u767d\u540d\u5355\u914d\u7f6e\u5931\u8d25");
        }
        CustomerCheckPatternConfigReqDto customerCheckPatternConfigReqDto = new CustomerCheckPatternConfigReqDto();
        customerCheckPatternConfigReqDto.setOrganizationIds((List)Lists.newArrayList((Object[])new Long[]{addReqDto.getOrganizationId()}));
        PageInfo<CustomerCheckPatternConfigRespDto> customerCheckPatternConfigRespDtoPageInfo = this.queryByPage(JSON.toJSONString((Object)customerCheckPatternConfigReqDto), 1, Integer.MAX_VALUE);
        List<String> list = this.customerCheckRelationService.calculateStoreIds(customerCheckPatternConfigRespDtoPageInfo.getList());
        delStoreList.removeAll(list);
        this.restRelation(storeGovernTypeEnum, orgIds, delStoreList);
    }

    @NotNull
    private List<Long> calculateOrgIds(List<CustomerCheckPatternEo> customerCheckPatternEos) {
        List<Long> orgIds = customerCheckPatternEos.stream().map(c -> c.getOrgId()).distinct().collect(Collectors.toList());
        List mergeOrgIds = customerCheckPatternEos.stream().map(c -> c.getMergeOrgId()).distinct().collect(Collectors.toList());
        orgIds.addAll(mergeOrgIds);
        return orgIds;
    }

    private List<String> verifyHistoryConfig(List<Long> orgIds, CustomerCheckPatternConfigReqDto addReqDto, StoreGovernTypeEnum storeGovernTypeEnum) {
        CustomerCheckPatternConfigEo checkPatternConfigEo = new CustomerCheckPatternConfigEo();
        checkPatternConfigEo.setConfigType(storeGovernTypeEnum.getCode());
        checkPatternConfigEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"organization_id", orgIds)}));
        List historyConfig = this.customerCheckPatternConfigDas.select((BaseEo)checkPatternConfigEo);
        List<String> historyContents = historyConfig.stream().map(c -> c.getConfigContent()).collect(Collectors.toList());
        List<Object> contents = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(historyContents)) {
            switch (storeGovernTypeEnum) {
                case AREA: {
                    List<String> config = this.storeService.queryByArea(addReqDto.getConfigContentLists());
                    List<String> historyStores = this.storeService.queryByArea(historyContents);
                    historyStores.removeAll(config);
                    contents = historyStores;
                    break;
                }
                case STORE_PARENT: {
                    historyContents.removeAll(addReqDto.getConfigContentLists());
                    List<StoreRespDto> storeRespDtos = this.storeService.queryListByIds(historyContents);
                    if (CollectionUtils.isEmpty(storeRespDtos)) break;
                    List creditNums = storeRespDtos.stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
                    StoreQueryReqDto storeQueryReqDto = new StoreQueryReqDto();
                    storeQueryReqDto.setParentSocialCreditNums(creditNums);
                    storeQueryReqDto.setPageNum(1);
                    storeQueryReqDto.setPageSize(Integer.MAX_VALUE);
                    PageInfo<StoreRespDto> storeRespDtoPageInfo = this.storeService.queryPage(storeQueryReqDto);
                    contents = CollectionUtils.isEmpty((Collection)storeRespDtoPageInfo.getList()) ? Lists.newArrayList() : storeRespDtoPageInfo.getList().stream().map(c -> c.getStoreId()).collect(Collectors.toList());
                    break;
                }
                case STORE: {
                    historyContents.removeAll(addReqDto.getConfigContentLists());
                    contents = historyContents;
                }
            }
            log.info("\u914d\u7f6e\u7c7b\u578b \uff1a{} \u5386\u53f2\u5bf9\u6bd4\u5dee\u5f02\u914d\u7f6e\u5185\u5bb9 : {} .", (Object)storeGovernTypeEnum.getName(), historyContents);
        }
        return contents;
    }

    private void restRelation(StoreGovernTypeEnum storeGovernTypeEnum, List<Long> orgId, List<String> historyContents) {
        if (CollectionUtils.isEmpty(historyContents)) {
            return;
        }
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        customerCheckRelationEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"org_id", orgId)}));
        customerCheckRelationEo.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        List relationList = this.customerCheckRelationDas.select((BaseEo)customerCheckRelationEo);
        if (!CollectionUtils.isEmpty((Collection)relationList)) {
            List<CustomerCheckRelationEo> collect = relationList.stream().filter(c -> historyContents.contains(c.getStoreId())).collect(Collectors.toList());
            collect.forEach(c -> {
                c.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                c.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.MERGE_CHECK_PATTERN_CONFIG.getType());
                int result = this.customerCheckRelationDas.update((BaseEo)c);
                AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u91cd\u7f6e\u95e8\u5e97\u8003\u6838\u5173\u7cfb\u5931\u8d25");
            });
        }
    }

    @Override
    public void modifyCustomerCheckPatternConfig(CustomerCheckPatternConfigReqDto modifyReqDto) {
        CustomerCheckPatternConfigEo customerCheckPatternConfigEo = new CustomerCheckPatternConfigEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerCheckPatternConfigEo);
        this.customerCheckPatternConfigDas.updateSelective((BaseEo)customerCheckPatternConfigEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerCheckPatternConfig(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerCheckPatternConfigDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public void removeCustomerCheckPatternConfig(List<Long> orgIds) {
        CustomerCheckPatternConfigEo customerCheckPatternConfigEo = new CustomerCheckPatternConfigEo();
        customerCheckPatternConfigEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"organization_id", orgIds)}));
        this.customerCheckPatternConfigDas.delete((BaseEo)customerCheckPatternConfigEo);
    }

    @Override
    public CustomerCheckPatternConfigRespDto queryById(Long id) {
        CustomerCheckPatternConfigEo customerCheckPatternConfigEo = (CustomerCheckPatternConfigEo)this.customerCheckPatternConfigDas.selectByPrimaryKey(id);
        CustomerCheckPatternConfigRespDto customerCheckPatternConfigRespDto = new CustomerCheckPatternConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)customerCheckPatternConfigEo, (BaseVo)customerCheckPatternConfigRespDto);
        return customerCheckPatternConfigRespDto;
    }

    @Override
    public PageInfo<CustomerCheckPatternConfigRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerCheckPatternConfigReqDto customerCheckPatternConfigReqDto = (CustomerCheckPatternConfigReqDto)JSON.parseObject((String)filter, CustomerCheckPatternConfigReqDto.class);
        CustomerCheckPatternConfigEo customerCheckPatternConfigEo = new CustomerCheckPatternConfigEo();
        DtoHelper.dto2Eo((BaseVo)customerCheckPatternConfigReqDto, (BaseEo)customerCheckPatternConfigEo);
        if (!CollectionUtils.isEmpty((Collection)customerCheckPatternConfigReqDto.getOrganizationIds())) {
            customerCheckPatternConfigEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"organization_id", (Object)customerCheckPatternConfigReqDto.getOrganizationIds())}));
        }
        if (!StringUtils.isEmpty((Object)customerCheckPatternConfigEo.getOrganizationId())) {
            CustomerRespDto customerRespDto = this.customerQueryService.queryByOrgInfoId(customerCheckPatternConfigEo.getOrganizationId());
            Assert.isTrue((null != customerRespDto ? 1 : 0) != 0, (String)"0001", (String)"\u5f53\u524d\u5ba2\u6237\u4e0d\u5b58\u5728");
            CustomerCheckPatternReqDto reqDto = new CustomerCheckPatternReqDto();
            reqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{customerRespDto.getCode()}));
            List patternEoList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto);
            ArrayList orgIds = Lists.newArrayList();
            orgIds.addAll(patternEoList.stream().map(c -> c.getOrgId()).collect(Collectors.toList()));
            orgIds.addAll(patternEoList.stream().map(c -> c.getMergeOrgId()).collect(Collectors.toList()));
            if (!CollectionUtils.isEmpty((Collection)orgIds)) {
                customerCheckPatternConfigEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"organization_id", (Object)orgIds)}));
                customerCheckPatternConfigEo.setOrganizationId(null);
            }
        }
        PageInfo eoPageInfo = this.customerCheckPatternConfigDas.selectPage((BaseEo)customerCheckPatternConfigEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerCheckPatternConfigRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public CustomerCheckPatternConfigDetailRespDto calculateConfigTotal(Long orgId) {
        CustomerCheckPatternConfigDetailRespDto customerCheckPatternConfigDetailRespDto = new CustomerCheckPatternConfigDetailRespDto();
        List<CustomerCheckPatternEo> patternEoList = this.getCustomerCheckPatternEos(orgId);
        ArrayList orgIds = Lists.newArrayList();
        orgIds.addAll(patternEoList.stream().map(c -> c.getOrgId()).collect(Collectors.toList()));
        orgIds.addAll(patternEoList.stream().map(c -> c.getMergeOrgId()).collect(Collectors.toList()));
        CustomerCheckPatternConfigReqDto customerCheckPatternConfigReqDto = new CustomerCheckPatternConfigReqDto();
        customerCheckPatternConfigReqDto.setOrganizationIds((List)orgIds);
        PageInfo<CustomerCheckPatternConfigRespDto> eoPageInfo = this.queryByPage(JSON.toJSONString((Object)customerCheckPatternConfigReqDto), 1, Integer.MAX_VALUE);
        if (!CollectionUtils.isEmpty((Collection)eoPageInfo.getList())) {
            Map collect = eoPageInfo.getList().stream().collect(Collectors.groupingBy(CustomerCheckPatternConfigRespDto::getConfigType, Collectors.mapping(CustomerCheckPatternConfigRespDto::getConfigContent, Collectors.toList())));
            customerCheckPatternConfigDetailRespDto.setAreaConfigTotal(Integer.valueOf(((List)collect.getOrDefault(StoreGovernTypeEnum.AREA.getCode(), Lists.newArrayList())).stream().distinct().collect(Collectors.toList()).size()));
            customerCheckPatternConfigDetailRespDto.setStoreConfigTotal(Integer.valueOf(((List)collect.getOrDefault(StoreGovernTypeEnum.STORE.getCode(), Lists.newArrayList())).stream().distinct().collect(Collectors.toList()).size()));
            customerCheckPatternConfigDetailRespDto.setParentStoreConfigTotal(Integer.valueOf(((List)collect.getOrDefault(StoreGovernTypeEnum.STORE_PARENT.getCode(), Lists.newArrayList())).stream().distinct().collect(Collectors.toList()).size()));
            customerCheckPatternConfigDetailRespDto.setBlackListConfigTotal(Integer.valueOf(((List)collect.getOrDefault(StoreGovernTypeEnum.BLACKLIST.getCode(), Lists.newArrayList())).stream().distinct().collect(Collectors.toList()).size()));
        }
        return customerCheckPatternConfigDetailRespDto;
    }

    @Override
    public List<StoreAreaRespDto> queryCheckPatternConfigByOrgId(Long orgId) {
        List<CustomerCheckPatternEo> patternEoList = this.getCustomerCheckPatternEos(orgId);
        ArrayList orgIds = Lists.newArrayList();
        orgIds.addAll(patternEoList.stream().map(c -> c.getOrgId()).collect(Collectors.toList()));
        orgIds.addAll(patternEoList.stream().map(c -> c.getMergeOrgId()).collect(Collectors.toList()));
        List storeAreaRespDtoList = this.customerCheckPatternConfigDas.queryCheckPatternArea((List)orgIds);
        if (!CollectionUtils.isEmpty((Collection)storeAreaRespDtoList)) {
            Map<String, StoreAreaRespDto> collect = storeAreaRespDtoList.stream().collect(Collectors.toMap(StoreAreaRespDto::getCode, val -> val, (v1, v2) -> v1));
            return collect.values().stream().collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    @NotNull
    private List<CustomerCheckPatternEo> getCustomerCheckPatternEos(Long orgId) {
        CustomerRespDto customerRespDto = this.customerQueryService.queryByOrgInfoId(orgId);
        Assert.isTrue((null != customerRespDto ? 1 : 0) != 0, (String)"0001", (String)"\u5f53\u524d\u5ba2\u6237\u4e0d\u5b58\u5728");
        CustomerCheckPatternReqDto reqDto = new CustomerCheckPatternReqDto();
        reqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{customerRespDto.getCode()}));
        List patternEoList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto);
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)patternEoList) ? 1 : 0) != 0, (String)"0001", (String)"\u672a\u914d\u7f6e\u8003\u6838\u65b9\u5f0f");
        List verifyList = patternEoList.stream().filter(c -> !CheckPatternTypeEnum.MERGE_CHECK.getType().equals(c.getPatternType())).collect(Collectors.toList());
        Assert.isTrue((boolean)CollectionUtils.isEmpty(verifyList), (String)"0001", (String)"\u975e\u5408\u5e76\u8003\u6838\u65e0\u9700\u8bbe\u7f6e\u9ed1\u767d\u540d\u5355");
        return patternEoList;
    }

    @Override
    public PageInfo<StoreRespDto> queryCheckPatternConfigStore(Long orgId, String dataType, Integer pageNum, Integer pageSize) {
        StoreGovernTypeEnum storeGovernTypeEnum = StoreGovernTypeEnum.enumOfCode((String)dataType);
        Assert.isTrue((null != storeGovernTypeEnum ? 1 : 0) != 0, (String)"001", (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u6570\u636e\u7c7b\u578b!");
        Assert.isTrue((null != orgId ? 1 : 0) != 0, (String)"0001", (String)"\u7ec4\u7ec7ID\u4e0d\u4e3a\u7a7a!");
        List<CustomerCheckPatternEo> patternEoList = this.getCustomerCheckPatternEos(orgId);
        ArrayList orgIds = Lists.newArrayList();
        orgIds.addAll(patternEoList.stream().map(c -> c.getOrgId()).collect(Collectors.toList()));
        orgIds.addAll(patternEoList.stream().map(c -> c.getMergeOrgId()).collect(Collectors.toList()));
        return this.customerCheckPatternConfigDas.queryCheckPatternConfigStore((List)orgIds, dataType, pageNum, pageSize);
    }

    @Override
    public void synStoreSellerGovern(Long orgId) {
        CustomerRespDto customerRespDto = this.customerQueryService.queryByOrgInfoId(orgId);
        Assert.isTrue((null != customerRespDto ? 1 : 0) != 0, (String)"0001", (String)"\u5f53\u524d\u5ba2\u6237\u4e0d\u5b58\u5728");
        CustomerCheckPatternReqDto reqDto = new CustomerCheckPatternReqDto();
        reqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{customerRespDto.getCode()}));
        List patternEoList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto);
        if (CollectionUtils.isEmpty((Collection)patternEoList)) {
            log.info("\u672a\u914d\u7f6e\u8003\u6838\u65b9\u5f0f");
            return;
        }
        List verifyList = patternEoList.stream().filter(c -> !CheckPatternTypeEnum.MERGE_CHECK.getType().equals(c.getPatternType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(verifyList)) {
            log.info("\u975e\u5408\u5e76\u8003\u6838\u65b9\u5f0f");
            return;
        }
        this.calculateTenantRel(orgId, this.calculateOrgIds(patternEoList));
    }

    private void calculateTenantRel(Long orgId, List<Long> orgIds) {
        Arrays.stream(StoreGovernTypeEnum.values()).forEach(enums -> {
            if (StoreGovernTypeEnum.BLACKLIST.getCode().equals(enums.getCode())) {
                return;
            }
            if (enums.getCode().equals(StoreGovernTypeEnum.AREA.getCode())) {
                List<String> governAreaCodeList;
                List<StoreAreaRespDto> governAreaList = this.storeSellerGovernContentService.querySellerGovernAreaByOrgId(orgId);
                List<StoreAreaRespDto> configAreaList = this.queryCheckPatternConfigByOrgId(orgId);
                List<StoreAreaRespDto> areaTree = this.storeAreaService.queryTree();
                List<String> collect = this.calculateArea(areaTree, governAreaCodeList = governAreaList.stream().map(c -> c.getCode()).collect(Collectors.toList()));
                governAreaCodeList.addAll((Collection<String>)(CollectionUtils.isEmpty(collect) ? Lists.newArrayList() : collect));
                List resultList = configAreaList.stream().filter(c -> governAreaCodeList.contains(c.getCode())).map(c -> c.getCode()).collect(Collectors.toList());
                CustomerCheckPatternConfigReqDto customerCheckPatternConfigReqDto = new CustomerCheckPatternConfigReqDto();
                customerCheckPatternConfigReqDto.setConfigType(enums.getCode());
                customerCheckPatternConfigReqDto.setConfigContentLists(resultList);
                customerCheckPatternConfigReqDto.setOrganizationId(orgId);
                this.saveOrUpdateCustomerCheckPatternConfig(customerCheckPatternConfigReqDto);
            } else {
                PageInfo<StoreRespDto> governList = this.storeSellerGovernContentService.querySellerGovern(orgId, enums.getCode(), 1, Integer.MAX_VALUE);
                PageInfo configList = this.customerCheckPatternConfigDas.queryCheckPatternConfigStore((List)Lists.newArrayList((Iterable)orgIds), enums.getCode(), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
                if (!CollectionUtils.isEmpty((Collection)configList.getList())) {
                    ArrayList governStoreIdList = CollectionUtils.isEmpty((Collection)governList.getList()) ? Lists.newArrayList() : governList.getList().stream().map(c -> c.getStoreId()).collect(Collectors.toList());
                    List configStoreIdList = configList.getList().stream().map(c -> c.getStoreId()).collect(Collectors.toList());
                    List dealConfigStoreIdList = configStoreIdList.stream().filter(c -> governStoreIdList.contains(c)).collect(Collectors.toList());
                    log.info("\u7ba1\u8f96\u5173\u7cfb\u53d8\u66f4\u4ea4\u96c6 \uff1a{} .", (Object)JSON.toJSONString(dealConfigStoreIdList));
                    CustomerCheckPatternConfigReqDto customerCheckPatternConfigReqDto = new CustomerCheckPatternConfigReqDto();
                    customerCheckPatternConfigReqDto.setConfigType(enums.getCode());
                    customerCheckPatternConfigReqDto.setConfigContentLists(dealConfigStoreIdList);
                    customerCheckPatternConfigReqDto.setOrganizationId(orgId);
                    this.saveOrUpdateCustomerCheckPatternConfig(customerCheckPatternConfigReqDto);
                }
            }
        });
    }

    @NotNull
    private List<String> calculateArea(List<StoreAreaRespDto> areaTree, List<String> governAreaCodeList) {
        List<String> collect = areaTree.stream().filter(c -> governAreaCodeList.contains(c.getParentCode())).map(c -> c.getCode()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            collect.addAll(this.calculateArea(areaTree, collect));
        }
        return collect;
    }
}

