/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.StoreSearchReqDto;
import com.dtyunxi.tcbj.api.dto.response.StoreSearchRespDto;
import com.dtyunxi.tcbj.api.query.ICustomerDistributorsQueryApi;
import com.dtyunxi.tcbj.api.query.IStoreSearchQueryApi;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.IsDealEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.RoBootAccessTokenEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreAreaLevelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreCategoryCodeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreDataOriginEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.IfSupplyEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.DingTaskReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreModifyRecordReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreSellerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernContentRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernExcelRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerRelateRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreAreaService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreModifyRecordService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernContentService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerRelateService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerService;
import com.dtyunxi.yundt.cube.center.customer.biz.vo.StoreExcelVo;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreHistoryDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreModifyRecordDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreSellerGovernDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreSellerRelateDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreHistoryEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreSellerGovernEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreSellerRelateEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.dto.request.CompanyCheckReqDto;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.biz.service.ICustomerQueryService;
import com.yx.tcbj.center.customer.biz.service.IStoreService;
import com.yx.tcbj.center.customer.biz.service.impl.StoreHelper;
import com.yx.tcbj.center.customer.biz.util.DingTaskUtils;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class StoreServiceImpl
implements IStoreService {
    private static final Logger logger = LoggerFactory.getLogger(StoreServiceImpl.class);
    @Resource
    private StoreDas storeDas;
    @Resource
    private StoreHistoryDas storeHistoryDas;
    @Resource
    private IStoreSellerGovernContentService storeSellerGovernContentService;
    @Resource
    private IStoreSearchQueryApi storeSearchQueryApi;
    @Resource
    private IStoreAreaService storeAreaService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private StoreModifyRecordDas storeModifyRecordDas;
    @Resource
    private IStoreSellerService storeSellerService;
    @Resource
    private ICustomerQueryService customerQueryService;
    @Resource
    private IStoreSellerRelateService storeSellerRelateService;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;
    @Resource
    private ICustomerDistributorsQueryApi customerDistributorsQueryApi;
    @Resource
    private IStoreModifyRecordService storeModifyRecordService;
    @Resource
    private StoreHelper storeHelper;
    @Resource
    private StoreSellerGovernDas storeSellerGovernDas;
    @Resource
    private StoreSellerRelateDas storeSellerRelateDas;
    @Resource
    private IStoreSellerGovernService storeSellerGovernService;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private ILockService lockService;
    @Resource
    private DingTaskUtils dingTaskUtils;

    @Override
    public List<StoreRespDto> queryByStoreName(String storeName) {
        StoreEo storeEo = new StoreEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.like((String)"store_name", (Object)("%" + storeName + "%")));
        storeEo.setSqlFilters((List)sqlFilters);
        List stores = this.storeDas.select((BaseEo)storeEo);
        ArrayList storeRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)stores, (Collection)storeRespDtos, StoreRespDto.class);
        return storeRespDtos;
    }

    @Override
    public PageInfo<StoreRespDto> queryPageByStoreName(String storeName, Integer pageNum, Integer pageSize) {
        PageInfo storeRespDtoPageInfo = this.storeDas.queryPageByStoreName(storeName, Integer.valueOf(1), Integer.valueOf(20));
        return storeRespDtoPageInfo;
    }

    @Override
    public List<StoreRespDto> queryStoreCheck(CompanyCheckReqDto reqDto) {
        Assert.notNull((Object)reqDto.getCode(), (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getName(), (String)"\u516c\u53f8\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getLegalPersonName(), (String)"\u6cd5\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        StoreEo storeEo = new StoreEo();
        storeEo.setSocialCreditNum(reqDto.getCode());
        storeEo.setStoreName(reqDto.getName());
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getLegalPersonName())) {
            storeEo.setStoreName(reqDto.getLegalPersonName());
        }
        List storeEos = this.storeDas.select((BaseEo)storeEo);
        ArrayList dtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)storeEos, (Collection)dtoList, StoreRespDto.class);
        return dtoList;
    }

    @Override
    public void addStoreBatch(List<StoreReqDto> reqDtos) {
        boolean isRAP = reqDtos != null && !reqDtos.isEmpty() && reqDtos.get(0).getDataOrigin() != null && "3".equals(reqDtos.get(0).getDataOrigin().toString());
        ArrayList storeEos = Lists.newArrayList();
        DtoHelper.dtoList2EoList(reqDtos, (Collection)storeEos, StoreEo.class);
        storeEos.forEach(storeEo -> {
            storeEo.setStoreNo(this.storeHelper.generateStoreCode(storeEo.getStoreType()));
            if (isRAP) {
                storeEo.setCreatePerson("python001-rap");
                storeEo.setUpdatePerson("python001-rap");
                storeEo.setCreateTime(new Date());
                storeEo.setUpdateTime(new Date());
            }
        });
        this.storeDas.insertBatch((List)storeEos);
        List socialCreaditNums = storeEos.stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
        StoreEo storeEo2 = new StoreEo();
        storeEo2.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"social_credit_num", socialCreaditNums)}));
        List storeList = this.storeDas.select((BaseEo)storeEo2);
        storeList.forEach(c -> c.setStoreId(c.getId().toString()));
        if (!isRAP) {
            this.storeDas.updateBatch(storeList);
        }
        storeList.forEach(c -> {
            StoreModifyRecordReqDto storeModifyRecordReqDto = new StoreModifyRecordReqDto();
            storeModifyRecordReqDto.setStoreId(c.getStoreId());
            storeModifyRecordReqDto.setIsDeal(IsDealEnum.NOT_DEAL.getCode());
            storeModifyRecordReqDto.setModifyCode(StringUtils.join(Arrays.asList(GovernTypeEnum.AREA.getCode(), GovernTypeEnum.STOREPARENT.getCode()), (String)","));
            if (isRAP) {
                storeModifyRecordReqDto.setCreatePerson("python001-rap");
                storeModifyRecordReqDto.setUpdatePerson("python001-rap");
            }
            this.storeModifyRecordService.addStoreModifyRecord(storeModifyRecordReqDto);
        });
        logger.info("\u65b0\u589e/\u66f4\u65b0\u836f\u5e97\u4fe1\u606f->\u6839\u636e(1. \u6307\u5b9a\u95e8\u5e97 (\u95e8\u5e97id)  2. \u533a\u57df\u7ba1\u8f96 (\u7701\u5e02\u533a\u7f16\u7801) \u4e0a\u7ea7\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801  (\u4e0a\u7ea7\u95e8\u5e97id) \u9ed1\u540d\u5355 (\u95e8\u5e97id))\u89c4\u5219,\u5199\u5165\u65b0\u589e\u95e8\u5e97\u6570\u636e\u540c\u6b65\u5546\u5bb6\u5173\u7cfb [addStoreBatch] \u8bf7\u6c42Eos: " + JSONObject.toJSONString((Object)storeList));
        this.addStoreSellerRelateBySaveAfter(storeList, this.context.userName());
    }

    @Override
    public void addStore(StoreReqDto reqDtos) {
        StoreEo storeEo = new StoreEo();
        DtoHelper.dto2Eo((BaseVo)reqDtos, (BaseEo)storeEo);
        storeEo.setStoreNo(this.storeHelper.generateStoreCode(storeEo.getStoreType()));
        int result = this.storeDas.insert((BaseEo)storeEo);
        Assert.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u63d2\u5165\u836f\u5e97\u6570\u636e\u5f02\u5e38", (Object[])new Object[0]);
        storeEo.setStoreId(storeEo.getId().toString());
        this.storeDas.updateSelective((BaseEo)storeEo);
        StoreModifyRecordReqDto storeModifyRecordReqDto = new StoreModifyRecordReqDto();
        storeModifyRecordReqDto.setStoreId(storeEo.getId().toString());
        storeModifyRecordReqDto.setIsDeal(IsDealEnum.NOT_DEAL.getCode());
        storeModifyRecordReqDto.setModifyCode(StringUtils.join(Arrays.asList(GovernTypeEnum.AREA.getCode(), GovernTypeEnum.STOREPARENT.getCode()), (String)","));
        this.storeModifyRecordService.addStoreModifyRecord(storeModifyRecordReqDto);
        ArrayList<StoreEo> storeEos = new ArrayList<StoreEo>();
        storeEos.add(storeEo);
        logger.info("\u65b0\u589e/\u66f4\u65b0\u836f\u5e97\u4fe1\u606f->\u6839\u636e(1. \u6307\u5b9a\u95e8\u5e97 (\u95e8\u5e97id)  2. \u533a\u57df\u7ba1\u8f96 (\u7701\u5e02\u533a\u7f16\u7801) \u4e0a\u7ea7\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801  (\u4e0a\u7ea7\u95e8\u5e97id) \u9ed1\u540d\u5355 (\u95e8\u5e97id))\u89c4\u5219,\u5199\u5165\u65b0\u589e\u95e8\u5e97\u6570\u636e\u540c\u6b65\u5546\u5bb6\u5173\u7cfb [addStore] \u8bf7\u6c42Eos: " + JSONObject.toJSONString(storeEos));
        this.addStoreSellerRelateBySaveAfter(storeEos, this.context.userName());
    }

    @Override
    public List<StoreRespDto> querySocialCreditNums(List<String> socialCreditNums) {
        StoreEo storeEo = new StoreEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"social_credit_num", socialCreditNums));
        storeEo.setSqlFilters((List)sqlFilters);
        List storeEos = this.storeDas.select((BaseEo)storeEo);
        ArrayList storeRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)storeEos, (Collection)storeRespDtos, StoreRespDto.class);
        return storeRespDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStoreBatch(List<StoreReqDto> reqDtos) {
        List socialCreaditNums = reqDtos.stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
        StoreEo storeEo = new StoreEo();
        storeEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"social_credit_num", socialCreaditNums)}));
        List storeList = this.storeDas.select((BaseEo)storeEo);
        Map<String, StoreEo> storeMap = storeList.stream().collect(Collectors.toMap(key -> key.getSocialCreditNum(), val -> val, (k1, k2) -> k1));
        ArrayList storeEos = Lists.newArrayList();
        ArrayList historyStores = Lists.newArrayList();
        reqDtos.forEach(c -> {
            c.setId(((StoreEo)storeMap.get(c.getSocialCreditNum())).getId());
            StoreEo store = (StoreEo)storeMap.get(c.getSocialCreditNum());
            if (!Objects.equals(c.getParentSocialCreditNum(), store.getParentSocialCreditNum())) {
                if (StringUtils.isBlank((CharSequence)c.getParentSocialCreditNum()) && StringUtils.isBlank((CharSequence)store.getParentSocialCreditNum())) {
                    return;
                }
                c.setRelationChangeTime(new Date());
                StoreHistoryEo historyStore = new StoreHistoryEo();
                BeanUtil.copyProperties((Object)store, (Object)historyStore, (String[])new String[]{"id"});
                historyStore.setDr(1);
                historyStore.setId(null);
                historyStore.setRelationChangeTime(new Date());
                historyStores.add(historyStore);
            }
        });
        DtoHelper.dtoList2EoList(reqDtos, (Collection)storeEos, StoreEo.class);
        int result = this.storeDas.updateBatch((List)storeEos);
        Assert.isTrue((result >= 0 ? 1 : 0) != 0, (String)"\u6279\u91cf\u66f4\u65b0\u95e8\u5e97\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        reqDtos.forEach(c -> {
            ArrayList modifyType = Lists.newArrayList();
            StoreEo store = (StoreEo)storeMap.get(c.getSocialCreditNum());
            if (ObjectUtils.isNotEmpty((Object)c.getParentSocialCreditNum()) != ObjectUtils.isNotEmpty((Object)store.getParentSocialCreditNum())) {
                modifyType.add(GovernTypeEnum.STOREPARENT.getCode());
            }
            if (ObjectUtils.isNotEmpty((Object)c.getParentSocialCreditNum()) && ObjectUtils.isNotEmpty((Object)store.getParentSocialCreditNum()) && !c.getParentSocialCreditNum().equals(store.getParentSocialCreditNum())) {
                modifyType.add(GovernTypeEnum.STOREPARENT.getCode());
            }
            ArrayList sourceAreaCodeList = Lists.newArrayList((Object[])new String[]{store.getProvinceCode(), store.getCityCode(), store.getDistrictCode()});
            ArrayList targetAreaCodeList = Lists.newArrayList((Object[])new String[]{c.getProvinceCode(), c.getCityCode(), c.getDistrictCode()});
            sourceAreaCodeList.removeAll(targetAreaCodeList);
            if (CollectionUtils.isNotEmpty((Collection)sourceAreaCodeList)) {
                modifyType.add(GovernTypeEnum.AREA.getCode());
            }
            if (CollectionUtils.isNotEmpty((Collection)modifyType)) {
                StoreModifyRecordReqDto storeModifyRecordReqDto = new StoreModifyRecordReqDto();
                storeModifyRecordReqDto.setStoreId(c.getStoreId());
                storeModifyRecordReqDto.setModifyCode(StringUtils.join((Iterable)modifyType, (String)","));
                storeModifyRecordReqDto.setIsDeal(IsDealEnum.NOT_DEAL.getCode());
                this.storeModifyRecordService.addStoreModifyRecord(storeModifyRecordReqDto);
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)historyStores)) {
            this.storeHistoryDas.insertBatch((List)historyStores);
        }
        logger.info("\u65b0\u589e/\u66f4\u65b0\u836f\u5e97\u4fe1\u606f->\u6839\u636e(1. \u6307\u5b9a\u95e8\u5e97 (\u95e8\u5e97id)  2. \u533a\u57df\u7ba1\u8f96 (\u7701\u5e02\u533a\u7f16\u7801) \u4e0a\u7ea7\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801  (\u4e0a\u7ea7\u95e8\u5e97id) \u9ed1\u540d\u5355 (\u95e8\u5e97id))\u89c4\u5219,\u5199\u5165\u65b0\u589e\u95e8\u5e97\u6570\u636e\u540c\u6b65\u5546\u5bb6\u5173\u7cfb [updateStoreBatch]  \u8bf7\u6c42Eos: " + JSONObject.toJSONString((Object)storeEos));
        this.addStoreSellerRelateBySaveAfter(storeEos, this.context.userName());
    }

    @Override
    public void updateStore(StoreReqDto reqDto) {
        StoreEo storeEo = new StoreEo();
        BeanUtils.copyProperties((Object)reqDto, (Object)storeEo);
        ArrayList sqlFilters = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getSocialCreditNum())) {
            sqlFilters.add(SqlFilter.eq((String)"social_credit_num", (Object)reqDto.getSocialCreditNum()));
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getStoreId())) {
            sqlFilters.add(SqlFilter.eq((String)"store_id", (Object)reqDto.getStoreId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getParentSocialCreditNum())) {
            sqlFilters.add(SqlFilter.eq((String)"parent_social_credit_num", (Object)reqDto.getParentSocialCreditNum()));
        }
        if (CollectionUtils.isEmpty((Collection)sqlFilters)) {
            throw new BizException("\u6ca1\u6709\u4fee\u6539\u7684\u6761\u4ef6");
        }
        storeEo.setSqlFilters((List)sqlFilters);
        this.storeDas.updateSelectiveSqlFilter((BaseEo)storeEo);
        ArrayList<StoreEo> storeEos = new ArrayList<StoreEo>();
        storeEos.add(storeEo);
        logger.info("\u65b0\u589e/\u66f4\u65b0\u836f\u5e97\u4fe1\u606f->\u6839\u636e(1. \u6307\u5b9a\u95e8\u5e97 (\u95e8\u5e97id)  2. \u533a\u57df\u7ba1\u8f96 (\u7701\u5e02\u533a\u7f16\u7801) \u4e0a\u7ea7\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801  (\u4e0a\u7ea7\u95e8\u5e97id) \u9ed1\u540d\u5355 (\u95e8\u5e97id))\u89c4\u5219,\u5199\u5165\u65b0\u589e\u95e8\u5e97\u6570\u636e\u540c\u6b65\u5546\u5bb6\u5173\u7cfb [updateStore]  \u8bf7\u6c42Eos: " + JSONObject.toJSONString(storeEos));
        this.addStoreSellerRelateBySaveAfter(storeEos, this.context.userName());
    }

    @Override
    public PageInfo<StoreSearchRespDto> queryStoreListSearch(StoreSearchReqDto storeSearchReqDto) {
        logger.info("\u836f\u5e97\u67e5\u8be2\u641c\u7d22\u6761\u4ef6\uff0c{}", (Object)JSONObject.toJSONString((Object)storeSearchReqDto));
        Long orgId = null;
        orgId = storeSearchReqDto.getOrgId() != null ? storeSearchReqDto.getOrgId() : (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        logger.info("\u5f53\u524d\u5927B\u7ec4\u7ec7id\uff0c{}", (Object)orgId);
        storeSearchReqDto.setOrgId(orgId);
        PageInfo storeSearchRespDtos = (PageInfo)RestResponseHelper.extractData((RestResponse)this.storeSearchQueryApi.queryStoreListSearch(storeSearchReqDto));
        return storeSearchRespDtos;
    }

    @Override
    public List<String> queryStoreType() {
        List strings = this.storeDas.queryStoreType();
        if (strings == null) {
            return new ArrayList<String>();
        }
        return strings;
    }

    @Override
    public PageInfo<StoreRespDto> queryPage(StoreQueryReqDto reqDto) {
        PageInfo storeRespDtoPageInfo;
        if (ObjectUtils.isNotEmpty((Object)reqDto) && CollectionUtil.isNotEmpty((Collection)reqDto.getAreas())) {
            StringBuffer areaArr = new StringBuffer();
            areaArr.append("(");
            reqDto.getAreas().forEach(area -> areaArr.append((String)area).append(","));
            areaArr.deleteCharAt(areaArr.length() - 1).append(")");
            reqDto.setAreaArr(areaArr.toString());
        }
        if ((storeRespDtoPageInfo = this.storeDas.queryPage(reqDto, Integer.valueOf(reqDto.getPageNum()), Integer.valueOf(reqDto.getPageSize()))).getList() == null) {
            storeRespDtoPageInfo.setList(new ArrayList());
        }
        storeRespDtoPageInfo.getList().forEach(storeRespDto -> {
            StoreDataOriginEnum storeDataOriginEnum = StoreDataOriginEnum.find((Integer)storeRespDto.getDataOrigin());
            if (storeDataOriginEnum == null) {
                storeRespDto.setDataOriginName("-");
            } else {
                storeRespDto.setDataOriginName(storeDataOriginEnum.getName());
            }
        });
        return storeRespDtoPageInfo;
    }

    @Override
    public RestResponse<StoreSellerGovernExcelRespDto> excel(MultipartFile file, String brandMapStr) {
        StoreSellerGovernExcelRespDto respDto = new StoreSellerGovernExcelRespDto();
        respDto.setNum(Integer.valueOf(0));
        respDto.setSuccessNum(Integer.valueOf(0));
        respDto.setFailNum(Integer.valueOf(0));
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        importParams.setKeyIndex(null);
        List storeExcelVoList = Lists.newArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), StoreExcelVo.class, (ImportParams)importParams);
            storeExcelVoList = result.getList();
            if (CollectionUtils.isEmpty((Collection)storeExcelVoList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        Map brandMap = (Map)com.dtyunxi.huieryun.core.util.JSON.parseObject((String)brandMapStr, Map.class);
        HashMap storeSellerMap = Maps.newHashMap();
        ArrayList storeIdsList = Lists.newArrayList();
        HashMap customerMap = Maps.newHashMap();
        HashMap storeEoMap = Maps.newHashMap();
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        sellerQueryReqDto.setOrganizationId(orgId);
        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(orgId));
        logger.info("\u5356\u5bb6\u4fe1\u606f \u53c2\u6570:{},\u7ed3\u679c:{}", (Object)orgId, (Object)com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)sellerRespDto));
        this.verifyInfo(orgId, storeExcelVoList, sellerRespDto, customerMap, storeSellerMap, storeEoMap, storeIdsList);
        this.verifyImportData(storeExcelVoList, brandMap, storeSellerMap, storeIdsList, customerMap, storeEoMap, sellerRespDto);
        List errorList = storeExcelVoList.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getErrorMsg())).collect(Collectors.toList());
        Integer successNum = storeExcelVoList.size() - errorList.size();
        if (CollectionUtils.isNotEmpty(errorList)) {
            respDto.setFailNum(Integer.valueOf(errorList.size()));
            String excelName = "cube/\u836f\u5e97\u8bbe\u7f6e\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, StoreExcelVo.class, null, (String)excelName, (String)"xls");
                respDto.setErrorFile(exportUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u836f\u5e97\u8bbe\u7f6e\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u9519\u8bef:{}", (Object)e.toString());
                return new RestResponse("-1", "\u836f\u5e97\u8bbe\u7f6e\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u9519\u8bef:" + e);
            }
        }
        respDto.setNum(Integer.valueOf(storeExcelVoList.size()));
        respDto.setSuccessNum(successNum);
        return new RestResponse((Object)respDto);
    }

    private void verifyImportData(List<StoreExcelVo> storeExcelVoList, Map<String, String> brandMap, Map<String, StoreSellerRespDto> storeSellerMap, List<String> storeIdsList, Map<String, CustomerRespDto> customerMap, Map<String, StoreEo> storeEoMap, SellerRespDto sellerRespDto) {
        logger.info("\u5f53\u524d\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)com.dtyunxi.huieryun.core.util.JSON.toJsonString(storeExcelVoList));
        for (StoreExcelVo vo : storeExcelVoList) {
            if (Objects.isNull(sellerRespDto)) {
                this.excelErrorMsg(vo, "\u5546\u5bb6\u4fe1\u606f\u4e0d\u5b58\u5728");
                continue;
            }
            StoreEo store = storeEoMap.getOrDefault(vo.getSocialCreditNum(), null);
            logger.info("\u5f53\u524d\u5bfc\u5165\u6d89\u53ca\u95e8\u5e97\uff1a{}", (Object)com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)store));
            if (!StringUtils.isNotBlank((CharSequence)vo.getSocialCreditNum()) || ObjectUtils.isEmpty((Object)store) || !storeIdsList.contains(store.getStoreId())) {
                this.excelErrorMsg(vo, "\u836f\u5e97\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u65e0\u6cd5\u627e\u5230\u6216\u4e0d\u5728\u7ba1\u8f96\u8303\u56f4\u5185");
                continue;
            }
            StoreSellerReqDto dto = new StoreSellerReqDto();
            if (storeSellerMap != null && Objects.nonNull(storeSellerMap.get(store.getStoreId()))) {
                CubeBeanUtils.copyProperties((Object)dto, (Object)storeSellerMap.get(store.getStoreId()), (String[])new String[0]);
            }
            dto.setStoreId(store.getStoreId());
            dto.setSellerId(sellerRespDto.getId());
            if (StringUtils.isNotBlank((CharSequence)vo.getParentCustomerCode())) {
                if (Objects.isNull(customerMap.get(vo.getParentCustomerCode()))) {
                    this.excelErrorMsg(vo, "\u5ba2\u6237\u7f16\u53f7\u65e0\u6cd5\u627e\u5230\u6216\u65e0\u6743\u9650");
                    continue;
                }
                RestResponse customerRespDtoRestResponse = this.customerDistributorsQueryApi.queryCustomerByDistributionCode(vo.getParentCustomerCode());
                CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)customerRespDtoRestResponse);
                logger.info("\u3010\u62a5\u8868\u4e2d\u5fc3\u3011\u83b7\u53d6\u5206\u9500\u5546\u8be6\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)customerRespDto));
                if (ObjectUtils.isEmpty((Object)customerRespDto) || !StringUtils.isNotBlank((CharSequence)customerRespDto.getCreditCode())) {
                    this.excelErrorMsg(vo, "\u4e0a\u7ea7\u5206\u9500\u5546\u5ba2\u6237\u7f3a\u5c11\u4fe1\u7528\u4ee3\u7801");
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)customerRespDto) && StringUtils.isNotBlank((CharSequence)customerRespDto.getCreditCode()) && ObjectUtils.isNotEmpty((Object)store) && customerRespDto.getCreditCode().equals(store.getParentSocialCreditNum())) {
                    this.excelErrorMsg(vo, "\u4e0a\u7ea7\u5206\u9500\u5546\u4fe1\u7528\u4ee3\u7801\u4e0e\u5f53\u524d\u836f\u5e97\u4e0a\u7ea7\u4fe1\u7528\u4ee3\u7801\u4e00\u81f4");
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)customerRespDto) && StringUtils.isNotBlank((CharSequence)customerRespDto.getCreditCode()) && ObjectUtils.isNotEmpty((Object)store) && customerRespDto.getCreditCode().equals(store.getSocialCreditNum())) {
                    this.excelErrorMsg(vo, "\u4e0a\u7ea7\u5206\u9500\u5546\u4fe1\u7528\u4ee3\u7801\u4e0e\u5f53\u524d\u836f\u5e97\u4fe1\u7528\u4ee3\u7801\u4e00\u81f4");
                    continue;
                }
                dto.setParentDistributionCode(customerMap.get(vo.getParentCustomerCode()).getCode());
                dto.setParentDistributionId(customerMap.get(vo.getParentCustomerCode()).getId());
            } else {
                dto.setParentDistributionCode("");
                dto.setParentDistributionId(Long.valueOf(0L));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getIfSupply())) {
                IfSupplyEnum ifSupplyEnum = IfSupplyEnum.fromName((String)vo.getIfSupply());
                if (Objects.isNull(ifSupplyEnum)) {
                    this.excelErrorMsg(vo, "\u662f\u5426\u4f9b\u8d27\u683c\u5f0f\u6709\u8bef");
                    continue;
                }
                dto.setIfSupply(ifSupplyEnum.getCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getBrandNames())) {
                ArrayList notExistBrands = Lists.newArrayList();
                ArrayList existBrands = Lists.newArrayList();
                Arrays.stream(vo.getBrandNames().split(";")).distinct().forEach(e -> {
                    if (StringUtils.isBlank((CharSequence)((CharSequence)brandMap.get(e)))) {
                        notExistBrands.add(e);
                    } else {
                        existBrands.add(brandMap.get(e));
                    }
                });
                if (notExistBrands.size() > 0) {
                    this.excelErrorMsg(vo, "\u7ecf\u8425\u54c1\u724c[" + notExistBrands.stream().collect(Collectors.joining(";")) + "]\u4e0d\u5b58\u5728");
                    continue;
                }
                dto.setBrand(existBrands.stream().collect(Collectors.joining(";")));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getStoreCategory())) {
                StoreCategoryCodeEnum storeCategoryCodeEnum = StoreCategoryCodeEnum.fromName((String)vo.getStoreCategory());
                if (ObjectUtils.isEmpty((Object)storeCategoryCodeEnum)) {
                    this.excelErrorMsg(vo, "\u8be5\u836f\u5e97\u7c7b\u522b\u4e0d\u5b58\u5728");
                    continue;
                }
                dto.setStoreCategoryCode(storeCategoryCodeEnum.getCode());
            }
            StoreSellerRespDto storeSellerRespDto = new StoreSellerRespDto();
            CubeBeanUtils.copyProperties((Object)storeSellerRespDto, (Object)dto, (String[])new String[0]);
            if (dto.getId() == null) {
                Long id = this.storeSellerService.addStoreSeller(dto);
                storeSellerRespDto.setId(id);
            } else {
                this.storeSellerService.modifyStoreSeller(dto);
            }
            logger.info("\u66f4\u65b0\u95e8\u5e97\u4fe1\u606fMap\u96c6\u5408:{},{}", (Object)store.getStoreId(), (Object)com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)storeSellerRespDto));
            storeSellerMap.put(store.getStoreId(), storeSellerRespDto);
        }
    }

    private void verifyInfo(Long orgId, List<StoreExcelVo> storeExcelVoList, SellerRespDto sellerRespDto, Map<String, CustomerRespDto> customerMap, Map<String, StoreSellerRespDto> storeSellerMap, Map<String, StoreEo> storeEoMap, List<String> storeIdsList) {
        if (ObjectUtils.isNotEmpty((Object)sellerRespDto)) {
            StoreSellerReqDto reqDto = new StoreSellerReqDto();
            reqDto.setSellerId(sellerRespDto.getId());
            List<StoreSellerRespDto> storeSellerRespDtos = this.storeSellerService.selectList(reqDto);
            storeSellerMap.putAll(storeSellerRespDtos.stream().collect(Collectors.toMap(e -> e.getStoreId(), e -> e, (k1, k2) -> k1)));
            logger.info("\u5546\u5bb6\u836f\u5e97\u5173\u7cfb \u53c2\u6570:{},\u7ed3\u679c:{}", (Object)com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)reqDto), (Object)com.dtyunxi.huieryun.core.util.JSON.toJsonString(storeSellerMap));
            List collect = storeExcelVoList.stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
            StoreEo storeEo = new StoreEo();
            storeEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"social_credit_num", collect)}));
            List storeEos = this.storeDas.select((BaseEo)storeEo);
            storeEoMap.putAll(Optional.of(storeEos).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(StoreEo::getSocialCreditNum, c -> c)));
            logger.info("\u836f\u5e97\u6570\u636e\uff1a{}", (Object)com.dtyunxi.huieryun.core.util.JSON.toJsonString(storeEoMap));
            List<String> storeIds = storeEos.stream().map(c -> c.getStoreId()).collect(Collectors.toList());
            List<StoreSellerRelateRespDto> storeSellerRelateRespDtos = this.storeSellerRelateService.queryStoreSellerRelateBySellerId(sellerRespDto.getId(), storeIds);
            storeIdsList.addAll(storeSellerRelateRespDtos.stream().map(c -> c.getStoreId()).collect(Collectors.toList()));
            logger.info("\u5546\u5bb6\u7ba1\u8f96\u5185\u5bb9\uff1a{}", (Object)com.dtyunxi.huieryun.core.util.JSON.toJsonString(storeIdsList));
            List<String> codes = storeExcelVoList.stream().map(e -> e.getParentCustomerCode()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(codes)) {
                List<CustomerRespDto> customerRespDtoList = this.customerQueryService.queryCustomerListByCodesAndOrg(codes, orgId.toString());
                if (CollectionUtils.isNotEmpty(customerRespDtoList)) {
                    customerMap.putAll(customerRespDtoList.stream().collect(Collectors.toMap(e -> e.getCode(), e -> e, (k1, k2) -> k1)));
                }
                logger.info("\u5ba2\u6237\u4fe1\u606f \u53c2\u6570:{},\u7ed3\u679c:{}", (Object)com.dtyunxi.huieryun.core.util.JSON.toJsonString(codes), (Object)com.dtyunxi.huieryun.core.util.JSON.toJsonString(customerMap));
            }
        }
    }

    @Override
    public void deleteAllStore(Boolean ifConfirm) {
        if (ifConfirm.booleanValue()) {
            this.storeDas.deleteAllStore();
        }
    }

    @Override
    public void fillStoreAreaCode(List<String> storeIds) {
        logger.info("\u586b\u8865\u533a\u57dfCODE\u4fe1\u606f\uff1a{}", (Object)com.dtyunxi.huieryun.core.util.JSON.toJsonString(storeIds));
        if (CollectionUtils.isEmpty(storeIds)) {
            return;
        }
        List<StoreAreaRespDto> areaTreeList = this.storeAreaService.queryTree();
        for (StoreAreaRespDto area1 : areaTreeList) {
            if (!CollectionUtils.isNotEmpty((Collection)area1.getChildren())) continue;
            area1.getChildren().forEach(area2 -> {
                if (CollectionUtils.isNotEmpty((Collection)area2.getChildren())) {
                    area2.setChildrenMap(area2.getChildren().stream().collect(Collectors.toMap(StoreAreaRespDto::getName, StoreAreaRespDto2 -> StoreAreaRespDto2)));
                }
            });
            area1.setChildrenMap(area1.getChildren().stream().collect(Collectors.toMap(StoreAreaRespDto::getName, StoreAreaRespDto2 -> StoreAreaRespDto2)));
        }
        Map<String, StoreAreaRespDto> areaMap = areaTreeList.stream().collect(Collectors.toMap(StoreAreaRespDto::getName, StoreAreaRespDto2 -> StoreAreaRespDto2));
        List<StoreRespDto> storeList = this.queryListByIds(storeIds);
        storeList.forEach(store -> {
            StoreEo eo = new StoreEo();
            eo.setId(store.getId());
            StoreAreaRespDto province = (StoreAreaRespDto)areaMap.get(store.getProvince());
            if (ObjectUtils.isNotEmpty((Object)province)) {
                eo.setProvinceCode(province.getCode());
                StoreAreaRespDto city = (StoreAreaRespDto)province.getChildrenMap().get(store.getCity());
                if (ObjectUtils.isNotEmpty((Object)city)) {
                    eo.setCityCode(city.getCode());
                    StoreAreaRespDto district = (StoreAreaRespDto)city.getChildrenMap().get(store.getDistrict());
                    eo.setDistrictCode(district.getCode());
                }
            }
            this.storeDas.updateSelective((BaseEo)eo);
        });
        logger.info("\u836f\u5e97\u533a\u57df\u51fa\u73b0\u53d8\u66f4\uff0c\u66f4\u65b0\u7ba1\u8f96\u5173\u8054\u6570\u636e");
        ExecutorUtils.execute(() -> {
            logger.info("\u5f02\u6b65\u6267\u884c\uff1a\u836f\u5e97\u533a\u57df\u51fa\u73b0\u53d8\u66f4\uff0c\u66f4\u65b0\u7ba1\u8f96\u5173\u8054\u6570\u636e");
            this.storeSellerRelateService.updateRelateByStoreChange(storeIds);
        });
    }

    @Override
    public void fillStoreAreaCodeForNot() {
        List storeIds = this.storeDas.queryStoreAreaCodeForNot();
        if (CollectionUtil.isEmpty((Collection)storeIds)) {
            logger.info("\u65e0\u533a\u57dfcode\u4e3a\u7a7a\u7684\u836f\u5e97\u6570\u636e");
            return;
        }
        this.fillStoreAreaCode(storeIds);
    }

    @Override
    public void syncStore(List<StoreReqDto> reqDtoList) {
        logger.info("\u540c\u6b65\u836f\u5e97\u6570\u636e\uff1a{}", (Object)com.dtyunxi.huieryun.core.util.JSON.toJsonString(reqDtoList));
        if (CollectionUtils.isEmpty(reqDtoList)) {
            return;
        }
        List<String> storeIds = reqDtoList.stream().map(StoreReqDto::getStoreId).collect(Collectors.toList());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"store_id", storeIds));
        StoreEo params = new StoreEo();
        params.setSqlFilters(sqlFilters);
        List queryStoreList = this.storeDas.select((BaseEo)params);
        if (CollectionUtils.isEmpty((Collection)queryStoreList)) {
            this.addStoreBatch(reqDtoList);
            return;
        }
        ArrayList<StoreReqDto> insertList = new ArrayList<StoreReqDto>();
        reqDtoList.forEach(reqDto -> {
            StoreEo queryEo = null;
            for (StoreEo eo : queryStoreList) {
                if (!eo.getStoreId().equals(reqDto.getStoreId())) continue;
                queryEo = eo;
                break;
            }
            if (ObjectUtils.isEmpty(queryEo)) {
                insertList.add((StoreReqDto)reqDto);
            } else {
                StoreEo updateEo = new StoreEo();
                DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)updateEo);
                updateEo.setId(queryEo.getId());
                this.storeDas.update((BaseEo)updateEo);
            }
        });
        this.addStoreBatch(insertList);
        this.fillStoreAreaCode(storeIds);
    }

    @Override
    public List<String> queryByArea(List<String> areas) {
        if (CollectionUtil.isEmpty(areas)) {
            return new ArrayList<String>();
        }
        List storeIds = this.storeDas.queryStoreIdByArea(areas);
        if (storeIds == null) {
            return new ArrayList<String>();
        }
        return storeIds;
    }

    @Override
    public List<StoreRespDto> queryListByIds(List<String> storeIds) {
        if (CollectionUtil.isEmpty(storeIds)) {
            return new ArrayList<StoreRespDto>();
        }
        StoreEo params = new StoreEo();
        params.setSqlFilters((List)Stream.of(SqlFilter.in((String)"store_id", storeIds)).collect(Collectors.toCollection(ArrayList::new)));
        List select = this.storeDas.select((BaseEo)params);
        ArrayList<StoreRespDto> list = new ArrayList<StoreRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, list, StoreRespDto.class);
        return list;
    }

    @Override
    public StoreRespDto queryStoreRespDtoByCreditNum(String creditNum) {
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{creditNum})) {
            return null;
        }
        StoreEo params = new StoreEo();
        params.setSocialCreditNum(creditNum);
        StoreEo storeEo = (StoreEo)this.storeDas.selectOne((BaseEo)params);
        StoreRespDto storeRespDto = new StoreRespDto();
        DtoHelper.eo2Dto((BaseEo)storeEo, (BaseVo)storeRespDto);
        return storeRespDto;
    }

    @Override
    public StoreRespDto queryStoreRespDtoExtByCreditNum(String creditNum) {
        StoreRespDto storeRespDto = this.queryStoreRespDtoByCreditNum(creditNum);
        return storeRespDto;
    }

    @Override
    public List<StoreRespDto> queryStoreByParentSocialCreditNum(String parentSocialCreditNum) {
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{parentSocialCreditNum})) {
            return null;
        }
        StoreEo params = new StoreEo();
        params.setParentSocialCreditNum(parentSocialCreditNum);
        List storeEos = this.storeDas.selectList((BaseEo)params);
        ArrayList storeRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)storeEos, (Collection)storeRespDtoList, StoreRespDto.class);
        return storeRespDtoList;
    }

    @Deprecated
    private Map<String, StoreAreaRespDto> searchStoreArea(StoreReqDto reqDto, List<StoreAreaRespDto> areaList) {
        HashMap<String, StoreAreaRespDto> restMap = new HashMap<String, StoreAreaRespDto>();
        areaList.forEach(area -> {
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getProvince()) && restMap.get(StoreAreaLevelEnum.PROVINCE.getName()) == null && area.getLevel().intValue() == StoreAreaLevelEnum.PROVINCE.getCode().intValue() && reqDto.getProvince().equals(area.getName())) {
                restMap.put(StoreAreaLevelEnum.PROVINCE.getName(), (StoreAreaRespDto)area);
            }
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getCity()) && restMap.get(StoreAreaLevelEnum.CITY.getName()) == null && area.getLevel().intValue() == StoreAreaLevelEnum.CITY.getCode().intValue() && reqDto.getCity().equals(area.getName())) {
                restMap.put(StoreAreaLevelEnum.CITY.getName(), (StoreAreaRespDto)area);
            }
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getDistrict()) && restMap.get(StoreAreaLevelEnum.DISTRICT.getName()) == null && area.getLevel().intValue() == StoreAreaLevelEnum.DISTRICT.getCode().intValue() && reqDto.getDistrict().equals(area.getName())) {
                restMap.put(StoreAreaLevelEnum.DISTRICT.getName(), (StoreAreaRespDto)area);
            }
        });
        return restMap;
    }

    private StoreExcelVo excelErrorMsg(StoreExcelVo vo, String errorMsg) {
        vo.setErrorMsg(errorMsg);
        return vo;
    }

    @Override
    public void addStoreSellerRelateBySaveAfter(List<StoreEo> storeEoList, String username) {
        logger.info("addStoreSellerRelateBySaveAfter \u5165\u53c2: storeEoList={}, username={}", (Object)JSON.toJSONString(storeEoList), (Object)username);
        List<StoreEo> completeStore = this.fetchCompleteStoreInfo(storeEoList);
        ExecutorUtils.execute(() -> {
            try {
                logger.info("\u5f02\u6b65\u6267\u884c  \u836f\u5e97\u4fe1\u606f\u7f16\u8f91\u4fdd\u5b58\u540e\u7f6e  addStoreSellerRelateBySaveAfter   \u6839\u636e\u533a\u57df\u7ba1\u8f96\u5206\u914d\u89c4\u5219,\u5199\u5165\u65b0\u589e\u95e8\u5e97\u6570\u636e\u540c\u6b65\u5546\u5bb6\u5173\u7cfb  \u8bf7\u6c42storeEoList: " + JSON.toJSONString((Object)storeEoList));
                this.deleteStoreSellerRelate(completeStore);
                this.insertBatchStoreSellerRelate(completeStore);
            }
            catch (Exception e) {
                logger.info("\u51fa\u73b0\u5f02\u5e38\u5f00\u59cb\u53d1\u9001\u9489\u9489\u6d88\u606f : {} ", (Object)e.getMessage());
                List creditNums = completeStore.stream().map(c -> c.getSocialCreditNum()).filter(c -> StringUtils.isNotBlank((CharSequence)c)).collect(Collectors.toList());
                if (creditNums.isEmpty()) {
                    return;
                }
                DingTaskReqDto.ActionCard actionCard = new DingTaskReqDto.ActionCard(String.format(DingTaskUtils.SELLER_RELATION_WARN_CONTENT, RoBootAccessTokenEnum.STORE_SELLER_RELATION_AUTO_ROBOOT.getDesc(), creditNums.size() <= 50 ? com.dtyunxi.huieryun.core.util.JSON.toJsonString(creditNums) : "MAX", e.getMessage(), username, LocalDate.now()), RoBootAccessTokenEnum.STORE_SELLER_RELATION_AUTO_ROBOOT.getTitle());
                DingTaskReqDto dingTaskReqDto = new DingTaskReqDto();
                dingTaskReqDto.setMsgtype(RoBootAccessTokenEnum.STORE_SELLER_RELATION_AUTO_ROBOOT.getContentModel());
                dingTaskReqDto.setActionCard(actionCard);
                this.dingTaskUtils.dingTalkRobot(RoBootAccessTokenEnum.STORE_SELLER_RELATION_AUTO_ROBOOT.getAccessToken(), com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)dingTaskReqDto));
                e.printStackTrace();
            }
        });
    }

    private List<StoreEo> fetchCompleteStoreInfo(List<StoreEo> storeEoList) {
        List ids = storeEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        if (!ids.isEmpty() && ids.get(0) != null) {
            return this.storeDas.selectByIds(ids);
        }
        return storeEoList;
    }

    private void insertBatchStoreSellerRelate(List<StoreEo> storeEoList) {
        if (CollectionUtils.isEmpty(storeEoList)) {
            return;
        }
        List storeEos = storeEoList.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s.getStoreId())).collect(Collectors.toList());
        for (StoreEo store : storeEos) {
            List storeSellerGovernEoIds;
            List<String> governContents = this.getGovernContents(store);
            List<Object> governContentRespDtoList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(governContents)) {
                governContentRespDtoList = this.storeSellerGovernContentService.queryByGovernContents(governContents);
            }
            List storeSellerGovernEoList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)governContentRespDtoList) && !CollectionUtils.isEmpty(storeSellerGovernEoIds = (governContentRespDtoList = governContentRespDtoList.stream().filter(g -> !GovernTypeEnum.BLACKLIST.getCode().equals(g.getGovernType())).collect(Collectors.toList())).stream().map(c -> c.getStoreSellerId()).distinct().collect(Collectors.toList()))) {
                storeSellerGovernEoList = this.storeSellerGovernDas.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, storeSellerGovernEoIds));
            }
            if (!CollectionUtils.isNotEmpty((Collection)storeSellerGovernEoList)) continue;
            Map<Long, List<StoreSellerGovernEo>> storeSellerGovernIdMap = storeSellerGovernEoList.stream().collect(Collectors.groupingBy(BaseEo::getId));
            Map<Long, StoreSellerGovernContentRespDto> collect = governContentRespDtoList.stream().collect(Collectors.toMap(StoreSellerGovernContentRespDto::getStoreSellerId, v -> v, (k1, k2) -> k1));
            for (StoreSellerGovernContentRespDto contentRespDto : collect.values()) {
                List<StoreSellerGovernEo> governList = storeSellerGovernIdMap.get(contentRespDto.getStoreSellerId());
                if (!CollectionUtils.isNotEmpty(governList)) continue;
                this.generateStoreSellerRelate(store, (StoreSellerGovernEo)governList.stream().findFirst().get(), contentRespDto);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateStoreSellerRelate(StoreEo store, StoreSellerGovernEo storeSellerGovernEo, StoreSellerGovernContentRespDto contentRespDto) {
        Mutex addMutex = null;
        try {
            addMutex = this.lockService.lock("buildStoreSellerRelate", storeSellerGovernEo.getSellerId().toString(), 10, 5, TimeUnit.MINUTES);
            StoreSellerRelateEo insertEo = new StoreSellerRelateEo();
            insertEo.setSellerId(storeSellerGovernEo.getSellerId());
            insertEo.setOrganizationId(contentRespDto.getOrganizationId());
            insertEo.setStoreId(store.getStoreId());
            insertEo.setGovernSource(contentRespDto.getGovernType());
            Assert.isTrue((this.storeSellerRelateDas.insert((BaseEo)insertEo) > 0 ? 1 : 0) != 0, (String)"0001", (Object[])new Object[]{"\u6839\u636e\u533a\u57df\u7ba1\u8f96\u5206\u914d\u89c4\u5219,\u5199\u5165\u65b0\u589e\u95e8\u5e97\u6570\u636e\u540c\u6b65\u5546\u5bb6\u5173\u7cfb\u5931\u8d25\uff01\uff01\uff01\u95e8\u5e97\u4fe1\u606f:" + JSON.toJSONString((Object)store)});
        }
        catch (Throwable throwable) {
            this.lockService.unlock(addMutex);
            throw throwable;
        }
        this.lockService.unlock(addMutex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteStoreSellerRelate(List<StoreEo> storeEoList) {
        List distinctStoreIds = storeEoList.stream().map(StoreEo::getStoreId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(distinctStoreIds)) {
            for (String storeId : distinctStoreIds) {
                List relateEoList = this.storeSellerRelateDas.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEo::getDr, (Object)0)).eq(StoreSellerRelateEo::getStoreId, (Object)storeId));
                if (!CollectionUtils.isNotEmpty((Collection)relateEoList)) continue;
                Mutex deleteMutex = null;
                for (StoreSellerRelateEo eo : relateEoList) {
                    try {
                        this.lockService.lock("buildStoreSellerRelate", String.valueOf(eo.getSellerId()), 10, 5, TimeUnit.MINUTES);
                        this.storeSellerRelateDas.logicDeleteById(eo.getId());
                        logger.info("addStoreSellerRelateBySaveAfter \u627e\u5230\u95e8\u5e97\u5217\u8868\u5386\u53f2\u5173\u8054\u7684\u5546\u5bb6\u5e76\u5220\u9664, \u95e8\u5e97id:{},\u5220\u9664\u5546\u5bb6\u5173\u8054\u5173\u7cfb:{}", (Object)storeId, (Object)JSON.toJSONString((Object)eo));
                    }
                    finally {
                        this.lockService.unlock(deleteMutex);
                    }
                }
            }
        }
    }

    private List<String> getGovernContents(StoreEo s) {
        if (ObjectUtils.isEmpty((Object)s)) {
            return Lists.newArrayList();
        }
        ArrayList governContents = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)s.getStoreId())) {
            governContents.add(s.getStoreId());
        }
        if (StringUtils.isNotBlank((CharSequence)s.getProvinceCode())) {
            governContents.add(s.getProvinceCode());
        }
        if (StringUtils.isNotBlank((CharSequence)s.getCityCode())) {
            governContents.add(s.getCityCode());
        }
        if (StringUtils.isNotBlank((CharSequence)s.getDistrictCode())) {
            governContents.add(s.getDistrictCode());
        }
        if (StringUtils.isNotBlank((CharSequence)s.getParentSocialCreditNum())) {
            ArrayList socialCreditNums = Lists.newArrayList();
            socialCreditNums.add(s.getParentSocialCreditNum());
            List<StoreRespDto> parentStoreEoList = this.querySocialCreditNums(socialCreditNums);
            if (CollectionUtils.isNotEmpty(parentStoreEoList)) {
                governContents.addAll(parentStoreEoList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getStoreId())).map(a -> a.getStoreId()).distinct().collect(Collectors.toList()));
            }
        }
        return governContents;
    }

    private void deleteStoreSellerRelateByStoreIds(List<StoreEo> storeEoList) {
        List relateEoList;
        List storeIds;
        if (CollectionUtils.isNotEmpty(storeEoList) && CollectionUtils.isNotEmpty(storeIds = storeEoList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getStoreId())).map(s -> s.getStoreId()).collect(Collectors.toList())) && CollectionUtils.isNotEmpty((Collection)(relateEoList = this.storeSellerRelateDas.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEo::getDr, (Object)0)).in(StoreSellerRelateEo::getStoreId, storeIds))))) {
            relateEoList.forEach(e -> e.setDr(1));
            this.storeSellerRelateDas.updateBatch(relateEoList);
        }
    }

    @Override
    public List<StoreRespDto> queryCreditAndNameInDisable(StoreQueryReqDto reqDto) {
        StoreQueryReqDto param = new StoreQueryReqDto();
        param.setStoreName(reqDto.getStoreName());
        param.setStateList(Arrays.asList("\u5b58\u7eed", "\u8fc1\u51fa", "\u5f00\u4e1a", "\u5728\u4e1a", "\u6b63\u5e38", "\u8fc1\u5165"));
        PageInfo storeRespDtoPageInfo = this.storeDas.queryCreditAndNameInDisable(param, Integer.valueOf(1), Integer.valueOf(100));
        if (storeRespDtoPageInfo.getList() == null) {
            storeRespDtoPageInfo.setList(new ArrayList());
        }
        return storeRespDtoPageInfo.getList();
    }
}

