package com.yx.demo.center.data.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @Author: xiuji
 * @Date: 2022/3/21 9:52 AM
 */
@Api(
        tags = {"基础数据中心：区域数据扩展管理：区域信息查询服务"}
)
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-data-api-query-IAreaExtQueryApi",
        path = "/v1/areaExt",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}",
        url = "${yundt.cube.center.data.api:}"
)
public interface IAreaExtQueryApi {

    @PostMapping("getAreaByNames")
    @ApiOperation(value = "根据区域名称查询区域信息", notes = "根据区域名称查询区域信息")
    RestResponse<List<AreaDto>> getAreaByNames(@RequestBody List<String> names);

}
