/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressResolutionUtil {
    private static final Logger log = LoggerFactory.getLogger(AddressResolutionUtil.class);

    public static AddressDto addressResolution(String address) {
        try {
            return AddressResolutionUtil.executeResolution(address);
        }
        catch (Exception e) {
            log.error("\u8be6\u7ec6\u5730\u5740\u89e3\u6790\u5931\u8d25: {}, {}", (Object)address, (Object)e.getMessage());
            return null;
        }
    }

    private static AddressDto executeResolution(String address) {
        String regex = "(?<province>[^\u7701]+\u81ea\u6cbb\u533a|.*?\u7701|.*?\u884c\u653f\u533a|.*?\u5e02)(?<city>[^\u5e02]+\u81ea\u6cbb\u5dde|.*?\u5730\u533a|.*?\u884c\u653f\u5355\u4f4d|.+\u76df|\u5e02\u8f96\u533a|.*?\u5e02|.*?\u53bf)(?<county>[^\u53bf]+\u53bf|.+\u533a|.+\u5e02|.+\u65d7|.+\u6d77\u57df|.+\u5c9b)?(?<town>[^\u533a]+\u533a|.+\u9547)?(?<village>.*)";
        Matcher m = Pattern.compile(regex).matcher(address);
        String province = null;
        String city = null;
        String county = null;
        String town = null;
        String village = null;
        ArrayList<AddressDto> addressDtoList = new ArrayList<AddressDto>();
        AddressDto row = null;
        while (m.find()) {
            row = new AddressDto();
            province = m.group("province");
            row.setProvince(province == null ? "" : province.trim());
            city = m.group("city");
            row.setCity(city == null ? "" : city.trim());
            county = m.group("county");
            row.setCounty(county == null ? "" : county.trim());
            town = m.group("town");
            row.setTown(town == null ? "" : town.trim());
            village = m.group("village");
            row.setVillage(village == null ? "" : village.trim());
            addressDtoList.add(row);
        }
        return (AddressDto)addressDtoList.get(0);
    }

    public static class AddressDto {
        private String province;
        private String city;
        private String county;
        private String town;
        private String village;

        public String getProvince() {
            return this.province;
        }

        public String getCity() {
            return this.city;
        }

        public String getCounty() {
            return this.county;
        }

        public String getTown() {
            return this.town;
        }

        public String getVillage() {
            return this.village;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public void setCounty(String county) {
            this.county = county;
        }

        public void setTown(String town) {
            this.town = town;
        }

        public void setVillage(String village) {
            this.village = village;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddressDto)) {
                return false;
            }
            AddressDto other = (AddressDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$province = this.getProvince();
            String other$province = other.getProvince();
            if (this$province == null ? other$province != null : !this$province.equals(other$province)) {
                return false;
            }
            String this$city = this.getCity();
            String other$city = other.getCity();
            if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                return false;
            }
            String this$county = this.getCounty();
            String other$county = other.getCounty();
            if (this$county == null ? other$county != null : !this$county.equals(other$county)) {
                return false;
            }
            String this$town = this.getTown();
            String other$town = other.getTown();
            if (this$town == null ? other$town != null : !this$town.equals(other$town)) {
                return false;
            }
            String this$village = this.getVillage();
            String other$village = other.getVillage();
            return !(this$village == null ? other$village != null : !this$village.equals(other$village));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AddressDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $province = this.getProvince();
            result = result * 59 + ($province == null ? 43 : $province.hashCode());
            String $city = this.getCity();
            result = result * 59 + ($city == null ? 43 : $city.hashCode());
            String $county = this.getCounty();
            result = result * 59 + ($county == null ? 43 : $county.hashCode());
            String $town = this.getTown();
            result = result * 59 + ($town == null ? 43 : $town.hashCode());
            String $village = this.getVillage();
            result = result * 59 + ($village == null ? 43 : $village.hashCode());
            return result;
        }

        public String toString() {
            return "AddressResolutionUtil.AddressDto(province=" + this.getProvince() + ", city=" + this.getCity() + ", county=" + this.getCounty() + ", town=" + this.getTown() + ", village=" + this.getVillage() + ")";
        }
    }
}

