/**
 * @(#)CsDeliveryNoticeOrderQueryDto.java 1.0 2021/12/29 11:08
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
* @Description CsDeliveryNoticeOrderQueryDto
*
* @author jingran
* @Date: 2021/12/29 11:08
* @since 1.0.0
*/
@ApiModel(value = "csDeliveryNoticeOrderQueryDto", description = "查询Dto")
public class CsDeliveryNoticeOrderQueryDto extends RequestDto {

    /** 发货通知单号 */
    @ApiModelProperty(name="documentNo",value = "发货通知单号")
    private String documentNo;
    /** 关联单据号 */
    @ApiModelProperty(name="relevanceNo",value = "关联单据号")
    private String relevanceNo;
    /** 前置单号 */
    @ApiModelProperty(name="preOrderNo",value = "前置单号")
    private String preOrderNo;
    /** 业务类型 */
    @ApiModelProperty(name="businessType",value = "业务类型")
    private String businessType;

    /** 单据状态,待定 */
    @ApiModelProperty(name="orderStatus",value = "单据状态,待定")
    private String orderStatus;
    /** 发货店铺ID */
    @ApiModelProperty(name="shopId",value = "发货店铺ID")
    private Long shopId;
    /** 发货店铺编码 */
    @ApiModelProperty(name="shopCode",value = "发货店铺编码")
    private String shopCode;
    /** 发货店铺名称 */
    @ApiModelProperty(name="shopName",value = "发货店铺名称")
    private String shopName;
    /** 发货仓库ID */
    @ApiModelProperty(name="warehouseId",value = "发货仓库ID")
    private Long warehouseId;
    /** 发货仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "发货仓库编码")
    private String warehouseCode;
    /** 发货仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "发货仓库名称")
    private String warehouseName;
    /** 仓库分类,physics-物理仓,logic-逻辑仓 */
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类,physics-物理仓,logic-逻辑仓")
    private String warehouseClassify;
    /** 发货总数量 */
    @ApiModelProperty(name="totalQuantity",value = "发货总数量")
    private BigDecimal totalQuantity;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;

    @ApiModelProperty(name="createTimeStart",value = "创建开始时间")
    private String createTimeStart;
    @ApiModelProperty(name="createTimeEnd",value = "创建结束时间")
    private String createTimeEnd;
    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照create_time降序")
    private String orderByDesc = "create_time";

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getRelevanceNo() {
        return relevanceNo;
    }

    public void setRelevanceNo(String relevanceNo) {
        this.relevanceNo = relevanceNo;
    }

    public String getPreOrderNo() {
        return preOrderNo;
    }

    public void setPreOrderNo(String preOrderNo) {
        this.preOrderNo = preOrderNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }


    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCreateTimeStart() {
        return createTimeStart;
    }

    public void setCreateTimeStart(String createTimeStart) {
        this.createTimeStart = createTimeStart;
    }

    public String getCreateTimeEnd() {
        return createTimeEnd;
    }

    public void setCreateTimeEnd(String createTimeEnd) {
        this.createTimeEnd = createTimeEnd;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }
}