package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InventorySubItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.InventorySubItemRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.SubItemRelationReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.SubItemRelationRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 礼盒子产品关联表服务接口
*
* @author ghosn
* @since 2023-08-15
*/
@Api(tags = {"礼盒子产品关联表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-IInventorySubItemQueryApi",
    name = "yundt-cube-center-inventory",
    path = "/v1/subitem/rel",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface IInventorySubItemQueryApi {

    /**
    * 根据id查询礼盒子产品关联表
    *
    * @param id 礼盒子产品关联表id
    * @return   礼盒子产品关联表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询礼盒子产品关联表", notes = "根据id查询礼盒子产品关联表")
    RestResponse<InventorySubItemRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 礼盒子产品关联表分页数据
    *
    * @param filter   礼盒子产品关联表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 礼盒子产品关联表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "礼盒子产品关联表分页数据", notes = "根据filter查询条件查询礼盒子产品关联表数据，filter=InventorySubItemReqDto")
    RestResponse<PageInfo<InventorySubItemRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询礼盒产品关联子产品明细
     * @param subItemRelationReqDto
     * @return
     */
    @PostMapping("/rel")
    @ApiOperation(value = "查询礼盒产品关联子产品明细", notes = "查询礼盒产品关联子产品明细")
    RestResponse<SubItemRelationRespDto> querySubItemRelation(@RequestBody SubItemRelationReqDto subItemRelationReqDto);

}
