package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author shuidi
 */
@ApiModel(value = "TcbjProOccupyItemReqDto", description = "返回信息Dto")
public class TcbjProOccupyItemReqDto {
    /**
     * 商品编码
     */
    @ApiModelProperty(name = "cargoCode", value = "商品编码")
    private String cargoCode;
    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 批次
     */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
     * 库位
     */
    @ApiModelProperty(name = "warepos", value = "库位")
    private String warepos;

    @ApiModelProperty(name = "num")
    private Integer num;

    /**
     * 活动类型，目前只有套装组合商品的才需要做特殊处理，组合套装类型为：COMBINATION_ACTIVITY
     */
    @ApiModelProperty(name = "activityType", value = "活动类型，目前只有套装组合商品的才需要做特殊处理，组合套装类型为：COMBINATION_ACTIVITY")
    private String activityType;

    /** 活动ID **/
    @ApiModelProperty(name = "activityId",value = "活动ID")
    private Long activityId;

    /** 是否为套装组合商品  0-否  1-是 **/
    @ApiModelProperty(name = "是否为套装组合商品  0-否  1-是")
    private Integer combinationFlag;

    /** 是否为活动创建时的预占  0-否  1-是   下单预占可忽略此参数 **/
    @ApiModelProperty(name = "是否为套装组合商品  0-否  1-是 下单预占可忽略此参数")
    private Integer activityCreateFlag;

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getWarepos() {
        return warepos;
    }

    public void setWarepos(String warepos) {
        this.warepos = warepos;
    }

    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getCombinationFlag() {
        return combinationFlag;
    }

    public void setCombinationFlag(Integer combinationFlag) {
        this.combinationFlag = combinationFlag;
    }

    public Integer getActivityCreateFlag() {
        return activityCreateFlag;
    }

    public void setActivityCreateFlag(Integer activityCreateFlag) {
        this.activityCreateFlag = activityCreateFlag;
    }
}
