/**
 * @(#)CsLogicInventoryTotalQueryDto.java 1.0 2022/01/12 09:18
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * @author jingran
 * @Description CsLogicInventoryTotalQueryDto
 * @Date: 2022/01/12 09:18
 * @since 1.0.0
 */
@ApiModel(value = "CsLogicInventoryTotalBatchQueryDto", description = "批量查询可用总库存Dto")
public class CsLogicInventoryTotalBatchQueryDto implements Serializable {

    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    @ApiModelProperty(name = "warehouseCodeList", value = "仓库编码集合")
    private List<String> warehouseCodeList;
    /**
     * 货品编码集合
     */
    @ApiModelProperty(name = "cargoCodeList", value = "货品编码集合")
    private List<String> cargoCodeList;
    /**
     * 货品编码
     */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "isAvailable", value = "是否过滤可用库存大于0的，1.过滤，0.不过滤 （默认过滤）")
    private Integer isAvailable= YesNoEnum.YES.getValue();

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public List<String> getWarehouseCodeList() {
        return warehouseCodeList;
    }

    public void setWarehouseCodeList(List<String> warehouseCodeList) {
        this.warehouseCodeList = warehouseCodeList;
    }

    public List<String> getCargoCodeList() {
        return cargoCodeList;
    }

    public void setCargoCodeList(List<String> cargoCodeList) {
        this.cargoCodeList = cargoCodeList;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public Integer getIsAvailable() {
        return isAvailable;
    }

    public void setIsAvailable(Integer isAvailable) {
        this.isAvailable = isAvailable;
    }
}