package com.dtyunxi.yundt.cube.center.inventory.enums;

public enum CsOrderStatusEnum {
    INIT("1010", "草稿"),
    DELIVERY_WAIT_AUDIT("1011", "待审核"),
    DELIVERY_OUT("1012", "出库"),
    DELIVERY_OUT_ING("1013", "出库中"),
    DELIVERY_OUT_FINISH("1014", "已完成"),
    DELIVERY_CANCEL("1015", "已取消"),

    RECEIVE_WAIT_AUDIT("2011", "待审核"),
    RECEIVE_WAIT_DELIVER("2012", "待配发"),
    RECEIVE_DELIVERED("2013", "已配发"),
    RECEIVE_WAIT_RECEIVE("2014", "待收货"),
    RECEIVE_FINISH("2015", "已完成"),
    RECEIVE_CANCEL("2016", "已取消"),
    RECEIVE_ING("2017", "入库中"),

    ADJUST_WAIT_AUDIT("3011", "待审核"),
    ADJUST_FINISH("3012", "已调整"),
    ADJUST_REFUSE("3013", "审批拒绝");

    CsOrderStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private String code;
    private String desc;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(String code) {
        for (CsOrderStatusEnum value : CsOrderStatusEnum.values()) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return null;
    }

    public static CsOrderStatusEnum getStatusByCode(String code) {
        for (CsOrderStatusEnum value : CsOrderStatusEnum.values()) {
            if (value.code.equals(code)) {
                return value;
            }
        }
        return null;
    }
}
