package com.dtyunxi.yundt.cube.center.inventory.dto;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;

/**
 * 响应Dto（提供给营销云调用）
 */
@Data
public class ResponseDto {

    public static final Integer SUCC_CODE = 0;
    public static final Integer ERROR_CODE = -1;

    private Integer errorCode;

    private String errorMessage;

    private String returnObject;

    public static ResponseDto success(String data){
        //String dataStr = JSONObject.toJSONString(data);
        ResponseDto dto = new ResponseDto();
        dto.setErrorCode(SUCC_CODE);
        dto.setErrorMessage(null);
        dto.setReturnObject(data);
        return dto;
    }

    public static ResponseDto error(String errorMessage){
        ResponseDto dto = new ResponseDto();
        dto.setErrorCode(SUCC_CODE);
        dto.setErrorMessage(errorMessage);
        dto.setReturnObject(null);
        return dto;
    }
}
