/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter.bd;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsPhysicsInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.adapter.PcpInventoryExposedApiImpl;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.IOrderPreemptWrapperHelper;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.CsBasicsExternalStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.ICsBasicsExternalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.other.CsRelWarehouseShipmentMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsReceiveReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsWmsBasicsDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOrderSalesRefundDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOrderSalesRefundReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicPreemptInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOrderUpdateShipmentInfoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutDeliveryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsAddInventoryOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsPcpInventoryExposedRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsExternalStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.transcation.TransactionAfterService;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bd_PcpInventoryExposedApi")
public class BdPcpInventoryExposedApiImpl
extends PcpInventoryExposedApiImpl {
    private static final Logger log = LoggerFactory.getLogger(BdPcpInventoryExposedApiImpl.class);
    @Autowired
    private BaseOrderFacade baseOrderFacade;
    @Autowired
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Autowired
    private IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    private CsRelWarehouseShipmentMapper csRelWarehouseShipmentMapper;
    @Resource
    private IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    private IItemSkuQueryApiProxy itemSkuQueryApiProxy;
    @Autowired
    private IRelWarehouseDomain relWarehouseDomain;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    private IOrderPreemptWrapperHelper orderPreemptWrapperHelper;
    @Resource
    private TransactionAfterService transactionAfterService;
    @Resource(name="${yunxi.dg.base.project}_ICsPhysicsInventoryExposedApi")
    private ICsPhysicsInventoryExposedApi csPhysicsInventoryExposedApi;
    private final String UN_SEND_WAREHOUSE_CODE = "CS_logic";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<CsPcpInventoryExposedRespDto> preemptOrderInventory(final CsLogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        log.info("preemptOrderInventory==>PCP\u64cd\u4f5c\uff0clogicPreemptInventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(logicPreemptInventoryOperateReqDto));
        AssertUtil.isTrue(null != logicPreemptInventoryOperateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Integer generateOutNoticeOrder = logicPreemptInventoryOperateReqDto.getGenerateOutNoticeOrder();
        AssertUtil.isTrue(null != generateOutNoticeOrder && (YesNoEnum.NO.getValue().equals(generateOutNoticeOrder) || YesNoEnum.YES.getValue().equals(generateOutNoticeOrder)), "\u662f\u5426\u751f\u6210\u51fa\u5e93\u901a\u77e5\u5355\u53c2\u6570\u6709\u8bef");
        final CsInventoryOperateReqDto inventoryOperateReqDto = logicPreemptInventoryOperateReqDto.getInventoryOperateReqDto();
        LogicWarehouseEo warehouse = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)inventoryOperateReqDto.getLogicWarehouseCode())).one();
        AssertUtil.isTrue(Objects.nonNull(warehouse), "\u4ed3\u5e93\u4e0d\u5b58\u5728:{}", inventoryOperateReqDto.getLogicWarehouseCode());
        ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        receiveDeliveryNoticeOrderFacadeBo.setSourceType(CsInventorySourceTypeEnum.PCP_OUT_SALE_PREEMPT.getCode());
        receiveDeliveryNoticeOrderFacadeBo.setLogicWarehouseCode(inventoryOperateReqDto.getLogicWarehouseCode());
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceNo(inventoryOperateReqDto.getRelevanceNo());
        receiveDeliveryNoticeOrderFacadeBo.setPreOrderNo(null);
        receiveDeliveryNoticeOrderFacadeBo.setDisplayBusinessType(CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode());
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_SALE);
        receiveDeliveryNoticeOrderFacadeBo.setExternalOrderNo(inventoryOperateReqDto.getPlatformOrderNo());
        receiveDeliveryNoticeOrderFacadeBo.setBusinessType(CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode());
        final boolean isComplete = "enable".equals(warehouse.getVirtualMatterFlag());
        receiveDeliveryNoticeOrderFacadeBo.setAutoComplete(Boolean.valueOf(isComplete));
        if (isComplete) {
            this.orderPreemptWrapperHelper.setCompleteCallBack(inventoryOperateReqDto, receiveDeliveryNoticeOrderFacadeBo);
        }
        receiveDeliveryNoticeOrderFacadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                ReceiveDeliveryNoticeOrderContext noticeOrderContext = (ReceiveDeliveryNoticeOrderContext)context;
                BdPcpInventoryExposedApiImpl.this.orderPreemptWrapperHelper.wrapperOrderInfo(noticeOrderContext, inventoryOperateReqDto, logicPreemptInventoryOperateReqDto);
            }

            public void afterCallBack(BaseOrderBaseContext context) {
                if (isComplete) {
                    context.setTransparentCallback(Boolean.valueOf(true));
                    context.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

                        public void beforeCallBack(BaseOrderBaseContext context) {
                            if (context instanceof InOutNoticeOrderContext) {
                                context.setShippingInfoReqDtoList(BdPcpInventoryExposedApiImpl.this.orderPreemptWrapperHelper.shipmentDispose(((InOutNoticeOrderContext)context).getInOutNoticeOrderEo()));
                            }
                        }

                        public void afterCallBack(BaseOrderBaseContext context) {
                        }
                    });
                }
            }
        });
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (CsInventoryOperateCargoReqDto detail : inventoryOperateReqDto.getOperateCargoReqDtoList()) {
            BaseOrderDetailReqDto detailReqDto = new BaseOrderDetailReqDto();
            detailReqDto.setSkuCode(detail.getCargoCode());
            detailReqDto.setSkuName(detail.getCargoName());
            detailReqDto.setQuantity(detail.getChangeInventory());
            detailReqDto.setBatch(detail.getBatch());
            detailReqDto.setPreOrderItemId(detail.getTradeOrderItemId());
            detailReqDtoList.add(detailReqDto);
        }
        receiveDeliveryNoticeOrderFacadeBo.setOrderBasicsDetailReqDtoList((List)detailReqDtoList);
        this.baseOrderFacade.deliveryNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
        CsPcpInventoryExposedRespDto csPcpInventoryExposedRespDto = new CsPcpInventoryExposedRespDto();
        csPcpInventoryExposedRespDto.setGenerateDeliveryNoticeOrderFlag(Boolean.valueOf(true));
        csPcpInventoryExposedRespDto.setGenerateOutNoticeOrderFlag(Boolean.valueOf(true));
        log.info("preemptOrderInventory==>PCP\u64cd\u4f5c\uff0ccsPcpInventoryExposedRespDto:{}", (Object)LogUtils.buildLogContent(csPcpInventoryExposedRespDto));
        return new RestResponse((Object)csPcpInventoryExposedRespDto);
    }

    public RestResponse<Boolean> cancelLogicAndStorageOrder(String orderNo, Long id) {
        return null;
    }

    public RestResponse<Boolean> cancelLogicAndTransferOrder(String orderNo, Long id) {
        Boolean cancelFlag = this.csPcpInventoryExposedService.cancelLogicAndTransferOrder(orderNo, id);
        return new RestResponse((Object)cancelFlag);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Boolean> deductionInventoryOrder(final CsLogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        log.info("deductionInventoryOrder==>\u76f4\u63a5\u6263\u51cf\u5e93\u5b58\uff0c\u5e76\u4e14\u751f\u6210\u53d1\u8d27\u7ed3\u679c\u5355\u3001\u51fa\u5e93\u7ed3\u679c\u5355,logicPreemptInventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(logicPreemptInventoryOperateReqDto));
        this.checkDeductionInventoryOrder(logicPreemptInventoryOperateReqDto);
        final CsInventoryOperateReqDto inventoryOperateReqDto = logicPreemptInventoryOperateReqDto.getInventoryOperateReqDto();
        ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo = this.orderPreemptWrapperHelper.getPreemptFacadeBo(inventoryOperateReqDto);
        receiveDeliveryNoticeOrderFacadeBo.setAutoComplete(Boolean.valueOf(true));
        receiveDeliveryNoticeOrderFacadeBo.setValidNegative(Boolean.valueOf(false));
        receiveDeliveryNoticeOrderFacadeBo.setSourceType(CsInventorySourceTypeEnum.PCP_OUT_SALE_PREEMPT.getCode());
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_SALE);
        receiveDeliveryNoticeOrderFacadeBo.setOnlyGenResult(true);
        receiveDeliveryNoticeOrderFacadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                ReceiveDeliveryNoticeOrderContext deliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)context;
                deliveryNoticeOrderContext.setSendWms(false);
                BdPcpInventoryExposedApiImpl.this.orderPreemptWrapperHelper.wrapperOrderInfo(deliveryNoticeOrderContext, inventoryOperateReqDto, logicPreemptInventoryOperateReqDto);
            }

            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
        Optional.ofNullable(logicPreemptInventoryOperateReqDto.getReceivePersonAddressInfo()).ifPresent(re -> {
            BaseOrderAddressEo baseOrderAddressEo = (BaseOrderAddressEo)BeanUtil.copyProperties((Object)re, BaseOrderAddressEo.class, (String[])new String[0]);
            baseOrderAddressEo.setContactsType("consignee");
            receiveDeliveryNoticeOrderFacadeBo.setBaseOrderAddressEoList((List)Lists.newArrayList((Object[])new BaseOrderAddressEo[]{baseOrderAddressEo}));
        });
        this.baseOrderFacade.deliveryNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
        return new RestResponse((Object)Boolean.TRUE);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Boolean> updateOrderShipmentInfo(CsOrderUpdateShipmentInfoReqDto orderUpdateShipmentInfoReqDto) {
        log.info("updateOrderShipmentInfo==>\u66f4\u65b0\u8ba2\u5355\u7269\u6d41\u4fe1\u606f,orderUpdateShipmentInfoReqDto:{}", (Object)LogUtils.buildLogContent(orderUpdateShipmentInfoReqDto));
        AssertUtil.isTrue(null != orderUpdateShipmentInfoReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String orderNo = orderUpdateShipmentInfoReqDto.getOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u8ba2\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String shipmentEnterpriseCode = orderUpdateShipmentInfoReqDto.getShipmentEnterpriseCode();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)shipmentEnterpriseCode), "\u7269\u6d41\u5546\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String shipmentEnterpriseName = orderUpdateShipmentInfoReqDto.getShipmentEnterpriseName();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)shipmentEnterpriseName), "\u7269\u6d41\u5546\u540d\u79f0\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper csDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)orderNo);
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_status", (Object)BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode());
        List csDeliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)csDeliveryNoticeOrderEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csDeliveryNoticeOrderEoList)) {
            return new RestResponse((Object)Boolean.TRUE);
        }
        ReceiveDeliveryNoticeOrderEo csDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)csDeliveryNoticeOrderEoList.get(0);
        String logicWarehouseCode = csDeliveryNoticeOrderEo.getDeliveryLogicWarehouseCode();
        QueryWrapper csRelWarehouseShipmentEoQueryWrapper = new QueryWrapper();
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"warehouse_code", (Object)logicWarehouseCode);
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"shipment_enterprise_code", (Object)shipmentEnterpriseCode);
        List csRelWarehouseShipmentEoList = this.csRelWarehouseShipmentMapper.selectList((Wrapper)csRelWarehouseShipmentEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csRelWarehouseShipmentEoList)) {
            throw new BizException(String.format("\u7269\u6d41\u5546\u7f16\u7801\u3010%s\u3011,\u4ed3\u5e93\u7f16\u7801\u3010%s\u3011\u672a\u7ed1\u5b9a", shipmentEnterpriseCode, logicWarehouseCode));
        }
        csDeliveryNoticeOrderEo.setShipmentEnterpriseCode(shipmentEnterpriseCode);
        csDeliveryNoticeOrderEo.setShipmentEnterpriseName(shipmentEnterpriseName);
        csDeliveryNoticeOrderEoQueryWrapper.clear();
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"id", (Object)csDeliveryNoticeOrderEo.getId());
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        this.receiveDeliveryNoticeOrderDomain.getMapper().update((Object)csDeliveryNoticeOrderEo, (Wrapper)csDeliveryNoticeOrderEoQueryWrapper);
        return new RestResponse((Object)Boolean.TRUE);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<CsAddInventoryOrderRespDto> addInventoryOrder(final CsInventoryOperateReqDto inventoryOperateReqDto) {
        List inOutResultOrderEos;
        log.info("addInventoryOrder==>\u76f4\u63a5\u589e\u52a0\u5e93\u5b58\uff0c\u5e76\u4e14\u751f\u6210\u6536\u8d27\u7ed3\u679c\u5355\u3001\u5165\u5e93\u7ed3\u679c\u5355inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        this.checkAddInventoryOrder(inventoryOperateReqDto);
        ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo = this.orderPreemptWrapperHelper.getPreemptFacadeBo(inventoryOperateReqDto);
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_AFTER_SALE);
        receiveDeliveryNoticeOrderFacadeBo.setAutoComplete(Boolean.valueOf(true));
        receiveDeliveryNoticeOrderFacadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                BdPcpInventoryExposedApiImpl.this.orderPreemptWrapperHelper.wrapperOrderInfo((ReceiveDeliveryNoticeOrderContext)context, inventoryOperateReqDto);
            }

            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
        this.baseOrderFacade.receiveNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
        CsAddInventoryOrderRespDto addInventoryOrderRespDto = new CsAddInventoryOrderRespDto();
        List receiveDeliveryResultOrderEos = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDomain.filter().eq((Object)"relevance_no", (Object)receiveDeliveryNoticeOrderFacadeBo.getRelevanceNo())).list();
        if (CollectionUtils.isNotEmpty((Collection)receiveDeliveryResultOrderEos)) {
            addInventoryOrderRespDto.setReceiveResultOrderNo(((ReceiveDeliveryResultOrderEo)receiveDeliveryResultOrderEos.get(0)).getDocumentNo());
        }
        if (CollectionUtils.isNotEmpty((Collection)(inOutResultOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)receiveDeliveryNoticeOrderFacadeBo.getRelevanceNo())).orderByDesc((Object)"create_time")).list()))) {
            addInventoryOrderRespDto.setInResultResultOrderNo(((InOutResultOrderEo)inOutResultOrderEos.get(0)).getDocumentNo());
        }
        return new RestResponse((Object)addInventoryOrderRespDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Boolean> orderSalesRefundConfirm(CsInventoryOrderSalesRefundReqDto csOutDeliveryReqDto) {
        log.info("orderSalesRefundConfirm==>\u9500\u552e\u9000\u786e\u8ba4\u64cd\u4f5c,csOutDeliveryReqDto:{}", (Object)LogUtils.buildLogContent(csOutDeliveryReqDto));
        this.checkParams(csOutDeliveryReqDto);
        List<CsInventoryOrderSalesRefundReqDto> groupingList = this.groupingByWarehouseCode(csOutDeliveryReqDto);
        for (CsInventoryOrderSalesRefundReqDto orderSalesRefundReqDto : groupingList) {
            List operateCargoReqDtoList = orderSalesRefundReqDto.getOperateCargoReqDtoList();
            CsInventoryOrderSalesRefundDetailReqDto refundDetailReqDto = (CsInventoryOrderSalesRefundDetailReqDto)operateCargoReqDtoList.get(0);
            ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
            receiveDeliveryNoticeOrderFacadeBo.setBusinessType(CsPcpBusinessTypeEnum.ORDER_SALES_REFUND.getCode());
            receiveDeliveryNoticeOrderFacadeBo.setPreOrderNo(null);
            receiveDeliveryNoticeOrderFacadeBo.setRelevanceNo(orderSalesRefundReqDto.getSourceNo());
            receiveDeliveryNoticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_SALE_REFUND);
            receiveDeliveryNoticeOrderFacadeBo.setLogicWarehouseCode(refundDetailReqDto.getWarehouseCode());
            receiveDeliveryNoticeOrderFacadeBo.setAutoComplete(Boolean.valueOf(false));
            ArrayList deliveryNoticeOrderDetails = Lists.newArrayList();
            for (CsInventoryOrderSalesRefundDetailReqDto detail : operateCargoReqDtoList) {
                BaseOrderDetailReqDto detailReqDto = new BaseOrderDetailReqDto();
                detailReqDto.setBatch(detail.getBatch());
                detailReqDto.setQuantity(BigDecimalUtils.abs((BigDecimal)detail.getChangeInventory()));
                detailReqDto.setSkuCode(detail.getCargoCode());
                detailReqDto.setSkuName(detail.getCargoName());
                detailReqDto.setExpireTime(detail.getExpireTime());
                detailReqDto.setProduceTime(detail.getProduceTime());
                deliveryNoticeOrderDetails.add(detailReqDto);
            }
            receiveDeliveryNoticeOrderFacadeBo.setOrderBasicsDetailReqDtoList((List)deliveryNoticeOrderDetails);
            this.baseOrderFacade.receiveNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
            Boolean sendWmsFlag = orderSalesRefundReqDto.getSendWmsFlag();
            if (sendWmsFlag.booleanValue()) {
                this.sendWms(orderSalesRefundReqDto);
                continue;
            }
            List eos = ((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)orderSalesRefundReqDto.getSourceNo())).list();
            InOutNoticeOrderEo csOutNoticeOrderEo = CollectionUtils.isNotEmpty((Collection)eos) ? (InOutNoticeOrderEo)eos.get(0) : new InOutNoticeOrderEo();
            this.wmsInSendBack(csOutNoticeOrderEo, orderSalesRefundReqDto);
        }
        return new RestResponse((Object)true);
    }

    private void sendWms(CsInventoryOrderSalesRefundReqDto orderSalesRefundReqDto) {
        ICsBasicsExternalService wmsExternalService = CsBasicsExternalStrategyUtils.getBasicsOrderOperateService(CsBasicsExternalStrategyEnum.WMS.getCode());
        CsBasicsOrderReqDto basicsOrderReqDto = new CsBasicsOrderReqDto();
        wmsExternalService.send(basicsOrderReqDto);
    }

    private void wmsInSendBack(InOutNoticeOrderEo csOutNoticeOrderEo, CsInventoryOrderSalesRefundReqDto orderSalesRefundReqDto) {
        List operateCargoReqDtoList = orderSalesRefundReqDto.getOperateCargoReqDtoList();
        CsInventoryOrderSalesRefundDetailReqDto refundDetailReqDto = (CsInventoryOrderSalesRefundDetailReqDto)operateCargoReqDtoList.get(0);
        String logicWarehouseCode = refundDetailReqDto.getWarehouseCode();
        ICsBasicsExternalService wmsExternalService = CsBasicsExternalStrategyUtils.getBasicsOrderOperateService(CsBasicsExternalStrategyEnum.WMS.getCode());
        CsBasicsReceiveReqDto csBasicsReceiveReqDto = new CsBasicsReceiveReqDto();
        csBasicsReceiveReqDto.setPlatformOrderNo("-1");
        csBasicsReceiveReqDto.setInOutNoticeOrderNo(csOutNoticeOrderEo.getDocumentNo());
        csBasicsReceiveReqDto.setInOutTime(new Date());
        csBasicsReceiveReqDto.setWmsOrderNo(IdUtils.getId() + "");
        QueryWrapper csRelWarehouseEoQueryWrapper = new QueryWrapper();
        csRelWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csRelWarehouseEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        csRelWarehouseEoQueryWrapper.eq((Object)"warehouse_code", (Object)logicWarehouseCode);
        csRelWarehouseEoQueryWrapper.in((Object)"warehouse_classify", new Object[]{CsWarehouseClassifyEnum.LOGIC.getCode()});
        csRelWarehouseEoQueryWrapper.in((Object)"ref_warehouse_classify", new Object[]{CsWarehouseClassifyEnum.PHYSICS.getCode()});
        List csRelWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)csRelWarehouseEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csRelWarehouseEoList), "\u903b\u8f91\u4ed3\u672a\u5173\u8054\u7269\u7406\u4ed3\u4fe1\u606f");
        RelWarehouseEo csRelWarehouseEo = (RelWarehouseEo)csRelWarehouseEoList.get(0);
        String physicsWarehouseCode = csRelWarehouseEo.getRefWarehouseCode();
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (CsInventoryOrderSalesRefundDetailReqDto detailReqDto : operateCargoReqDtoList) {
            CsWmsBasicsDetailReqDto inSendBackDetailReqDto = new CsWmsBasicsDetailReqDto();
            inSendBackDetailReqDto.setBatch(detailReqDto.getBatch());
            inSendBackDetailReqDto.setQuantity(detailReqDto.getChangeInventory());
            inSendBackDetailReqDto.setSkuCode(detailReqDto.getLongCode());
            inSendBackDetailReqDto.setWarehouseCode(physicsWarehouseCode);
            detailReqDtoList.add(inSendBackDetailReqDto);
        }
        csBasicsReceiveReqDto.setDetailReqDtoList((List)detailReqDtoList);
        wmsExternalService.receiveIn(csBasicsReceiveReqDto);
    }

    private List<CsInventoryOrderSalesRefundReqDto> groupingByWarehouseCode(CsInventoryOrderSalesRefundReqDto csOutDeliveryReqDto) {
        Boolean sendWmsFlag = csOutDeliveryReqDto.getSendWmsFlag();
        sendWmsFlag = null == sendWmsFlag ? true : sendWmsFlag;
        ArrayList resultList = Lists.newArrayList();
        List operateCargoReqDtoList = csOutDeliveryReqDto.getOperateCargoReqDtoList();
        Map<String, List<CsInventoryOrderSalesRefundDetailReqDto>> groupMap = operateCargoReqDtoList.stream().collect(Collectors.groupingBy(CsInventoryOrderSalesRefundDetailReqDto::getWarehouseCode));
        Set<Map.Entry<String, List<CsInventoryOrderSalesRefundDetailReqDto>>> entrySet = groupMap.entrySet();
        for (Map.Entry<String, List<CsInventoryOrderSalesRefundDetailReqDto>> entry : entrySet) {
            String warehouseCode = entry.getKey();
            CsInventoryOrderSalesRefundReqDto targetReqDto = new CsInventoryOrderSalesRefundReqDto();
            CubeBeanUtils.copyProperties((Object)targetReqDto, (Object)csOutDeliveryReqDto, (String[])new String[]{"operateCargoReqDtoList"});
            List<CsInventoryOrderSalesRefundDetailReqDto> detailReqDtoList = entry.getValue();
            ArrayList targetList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)targetList, detailReqDtoList, CsInventoryOrderSalesRefundDetailReqDto.class);
            targetReqDto.setOperateCargoReqDtoList((List)targetList);
            resultList.add(targetReqDto);
            targetReqDto.setSendWmsFlag(sendWmsFlag);
            if (!"CS_logic".equals(warehouseCode)) continue;
            targetReqDto.setSendWmsFlag(Boolean.valueOf(false));
        }
        return resultList;
    }

    private void checkParams(CsInventoryOrderSalesRefundReqDto csOutDeliveryReqDto) {
        String sourceNo = csOutDeliveryReqDto.getSourceNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)sourceNo), "\u6765\u6e90\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        BigDecimal totalInventory = csOutDeliveryReqDto.getTotalInventory();
        AssertUtil.isTrue(null != totalInventory && totalInventory.compareTo(BigDecimal.ZERO) > 0, "\u603b\u6570\u91cf\u53c2\u6570\u6709\u8bef");
        List operateCargoReqDtoList = csOutDeliveryReqDto.getOperateCargoReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)operateCargoReqDtoList), "\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u53c2\u6570\u6709\u8bef");
        for (CsInventoryOrderSalesRefundDetailReqDto refundDetailReqDto : operateCargoReqDtoList) {
            String warehouseCode = refundDetailReqDto.getWarehouseCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseCode), "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            String batch = refundDetailReqDto.getBatch();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)batch), "\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
            String longCode = refundDetailReqDto.getLongCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)longCode), "\u5546\u54c1\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal changeInventory = refundDetailReqDto.getChangeInventory();
            AssertUtil.isTrue(null != changeInventory && changeInventory.compareTo(BigDecimal.ZERO) > 0, "\u5e93\u5b58\u53d8\u52a8\u53c2\u6570\u6709\u8bef");
        }
        List warehouseCodeList = operateCargoReqDtoList.stream().map(CsInventoryOrderSalesRefundDetailReqDto::getWarehouseCode).distinct().collect(Collectors.toList());
        QueryWrapper csLogicWarehouseEoQueryWrapper = new QueryWrapper();
        csLogicWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csLogicWarehouseEoQueryWrapper.eq((Object)"warehouse_status", (Object)CsLogicWarehouseStatusEnum.ENABLE.getCode());
        csLogicWarehouseEoQueryWrapper.in((Object)"warehouse_code", warehouseCodeList);
        List csLogicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)csLogicWarehouseEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csLogicWarehouseEoList), "\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
        Map logicWarehouseEoMap = csLogicWarehouseEoList.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity()));
        List longCodeList = operateCargoReqDtoList.stream().map(CsInventoryOrderSalesRefundDetailReqDto::getLongCode).distinct().collect(Collectors.toList());
        List itemList = this.itemSkuQueryApiProxy.queryBySkuCodes(longCodeList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)itemList), "\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        Map csItemEoMap = itemList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity()));
        for (CsInventoryOrderSalesRefundDetailReqDto refundDetailReqDto : operateCargoReqDtoList) {
            ItemSkuDto csItemEo;
            String warehouseCode = refundDetailReqDto.getWarehouseCode();
            String longCode = refundDetailReqDto.getLongCode();
            LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)logicWarehouseEoMap.get(warehouseCode);
            if (null != csLogicWarehouseEo) {
                refundDetailReqDto.setWarehouseId(csLogicWarehouseEo.getId());
                refundDetailReqDto.setWarehouseName(csLogicWarehouseEo.getWarehouseName());
            }
            if (null == (csItemEo = (ItemSkuDto)csItemEoMap.get(longCode))) continue;
            refundDetailReqDto.setCargoName(csItemEo.getSkuName());
            refundDetailReqDto.setCargoCode(csItemEo.getSkuCode());
            refundDetailReqDto.setLongCode(csItemEo.getSkuCode());
        }
        BigDecimal calculateTotalInventory = operateCargoReqDtoList.stream().map(CsInventoryOrderSalesRefundDetailReqDto::getChangeInventory).reduce(BigDecimal.ZERO, BigDecimal::add);
        int compare = calculateTotalInventory.compareTo(totalInventory);
        AssertUtil.isTrue(compare == 0, "\u603b\u6570\u91cf\u5fc5\u987b\u7b49\u4e8e\u660e\u7ec6\u52a0\u8d77\u6765\u7684\u603b\u6570\u91cf");
        QueryWrapper csDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)csOutDeliveryReqDto.getSourceNo());
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)"receive");
        ArrayList<String> notInStatusList = new ArrayList<String>(2);
        notInStatusList.add(BaseOrderStatusEnum.RNO_CANCEL.getCode());
        notInStatusList.add(BaseOrderStatusEnum.RNO_HANG_UP.getCode());
        csDeliveryNoticeOrderEoQueryWrapper.notIn((Object)"order_status", notInStatusList);
        List csDeliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)csDeliveryNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)csDeliveryNoticeOrderEoList), String.format("\u3010%s\u3011\u4e0d\u5141\u8bb8\u91cd\u590d\u64cd\u4f5c", csOutDeliveryReqDto.getSourceNo()));
    }

    private void checkAddInventoryOrder(CsInventoryOperateReqDto inventoryOperateReqDto) {
        AssertUtil.isTrue(null != inventoryOperateReqDto, "\u5e93\u5b58\u64cd\u4f5c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)sourceNo), "\u6765\u6e90\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String basicDataBusinessType = inventoryOperateReqDto.getBasicDataBusinessType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)basicDataBusinessType), "\u4e1a\u52a1\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List operateCargoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)operateCargoList), "\u5546\u54c1\u660e\u7ec6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (CsInventoryOperateCargoReqDto cargoReqDto : operateCargoList) {
            String warehouseCode = cargoReqDto.getWarehouseCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseCode), "\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            String longCode = cargoReqDto.getLongCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)longCode), "\u5546\u54c1\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal changeInventory = cargoReqDto.getChangeInventory();
            AssertUtil.isTrue(null != changeInventory, "\u53d8\u52a8\u5e93\u5b58\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkDeductionInventoryOrder(CsLogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        AssertUtil.isTrue(null != logicPreemptInventoryOperateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsInventoryOperateReqDto inventoryOperateReqDto = logicPreemptInventoryOperateReqDto.getInventoryOperateReqDto();
        AssertUtil.isTrue(null != inventoryOperateReqDto, "\u5e93\u5b58\u64cd\u4f5c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)sourceNo), "\u6765\u6e90\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String basicDataBusinessType = inventoryOperateReqDto.getBasicDataBusinessType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)basicDataBusinessType), "\u4e1a\u52a1\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List operateCargoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)operateCargoList), "\u5546\u54c1\u660e\u7ec6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (CsInventoryOperateCargoReqDto cargoReqDto : operateCargoList) {
            String warehouseCode = cargoReqDto.getWarehouseCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseCode), "\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            String longCode = cargoReqDto.getLongCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)longCode), "\u5546\u54c1\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal changeInventory = cargoReqDto.getChangeInventory();
            AssertUtil.isTrue(null != changeInventory, "\u53d8\u52a8\u5e93\u5b58\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public RestResponse<Boolean> bdOutDelivery(CsOutDeliveryReqDto csOutDeliveryReqDto) {
        Boolean resultFlag = this.csPcpInventoryExposedService.bdOutDelivery(csOutDeliveryReqDto);
        return new RestResponse((Object)resultFlag);
    }

    @Override
    public RestResponse<Boolean> checkHangUp(String sourceNo) {
        Boolean resultFlag = this.csPcpInventoryExposedService.checkHangUp(sourceNo);
        return new RestResponse((Object)resultFlag);
    }

    @Override
    public RestResponse<Boolean> checkCancelHangUp(String sourceNo) {
        Boolean resultFlag = this.csPcpInventoryExposedService.checkCancelHangUp(sourceNo);
        return new RestResponse((Object)resultFlag);
    }
}

