/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.handler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.yundt.cube.center.inventory.anno.cs.inventory.CsInventorySourceTypeHandler;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventorySourceTypeHandler;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="csCommonInventoryOutInventoryHandler")
@CsInventorySourceTypeHandler(sourceType={CsInventorySourceTypeEnum.OUT_SALE_PREEMPT, CsInventorySourceTypeEnum.OUT_ACT_ORDER_PREEMPT, CsInventorySourceTypeEnum.OUT_BUSINESS_APPROVE_PREEMPT, CsInventorySourceTypeEnum.OUT_FINANCE_APPROVE_PREEMPT, CsInventorySourceTypeEnum.OUT_ACT_AUDIT_PREEMPT, CsInventorySourceTypeEnum.OUT_ALLOT_PREEMPT, CsInventorySourceTypeEnum.OUT_OTHER_PREEMPT, CsInventorySourceTypeEnum.OUT_SEPARATE_PREEMPT, CsInventorySourceTypeEnum.OUT_BACKTRACK_PREEMPT, CsInventorySourceTypeEnum.OUT_TOP_BACKTRACK_PREEMPT, CsInventorySourceTypeEnum.OUT_MATERIAL_ADJUST_PREEMPT, CsInventorySourceTypeEnum.OUT_INTERIOR_ADJUST_PREEMPT, CsInventorySourceTypeEnum.SECOND_OUT_TOP_BACKTRACK_PREEMPT, CsInventorySourceTypeEnum.OUT_ACT_AUDIT_PREEMPT, CsInventorySourceTypeEnum.BATCH_ADJUSTMENT_SUBMITTED_PREEMPT, CsInventorySourceTypeEnum.DISH_PREEMPT, CsInventorySourceTypeEnum.PURCHASE_RETREAT_PREEMPT, CsInventorySourceTypeEnum.OUTSOURCE_RETREAT_PREEMPT, CsInventorySourceTypeEnum.TRANSFER_OTHER_PREEMPT, CsInventorySourceTypeEnum.OUT_OTHER_PREEMPT, CsInventorySourceTypeEnum.PCP_OUT_SALE_PREEMPT}, priority=0)
public class CsCommonInventoryOutPreemptHandler
implements ICsInventorySourceTypeHandler {
    private static final Logger logger = LoggerFactory.getLogger(CsCommonInventoryOutPreemptHandler.class);
    @Autowired
    IInventoryPreemptionDomain inventoryPreemptionDomain;

    @Override
    public void handle(CsInventoryInOutBasicsDto inParamDto, List<CsInventoryInOutBasicsCargoDto> successList) {
        logger.info("CsInventoryOutSaleHandler==>\u5904\u7406,inParamDto:{},successListL:{}", (Object)LogUtils.buildLogContent(inParamDto), (Object)LogUtils.buildLogContent(successList));
        if (CollectionUtils.isEmpty(successList)) {
            return;
        }
        this.insertInventoryPreemptionInfo(inParamDto, successList);
    }

    private void insertInventoryPreemptionInfo(CsInventoryInOutBasicsDto inParamDto, List<CsInventoryInOutBasicsCargoDto> successList) {
        logger.info("common_insertInventoryPreemptionInfo,inParamDto:{},successList:{}", (Object)LogUtils.buildLogContent(inParamDto), (Object)LogUtils.buildLogContent(successList));
        ArrayList inventoryPreemptionEoList = Lists.newArrayList();
        if (CsInventorySourceTypeEnum.OUT_ACT_AUDIT_PREEMPT.getCode().equals(inParamDto.getSourceType())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"source_type", (Object)inParamDto.getSourceType());
            queryWrapper.eq((Object)"source_no", (Object)inParamDto.getSourceNo());
            queryWrapper.eq((Object)"dr", (Object)0);
            List preemptionEoList = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)preemptionEoList)) {
                return;
            }
        }
        for (CsInventoryInOutBasicsCargoDto cargoDto : successList) {
            InventoryPreemptionEo InventoryPreemptionEo2 = new InventoryPreemptionEo();
            InventoryPreemptionEo2.setSourceNo(inParamDto.getSourceNo());
            InventoryPreemptionEo2.setSourceType(inParamDto.getSourceType());
            InventoryPreemptionEo2.setWarehouseId(cargoDto.getWarehouseId());
            InventoryPreemptionEo2.setWarehouseCode(cargoDto.getWarehouseCode());
            InventoryPreemptionEo2.setWarehouseName(cargoDto.getWarehouseName());
            InventoryPreemptionEo2.setWarehouseClassify(cargoDto.getWarehouseClassify());
            InventoryPreemptionEo2.setWarehouseType(cargoDto.getWarehouseType());
            InventoryPreemptionEo2.setSkuCode(cargoDto.getCargoCode());
            InventoryPreemptionEo2.setSkuName(cargoDto.getCargoName());
            InventoryPreemptionEo2.setBatch(cargoDto.getBatch());
            InventoryPreemptionEo2.setBatchType(cargoDto.getBatchType());
            InventoryPreemptionEo2.setValid(CsValidFlagEnum.ENABLE.getCode());
            InventoryPreemptionEo2.setActivityId(cargoDto.getActivityId());
            InventoryPreemptionEo2.setActivityType(cargoDto.getActivityType());
            InventoryPreemptionEo2.setActivityFlag(cargoDto.getActivityFlag());
            boolean flag = Objects.nonNull(cargoDto.getActivityId()) && (CsInventorySourceTypeEnum.OUT_BUSINESS_APPROVE_PREEMPT.getCode().equals(inParamDto.getSourceType()) || CsInventorySourceTypeEnum.OUT_FINANCE_APPROVE_PREEMPT.getCode().equals(inParamDto.getSourceType()) || CsInventorySourceTypeEnum.OUT_ACT_ORDER_PREEMPT.getCode().equals(inParamDto.getSourceType()));
            InventoryPreemptionEo2.setDisplay(flag ? YesNoEnum.NO.getValue() : YesNoEnum.YES.getValue());
            BigDecimal preempt = cargoDto.getPreempt();
            if (CsInventorySourceTypeEnum.OUT_ACT_AUDIT_PREEMPT.getCode().equals(inParamDto.getSourceType())) {
                preempt = BigDecimal.valueOf(cargoDto.getActivityNum().intValue());
                InventoryPreemptionEo2.setSourceNo(inParamDto.getSourceNo());
                InventoryPreemptionEo2.setValid(CsValidFlagEnum.DISABLE.getCode());
            }
            preempt = preempt == null ? BigDecimal.ZERO : preempt;
            InventoryPreemptionEo2.setPreemptNum(preempt);
            inventoryPreemptionEoList.add(InventoryPreemptionEo2);
        }
        this.inventoryPreemptionDomain.insertBatch((List)inventoryPreemptionEoList);
    }
}

