/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryPreemptionApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryPreemptionQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryPreemptionService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPreemptionAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPreemptionQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPreemptionUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryPreemptionRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class InventoryPreemptionApiImpl
implements ICsInventoryPreemptionApi {
    private static final Logger log = LoggerFactory.getLogger(InventoryPreemptionApiImpl.class);
    @Autowired
    protected ICsInventoryPreemptionService csInventoryPreemptionService;
    @Autowired
    protected ICsInventoryPreemptionQueryService csInventoryPreemptionQueryService;
    @Autowired
    protected IInventoryPreemptionDomain inventoryPreemptionDomain;

    public RestResponse<Long> add(CsInventoryPreemptionAddReqDto addReqDto) {
        log.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        return new RestResponse((Object)this.csInventoryPreemptionService.add(addReqDto));
    }

    public RestResponse<Void> update(Long id, CsInventoryPreemptionUpdateReqDto updateReqDto) {
        log.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        this.csInventoryPreemptionService.update(id, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        log.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        this.csInventoryPreemptionService.delete(id);
        return RestResponse.VOID;
    }

    public RestResponse<CsInventoryPreemptionRespDto> queryByPrimaryKey(Long id) {
        log.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        InventoryPreemptionEo eo = this.csInventoryPreemptionQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        CsInventoryPreemptionRespDto dto = new CsInventoryPreemptionRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)eo, (String[])new String[0]);
        return new RestResponse((Object)dto);
    }

    public RestResponse<Integer> searchCountForLessNum(String sourceNo) {
        AssertUtil.assertNotBlank(sourceNo, "\u6765\u6e90\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        return new RestResponse((Object)this.inventoryPreemptionDomain.searchCountForLessNum(sourceNo));
    }

    public RestResponse<List<CsInventoryPreemptionRespDto>> queryList(CsInventoryPreemptionQueryDto queryDto) {
        if (StringUtils.isBlank((CharSequence)queryDto.getSourceNo()) && CollectionUtils.isEmpty((Collection)queryDto.getSourceNoList())) {
            throw new CsInventoryException("\u7f3a\u5c11\u6765\u6e90\u5355\u53f7", new Object[0]);
        }
        String valid = CsValidFlagEnum.ENABLE.getCode();
        if (StringUtils.isNotBlank((CharSequence)queryDto.getValid())) {
            valid = queryDto.getValid();
        }
        List InventoryPreemptionEos = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in(CollectionUtils.isNotEmpty((Collection)queryDto.getSourceNoList()), (Object)"source_no", (Collection)queryDto.getSourceNoList())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getSourceNo()), (Object)"source_no", (Object)queryDto.getSourceNo())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getCargoCode()), (Object)"sku_code", (Object)queryDto.getCargoCode())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseCode()), (Object)"warehouse_code", (Object)queryDto.getWarehouseCode())).eq((Object)"valid", (Object)valid)).eq((Object)"dr", (Object)YesNoHelper.NO));
        ArrayList dtoList = Lists.newArrayList();
        for (InventoryPreemptionEo eo : InventoryPreemptionEos) {
            CsInventoryPreemptionRespDto dto = new CsInventoryPreemptionRespDto();
            BeanUtils.copyProperties((Object)eo, (Object)dto);
            dto.setLongCode(eo.getSkuCode());
            dto.setCargoCode(eo.getSkuCode());
            dto.setCargoName(eo.getSkuName());
            dtoList.add(dto);
        }
        return new RestResponse((Object)dtoList);
    }
}

