/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ImportInspectionReleasePlanReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InspectionReleasePlanReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.InspectionReleasePlanRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IInspectionReleasePlanService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.InspectionReleaseOperateLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.InspectionReleasePlanDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InspectionReleaseOperateLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InspectionReleasePlanEo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InspectionReleasePlanServiceImpl
implements IInspectionReleasePlanService {
    @Resource
    private InspectionReleasePlanDas inspectionReleasePlanDas;
    @Resource
    private InspectionReleaseOperateLogDas inspectionReleaseOperateLogDas;

    @Override
    public Long addInspectionReleasePlan(InspectionReleasePlanReqDto addReqDto) {
        InspectionReleasePlanEo inspectionReleasePlanEo = new InspectionReleasePlanEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)inspectionReleasePlanEo);
        this.inspectionReleasePlanDas.insert((BaseEo)inspectionReleasePlanEo);
        return inspectionReleasePlanEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyInspectionReleasePlan(ImportInspectionReleasePlanReqDto modifyReqDto) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)modifyReqDto.getBatch()), "\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)modifyReqDto.getSkuCode()), "\u5546\u54c1\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inspectionReleasePlanDas.filter().eq((Object)"sku_code", (Object)modifyReqDto.getSkuCode())).eq((Object)"batch", (Object)modifyReqDto.getBatch())).list();
        InspectionReleasePlanEo planEo = new InspectionReleasePlanEo();
        if (CollectionUtil.isNotEmpty((Collection)eos)) {
            InspectionReleasePlanEo eo = (InspectionReleasePlanEo)eos.get(0);
            Long id = eo.getId();
            planEo.setId(id);
            planEo.setPlanReleaseNum(Optional.ofNullable(modifyReqDto.getPlanReleaseNum()).orElse(BigDecimal.ZERO));
            this.inspectionReleasePlanDas.updateSelective((BaseEo)planEo);
            InspectionReleaseOperateLogEo logEo = new InspectionReleaseOperateLogEo();
            String logDesc = "\u66f4\u65b0\u8ba1\u5212\u653e\u884c\u6570\u91cf:";
            logEo.setSkuCode(eo.getSkuCode());
            logEo.setSkuName(eo.getSkuName());
            logEo.setBatch(eo.getBatch());
            logEo.setOperate("import_planned_release_quantity");
            logEo.setDescription(logDesc + modifyReqDto.getPlanReleaseNum());
            this.inspectionReleaseOperateLogDas.insert((BaseEo)logEo);
        } else {
            BeanUtils.copyProperties((Object)modifyReqDto, (Object)planEo);
            planEo.setPlanReleaseNum(Optional.ofNullable(modifyReqDto.getPlanReleaseNum()).orElse(BigDecimal.ZERO));
            this.inspectionReleasePlanDas.insert((BaseEo)planEo);
            InspectionReleaseOperateLogEo logEo = new InspectionReleaseOperateLogEo();
            String logDesc = "\u66f4\u65b0\u8ba1\u5212\u653e\u884c\u6570\u91cf:";
            logEo.setSkuCode(modifyReqDto.getSkuCode());
            logEo.setSkuName(modifyReqDto.getSkuName());
            logEo.setBatch(modifyReqDto.getBatch());
            logEo.setOperate("import_planned_release_quantity");
            logEo.setDescription(logDesc + modifyReqDto.getPlanReleaseNum());
            this.inspectionReleaseOperateLogDas.insert((BaseEo)logEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeInspectionReleasePlan(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.inspectionReleasePlanDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public InspectionReleasePlanRespDto queryById(Long id) {
        InspectionReleasePlanEo inspectionReleasePlanEo = (InspectionReleasePlanEo)this.inspectionReleasePlanDas.selectByPrimaryKey(id);
        InspectionReleasePlanRespDto inspectionReleasePlanRespDto = new InspectionReleasePlanRespDto();
        DtoHelper.eo2Dto((BaseEo)inspectionReleasePlanEo, (BaseVo)inspectionReleasePlanRespDto);
        return inspectionReleasePlanRespDto;
    }

    @Override
    public PageInfo<InspectionReleasePlanRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        InspectionReleasePlanReqDto inspectionReleasePlanReqDto = (InspectionReleasePlanReqDto)JSON.parseObject((String)filter, InspectionReleasePlanReqDto.class);
        InspectionReleasePlanEo inspectionReleasePlanEo = new InspectionReleasePlanEo();
        DtoHelper.dto2Eo((BaseVo)inspectionReleasePlanReqDto, (BaseEo)inspectionReleasePlanEo);
        PageInfo eoPageInfo = this.inspectionReleasePlanDas.selectPage((BaseEo)inspectionReleasePlanEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, InspectionReleasePlanRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

