/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.shop.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.shop.ICsShopEnquiryApplyDetailExtService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.Assert;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.shop.CsShopEnquiryApplyDetailExtDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.shop.CsShopEnquiryApplyExtDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.shop.CsShopEnquiryApplyDetailExtEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.shop.CsShopEnquiryApplyExtEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.shop.CsShopEnquiryApplyDetailExtMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.shop.CsShopEnquiryApplyDetailExtReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.shop.CsShopEnquiryApplyDetailPageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.shop.CsItemAvailableInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.shop.CsShopEnquiryApplyDetailExtRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.BdLogicWarehousePropertyEnum;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.basicdata.api.IPcpDictApi;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CsShopEnquiryApplyDetailExtServiceImpl
implements ICsShopEnquiryApplyDetailExtService {
    private static Logger logger = LoggerFactory.getLogger(ICsShopEnquiryApplyDetailExtService.class);
    @Resource
    private CsShopEnquiryApplyExtDas shopEnquiryApplyExtDas;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private ILogicInventoryTotalDomain logicInventoryTotalDomain;
    @Resource
    private CsShopEnquiryApplyDetailExtDas shopEnquiryApplyDetailExtDas;
    @Resource
    private IPcpDictApi iPcpDictApi;
    @Resource
    private CsShopEnquiryApplyDetailExtMapper shopEnquiryApplyDetailExtMapper;

    @Override
    public Long addShopEnquiryApplyDetailExt(CsShopEnquiryApplyDetailExtReqDto addReqDto) {
        CsShopEnquiryApplyDetailExtEo shopEnquiryApplyDetailExtEo = new CsShopEnquiryApplyDetailExtEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)shopEnquiryApplyDetailExtEo);
        this.shopEnquiryApplyDetailExtDas.insert((BaseEo)shopEnquiryApplyDetailExtEo);
        return shopEnquiryApplyDetailExtEo.getId();
    }

    @Override
    public void modifyShopEnquiryApplyDetailExt(CsShopEnquiryApplyDetailExtReqDto modifyReqDto) {
        CsShopEnquiryApplyDetailExtEo shopEnquiryApplyDetailExtEo = new CsShopEnquiryApplyDetailExtEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)shopEnquiryApplyDetailExtEo);
        this.shopEnquiryApplyDetailExtDas.updateSelective((BaseEo)shopEnquiryApplyDetailExtEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeShopEnquiryApplyDetailExt(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.shopEnquiryApplyDetailExtDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CsShopEnquiryApplyDetailExtRespDto queryById(Long id) {
        CsShopEnquiryApplyDetailExtEo shopEnquiryApplyDetailExtEo = (CsShopEnquiryApplyDetailExtEo)this.shopEnquiryApplyDetailExtDas.selectByPrimaryKey(id);
        CsShopEnquiryApplyDetailExtRespDto shopEnquiryApplyDetailExtRespDto = new CsShopEnquiryApplyDetailExtRespDto();
        DtoHelper.eo2Dto((BaseEo)shopEnquiryApplyDetailExtEo, (BaseVo)shopEnquiryApplyDetailExtRespDto);
        return shopEnquiryApplyDetailExtRespDto;
    }

    @Override
    public List<CsShopEnquiryApplyDetailExtRespDto> queryByApplyId(Long shopEnquiryApplyId) {
        if (Objects.isNull(shopEnquiryApplyId)) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_id", (Object)shopEnquiryApplyId);
        queryWrapper.eq((Object)"dr", (Object)0);
        List shopEnquiryApplyDetailExtEoList = this.shopEnquiryApplyDetailExtMapper.selectList((Wrapper)queryWrapper);
        ArrayList<CsShopEnquiryApplyDetailExtRespDto> list = new ArrayList<CsShopEnquiryApplyDetailExtRespDto>();
        CubeBeanUtils.copyCollection(list, (Collection)shopEnquiryApplyDetailExtEoList, CsShopEnquiryApplyDetailExtRespDto.class);
        return list;
    }

    @Override
    public PageInfo<CsShopEnquiryApplyDetailExtRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CsShopEnquiryApplyDetailExtReqDto shopEnquiryApplyDetailExtReqDto = (CsShopEnquiryApplyDetailExtReqDto)JSON.parseObject((String)filter, CsShopEnquiryApplyDetailExtReqDto.class);
        CsShopEnquiryApplyDetailExtEo shopEnquiryApplyDetailExtEo = new CsShopEnquiryApplyDetailExtEo();
        DtoHelper.dto2Eo((BaseVo)shopEnquiryApplyDetailExtReqDto, (BaseEo)shopEnquiryApplyDetailExtEo);
        PageInfo eoPageInfo = this.shopEnquiryApplyDetailExtDas.selectPage((BaseEo)shopEnquiryApplyDetailExtEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CsShopEnquiryApplyDetailExtRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<CsShopEnquiryApplyDetailExtRespDto> queryDetailByApplyId(Long shopEnquiryApplyId) {
        List eoList = ((ExtQueryChainWrapper)this.shopEnquiryApplyDetailExtDas.filter().eq((Object)"order_id", (Object)shopEnquiryApplyId)).list();
        ArrayList<CsShopEnquiryApplyDetailExtRespDto> dtoList = new ArrayList<CsShopEnquiryApplyDetailExtRespDto>();
        for (CsShopEnquiryApplyDetailExtEo enquiryApplyDetailExtEo : eoList) {
            CsShopEnquiryApplyDetailExtRespDto shopEnquiryApplyDetailExtRespDto = new CsShopEnquiryApplyDetailExtRespDto();
            DtoHelper.eo2Dto((BaseEo)enquiryApplyDetailExtEo, (BaseVo)shopEnquiryApplyDetailExtRespDto);
            List<CsItemAvailableInventoryRespDto> respDtos = this.queryItemAvailableInventory(Collections.singletonList(enquiryApplyDetailExtEo.getCargoCode()));
            if (CollectionUtil.isNotEmpty(respDtos)) {
                shopEnquiryApplyDetailExtRespDto.setSurplusNum(ParamConverter.convertToLong((Object)respDtos.get(0).getAvailableInventory()));
            }
            dtoList.add(shopEnquiryApplyDetailExtRespDto);
        }
        return dtoList;
    }

    @Override
    public PageInfo<CsShopEnquiryApplyDetailExtRespDto> queryDetailPageByApplyId(CsShopEnquiryApplyDetailPageReqDto csShopEnquiryApplyDetailPageReqDto) {
        logger.debug("\u67e5\u770b\u8981\u8d27\u8be6\u60c5\u53c2\u6570{}", (Object)JSON.toJSONString((Object)csShopEnquiryApplyDetailPageReqDto));
        CsShopEnquiryApplyDetailExtEo shopEnquiryApplyDetailExtEo = new CsShopEnquiryApplyDetailExtEo();
        shopEnquiryApplyDetailExtEo.setOrderId(csShopEnquiryApplyDetailPageReqDto.getApplyId());
        PageInfo shopEnquiryApplyDetailExtEoPageInfo = this.shopEnquiryApplyDetailExtDas.selectPage((BaseEo)shopEnquiryApplyDetailExtEo, csShopEnquiryApplyDetailPageReqDto.getPageNum(), csShopEnquiryApplyDetailPageReqDto.getPageSize());
        List list = shopEnquiryApplyDetailExtEoPageInfo.getList();
        CsShopEnquiryApplyExtEo shopEnquiryApplyExtEo = (CsShopEnquiryApplyExtEo)this.shopEnquiryApplyExtDas.selectByPrimaryKey(csShopEnquiryApplyDetailPageReqDto.getApplyId());
        Assert.notNull(shopEnquiryApplyExtEo, CsInventoryExceptionCode.NOT_EXIST_SHOP_ENQUIRY);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)shopEnquiryApplyDetailExtEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<CsShopEnquiryApplyDetailExtRespDto> dtoList = new ArrayList<CsShopEnquiryApplyDetailExtRespDto>();
        for (CsShopEnquiryApplyDetailExtEo enquiryApplyDetailExtEo : list) {
            CsShopEnquiryApplyDetailExtRespDto shopEnquiryApplyDetailExtRespDto = new CsShopEnquiryApplyDetailExtRespDto();
            DtoHelper.eo2Dto((BaseEo)enquiryApplyDetailExtEo, (BaseVo)shopEnquiryApplyDetailExtRespDto);
            List<CsItemAvailableInventoryRespDto> respDtos = this.queryItemAvailableInventory(Collections.singletonList(enquiryApplyDetailExtEo.getCargoCode()));
            if (CollectionUtil.isNotEmpty(respDtos)) {
                shopEnquiryApplyDetailExtRespDto.setSurplusNum(ParamConverter.convertToLong((Object)respDtos.get(0).getAvailableInventory()));
            }
            shopEnquiryApplyDetailExtRespDto.setConfirmNum(Long.valueOf(enquiryApplyDetailExtEo.getConfirmNum() != null ? enquiryApplyDetailExtEo.getConfirmNum() : 0L));
            dtoList.add(shopEnquiryApplyDetailExtRespDto);
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<CsItemAvailableInventoryRespDto> queryItemAvailableInventory(List<String> itemCodes) {
        logger.info("\u5546\u54c1\u7f16\u7801\u96c6\u5408itemCodes:{}", (Object)JSON.toJSONString(itemCodes));
        List dictDtos = (List)RestResponseHelper.extractData((RestResponse)this.iPcpDictApi.queryByGroupCode("available_warehouse"));
        if (CollectionUtils.isEmpty((Collection)dictDtos) || StringUtils.isBlank((CharSequence)((DictDto)dictDtos.get(0)).getValue())) {
            throw new RuntimeException("\u95e8\u5e97\u53ef\u7528\u5e93\u5b58\u7684\u4ed3\u5e93\u914d\u7f6e\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        Object[] warehouseCodes = ((DictDto)dictDtos.get(0)).getValue().split(",");
        List csLogicInventoryTotalEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryTotalDomain.filter().in((Object)"sku_code", itemCodes)).in((Object)"warehouse_code", warehouseCodes)).list();
        List<Object> respDtos = new ArrayList<CsItemAvailableInventoryRespDto>();
        if (CollectionUtil.isEmpty((Collection)csLogicInventoryTotalEos)) {
            return respDtos;
        }
        Map<String, List<LogicInventoryTotalEo>> csLogicInventoryTotalEoMap = csLogicInventoryTotalEos.stream().collect(Collectors.groupingBy(LogicInventoryTotalEo::getSkuCode));
        logger.info("\u6839\u636e\u5546\u54c1\u7f16\u7801\u5206\u7ec4csLogicInventoryTotalEoMap:{}", (Object)JSON.toJSONString(csLogicInventoryTotalEoMap));
        respDtos = itemCodes.stream().map(itemCode -> {
            List eos = (List)csLogicInventoryTotalEoMap.get(itemCode);
            CsItemAvailableInventoryRespDto respDto = new CsItemAvailableInventoryRespDto();
            respDto.setItemCode(itemCode);
            BigDecimal availableNum = new BigDecimal(0);
            if (CollectionUtil.isNotEmpty((Collection)eos)) {
                for (LogicInventoryTotalEo eo : eos) {
                    availableNum = availableNum.add(eo.getAvailable());
                }
            }
            respDto.setAvailableInventory(ParamConverter.convertToInteger((Object)availableNum.setScale(0, 4).toString()));
            return respDto;
        }).collect(Collectors.toList());
        logger.info("\u5546\u54c1\u7f16\u7801\u53ca\u5176\u53ef\u7528\u5e93\u5b58:{}", (Object)JSON.toJSONString(respDtos));
        return respDtos;
    }

    @Override
    public CsShopEnquiryApplyDetailExtRespDto queryByCargoCode(String cargoCode, Integer status, Boolean flag) {
        CsShopEnquiryApplyDetailExtRespDto respDto = new CsShopEnquiryApplyDetailExtRespDto();
        return respDto;
    }

    private static List<String> getWarehousePropertyList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(BdLogicWarehousePropertyEnum.INTERNAL.getCode());
        list.add(BdLogicWarehousePropertyEnum.OVERSEAS.getCode());
        list.add(BdLogicWarehousePropertyEnum.OUTLET.getCode());
        return list;
    }
}

