/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq.cs;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.impl.CsSinceTheClosedLoopHandlerService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="SINGLE_TOPIC", tag="INVENTORY_SINCE_THE_CLOSED_LOOP_TAG")
public class CsSinceTheClosedLoopProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(CsSinceTheClosedLoopProcessor.class);
    private static final Logger logger = LoggerFactory.getLogger(CsSinceTheClosedLoopProcessor.class);
    @Autowired
    private CsSinceTheClosedLoopHandlerService csSinceTheClosedLoopHandlerService;
    @Resource
    private ILockService lockService;
    public static final String INVENTORY_SINCE_THE_CLOSED_LOOP_SYNC = "INVENTORY_SINCE_THE_CLOSED_LOOP_SYNC";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(MessageVo messageVo) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("----->\u5e93\u5b58\u4e2d\u5fc3,\u81ea\u4ea7\u81ea\u9500\u9488\u5bf9\u81ea\u95ed\u73af,messageVo:{}", (Object)JSONObject.toJSONString((Object)messageVo));
        if (null == messageVo) {
            return MessageResponse.SUCCESS;
        }
        String documentNo = (String)messageVo.getData();
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock(INVENTORY_SINCE_THE_CLOSED_LOOP_SYNC, documentNo);
            if (null == mutex) {
                throw new BizException("\u5e93\u5b58\u4e2d\u5fc3,\u81ea\u4ea7\u81ea\u9500\u9488\u5bf9\u81ea\u95ed\u73af\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
            }
            this.csSinceTheClosedLoopHandlerService.handleByDocumentNo(documentNo);
        }
        catch (Exception e) {
            log.error(String.format("\u63a5\u5e93\u5b58\u4e2d\u5fc3,\u81ea\u4ea7\u81ea\u9500\u9488\u5bf9\u81ea\u95ed\u73af\u5931\u8d25\uff1a%s", e.getLocalizedMessage()));
            MessageResponse messageResponse = MessageResponse.ERROR;
            return messageResponse;
        }
        finally {
            this.lockService.unlock(mutex);
        }
        return MessageResponse.SUCCESS;
    }
}

