/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter.bd;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.adapter.TransferOrderDetailApiImpl;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsTransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsTransferOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferDispatcherStatusEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderDetailResponseDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.TransferOrderBatchDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicInventoryDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.entity.ILogicInventoryService;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="bd_TransferOrderDetailApi")
public class BdTransferOrderDetailApiImpl
extends TransferOrderDetailApiImpl {
    private static final Logger log = LoggerFactory.getLogger(BdTransferOrderDetailApiImpl.class);
    @Resource
    private ICsTransferOrderService csTransferOrderService;
    @Resource
    private ILogicInventoryService logicInventoryService;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    private IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    private IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    private CsTransferOrderDetailDas csTransferOrderDetailDas;

    @Override
    public RestResponse<List<CsTransferOrderDetailRespDto>> queryListByTransferOrderNo(String transferOrderNo) {
        List<CsTransferOrderDetailRespDto> detail = this.csTransferOrderDetailService.queryListByTransferOrderNo(transferOrderNo);
        if (CollectionUtil.isNotEmpty(detail)) {
            this.queryAndSetAvailable(transferOrderNo, detail);
        }
        this.formatWaitInfo(transferOrderNo, detail);
        return new RestResponse(detail);
    }

    @Override
    public RestResponse<PageInfo<CsTransferOrderDetailResponseDto>> queryDetailListByTransferOrderNo(String transferOrderNo, Integer pageNum, Integer pageSize) {
        PageInfo page;
        block10: {
            ArrayList list;
            block11: {
                List<InOutResultOrderDetailEo> in;
                PageInfo eoPageInfo = ((ExtQueryChainWrapper)this.csTransferOrderDetailDas.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).select(new String[0]).page(pageNum, pageSize);
                page = new PageInfo();
                CubeBeanUtils.copyProperties((Object)page, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                list = new ArrayList();
                DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), list, CsTransferOrderDetailResponseDto.class);
                page.setList(list);
                List csDeliveryNoticeOrderEoList = ((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).list();
                ReceiveDeliveryNoticeOrderEo csDeliveryNoticeOrderEo = null;
                if (CollectionUtils.isNotEmpty((Collection)csDeliveryNoticeOrderEoList)) {
                    csDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)csDeliveryNoticeOrderEoList.get(0);
                }
                if (!CollectionUtil.isNotEmpty(list)) break block10;
                Map<String, List<InOutResultOrderDetailEo>> map = this.csTransferOrderDetailService.queryInOutResult(transferOrderNo);
                if (!CollectionUtil.isNotEmpty(map)) break block11;
                List<InOutResultOrderDetailEo> out = map.get("out");
                if (CollectionUtil.isNotEmpty(out)) {
                    Map<String, Double> outFinishMap = out.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode, Collectors.summingDouble(c -> c.getQuantity().doubleValue())));
                    Map<Long, Double> outFinishPreOrderItemIdMap = out.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getPreOrderItemId, Collectors.summingDouble(c -> c.getQuantity().doubleValue())));
                    Map<String, List<InOutResultOrderDetailEo>> batchMap = out.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode));
                    Map<Long, List<InOutResultOrderDetailEo>> batchPreOrderItemIdMap = out.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getPreOrderItemId));
                    for (CsTransferOrderDetailResponseDto transfer : list) {
                        Double outTotal = Objects.nonNull(outFinishPreOrderItemIdMap.get(transfer.getId())) ? outFinishPreOrderItemIdMap.get(transfer.getId()) : outFinishMap.get(transfer.getLongCode());
                        transfer.setDoneDeliveryQuantity(outTotal == null ? BigDecimal.ZERO : new BigDecimal(outTotal));
                        List<InOutResultOrderDetailEo> outBatch = Objects.nonNull(batchPreOrderItemIdMap.get(transfer.getId())) ? batchPreOrderItemIdMap.get(transfer.getId()) : batchMap.get(transfer.getLongCode());
                        if (!CollectionUtil.isNotEmpty(outBatch)) continue;
                        ArrayList<TransferOrderBatchDetailRespDto> batchList = new ArrayList<TransferOrderBatchDetailRespDto>();
                        for (InOutResultOrderDetailEo batch : outBatch) {
                            TransferOrderBatchDetailRespDto t = new TransferOrderBatchDetailRespDto();
                            t.setBatch(batch.getBatch());
                            t.setDoneDeliveryQuantity(batch.getQuantity() == null ? BigDecimal.ZERO : batch.getQuantity());
                            t.setDoneReceiveQuantity(BigDecimal.ZERO);
                            t.setOutResultNo(batch.getDocumentNo());
                            t.setInResultNo("-");
                            if (null != csDeliveryNoticeOrderEo) {
                                t.setJumpDocumentType(csDeliveryNoticeOrderEo.getJumpDocumentType());
                                t.setJumpDocumentName(csDeliveryNoticeOrderEo.getJumpDocumentName());
                            }
                            t.setJumpDocumentName("\u53d1\u8d27\u7ed3\u679c\u5355");
                            batchList.add(t);
                        }
                        transfer.setBatchList(batchList);
                    }
                }
                if (!CollectionUtil.isNotEmpty(in = map.get("in"))) break block10;
                Map<String, Double> inFinishMap = in.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode, Collectors.summingDouble(c -> CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode().equals(c.getDispatcherStatus()) ? c.getQuantity().add(Optional.ofNullable(c.getDispatcherQuantity()).orElse(BigDecimal.ZERO)).doubleValue() : c.getQuantity().doubleValue())));
                Map<Long, Double> inFinishPreOrderItemIdMap = in.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getPreOrderItemId, Collectors.summingDouble(c -> c.getQuantity().doubleValue())));
                Map<String, List<InOutResultOrderDetailEo>> batchMap = in.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode));
                Map<Long, List<InOutResultOrderDetailEo>> batchPreOrderItemIdMap = in.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getPreOrderItemId));
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    CsTransferOrderDetailResponseDto transfer;
                    Double inTotal = (Double)DataExtractUtils.ifNullElse((Object)inFinishMap.get((transfer = (CsTransferOrderDetailResponseDto)iterator.next()).getLongCode()), (Object)inFinishPreOrderItemIdMap.get(transfer.getId()));
                    transfer.setDoneReceiveQuantity(inTotal == null ? BigDecimal.ZERO : new BigDecimal(inTotal));
                    List<InOutResultOrderDetailEo> inBatch = Objects.nonNull(batchPreOrderItemIdMap.get(transfer.getId())) ? batchPreOrderItemIdMap.get(transfer.getId()) : batchMap.get(transfer.getLongCode());
                    if (!CollectionUtil.isNotEmpty(inBatch)) continue;
                    List batchList = transfer.getBatchList();
                    for (InOutResultOrderDetailEo batch : inBatch) {
                        TransferOrderBatchDetailRespDto t = new TransferOrderBatchDetailRespDto();
                        t.setBatch(batch.getBatch());
                        t.setDoneReceiveQuantity(batch.getQuantity() == null ? BigDecimal.ZERO : batch.getQuantity());
                        t.setDoneDeliveryQuantity(BigDecimal.ZERO);
                        t.setInResultNo(batch.getDocumentNo());
                        if (CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode().equals(batch.getDispatcherStatus())) {
                            t.setDoneReceiveQuantity(t.getDoneReceiveQuantity().add(Optional.ofNullable(batch.getDispatcherQuantity()).orElse(BigDecimal.ZERO)));
                        }
                        t.setOutResultNo("-");
                        if (null != csDeliveryNoticeOrderEo) {
                            t.setJumpDocumentType(csDeliveryNoticeOrderEo.getJumpDocumentType());
                            t.setJumpDocumentName(csDeliveryNoticeOrderEo.getJumpDocumentName());
                        }
                        t.setJumpDocumentName("\u6536\u8d27\u7ed3\u679c\u5355");
                        batchList.add(t);
                    }
                }
                break block10;
            }
            for (CsTransferOrderDetailResponseDto responseDto : list) {
                List batchList = responseDto.getBatchList();
                if (!CollectionUtils.isEmpty((Collection)batchList)) continue;
                responseDto.setBatchList(null);
            }
        }
        return new RestResponse((Object)page);
    }

    private void formatWaitInfo(String transferOrderNo, List<CsTransferOrderDetailRespDto> detail) {
        ArrayList notOutInNoticeStatusList = Lists.newArrayList();
        notOutInNoticeStatusList.add(BaseOrderStatusEnum.ONO_CANCEL.getCode());
        notOutInNoticeStatusList.add(BaseOrderStatusEnum.INO_CANCEL.getCode());
        QueryWrapper csOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        csOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csOutNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)transferOrderNo);
        csOutNoticeOrderEoQueryWrapper.notIn((Object)"order_status", (Collection)notOutInNoticeStatusList);
        List csOutNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).notIn((Object)"order_status", (Collection)notOutInNoticeStatusList)).list();
        InOutNoticeOrderEo outNoticeOrderEo = null;
        InOutNoticeOrderEo inNoticeOrderEo = null;
        if (CollectionUtils.isNotEmpty((Collection)csOutNoticeOrderEoList)) {
            for (InOutNoticeOrderEo outInNoticeOrderEo : csOutNoticeOrderEoList) {
                String orderType = outInNoticeOrderEo.getOrderType();
                if ("out".equals(orderType)) {
                    outNoticeOrderEo = outInNoticeOrderEo;
                    continue;
                }
                if (!"in".equals(orderType)) continue;
                inNoticeOrderEo = outInNoticeOrderEo;
            }
        }
        Map<Object, Object> outNoticeOrderDetailMap = Maps.newHashMap();
        if (null != outNoticeOrderEo) {
            String documentNo = outNoticeOrderEo.getDocumentNo();
            List outNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)documentNo)).list();
            if (CollectionUtils.isNotEmpty((Collection)outNoticeOrderDetailEoList)) {
                outNoticeOrderDetailMap = outNoticeOrderDetailEoList.stream().collect(Collectors.toMap(InOutNoticeOrderDetailEo::getSkuCode, Function.identity()));
            }
        }
        Map<Object, Object> outResultOrderDetailEoMap = Maps.newHashMap();
        List csOutResultOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).eq((Object)"order_status", (Object)BaseOrderStatusEnum.IRO_DONE_IN.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)csOutResultOrderEoList)) {
            List resultDocumentNoList = csOutResultOrderEoList.stream().map(InOutResultOrderEo::getDocumentNo).collect(Collectors.toList());
            List csOutResultOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().in((Object)"document_no", resultDocumentNoList)).list();
            if (CollectionUtils.isNotEmpty((Collection)csOutResultOrderDetailEoList)) {
                outResultOrderDetailEoMap = csOutResultOrderDetailEoList.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode));
            }
        }
        Map<Object, Object> inNoticeOrderDetailMap = Maps.newHashMap();
        if (null != inNoticeOrderEo) {
            String documentNo = inNoticeOrderEo.getDocumentNo();
            List inNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)documentNo)).list();
            if (CollectionUtils.isNotEmpty((Collection)inNoticeOrderDetailEoList)) {
                inNoticeOrderDetailMap = inNoticeOrderDetailEoList.stream().collect(Collectors.toMap(InOutNoticeOrderDetailEo::getSkuCode, Function.identity()));
            }
        }
        log.info("formatWaitInfo==>\u67e5\u8be2\u8bbe\u7f6e\u5f85\u5165\u3001\u5f85\u51fa\u3001\u5df2\u5165\u3001\u5df2\u51fa\u6570\u91cf,outNoticeOrderDetailMap:{},inNoticeOrderDetailMap:{},outResultOrderDetailEoMap:{}", new Object[]{LogUtils.buildLogContent(outNoticeOrderDetailMap), LogUtils.buildLogContent(inNoticeOrderDetailMap), LogUtils.buildLogContent(outResultOrderDetailEoMap)});
        for (CsTransferOrderDetailRespDto detailRespDto : detail) {
            InOutNoticeOrderDetailEo outNoticeOrderDetailEo;
            List csOutResultOrderDetailEoList;
            String longCode = detailRespDto.getLongCode();
            InOutNoticeOrderDetailEo inNoticeOrderDetailEo = (InOutNoticeOrderDetailEo)inNoticeOrderDetailMap.get(longCode);
            if (null != inNoticeOrderDetailEo) {
                detailRespDto.setWaitInQuantity(inNoticeOrderDetailEo.getWaitQuantity());
            }
            if (CollectionUtils.isNotEmpty((Collection)(csOutResultOrderDetailEoList = (List)outResultOrderDetailEoMap.get(longCode)))) {
                BigDecimal totalDoneQuantity = csOutResultOrderDetailEoList.stream().map(InOutResultOrderDetailEo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                detailRespDto.setDoneInQuantity(totalDoneQuantity);
            }
            if (null == (outNoticeOrderDetailEo = (InOutNoticeOrderDetailEo)outNoticeOrderDetailMap.get(longCode))) continue;
            detailRespDto.setWaitOutQuantity(outNoticeOrderDetailEo.getWaitQuantity());
            detailRespDto.setDoneOutQuantity(outNoticeOrderDetailEo.getDoneQuantity());
        }
        log.info("formatWaitInfo==>\u5904\u7406\u5b8c\u6210\u540e,detail:{}", (Object)LogUtils.buildLogContent(detail));
    }

    private void queryAndSetAvailable(String transferOrderNo, List<CsTransferOrderDetailRespDto> list) {
        CsTransferOrderRespDto transfer = this.csTransferOrderService.queryByTransferOrderNo(transferOrderNo);
        String outLogicWarehouseCode = transfer.getOutLogicWarehouseCode();
        if (StringUtils.isEmpty((String)list.get(0).getBatch())) {
            Set longCodeSet2 = list.stream().map(CsTransferOrderDetailRespDto::getLongCode).collect(Collectors.toSet());
            List inventoryEos = this.logicInventoryService.queryBySkuCodesWithWarehouseCode(transfer.getOutLogicWarehouseCode(), longCodeSet2);
            if (CollectionUtil.isNotEmpty((Collection)inventoryEos)) {
                Map<String, BigDecimal> availMap = inventoryEos.stream().collect(Collectors.toMap(LogicInventoryDto::getSkuCode, LogicInventoryDto::getAvailable));
                list.forEach(d -> d.setAvailableInventory(availMap.get(d.getLongCode()) == null ? "" : ((BigDecimal)availMap.get(d.getLongCode())).toString()));
            }
        } else {
            Map longCodeMap = list.stream().collect(Collectors.groupingBy(CsTransferOrderDetailRespDto::getBatch, Collectors.mapping(CsTransferOrderDetailRespDto::getLongCode, Collectors.toSet())));
            ArrayList inventoryEos = new ArrayList();
            longCodeMap.forEach((batch, longCodeSet) -> inventoryEos.addAll(this.logicInventoryService.queryByBatchAndSkuCodes(outLogicWarehouseCode, batch, longCodeSet)));
            if (CollectionUtil.isNotEmpty(inventoryEos)) {
                Map<String, BigDecimal> availMap = inventoryEos.stream().collect(Collectors.toMap(eo -> eo.getSkuCode() + "_" + eo.getBatch(), LogicInventoryDto::getAvailable));
                list.forEach(d -> {
                    String key = d.getLongCode() + "_" + d.getBatch();
                    d.setAvailableInventory(availMap.get(key) == null ? "" : ((BigDecimal)availMap.get(key)).toString());
                });
            }
        }
    }
}

