/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsTransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="PUBLISH_TOPIC", tag="TRANSFER_CREATE")
public class TransferOrderCreateProcess
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(TransferOrderCreateProcess.class);
    @Autowired
    ICsTransferOrderService csTransferOrderService;

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        log.info("TransferOrderCreateProcess:{}", (Object)LogUtils.buildLogContent(message));
        CsTransferOrderRespDto csTransferOrderRespDto = (CsTransferOrderRespDto)JSONObject.parseObject((String)((String)message.getData()), CsTransferOrderRespDto.class);
        if (CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode().equals(csTransferOrderRespDto.getType()) || CsPcpBusinessTypeEnum.BC_EQUAL_ALLOT.getCode().equals(csTransferOrderRespDto.getType()) || CsPcpBusinessTypeEnum.CB_ALLOT.getCode().equals(csTransferOrderRespDto.getType())) {
            CsAuditReqDto auditReqDto = new CsAuditReqDto();
            auditReqDto.setBusinessOrderNo(csTransferOrderRespDto.getTransferOrderNo());
            auditReqDto.setAuditResult(CsOtherStorageOrderEnum.AuditEnum.AUDIT_PASS.getCode());
            auditReqDto.setRemark("\u81ea\u52a8\u5ba1\u6838");
            this.csTransferOrderService.auditTransferOrder(auditReqDto);
        }
        return MessageResponse.SUCCESS;
    }
}

