/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq.cs;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.bd.IStorageOrderExtApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsTransferOrderDetailService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsTransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.SapStorageOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.StorageOrderExtDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushTransferStorageOrderHeadReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushTransferStorageOrderReqDto;
import com.yunxi.dg.base.center.basicdata.enums.PcpBasicInventoryBusinessTypeEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="SINGLE_TOPIC", tag="CS_ADD_TRANSFER_STORE_RAISED_RESULT_ORDER_TAG")
public class CsAddTransferStoreRaisedResultOrderProcess
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(CsAddTransferStoreRaisedResultOrderProcess.class);
    private static final Logger logger = LoggerFactory.getLogger(CsAddTransferStoreRaisedResultOrderProcess.class);
    @Resource
    private ILockService lockService;
    @Resource
    private ICsTransferOrderService csTransferOrderService;
    @Resource(name="storageOrderExtApiImpl")
    private IStorageOrderExtApi storageOrderExtApi;
    @Resource
    private ICsTransferOrderDetailService csTransferOrderDetailService;
    @Resource
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    private IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private ICommonsMqService commonsMqService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(MessageVo messageVo) {
        List outResultOrderEos;
        String sapNo;
        Integer num;
        CsTransferOrderRespDto transferOrderRespDto;
        Mutex mutex;
        String transferOrderNo;
        block16: {
            Integer n;
            MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
            log.info("\u95e8\u5e97\u6a2a\u8c03\u65b0\u589e\u7ed3\u679c\u5355\u548c\u66f4\u65b0\u5e93\u5b58\u63a5\u6536\u5230\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)messageVo));
            transferOrderNo = (String)messageVo.getData();
            mutex = null;
            mutex = this.lockService.lock("CS_ADD_TRANSFER_STORE_RAISED_RESULT_ORDER_TAG", transferOrderNo, 10, 20, TimeUnit.SECONDS);
            if (null == mutex) {
                throw new BizException("\u95e8\u5e97\u6a2a\u8c03\u65b0\u589e\u7ed3\u679c\u5355\u548c\u66f4\u65b0\u5e93\u5b58\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
            }
            transferOrderRespDto = null;
            num = 0;
            do {
                transferOrderRespDto = this.csTransferOrderService.queryByTransferOrderNo(transferOrderNo);
                logger.info("\u7b2c\u3010{}\u3011\u6b21\u6839\u636e\u8c03\u62e8\u5355\u53f7\u67e5\u8be2\u8c03\u62e8\u5355\u4fe1\u606f\uff1a{}", (Object)(num + 1), (Object)JSON.toJSONString((Object)transferOrderRespDto));
                sapNo = transferOrderRespDto.getSapNO();
                Integer n2 = num;
                n = num = Integer.valueOf(num + 1);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } while (StringUtils.isBlank((CharSequence)sapNo) && num < 70);
            outResultOrderEos = this.inOutResultOrderDomain.queryByRelevanceNo(transferOrderNo);
            logger.info("\u65b0\u589e\u7ed3\u679c\u5355\u524d\u67e5\u8be2\u51fa\u5165\u5e93\u7ed3\u679c\u5355:{}", (Object)JSON.toJSONString((Object)outResultOrderEos));
            if (!CollectionUtils.isNotEmpty((Collection)outResultOrderEos)) break block16;
            logger.info("\u65b0\u589e\u7ed3\u679c\u5355\u524d\u67e5\u8be2\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u4e0d\u4e3a\u7a7a\uff0c\u5373\u91cd\u590d\u6d88\u8d39\uff0c\u76f4\u63a5\u8fd4\u56de\u6210\u529f");
            n = MessageResponse.SUCCESS;
            this.lockService.unlock(mutex);
            return n;
        }
        try {
            List outResultOrderDetailEos;
            List<SapStorageOrderAddReqDto> sapStorageOrderAddReqDtos = this.getSapStorageOrderAddReqDtos(transferOrderRespDto);
            logger.info("\u65b0\u589e\u7ed3\u679c\u5355\u548c\u66f4\u65b0\u5e93\u5b58\u5165\u53c2:{}", (Object)JSON.toJSONString(sapStorageOrderAddReqDtos));
            RestResponseHelper.extractData((RestResponse)this.storageOrderExtApi.sapAddStorageOrder(sapStorageOrderAddReqDtos));
            outResultOrderEos = this.inOutResultOrderDomain.queryByRelevanceNo(transferOrderNo);
            logger.info("\u67e5\u8be2\u51fa\u5165\u5e93\u7ed3\u679c\u5355:{}", (Object)JSON.toJSONString((Object)outResultOrderEos));
            Map<Object, Object> outResultOrderMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)outResultOrderEos)) {
                outResultOrderMap = outResultOrderEos.stream().collect(Collectors.toMap(InOutResultOrderEo::getOrderType, Function.identity(), (k1, k2) -> k1));
            }
            List detailEos = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).list();
            logger.info("\u67e5\u8be2\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u660e\u7ec6:{}", (Object)JSON.toJSONString((Object)detailEos));
            Map<Object, Object> outResultOrderDetailMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)detailEos)) {
                outResultOrderDetailMap = detailEos.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getDocumentNo));
            }
            InOutResultOrderEo outResultOrderEo = (InOutResultOrderEo)outResultOrderMap.get("out");
            logger.info("\u51fa\u5e93\u7ed3\u679c\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)outResultOrderEo));
            if (Objects.nonNull(outResultOrderEo)) {
                outResultOrderDetailEos = (List)outResultOrderDetailMap.get(outResultOrderEo.getDocumentNo());
                logger.info("\u53d1\u8d27\u7ed3\u679c\u5355\u660e\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)outResultOrderDetailEos));
                this.pushTransferResultOrder(outResultOrderEo, outResultOrderDetailEos, transferOrderRespDto);
                num = 0;
                do {
                    outResultOrderEo = (InOutResultOrderEo)this.inOutResultOrderDomain.selectByPrimaryKey(outResultOrderEo.getId());
                    logger.info("\u7b2c\u3010{}\u3011\u6b21\u6839\u636e\u51fa\u5e93\u7ed3\u679c\u5355id\u67e5\u8be2\u51fa\u5e93\u7ed3\u679c\u5355\u4fe1\u606f\uff1a{}", (Object)(num + 1), (Object)JSON.toJSONString((Object)outResultOrderEo));
                    sapNo = outResultOrderEo.getSapNo();
                    Integer n = num;
                    Integer n3 = num = Integer.valueOf(num + 1);
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } while (StringUtils.isBlank((CharSequence)sapNo) && num < 70);
            }
            logger.info("\u51fa\u5e93\u7ed3\u679c\u5355sapNo\uff1a{}", (Object)sapNo);
            outResultOrderEo = (InOutResultOrderEo)outResultOrderMap.get("in");
            logger.info("\u5165\u5e93\u7ed3\u679c\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)outResultOrderEo));
            if (Objects.nonNull(outResultOrderEo)) {
                outResultOrderDetailEos = (List)outResultOrderDetailMap.get(outResultOrderEo.getDocumentNo());
                logger.info("\u5165\u5e93\u7ed3\u679c\u5355\u660e\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)outResultOrderDetailEos));
                this.pushTransferResultOrder(outResultOrderEo, outResultOrderDetailEos, transferOrderRespDto);
            }
        }
        catch (BizException biz) {
            MessageResponse messageResponse;
            try {
                log.error("\u95e8\u5e97\u6a2a\u8c03\u65b0\u589e\u7ed3\u679c\u5355\u548c\u66f4\u65b0\u5e93\u5b58\u65f6\u63a5\u53e3\u5f02\u5e38:{},{}", (Object)biz.getMessage(), (Object)JSON.toJSONString((Object)((Object)biz)));
                messageResponse = MessageResponse.ERROR;
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
            this.lockService.unlock(mutex);
            return messageResponse;
        }
        this.lockService.unlock(mutex);
        return MessageResponse.SUCCESS;
    }

    private void pushTransferResultOrder(InOutResultOrderEo outResultOrderEo, List<InOutResultOrderDetailEo> detailEoList, CsTransferOrderRespDto transferOrderRespDto) {
        String moveType;
        String warehouseCode;
        String tag;
        PushTransferStorageOrderHeadReqDto head = new PushTransferStorageOrderHeadReqDto();
        head.setWarehouseCode(outResultOrderEo.getInLogicWarehouseCode());
        String factoryType = "1220";
        if (Objects.isNull(outResultOrderEo) || CollectionUtils.isEmpty(detailEoList)) {
            logger.info("\u51fa\u5165\u8d27\u5355\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        if (transferOrderRespDto == null) {
            logger.info("\u63a8\u9001\u8c03\u62e8\u51fa\u5165\u5e93\u5355\u8c03\u62e8\u5355\u4e0d\u5b58\u5728,\u8c03\u62e8\u5355\u5355\u53f7\u4e3a" + outResultOrderEo.getRelevanceNo());
            return;
        }
        String sapNo = transferOrderRespDto.getSapNO();
        if (StringUtils.isBlank((CharSequence)sapNo)) {
            logger.info("\u63a8\u9001\u8c03\u62e8\u51fa\u5165\u5e93\u5355sap\u5355\u53f7\u7f3a\u5931,\u8c03\u62e8\u5355\u5355\u53f7\u4e3a" + outResultOrderEo.getRelevanceNo());
            return;
        }
        if ("out".equals(outResultOrderEo.getOrderType())) {
            tag = "PUSH_TRANSFER_OUT_ORDER";
            warehouseCode = outResultOrderEo.getOutLogicWarehouseCode();
            moveType = "Z13";
        } else {
            tag = "PUSH_TRANSFER_IN_ORDER";
            warehouseCode = outResultOrderEo.getInLogicWarehouseCode();
            moveType = "Z15";
        }
        PushTransferStorageOrderReqDto pushTransferStorageOrderReqDto = new PushTransferStorageOrderReqDto();
        head.setId(outResultOrderEo.getId().toString());
        head.setSapNo(sapNo);
        head.setSapMoveType(moveType);
        head.setCreateDate(DateUtil.formatDateTime((Date)new Date()));
        head.setFactoryType(factoryType);
        head.setTransferOrderNo(transferOrderRespDto.getTransferOrderNo());
        head.setRefNo(outResultOrderEo.getDocumentNo());
        ArrayList<PushItemReqDto> itemReqDtoList = new ArrayList<PushItemReqDto>(detailEoList.size());
        for (int i = 0; i < detailEoList.size(); ++i) {
            PushItemReqDto sapItemReqDto = new PushItemReqDto();
            sapItemReqDto.setCode(detailEoList.get(i).getSkuCode());
            sapItemReqDto.setRowNum(String.valueOf(i + 1));
            sapItemReqDto.setNum(detailEoList.get(i).getQuantity().toString());
            sapItemReqDto.setFactoryType(factoryType);
            sapItemReqDto.setWarehouseCode(warehouseCode);
            itemReqDtoList.add(sapItemReqDto);
        }
        pushTransferStorageOrderReqDto.setSapTransferStorageOrderHearReqDto(head);
        pushTransferStorageOrderReqDto.setItemReqDtoList(itemReqDtoList);
        String msg = JSON.toJSONString((Object)pushTransferStorageOrderReqDto);
        logger.info("pushTransferResultOrder\u53d1\u9001\u63a8\u9001\u8c03\u62e8\u51fa\u5165\u5e93\u5355mq\u6d88\u606f:{}", (Object)msg);
        this.commonsMqService.sendDelaySingleMessage("SINGLE_TOPIC", tag, (Object)msg, Long.valueOf(10L));
    }

    private List<SapStorageOrderAddReqDto> getSapStorageOrderAddReqDtos(CsTransferOrderRespDto transferOrderRespDto) {
        SapStorageOrderAddReqDto sapStorageOrderAddReqDto = new SapStorageOrderAddReqDto();
        sapStorageOrderAddReqDto.setRelevanceNo(transferOrderRespDto.getTransferOrderNo());
        sapStorageOrderAddReqDto.setOrderSrcNo(transferOrderRespDto.getPreOrderNo());
        sapStorageOrderAddReqDto.setOutWarehouseCode(transferOrderRespDto.getOutLogicWarehouseCode());
        sapStorageOrderAddReqDto.setInWarehouseCode(transferOrderRespDto.getInLogicWarehouseCode());
        sapStorageOrderAddReqDto.setShippingCompany(transferOrderRespDto.getShipmentEnterpriseCode());
        sapStorageOrderAddReqDto.setRemark(transferOrderRespDto.getRemark());
        sapStorageOrderAddReqDto.setDisplayBusinessType(PcpBasicInventoryBusinessTypeEnum.TRANSFER_STORE_RAISED.getCode());
        sapStorageOrderAddReqDto.setDisplayBusinessName(PcpBasicInventoryBusinessTypeEnum.TRANSFER_STORE_RAISED.getValue());
        sapStorageOrderAddReqDto.setJumpDocumentType(PcpBasicInventoryBusinessTypeEnum.TRANSFER_STORE_RAISED.getGroupCode());
        sapStorageOrderAddReqDto.setJumpDocumentName(PcpBasicInventoryBusinessTypeEnum.TRANSFER_STORE_RAISED.getStatement());
        sapStorageOrderAddReqDto.setShopCode(transferOrderRespDto.getShopCode());
        sapStorageOrderAddReqDto.setShopName(transferOrderRespDto.getShopName());
        List<CsTransferOrderDetailRespDto> detailRespDtos = this.csTransferOrderDetailService.queryListByTransferOrderNo(transferOrderRespDto.getTransferOrderNo());
        logger.info("\u67e5\u8be2\u8c03\u62e8\u5355\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(detailRespDtos));
        List storageOrderExtDetailReqDtos = detailRespDtos.stream().map(e -> {
            StorageOrderExtDetailReqDto detailReqDto = new StorageOrderExtDetailReqDto();
            detailReqDto.setCargoCode(e.getCargoCode());
            detailReqDto.setNum(Long.valueOf(e.getQuantity().longValue()));
            detailReqDto.setPreOrderItemId(e.getId());
            return detailReqDto;
        }).collect(Collectors.toList());
        ArrayList<SapStorageOrderAddReqDto> sapStorageOrderAddReqDtos = new ArrayList<SapStorageOrderAddReqDto>();
        SapStorageOrderAddReqDto inSapStorageOrderAddReqDto = new SapStorageOrderAddReqDto();
        CubeBeanUtils.copyProperties((Object)inSapStorageOrderAddReqDto, (Object)sapStorageOrderAddReqDto, (String[])new String[0]);
        inSapStorageOrderAddReqDto.setCategory("in");
        inSapStorageOrderAddReqDto.setDetailList(storageOrderExtDetailReqDtos);
        sapStorageOrderAddReqDtos.add(inSapStorageOrderAddReqDto);
        SapStorageOrderAddReqDto outSapStorageOrderAddReqDto = new SapStorageOrderAddReqDto();
        CubeBeanUtils.copyProperties((Object)outSapStorageOrderAddReqDto, (Object)sapStorageOrderAddReqDto, (String[])new String[0]);
        outSapStorageOrderAddReqDto.setCategory("out");
        outSapStorageOrderAddReqDto.setDetailList(storageOrderExtDetailReqDtos);
        sapStorageOrderAddReqDtos.add(outSapStorageOrderAddReqDto);
        return sapStorageOrderAddReqDtos;
    }
}

