/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockEntryOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockOutOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.CsBasicsExternalStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.ICsBasicsExternalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.AbstractCsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsReceiveReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsWmsBasicsDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsSaleRefundInDeliveryMessageDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsExternalStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseQualityEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="Csorder_sale_refundBusinessOrderCallBackService")
public class CsOrderSaleRefundCallBackServiceImpl
extends AbstractCsBusinessOrderCallBackService
implements ICsBusinessOrderCallBackService {
    private static Logger logger = LoggerFactory.getLogger(CsOrderSaleRefundCallBackServiceImpl.class);
    private final String COMPLETE = "COMPLETE";
    private final String CANCEL = "CANCEL";
    private final String CLOSE = "CLOSE";
    private final String PART_INBOUND = "PART_INBOUND";
    private final String SEND_BACK = "SEND_BACK";
    private final String SEND_CANCEL = "SEND_CANCEL";
    @Resource
    private ICommonsMqService mqService;

    @Override
    public String getStrategy() {
        return this.getPrefix() + "order_sale_refund";
    }

    @Override
    public Boolean deliveryReceiveNoticeOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    @Override
    public Boolean inOutNoticeOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        Boolean sendWms = callBackContext.getSendWms();
        if (!sendWms.booleanValue()) {
            CsBasicsOrderReqDto csBasicsOrderReqDto = callBackContext.getCsBasicsOrderReqDto();
            String physicWarehouseCode = StringUtils.isNotBlank((CharSequence)csBasicsOrderReqDto.getPhysicsWarehouseCode()) ? csBasicsOrderReqDto.getPhysicsWarehouseCode() : csBasicsOrderReqDto.getInPhysicsWarehouseCode();
            this.generateWmsInCallbackOrder(callBackContext, physicWarehouseCode);
        }
        return null;
    }

    @Override
    public Boolean sendWms(InOutNoticeOrderEo outNoticeOrderEo) {
        String logicWarehouseCode = "";
        String physicsWarehouseCode = "";
        if ("out".equals(outNoticeOrderEo.getOrderType())) {
            logicWarehouseCode = outNoticeOrderEo.getOutLogicWarehouseCode();
            physicsWarehouseCode = outNoticeOrderEo.getOutPhysicsWarehouseCode();
        } else {
            logicWarehouseCode = outNoticeOrderEo.getInLogicWarehouseCode();
            physicsWarehouseCode = outNoticeOrderEo.getInPhysicsWarehouseCode();
        }
        List csLogicWarehouseEoList = this.logicWarehouseDomain.queryByCodes((List)Lists.newArrayList((Object[])new String[]{logicWarehouseCode}));
        LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)csLogicWarehouseEoList.get(0);
        if (CsLogicWarehouseQualityEnum.SCRAP.getCode().equals(csLogicWarehouseEo.getWarehouseQuality())) {
            return false;
        }
        if (YesNoEnum.YES.getValue().equals(csLogicWarehouseEo.getIsVirtual())) {
            return false;
        }
        List physicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(physicsWarehouseCode);
        AssertUtils.notEmpty((Collection)physicsWarehouseEos, (String)"\u51fa\u5e93\u7269\u7406\u4ed3\u67e5\u8be2\u4e0d\u5b58\u5728");
        PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)physicsWarehouseEos.get(0);
        if (YesNoHelper.isYes((Integer)physicsWarehouseEo.getIsLogistics())) {
            return false;
        }
        return true;
    }

    @Override
    public void getContactsInfo(WmsStockOutOrderReqDto dto) {
    }

    @Override
    public void getContactsInfo(WmsStockEntryOrderReqDto dto) {
    }

    @Override
    public void closeOrderStatus(String relevanceNo) {
    }

    private InOutNoticeOrderEo getInOutNoticeOrderEo(String relevanceNo) {
        List InOutNoticeOrderEos = this.inOutNoticeOrderDomain.queryByRelevanceNo(relevanceNo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)InOutNoticeOrderEos), "\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u5355\u636e\u4fe1\u606f");
        InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)InOutNoticeOrderEos.get(0);
        return outNoticeOrderEo;
    }

    private void generateWmsInCallbackOrder(CsOrderBusinessCallBackContext callBackContext, String physicWarehouseCode) {
        logger.info("generateWmsInCallbackOrder==>\u9000\u8d27\u4ed3\u4ed3\u5e93\u54c1\u8d28\u4e3a[\u62a5\u5e9f]\u65f6\uff0c\u4e0d\u63a8\u9001wms\u6536\u8d27,\u6a21\u62dfWMS\u56de\u8c03\u751f\u6210\u5165\u5e93\u7ed3\u679c\u5355");
        ICsBasicsExternalService wmsExternalService = CsBasicsExternalStrategyUtils.getBasicsOrderOperateService(CsBasicsExternalStrategyEnum.WMS.getCode());
        CsBasicsOrderReqDto basics = callBackContext.getCsBasicsOrderReqDto();
        CsBasicsReceiveReqDto csBasicsReceiveReqDto = new CsBasicsReceiveReqDto();
        List sourceDetail = basics.getOrderBasicsDetailReqDtoList();
        csBasicsReceiveReqDto.setPlatformOrderNo("-1");
        csBasicsReceiveReqDto.setInOutNoticeOrderNo(basics.getDocumentNo());
        csBasicsReceiveReqDto.setInOutTime(new Date());
        csBasicsReceiveReqDto.setWmsOrderNo(IdUtils.getId() + "");
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (CsBasicsOrderDetailReqDto detailReqDto : sourceDetail) {
            CsWmsBasicsDetailReqDto inSendBackDetailReqDto = new CsWmsBasicsDetailReqDto();
            inSendBackDetailReqDto.setBatch(detailReqDto.getBatch());
            inSendBackDetailReqDto.setQuantity(detailReqDto.getQuantity());
            inSendBackDetailReqDto.setSkuCode(detailReqDto.getLongCode());
            inSendBackDetailReqDto.setWarehouseCode(physicWarehouseCode);
            inSendBackDetailReqDto.setExpireTime(detailReqDto.getExpireTime());
            inSendBackDetailReqDto.setProduceTime(detailReqDto.getProduceTime());
            detailReqDtoList.add(inSendBackDetailReqDto);
        }
        csBasicsReceiveReqDto.setDetailReqDtoList((List)detailReqDtoList);
        wmsExternalService.receiveIn(csBasicsReceiveReqDto);
    }

    @Override
    public Boolean inOutResultOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return true;
    }

    private void operateInventory(CsOrderBusinessCallBackContext callBackContext) {
        String outResultNo = callBackContext.getInResultOrderNo();
        QueryWrapper csOutResultOrderEoQueryWrapper = new QueryWrapper();
        csOutResultOrderEoQueryWrapper.eq((Object)"document_no", (Object)outResultNo);
        csOutResultOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutResultOrderEo csOutResultOrderEo = (InOutResultOrderEo)this.inOutResultOrderDomain.getMapper().selectOne((Wrapper)csOutResultOrderEoQueryWrapper);
        AssertUtil.isTrue(null != csOutResultOrderEo, "\u67e5\u8be2\u4e0d\u5230\u5165\u5e93\u7ed3\u679c\u5355\u4fe1\u606f");
        QueryWrapper csOutResultOrderDetailEoQueryWrapper = new QueryWrapper();
        csOutResultOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)outResultNo);
        csOutResultOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List csOutResultOrderDetailEoList = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)csOutResultOrderDetailEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csOutResultOrderDetailEoList), "\u67e5\u8be2\u4e0d\u5230\u5165\u5e93\u7ed3\u679c\u5355\u660e\u7ec6\u4fe1\u606f");
        this.updateLogicInventory(callBackContext, csOutResultOrderEo, csOutResultOrderDetailEoList);
        this.updatePhysicsInventory(callBackContext, csOutResultOrderEo, csOutResultOrderDetailEoList);
    }

    private void updatePhysicsInventory(CsOrderBusinessCallBackContext callBackContext, InOutResultOrderEo csOutResultOrderEo, List<InOutResultOrderDetailEo> csOutResultOrderDetailEoList) {
    }

    private void updateLogicInventory(CsOrderBusinessCallBackContext callBackContext, InOutResultOrderEo csOutResultOrderEo, List<InOutResultOrderDetailEo> csOutResultOrderDetailEoList) {
    }

    @Override
    public Boolean deliveryReceiveResultOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("deliveryReceiveResultOrderCallBack==>WMS\u53d6\u6d88\u56de\u4f20,callBackContext:{}", (Object)LogUtils.buildLogContent(callBackContext));
        Boolean inFlag = callBackContext.getInFlag();
        if (inFlag.booleanValue()) {
            String relevanceNo = callBackContext.getRelevanceNo();
            List noticeOrderDetailEoList = callBackContext.getInOutResultOrderDetailEos();
            String sendStatus = callBackContext.getPortionFlag() != false ? "PART_INBOUND" : "COMPLETE";
            BigDecimal currentInQuantity = BigDecimal.ZERO;
            if (sendStatus.equals("COMPLETE")) {
                List inOutResultOrderEos = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderEo.class).eq(InOutResultOrderEo::getRelevanceNo, (Object)relevanceNo)).eq(InOutResultOrderEo::getOrderType, (Object)"in")).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
                logger.info("deliveryReceiveResultOrderCallBack==>\u67e5\u8be2\u5df2\u5165\u5e93\u6570\u636e,inOutResultOrderEos:{}", (Object)LogUtils.buildLogContent(inOutResultOrderEos));
                if (CollectionUtils.isNotEmpty((Collection)inOutResultOrderEos)) {
                    currentInQuantity = inOutResultOrderEos.stream().map(InOutResultOrderEo::getTotalQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
            } else {
                currentInQuantity = noticeOrderDetailEoList.stream().map(InOutResultOrderDetailEo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            CsSaleRefundInDeliveryMessageDto saleRefundInDeliveryMessageDto = new CsSaleRefundInDeliveryMessageDto();
            saleRefundInDeliveryMessageDto.setOrderNo(relevanceNo);
            saleRefundInDeliveryMessageDto.setTypeFlag("SEND_BACK");
            saleRefundInDeliveryMessageDto.setStatus(sendStatus);
            saleRefundInDeliveryMessageDto.setTotalQuantity(currentInQuantity);
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)saleRefundInDeliveryMessageDto);
            logger.info("inCancel==>\u9500\u552e\u9000WMS\u53d1\u8d77\u53d6\u6d88\u901a\u77e5\u4ea4\u6613\u4e2d\u5fc3,messageVo:{}", (Object)LogUtils.buildLogContent(messageVo));
            this.mqService.sendSingleMessage("ORDER_SALE_REFUND_WMS_SEND_BACK_TAG", (Object)messageVo);
        }
        return true;
    }

    @Override
    public Boolean relieveOverchargeCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    @Override
    public Boolean overchargeAdjustCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    @Override
    public Boolean wmsCancel(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("wmsCancel==>WMS\u53d6\u6d88\u56de\u4f20,callBackContext:{}", (Object)LogUtils.buildLogContent(callBackContext));
        Boolean inFlag = callBackContext.getInFlag();
        if (inFlag.booleanValue()) {
            this.inCancel(callBackContext);
        } else {
            this.outCancel(callBackContext);
        }
        return true;
    }

    private void inCancel(CsOrderBusinessCallBackContext callBackContext) {
        String relevanceNo = callBackContext.getRelevanceNo();
        String sendStatus = "";
        Boolean sendFlag = true;
        QueryWrapper InOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        InOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)relevanceNo);
        List InOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)InOutNoticeOrderEoQueryWrapper);
        int totalSize = InOutNoticeOrderEoList.size();
        int cancelSize = InOutNoticeOrderEoList.stream().filter(eo -> BaseOrderStatusEnum.INO_CANCEL.getCode().equals(eo.getOrderStatus())).collect(Collectors.toList()).size();
        int inSize = InOutNoticeOrderEoList.stream().filter(eo -> BaseOrderStatusEnum.INO_TOTAL_IN.getCode().equals(eo.getOrderStatus()) || BaseOrderStatusEnum.INO_PORTION_IN.getCode().equals(eo.getOrderStatus())).collect(Collectors.toList()).size();
        int waitInSize = InOutNoticeOrderEoList.stream().filter(eo -> BaseOrderStatusEnum.INO_WAIT_IN.getCode().equals(eo.getOrderStatus())).collect(Collectors.toList()).size();
        logger.info("inCancel==>totalSize:{},cancelSize:{},inSize:{}", new Object[]{totalSize, cancelSize, inSize});
        if (inSize == 0) {
            if (totalSize == cancelSize) {
                sendStatus = "CANCEL";
            } else {
                sendFlag = false;
            }
        } else if (cancelSize >= 1) {
            if (waitInSize >= 1) {
                sendFlag = false;
            } else {
                sendStatus = "CLOSE";
            }
        } else if (cancelSize >= 1 && waitInSize >= 1) {
            sendStatus = "PART_INBOUND";
        } else if (waitInSize >= 1) {
            sendFlag = false;
        } else {
            sendStatus = "COMPLETE";
        }
        logger.info("inCancel==>sendFlag:{},sendStatus:{}", (Object)sendFlag, (Object)sendStatus);
        if (!sendFlag.booleanValue()) {
            return;
        }
        CsSaleRefundInDeliveryMessageDto saleRefundInDeliveryMessageDto = new CsSaleRefundInDeliveryMessageDto();
        saleRefundInDeliveryMessageDto.setOrderNo(relevanceNo);
        saleRefundInDeliveryMessageDto.setTypeFlag("SEND_CANCEL");
        saleRefundInDeliveryMessageDto.setStatus(sendStatus);
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)saleRefundInDeliveryMessageDto);
        logger.info("inCancel==>\u9500\u552e\u9000WMS\u53d1\u8d77\u53d6\u6d88\u901a\u77e5\u4ea4\u6613\u4e2d\u5fc3,messageVo:{}", (Object)LogUtils.buildLogContent(messageVo));
        this.mqService.sendSingleMessage("ORDER_SALE_REFUND_WMS_SEND_BACK_TAG", (Object)messageVo);
    }

    private void outCancel(CsOrderBusinessCallBackContext callBackContext) {
    }
}

