/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.difforder;

import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.difforder.IDiffOrderOptAble;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.difforder.IDiffOrderOptCallBack;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class DiffOrderOptContext
implements ApplicationContextAware {
    public static final String DEFAULT_CODE = "default";
    private static final Map<String, IDiffOrderOptAble> DIFF_ORDER_OPT_MAP = Maps.newHashMap();
    private static final Map<String, IDiffOrderOptCallBack> DIFF_ORDER_OPT_CALLBACK_MAP = Maps.newHashMap();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        applicationContext.getBeansOfType(IDiffOrderOptAble.class).values().forEach(opt -> DIFF_ORDER_OPT_MAP.put(opt.getTransferType(), (IDiffOrderOptAble)opt));
        applicationContext.getBeansOfType(IDiffOrderOptCallBack.class).values().forEach(opt -> DIFF_ORDER_OPT_CALLBACK_MAP.put(opt.getCode(), (IDiffOrderOptCallBack)opt));
    }

    public static IDiffOrderOptCallBack getCurCallBack(String code) {
        return Optional.ofNullable(code).filter(StringUtils::isNotBlank).map(DIFF_ORDER_OPT_CALLBACK_MAP::get).orElse(DIFF_ORDER_OPT_CALLBACK_MAP.get(DEFAULT_CODE));
    }

    public static IDiffOrderOptAble getDiffOrderOptAble(String code) {
        return Optional.ofNullable(code).filter(StringUtils::isNotBlank).map(DIFF_ORDER_OPT_MAP::get).orElse(DIFF_ORDER_OPT_MAP.get(DEFAULT_CODE));
    }
}

