/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.ICsRelWarehouseShipmentQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.other.ICsRelWarehouseShipmentQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsRelWarehouseShipmentEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsRelWarehouseShipmentPageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsRelWarehouseShipmentParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsRelWarehouseShipmentDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsRelWarehouseShipmentPageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsRelWarehouseShipmentParticularsRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsRelWarehouseShipmentRespDto;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CsRelWarehouseShipmentQueryApiImpl
implements ICsRelWarehouseShipmentQueryApi {
    protected static Logger logger = LoggerFactory.getLogger(CsRelWarehouseShipmentQueryApiImpl.class);
    @Autowired
    protected ICsRelWarehouseShipmentQueryService csRelWarehouseShipmentQueryService;

    public RestResponse<CsRelWarehouseShipmentRespDto> queryByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        CsRelWarehouseShipmentEo eo = this.csRelWarehouseShipmentQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, CsInventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        CsRelWarehouseShipmentRespDto dto = new CsRelWarehouseShipmentRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)eo, (String[])new String[0]);
        return new RestResponse((Object)dto);
    }

    public RestResponse<CsRelWarehouseShipmentParticularsRespDto> queryByWarehouseCode(String warehouseCode) {
        CsRelWarehouseShipmentParticularsRespDto relWarehouseShipmentPageRespDto = this.csRelWarehouseShipmentQueryService.queryByWarehouseCode(warehouseCode);
        return new RestResponse((Object)relWarehouseShipmentPageRespDto);
    }

    public RestResponse<PageInfo<CsRelWarehouseShipmentPageRespDto>> queryPage(CsRelWarehouseShipmentPageQueryDto relWarehouseShipmentPageQueryDto) {
        PageInfo<CsRelWarehouseShipmentPageRespDto> pageInfo = this.csRelWarehouseShipmentQueryService.queryPage(relWarehouseShipmentPageQueryDto);
        return new RestResponse(pageInfo);
    }

    public RestResponse<List<CsRelWarehouseShipmentPageRespDto>> queryRelInfoList(CsRelWarehouseShipmentPageQueryDto relWarehouseShipmentPageQueryDto) {
        List<CsRelWarehouseShipmentPageRespDto> resultList = this.csRelWarehouseShipmentQueryService.queryRelInfoList(relWarehouseShipmentPageQueryDto);
        return new RestResponse(resultList);
    }

    public RestResponse<List<CsRelWarehouseShipmentRespDto>> queryByParam(CsRelWarehouseShipmentParamQueryDto relWarehouseShipmentParamQueryDto) {
        List<CsRelWarehouseShipmentRespDto> relWarehouseShipmentRespDtoList = this.csRelWarehouseShipmentQueryService.queryByParam(relWarehouseShipmentParamQueryDto);
        return new RestResponse(relWarehouseShipmentRespDtoList);
    }

    public RestResponse<CsRelWarehouseShipmentDetailRespDto> queryHighestPriorityByWarehouseCode(String warehouseCode) {
        CsRelWarehouseShipmentDetailRespDto relWarehouseShipmentDetailRespDto = this.csRelWarehouseShipmentQueryService.queryHighestPriorityByWarehouseCode(warehouseCode);
        return new RestResponse((Object)relWarehouseShipmentDetailRespDto);
    }
}

