/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.inventory;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.ICsLogicInventoryBalanceService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsLogicInventoryBalanceDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsLogicInventoryBalanceEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.cs.basics.CsInventoryBasicConstant;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryBalanceQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryBalanceReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryBalanceRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CsLogicInventoryBalanceServiceImpl
implements ICsLogicInventoryBalanceService {
    private static Logger logger = LoggerFactory.getLogger(CsLogicInventoryBalanceServiceImpl.class);
    @Resource
    private CsLogicInventoryBalanceDas csLogicInventoryBalanceDas;
    @Resource
    ILogicInventoryDomain logicInventoryDomain;
    @Resource
    private ILockService lockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logicInventoryBalanceSync() {
        Mutex mutex;
        block7: {
            mutex = null;
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String date = dateFormat.format(new Date());
                mutex = this.lockService.lock("LOGIC_INVENTORY_BALANCE_LOCK", date, 10, 20, TimeUnit.SECONDS);
                if (null == mutex) {
                    throw new BizException("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25~");
                }
                Integer pageSize = CsInventoryBasicConstant.DEFAULT_PAGE_SIZE;
                Integer pageNum = CsInventoryBasicConstant.DEFAULT_PAGE_NUM;
                List balanceEoList = ((ExtQueryChainWrapper)this.csLogicInventoryBalanceDas.filter().eq((Object)"balance_date", (Object)date)).list();
                if (CollectionUtils.isEmpty((Collection)balanceEoList)) {
                    PageInfo page;
                    ArrayList<CsLogicInventoryBalanceEo> csLogicInventoryBalanceEoList = new ArrayList<CsLogicInventoryBalanceEo>();
                    do {
                        ExtQueryChainWrapper filter = this.logicInventoryDomain.filter();
                        page = filter.select(new String[0]).page(pageNum, pageSize);
                        List csLogicInventoryEoList = page.getList();
                        ArrayList<CsLogicInventoryBalanceEo> csLogicInventoryBalanceEos = new ArrayList<CsLogicInventoryBalanceEo>();
                        if (CollectionUtils.isNotEmpty((Collection)csLogicInventoryEoList)) {
                            this.transformationBalanceList(csLogicInventoryBalanceEos, csLogicInventoryEoList);
                            csLogicInventoryBalanceEoList.addAll(csLogicInventoryBalanceEos);
                        }
                        Integer n = pageNum;
                        Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
                    } while (pageNum <= page.getPages());
                    if (CollectionUtils.isNotEmpty(csLogicInventoryBalanceEoList)) {
                        csLogicInventoryBalanceEoList.forEach(balance -> balance.setBalanceDate(date));
                        this.csLogicInventoryBalanceDas.insertBatch(csLogicInventoryBalanceEoList);
                        logger.info("\u5f53\u524d\u65e5\u671f\uff1a{},\u6279\u91cf\u65b0\u589e\u5f53\u524d\u65e5\u671f\u903b\u8f91\u5e93\u5b58\u7ed3\u5b58\u5b8c\u6bd5", (Object)date);
                    }
                    break block7;
                }
                logger.info("\u5f53\u524d\u65e5\u671f\uff1a{},\u903b\u8f91\u5e93\u5b58\u7ed3\u5b58\u5df2\u5b58\u5728\uff01");
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
    }

    public void transformationBalanceList(List<CsLogicInventoryBalanceEo> csLogicInventoryBalanceEoList, List<LogicInventoryEo> csLogicInventoryEoList) {
        CubeBeanUtils.copyCollection(csLogicInventoryBalanceEoList, csLogicInventoryEoList, CsLogicInventoryBalanceEo.class);
        csLogicInventoryBalanceEoList.forEach(logicBalance -> {
            logicBalance.setId(null);
            logicBalance.setCreateTime(null);
            logicBalance.setUpdateTime(null);
        });
    }

    @Override
    public Long addCsLogicInventoryBalance(CsLogicInventoryBalanceReqDto addReqDto) {
        CsLogicInventoryBalanceEo csLogicInventoryBalanceEo = new CsLogicInventoryBalanceEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)csLogicInventoryBalanceEo);
        this.csLogicInventoryBalanceDas.insert((BaseEo)csLogicInventoryBalanceEo);
        return csLogicInventoryBalanceEo.getId();
    }

    @Override
    public void modifyCsLogicInventoryBalance(CsLogicInventoryBalanceReqDto modifyReqDto) {
        CsLogicInventoryBalanceEo csLogicInventoryBalanceEo = new CsLogicInventoryBalanceEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)csLogicInventoryBalanceEo);
        this.csLogicInventoryBalanceDas.updateSelective((BaseEo)csLogicInventoryBalanceEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCsLogicInventoryBalance(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.csLogicInventoryBalanceDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CsLogicInventoryBalanceRespDto queryById(Long id) {
        CsLogicInventoryBalanceEo csLogicInventoryBalanceEo = (CsLogicInventoryBalanceEo)this.csLogicInventoryBalanceDas.selectByPrimaryKey(id);
        CsLogicInventoryBalanceRespDto csLogicInventoryBalanceRespDto = new CsLogicInventoryBalanceRespDto();
        DtoHelper.eo2Dto((BaseEo)csLogicInventoryBalanceEo, (BaseVo)csLogicInventoryBalanceRespDto);
        return csLogicInventoryBalanceRespDto;
    }

    @Override
    public PageInfo<CsLogicInventoryBalanceRespDto> queryByPage(CsLogicInventoryBalanceQueryDto logicInventoryBalanceQueryDto) {
        logger.info("\u83b7\u53d6\u7269\u7406\u4ed3\u5e93\u5e93\u5b58\u7ed3\u5b58-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)logicInventoryBalanceQueryDto));
        Integer pageNum = logicInventoryBalanceQueryDto.getPageNum();
        Integer pageSize = logicInventoryBalanceQueryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        ExtQueryChainWrapper<CsLogicInventoryBalanceEo> param = this.assembleCondition(logicInventoryBalanceQueryDto);
        PageInfo page = param.select(new String[0]).page(pageNum, pageSize);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)page, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)page.getList(), dtoList, CsLogicInventoryBalanceRespDto.class);
        pageInfo.setList(dtoList);
        return pageInfo;
    }

    public ExtQueryChainWrapper<CsLogicInventoryBalanceEo> assembleCondition(CsLogicInventoryBalanceQueryDto logicInventoryBalanceQueryDto) {
        ExtQueryChainWrapper filter = this.csLogicInventoryBalanceDas.filter();
        if (CollectionUtils.isNotEmpty((Collection)logicInventoryBalanceQueryDto.getIds())) {
            filter.in((Object)"id", (Collection)logicInventoryBalanceQueryDto.getIds());
        } else {
            if (StringUtils.isNotBlank((CharSequence)logicInventoryBalanceQueryDto.getBalanceDate())) {
                filter.eq((Object)"balance_date", (Object)logicInventoryBalanceQueryDto.getBalanceDate());
            }
            if (StringUtils.isNotBlank((CharSequence)logicInventoryBalanceQueryDto.getWarehouseCode())) {
                filter.eq((Object)"warehouse_code", (Object)logicInventoryBalanceQueryDto.getWarehouseCode());
            }
            if (StringUtils.isNotBlank((CharSequence)logicInventoryBalanceQueryDto.getWarehouseName())) {
                filter.eq((Object)"warehouse_name", (Object)logicInventoryBalanceQueryDto.getWarehouseName());
            }
            if (StringUtils.isNotBlank((CharSequence)logicInventoryBalanceQueryDto.getBatch())) {
                filter.like((Object)"batch", (Object)logicInventoryBalanceQueryDto.getBatch());
            }
            if (StringUtils.isNotBlank((CharSequence)logicInventoryBalanceQueryDto.getCargoCode())) {
                filter.eq((Object)"cargo_code", (Object)logicInventoryBalanceQueryDto.getCargoCode());
            }
            if (StringUtils.isNotBlank((CharSequence)logicInventoryBalanceQueryDto.getCargoName())) {
                filter.like((Object)"cargo_name", (Object)logicInventoryBalanceQueryDto.getCargoName());
            }
            if (StringUtils.isNotBlank((CharSequence)logicInventoryBalanceQueryDto.getLongCode())) {
                filter.like((Object)"long_code", (Object)logicInventoryBalanceQueryDto.getLongCode());
            }
            if (CollectionUtils.isNotEmpty((Collection)logicInventoryBalanceQueryDto.getFilterLongCodes())) {
                filter.in((Object)"long_code", (Collection)logicInventoryBalanceQueryDto.getFilterLongCodes());
            }
        }
        ((ExtQueryChainWrapper)filter.orderByDesc((Object)logicInventoryBalanceQueryDto.getOrderByDesc())).orderByDesc((Object)"id");
        return filter;
    }
}

