/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsWarehouseAddressQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsWarehouseAddressParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsWarehouseAddressRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csWarehouseAddressQueryService")
public class CsWarehouseAddressQueryServiceImpl
implements ICsWarehouseAddressQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsWarehouseAddressQueryServiceImpl.class);
    @Autowired
    IWarehouseAddressDomain warehouseAddressDomain;

    @Override
    public WarehouseAddressEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        return (WarehouseAddressEo)this.warehouseAddressDomain.selectByPrimaryKey(id);
    }

    @Override
    public WarehouseAddressEo selectByWarehouseId(Long warehouseId) {
        logger.info("\u6839\u636e\u4ed3\u5e93ID\u67e5\u8be2\uff1a[warehouseId:{}]", (Object)warehouseId);
        AssertUtil.isTrue(warehouseId != null && warehouseId > 0L, "\u4ed3\u5e93ID\u53c2\u6570\u6709\u8bef");
        WarehouseAddressEo csWarehouseAddressEo = new WarehouseAddressEo();
        csWarehouseAddressEo.setWarehouseId(warehouseId);
        List csWarehouseAddressEoList = this.warehouseAddressDomain.selectList((BaseEo)csWarehouseAddressEo);
        if (CollectionUtils.isEmpty((Collection)csWarehouseAddressEoList)) {
            return null;
        }
        return (WarehouseAddressEo)csWarehouseAddressEoList.get(0);
    }

    @Override
    public PageInfo<CsWarehouseAddressRespDto> queryPageInfo(CsWarehouseAddressParamQueryDto csPhysicsWarehousePageQueryDto) {
        String warehouseClassify;
        List warehouseIdList;
        logger.info("queryPageInfo==>\u4ed3\u5e93\u5730\u5740\u4fe1\u606f\u5206\u9875\u67e5\u8be2\uff0ccsPhysicsWarehousePageQueryDto:{}", (Object)LogUtils.buildLogContent(csPhysicsWarehousePageQueryDto));
        AssertUtil.isTrue(null != csPhysicsWarehousePageQueryDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != csPhysicsWarehousePageQueryDto.getPageNum() && csPhysicsWarehousePageQueryDto.getPageNum() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != csPhysicsWarehousePageQueryDto.getPageSize() && csPhysicsWarehousePageQueryDto.getPageSize() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        QueryWrapper csWarehouseAddressEoQueryWrapper = new QueryWrapper();
        List warehouseCodeList = csPhysicsWarehousePageQueryDto.getWarehouseCodeList();
        if (CollectionUtils.isNotEmpty((Collection)warehouseCodeList)) {
            csWarehouseAddressEoQueryWrapper.in((Object)"warehouse_code", (Collection)warehouseCodeList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(warehouseIdList = csPhysicsWarehousePageQueryDto.getWarehouseIdList()))) {
            csWarehouseAddressEoQueryWrapper.in((Object)"warehouse_id", (Collection)warehouseIdList);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseClassify = csPhysicsWarehousePageQueryDto.getWarehouseClassify()))) {
            csWarehouseAddressEoQueryWrapper.eq((Object)"warehouse_classify", (Object)warehouseClassify);
        }
        if (StringUtils.isNotBlank((CharSequence)csPhysicsWarehousePageQueryDto.getWarehouseCode())) {
            csWarehouseAddressEoQueryWrapper.eq((Object)"warehouse_code", (Object)csPhysicsWarehousePageQueryDto.getWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)csPhysicsWarehousePageQueryDto.getValidFlag())) {
            csWarehouseAddressEoQueryWrapper.eq((Object)"valid_flag", (Object)csPhysicsWarehousePageQueryDto.getValidFlag());
        }
        csWarehouseAddressEoQueryWrapper.orderByDesc((Object)"create_time");
        PageHelper.startPage((int)csPhysicsWarehousePageQueryDto.getPageNum(), (int)csPhysicsWarehousePageQueryDto.getPageSize());
        List csWarehouseAddressEoList = this.warehouseAddressDomain.getMapper().selectList((Wrapper)csWarehouseAddressEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csWarehouseAddressEoList)) {
            return new PageInfo();
        }
        List respDtoList = csWarehouseAddressEoList.stream().map(e -> {
            CsWarehouseAddressRespDto csWarehouseAddressRespDto = new CsWarehouseAddressRespDto();
            CubeBeanUtils.copyProperties((Object)csWarehouseAddressRespDto, (Object)e, (String[])new String[0]);
            return csWarehouseAddressRespDto;
        }).collect(Collectors.toList());
        PageInfo info = new PageInfo(csWarehouseAddressEoList);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList(respDtoList);
        return result;
    }

    @Override
    public List<CsWarehouseAddressRespDto> queryParam(CsWarehouseAddressParamQueryDto csWarehouseAddressParamQueryDto) {
        List csWarehouseAddressEoList;
        String warehouseClassify;
        logger.info("queryParam==>\u903b\u8f91\u4ed3\u5730\u5740\u4fe1\u606f\u6839\u636e\u53c2\u6570\u67e5\u8be2,csWarehouseAddressParamQueryDto:{}", (Object)LogUtils.buildLogContent(csWarehouseAddressParamQueryDto));
        AssertUtil.isTrue(null != csWarehouseAddressParamQueryDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper csWarehouseAddressEoQueryWrapper = new QueryWrapper();
        csWarehouseAddressEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csWarehouseAddressEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        List warehouseCodeList = csWarehouseAddressParamQueryDto.getWarehouseCodeList();
        if (CollectionUtils.isNotEmpty((Collection)warehouseCodeList)) {
            csWarehouseAddressEoQueryWrapper.in((Object)"warehouse_code", (Collection)warehouseCodeList);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseClassify = csWarehouseAddressParamQueryDto.getWarehouseClassify()))) {
            csWarehouseAddressEoQueryWrapper.eq((Object)"warehouse_classify", (Object)warehouseClassify);
        }
        if (StringUtils.isNotBlank((CharSequence)csWarehouseAddressParamQueryDto.getWarehouseCode())) {
            csWarehouseAddressEoQueryWrapper.eq((Object)"warehouse_code", (Object)csWarehouseAddressParamQueryDto.getWarehouseCode());
        }
        if (CollectionUtils.isEmpty((Collection)(csWarehouseAddressEoList = this.warehouseAddressDomain.getMapper().selectList((Wrapper)csWarehouseAddressEoQueryWrapper)))) {
            return Lists.newArrayList();
        }
        ArrayList warehouseAddressRespDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)warehouseAddressRespDtoList, (Collection)csWarehouseAddressEoList, CsWarehouseAddressRespDto.class);
        return warehouseAddressRespDtoList;
    }
}

