/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.inventory.CommonOrderService;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsStorageSendMqReqDto;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="SINGLE_TOPIC", tag="CREATE_OUT_IN_NOTICE_ORDER_TAG")
public class CreateOutInNoticeOrderProcess
implements IMessageProcessor<String> {
    @Resource
    private CommonOrderService csCommonOrder;
    @Resource
    private ILockService lockService;
    private static final Logger logger = LoggerFactory.getLogger(CreateOutInNoticeOrderProcess.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageResponse process(String message) {
        Mutex lock;
        block8: {
            MessageResponse messageResponse;
            block7: {
                logger.info("CreateOutInNoticeOrderProcess\uff1a{}", (Object)message);
                lock = null;
                try {
                    CsStorageSendMqReqDto csStorageSendMqReqDto = (CsStorageSendMqReqDto)JSON.parseObject((String)message, CsStorageSendMqReqDto.class);
                    String cacheKey = "mq_out_in_notice#" + csStorageSendMqReqDto.getPreDocumentNo();
                    lock = this.lockService.lock(cacheKey, "1", 20);
                    boolean success = this.csCommonOrder.createOutInNoticeOrder(csStorageSendMqReqDto);
                    if (!success) {
                        messageResponse = MessageResponse.ERROR;
                        if (lock == null) return messageResponse;
                        break block7;
                    }
                    if (lock == null) return MessageResponse.SUCCESS;
                    break block8;
                }
                catch (Exception e) {
                    logger.info("\u6d88\u606f\u961f\u5217\u521b\u5efa\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a{}\uff0ce\uff1a{}", (Object)e.getMessage(), (Object)e);
                    MessageResponse messageResponse2 = MessageResponse.ERROR;
                    return messageResponse2;
                }
            }
            this.lockService.unlock(lock);
            return messageResponse;
        }
        this.lockService.unlock(lock);
        return MessageResponse.SUCCESS;
        finally {
            if (lock != null) {
                this.lockService.unlock(lock);
            }
        }
    }
}

