/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.inventory;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.OrderInformMqService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.inventory.CsCommonOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.IMqMessageService;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsStorageSendMqReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.MqMessageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.MqMessageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.MqMessageEnum;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CommonOrderService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IMqMessageService mqMessageService;
    @Resource
    private OrderInformMqService orderInformMqService;
    @Resource
    private CsCommonOrderService csCommonOrderService;

    public void insertLogAndSendMq(CsStorageSendMqReqDto csStorageSendMqReqDto) {
        this.logger.info("\u63a5\u6536\u5230\u63d2\u5165mq\u65e5\u5fd7\u4fe1\u606f\u4e14\u53d1\u9001mq\u4efb\u52a1\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)csStorageSendMqReqDto));
        MqMessageReqDto mqMessageReqDto = new MqMessageReqDto();
        mqMessageReqDto.setType(csStorageSendMqReqDto.getType());
        mqMessageReqDto.setNo(csStorageSendMqReqDto.getBusinessOrderNo());
        mqMessageReqDto.setMessage(JSON.toJSONString((Object)csStorageSendMqReqDto));
        mqMessageReqDto.setStatus(MqMessageEnum.Status.SEND_FAILED.getType());
        Long messageId = this.mqMessageService.addMqMessage(mqMessageReqDto);
        csStorageSendMqReqDto.setMessageId(messageId);
        ExecutorUtils.execute(() -> {
            boolean mqFlag = this.orderInformMqService.sendOutInNoticeReceiveDeliveryMq(csStorageSendMqReqDto);
            if (mqFlag) {
                MqMessageReqDto update = new MqMessageReqDto();
                update.setId(messageId);
                update.setStatus(MqMessageEnum.Status.SEND_SUCCESS.getType());
                this.logger.info("\u53d1\u9001mq\u6210\u529f,\u4fee\u6539\u6d88\u606f\u72b6\u6001,\u53c2\u6570{}", (Object)JSON.toJSONString((Object)update));
                this.mqMessageService.updateMessage(update);
            } else {
                this.logger.info("\u53d1\u9001mq\u4efb\u52a1\u5931\u8d25");
            }
        });
    }

    public boolean createOutInNoticeOrder(CsStorageSendMqReqDto csStorageSendMqReqDto) {
        this.logger.info("\u521b\u5efa\u51fa\u5165\u5e93\u901a\u77e5createOutInNoticeOrder:{}", (Object)JSON.toJSONString((Object)csStorageSendMqReqDto));
        boolean successFlag = true;
        MqMessageRespDto mqMessageRespDto = this.checkMessage(csStorageSendMqReqDto);
        if (mqMessageRespDto != null) {
            MqMessageReqDto mqMessageReqDto = new MqMessageReqDto();
            mqMessageReqDto.setId(csStorageSendMqReqDto.getMessageId());
            try {
                this.logger.info("\u5f00\u59cb\u521b\u5efa\u51fa\u5165\u5e93\u901a\u77e5\u5355");
                this.csCommonOrderService.createOutInNoticeOrder(csStorageSendMqReqDto);
                mqMessageReqDto.setStatus(MqMessageEnum.Status.CREATE_SUCCESS.getType());
            }
            catch (Exception e) {
                successFlag = false;
                this.logger.info("\u521b\u5efa\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5f02\u5e38:{}", (Object)JSON.toJSONString((Object)e));
                mqMessageReqDto.setStatus(MqMessageEnum.Status.CREATE_FAILED.getType());
                mqMessageReqDto.setRemark(e.getMessage());
            }
            this.mqMessageService.updateMessage(mqMessageReqDto);
        }
        return successFlag;
    }

    public boolean createReceiveDeliveryResultOrder(CsStorageSendMqReqDto csStorageSendMqReqDto) {
        this.logger.info("\u521b\u5efa\u6536\u53d1\u8d27\u7ed3\u679c\u5355createReceiveDeliveryResultOrder:{}", (Object)JSON.toJSONString((Object)csStorageSendMqReqDto));
        boolean successFlag = true;
        MqMessageRespDto mqMessageRespDto = this.checkMessage(csStorageSendMqReqDto);
        if (mqMessageRespDto != null) {
            MqMessageReqDto mqMessageReqDto = new MqMessageReqDto();
            mqMessageReqDto.setId(csStorageSendMqReqDto.getMessageId());
            try {
                this.logger.info("\u5f00\u59cb\u521b\u5efa\u6536\u53d1\u8d27\u5e93\u7ed3\u679c\u5355");
                this.csCommonOrderService.createReceiveDeliveryResultOrder(csStorageSendMqReqDto);
                mqMessageReqDto.setStatus(MqMessageEnum.Status.CREATE_SUCCESS.getType());
            }
            catch (Exception e) {
                successFlag = false;
                this.logger.info("\u521b\u5efa\u6536\u53d1\u8d27\u7ed3\u679c\u5355\u5f02\u5e38:{}", (Object)e.getMessage());
                mqMessageReqDto.setStatus(MqMessageEnum.Status.CREATE_FAILED.getType());
                mqMessageReqDto.setRemark(e.getMessage());
            }
            this.mqMessageService.updateMessage(mqMessageReqDto);
        }
        return successFlag;
    }

    private MqMessageRespDto checkMessage(CsStorageSendMqReqDto csStorageSendMqReqDto) {
        MqMessageRespDto mqMessageRespDto = this.mqMessageService.queryById(csStorageSendMqReqDto.getMessageId());
        if (mqMessageRespDto == null) {
            this.logger.info("\u6d88\u606f\u4e0d\u5b58\u5728");
            return null;
        }
        if (MqMessageEnum.Status.CREATE_SUCCESS.getType().equals(mqMessageRespDto.getStatus())) {
            this.logger.info("\u5355\u636e\u5df2\u521b\u5efa\u6210\u529f,\u65e0\u9700\u518d\u6b21\u521b\u5efa");
            return null;
        }
        return mqMessageRespDto;
    }
}

