/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.dto.request.CsBasisOrderBusinessDataReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsBaseOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveredOutResultInfoDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveredOutResultInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsLogisticsDeliveredInfoDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsLogisticsDeliveredInfoRespDto;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasisOrderBusinessDataRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInfoQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csOutResultOrderQueryService")
public class CsOutResultOrderQueryServiceImpl
implements ICsOutResultOrderQueryService {
    private static final Logger logger = LoggerFactory.getLogger(CsOutResultOrderQueryServiceImpl.class);
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    ICsBaseOrderQueryService csBaseOrderQueryService;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;

    @Override
    public InOutResultOrderEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        return Optional.ofNullable(this.inOutResultOrderDomain.selectByPrimaryKey(id)).map(eo -> (InOutResultOrderEo)BeanUtil.copyProperties((Object)eo, InOutResultOrderEo.class, (String[])new String[0])).orElse(null);
    }

    @Override
    public CsOutResultOrderRespDto queryByDocumentNo(String documentNo) {
        String shippingJson;
        CsOutResultOrderRespDto dto = new CsOutResultOrderRespDto();
        QueryWrapper outResultOrderQueryWrapper = new QueryWrapper();
        outResultOrderQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        outResultOrderQueryWrapper.eq((Object)"dr", (Object)0);
        List inOutResultOrderEos = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)outResultOrderQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)inOutResultOrderEos)) {
            return dto;
        }
        InOutResultOrderEo inOutResultOrderEo = (InOutResultOrderEo)inOutResultOrderEos.get(0);
        CubeBeanUtils.copyProperties((Object)dto, (Object)inOutResultOrderEo, (String[])new String[0]);
        dto.setWarehouseCode(inOutResultOrderEo.getOutPhysicsWarehouseCode());
        dto.setWarehouseName(inOutResultOrderEo.getOutPhysicsWarehouseName());
        dto.setInWarehouseCode(inOutResultOrderEo.getInPhysicsWarehouseCode());
        dto.setInWarehouseName(inOutResultOrderEo.getInPhysicsWarehouseName());
        CsBasisOrderBusinessDataReqDto dataReqDto = new CsBasisOrderBusinessDataReqDto();
        CubeBeanUtils.copyProperties((Object)dataReqDto, (Object)dto, (String[])new String[0]);
        CsBasisOrderBusinessDataRespDto dataRespDto = this.csBaseOrderQueryService.outInResultBuildRelOrderInfo(dataReqDto, "delivery", "out");
        if (Objects.nonNull(dataRespDto)) {
            dto.setContactDto(dataRespDto.getContactDto());
            dto.setRelOrderInfoList(dataRespDto.getRelOrderInfoList());
        }
        if (StringUtils.isNotBlank((CharSequence)(shippingJson = dto.getShippingJson()))) {
            try {
                List csWmsShippingInfoReqDtoList = JSON.parseArray((String)shippingJson, CsWmsShippingInfoReqDto.class);
                logger.info("queryVersionSecondByDocumentNo==>\u5355\u53f7:{},\u7269\u6d41\u4fe1\u606f\u96c6\u5408,csWmsShippingInfoReqDtoList:{}", (Object)dto.getDocumentNo(), (Object)LogUtils.buildLogContent(csWmsShippingInfoReqDtoList));
                dto.setShippingInfoList(csWmsShippingInfoReqDtoList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BigDecimal skuNum = this.csBaseOrderQueryService.queryItemMapByOutInResultDocumentNo(dto.getDocumentNo());
        dto.setSkuNum(skuNum);
        if ("out".equals(inOutResultOrderEo.getOrderType())) {
            QueryWrapper inResultOrderQueryWrapper = new QueryWrapper();
            inResultOrderQueryWrapper.eq((Object)"relevance_no", (Object)inOutResultOrderEo.getRelevanceNo());
            inResultOrderQueryWrapper.eq((Object)"dr", (Object)0);
            inResultOrderQueryWrapper.eq((Object)"order_type", (Object)"in");
            List inResultOrderEos = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)inResultOrderQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)inResultOrderEos)) {
                InOutResultOrderEo inResultOrderEo = (InOutResultOrderEo)inResultOrderEos.get(0);
                dto.setInWarehouseCode(inResultOrderEo.getInPhysicsWarehouseCode());
                dto.setInWarehouseName(inResultOrderEo.getInPhysicsWarehouseName());
                dto.setInPhysicsWarehouseCode(inResultOrderEo.getInPhysicsWarehouseCode());
                dto.setInPhysicsWarehouseName(inResultOrderEo.getInPhysicsWarehouseName());
                dto.setInLogicWarehouseCode(inResultOrderEo.getInLogicWarehouseCode());
                dto.setInLogicWarehouseName(inResultOrderEo.getInLogicWarehouseName());
            }
        }
        return dto;
    }

    @Override
    public CsOutResultOrderRespDto queryByDocumentNo2(String documentNo) {
        CsOutResultOrderRespDto dto = new CsOutResultOrderRespDto();
        List InOutResultOrderEos = this.inOutResultOrderDomain.queryByDocumentNo(documentNo);
        if (CollectionUtils.isEmpty((Collection)InOutResultOrderEos)) {
            return dto;
        }
        InOutResultOrderEo InOutResultOrderEo2 = (InOutResultOrderEo)InOutResultOrderEos.get(0);
        List detailEoList = this.inOutResultOrderDetailDomain.queryByDocumentNo(documentNo);
        CubeBeanUtils.copyProperties((Object)dto, (Object)InOutResultOrderEo2, (String[])new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)detailEoList)) {
            ArrayList detailRespDtoList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)detailRespDtoList, (Collection)detailEoList, CsOutResultOrderDetailRespDto.class);
            dto.setDetailRespDtoList((List)detailRespDtoList);
        }
        return dto;
    }

    @Override
    public String queryDocumentByPreOrderNo(String preOrderNo) {
        List InOutResultOrderEos = this.inOutResultOrderDomain.queryByPreOrderNo(preOrderNo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)InOutResultOrderEos), "\u524d\u7f6e\u5355\u53f7\u4e0d\u5b58\u5728\u51fa\u5e93\u7ed3\u679c\u5355");
        return ((InOutResultOrderEo)InOutResultOrderEos.get(0)).getDocumentNo();
    }

    @Override
    public Boolean queryPreOrderNoExist(String preOrderNo) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)preOrderNo), "\u51fa/\u5165\u5e93\u901a\u77e5\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List InOutResultOrderEos = this.inOutResultOrderDomain.queryByPreOrderNo(preOrderNo);
        return CollectionUtils.isNotEmpty((Collection)InOutResultOrderEos);
    }

    @Override
    public PageInfo<CsOutResultOrderDetailRespDto> queryDetailByPage(CsOutResultOrderQueryDto queryDto) {
        if (StringUtil.isNotBlank((String)queryDto.getIdentification()) && queryDto.getIdentification().equals("identification")) {
            PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
            List dtoList = this.inOutResultOrderDetailDomain.queryByPage(queryDto);
            for (CsOutResultOrderDetailRespDto respDto : dtoList) {
                respDto.setLongCode(respDto.getSkuCode());
                respDto.setCargoCode(respDto.getSkuCode());
                respDto.setCargoName(respDto.getSkuName());
            }
            return new PageInfo(dtoList);
        }
        InOutResultOrderDetailEo eo = new InOutResultOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)queryDto, (BaseEo)eo);
        PageInfo csOutResultOrderDetailEoPageInfo = this.inOutResultOrderDetailDomain.selectPage((BaseEo)eo, queryDto.getPageNum(), queryDto.getPageSize());
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)csOutResultOrderDetailEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = csOutResultOrderDetailEoPageInfo.getList().stream().map(e -> {
            CsOutResultOrderDetailRespDto respDto = new CsOutResultOrderDetailRespDto();
            BeanUtils.copyProperties((Object)e, (Object)respDto);
            respDto.setCargoCode(e.getSkuCode());
            respDto.setLongCode(e.getSkuCode());
            respDto.setCargoName(e.getSkuName());
            respDto.setSnCodeList((List)(StringUtils.isNotEmpty((CharSequence)e.getSnCode()) ? Arrays.asList(e.getSnCode().split(",")) : Lists.newArrayList()));
            respDto.setShippingCodeList((List)(StringUtils.isNotEmpty((CharSequence)e.getShippingCode()) ? Arrays.asList(e.getShippingCode().split(",")) : Lists.newArrayList()));
            return respDto;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return pageInfo;
    }

    @Override
    public CsLogisticsDeliveredInfoRespDto queryInfoByExternalOrderNo(CsInfoQueryDto infoQueryDto) {
        AssertUtil.isTrue(null != infoQueryDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ExtQueryChainWrapper filter = this.inOutResultOrderDomain.filter();
        if (!StringUtils.isNotBlank((CharSequence)infoQueryDto.getCspNo())) {
            throw new BizException("\u8425\u9500\u4e91\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        filter.eq((Object)"external_order_no", (Object)infoQueryDto.getCspNo());
        if (!StringUtils.isNotBlank((CharSequence)infoQueryDto.getConsignmentNo())) {
            throw new BizException("\u6258\u8fd0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        filter.like((Object)"consignment_no", (Object)infoQueryDto.getConsignmentNo());
        InOutResultOrderEo resultOrderEo = (InOutResultOrderEo)filter.one();
        AssertUtil.isTrue(null != resultOrderEo, "\u6839\u636e\u8425\u9500\u4e91\u5355\u53f7\u548c\u6258\u8fd0\u5355\u53f7\u672a\u67e5\u5230\u8be5\u5355\u636e");
        List orderDetailList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"document_no", (Object)resultOrderEo.getDocumentNo())).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)orderDetailList), "\u6839\u636e\u8425\u9500\u4e91\u5355\u53f7\u548c\u6258\u8fd0\u5355\u53f7\u67e5\u5230\u8be5\u5355\u636e\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
        CsLogisticsDeliveredInfoRespDto logisticsDeliveredInfoRespDto = new CsLogisticsDeliveredInfoRespDto();
        logisticsDeliveredInfoRespDto.setConsignmentNo(resultOrderEo.getConsignmentNo());
        ArrayList list = new ArrayList();
        CubeBeanUtils.copyCollection(list, (Collection)orderDetailList, CsLogisticsDeliveredInfoDetailRespDto.class);
        logisticsDeliveredInfoRespDto.setDeliveredInfoDetailRespDtoList(list);
        return logisticsDeliveredInfoRespDto;
    }

    @Override
    public CsDeliveredOutResultInfoRespDto queryDeliveredInfo(String preOrderNo) {
        List csItemEoList;
        logger.info("queryDeliveredInfo==>\u6839\u636e\u524d\u7f6e\u4e1a\u52a1\u5355\u53f7\u67e5\u8be2\u5df2\u53d1\u8d27\u8d27\u54c1\u6570\u91cf\u4fe1\u606f,preOrderNo:{}", (Object)preOrderNo);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)preOrderNo), "\u524d\u7f6e\u4e1a\u52a1\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper outResultOrderDetailQueryWrapper = new QueryWrapper();
        outResultOrderDetailQueryWrapper.eq((Object)"pre_order_no", (Object)preOrderNo);
        List csOutResultOrderDetailEoList = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)outResultOrderDetailQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csOutResultOrderDetailEoList)) {
            return new CsDeliveredOutResultInfoRespDto();
        }
        List cargoCodeList = csOutResultOrderDetailEoList.stream().map(InOutResultOrderDetailEo::getSkuCode).collect(Collectors.toList());
        Map<Object, Object> itemMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(cargoCodeList) && CollectionUtils.isNotEmpty((Collection)(csItemEoList = this.itemSkuProxy.queryBySkuCodes(cargoCodeList)))) {
            itemMap = csItemEoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity()));
        }
        CsDeliveredOutResultInfoRespDto csDeliveredOutResultInfoRespDto = new CsDeliveredOutResultInfoRespDto();
        ArrayList csDeliveredOutResultInfoDetailRespDtoList = Lists.newArrayList();
        csDeliveredOutResultInfoRespDto.setCsDeliveredOutResultInfoDetailRespDtoList((List)csDeliveredOutResultInfoDetailRespDtoList);
        for (InOutResultOrderDetailEo orderDetailEo : csOutResultOrderDetailEoList) {
            CsDeliveredOutResultInfoDetailRespDto respDto = new CsDeliveredOutResultInfoDetailRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)orderDetailEo, (String[])new String[0]);
            String cargoCode = orderDetailEo.getSkuCode();
            ItemSkuDto csItemEo = (ItemSkuDto)itemMap.get(cargoCode);
            if (null != csItemEo) {
                respDto.setLongCode(csItemEo.getSkuCode());
            }
            csDeliveredOutResultInfoDetailRespDtoList.add(respDto);
        }
        logger.info("queryDeliveredInfo==>\u8fd4\u56de\u6570\u636e,csDeliveredOutResultInfoRespDto:{}", (Object)LogUtils.buildLogContent(csDeliveredOutResultInfoRespDto));
        return csDeliveredOutResultInfoRespDto;
    }

    @Override
    public List<CsOutResultOrderDetailRespDto> queryDetailByRelevanceNo(String relevanceNo) {
        List csOutResultOrderDetailEos = this.inOutResultOrderDetailDomain.queryByRelevanceNo(relevanceNo);
        ArrayList<CsOutResultOrderDetailRespDto> csOutResultOrderDetailRespDtos = new ArrayList<CsOutResultOrderDetailRespDto>();
        for (InOutResultOrderDetailEo csOutResultOrderDetailEo : csOutResultOrderDetailEos) {
            CsOutResultOrderDetailRespDto csOutResultOrderDetailRespDto = new CsOutResultOrderDetailRespDto();
            DtoHelper.eo2Dto((BaseEo)csOutResultOrderDetailEo, (BaseVo)csOutResultOrderDetailRespDto);
            if (csOutResultOrderDetailEo.getProduceTime() != null) {
                csOutResultOrderDetailRespDto.setProduceTime(DateUtil.format((Date)csOutResultOrderDetailEo.getProduceTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (csOutResultOrderDetailEo.getExpireTime() != null) {
                csOutResultOrderDetailRespDto.setExpireTime(DateUtil.format((Date)csOutResultOrderDetailEo.getExpireTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            csOutResultOrderDetailRespDto.setCargoCode(csOutResultOrderDetailEo.getSkuCode());
            csOutResultOrderDetailRespDto.setLongCode(csOutResultOrderDetailEo.getSkuCode());
            csOutResultOrderDetailRespDto.setCargoName(csOutResultOrderDetailEo.getSkuName());
            csOutResultOrderDetailRespDtos.add(csOutResultOrderDetailRespDto);
        }
        return csOutResultOrderDetailRespDtos;
    }

    @Override
    public List<CsOutResultOrderDetailRespDto> queryDetailByDocumentNo(String documentNo) {
        AssertUtil.assertNotBlank(documentNo, "\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        List csOutResultOrderDetailEos = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderDetailEo.class).eq(InOutResultOrderDetailEo::getDocumentNo, (Object)documentNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        ArrayList<CsOutResultOrderDetailRespDto> csOutResultOrderDetailRespDtos = new ArrayList<CsOutResultOrderDetailRespDto>();
        for (InOutResultOrderDetailEo csOutResultOrderDetailEo : csOutResultOrderDetailEos) {
            CsOutResultOrderDetailRespDto csOutResultOrderDetailRespDto = new CsOutResultOrderDetailRespDto();
            DtoHelper.eo2Dto((BaseEo)csOutResultOrderDetailEo, (BaseVo)csOutResultOrderDetailRespDto);
            csOutResultOrderDetailRespDto.setCargoCode(csOutResultOrderDetailEo.getSkuCode());
            csOutResultOrderDetailRespDto.setLongCode(csOutResultOrderDetailEo.getSkuCode());
            csOutResultOrderDetailRespDto.setCargoName(csOutResultOrderDetailEo.getSkuName());
            csOutResultOrderDetailRespDtos.add(csOutResultOrderDetailRespDto);
        }
        return csOutResultOrderDetailRespDtos;
    }

    @Override
    public com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutResultOrderRespDto queryCsOutResultOrder(CsOutResultOrderAddReqDto csOutResultOrderAddReqDto) {
        return null;
    }

    @Override
    public List<CsOutResultOrderRespDto> queryByParam(CsOutResultOrderQueryDto queryDto) {
        InOutResultOrderEo eo = new InOutResultOrderEo();
        DtoHelper.dto2Eo((BaseVo)queryDto, (BaseEo)eo);
        List select = this.inOutResultOrderDomain.selectList((BaseEo)eo);
        ArrayList<CsOutResultOrderRespDto> list = new ArrayList<CsOutResultOrderRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            DtoHelper.eoList2DtoList((Collection)select, list, CsOutResultOrderRespDto.class);
        }
        return list;
    }
}

