/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InspectionReleaseOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.InspectionReleaseOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IInspectionReleaseOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IInspectionReleaseTaskService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.CodeGenerateUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.InspectionReleaseOperateLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.InspectionReleaseOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.InspectionReleaseTaskDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.InspectionReleaseTaskItemDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InspectionNotReleaseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InspectionReleaseOperateLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InspectionReleaseOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InspectionReleasePlanEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InspectionReleaseTaskEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InspectionReleaseTaskItemEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.InspectionNotReleaseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.InspectionReleaseOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.InspectionReleasePlanMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.InspectionReleaseTaskItemMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.InspectionReleaseTaskMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.ReleaseOrderErrorRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseQualityEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.transcation.TransactionAfterService;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InspectionReleaseOrderServiceImpl
implements IInspectionReleaseOrderService {
    private static final Logger log = LoggerFactory.getLogger(InspectionReleaseOrderServiceImpl.class);
    @Autowired
    InspectionReleaseOrderDas inspectionReleaseOrderDas;
    @Autowired
    InspectionReleaseOrderMapper inspectionReleaseOrderMapper;
    @Autowired
    InspectionReleasePlanMapper inspectionReleasePlanMapper;
    @Autowired
    InspectionReleaseOperateLogDas inspectionReleaseOperateLogDas;
    @Autowired
    InspectionReleaseTaskMapper inspectionReleaseTaskMapper;
    @Autowired
    InspectionReleaseTaskDas inspectionReleaseTaskDas;
    @Autowired
    ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    ILogicInventoryDomain logicInventoryDomain;
    @Autowired
    InspectionReleaseTaskItemDas inspectionReleaseTaskItemDas;
    @Autowired
    InspectionReleaseTaskItemMapper inspectionReleaseTaskItemMapper;
    @Autowired
    CodeGenerateUtil codeGenerateUtil;
    @Autowired
    ICommonsMqService commonsMqService;
    @Autowired
    TransactionAfterService transactionAfterService;
    @Autowired
    IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Autowired
    InspectionNotReleaseMapper inspectionNotReleaseMapper;
    @Autowired
    IInspectionReleaseTaskService inspectionReleaseTaskService;

    @Override
    public Long addInspectionReleaseOrder(InspectionReleaseOrderReqDto addReqDto) {
        InspectionReleaseOrderEo inspectionReleaseOrderEo = new InspectionReleaseOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)inspectionReleaseOrderEo);
        this.inspectionReleaseOrderDas.insert((BaseEo)inspectionReleaseOrderEo);
        return inspectionReleaseOrderEo.getId();
    }

    @Override
    public void modifyInspectionReleaseOrder(InspectionReleaseOrderReqDto modifyReqDto) {
        InspectionReleaseOrderEo inspectionReleaseOrderEo = new InspectionReleaseOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)inspectionReleaseOrderEo);
        this.inspectionReleaseOrderDas.updateSelective((BaseEo)inspectionReleaseOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeInspectionReleaseOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.inspectionReleaseOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public InspectionReleaseOrderRespDto queryById(Long id) {
        InspectionReleaseOrderEo inspectionReleaseOrderEo = (InspectionReleaseOrderEo)this.inspectionReleaseOrderDas.selectByPrimaryKey(id);
        InspectionReleaseOrderRespDto inspectionReleaseOrderRespDto = new InspectionReleaseOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)inspectionReleaseOrderEo, (BaseVo)inspectionReleaseOrderRespDto);
        return inspectionReleaseOrderRespDto;
    }

    @Override
    public List<InspectionReleaseOrderRespDto> queryList(InspectionReleaseOrderReqDto reqDto) {
        if (null == reqDto.getOrderStatus() && StringUtils.isBlank((CharSequence)reqDto.getInspectionReleaseNo()) && StringUtils.isBlank((CharSequence)reqDto.getQualityInspectionNo()) && StringUtils.isBlank((CharSequence)reqDto.getSkuCode()) && StringUtils.isBlank((CharSequence)reqDto.getBatch())) {
            throw new CsInventoryException("\u67e5\u8be2\u5bf9\u8c61\u4e0d\u5b58\u5728\u6709\u6548\u53c2\u6570", new Object[0]);
        }
        List inspectionReleaseOrderEos = this.inspectionReleaseOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseOrderEo.class).eq(null != reqDto.getOrderStatus(), InspectionReleaseOrderEo::getOrderStatus, (Object)reqDto.getOrderStatus())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getInspectionReleaseNo()), InspectionReleaseOrderEo::getInspectionReleaseNo, (Object)reqDto.getInspectionReleaseNo())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getQualityInspectionNo()), InspectionReleaseOrderEo::getQualityInspectionNo, (Object)reqDto.getQualityInspectionNo())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getSkuCode()), InspectionReleaseOrderEo::getSkuCode, (Object)reqDto.getSkuCode())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getBatch()), InspectionReleaseOrderEo::getBatch, (Object)reqDto.getBatch()));
        if (CollectionUtils.isEmpty((Collection)inspectionReleaseOrderEos)) {
            return Lists.newArrayList();
        }
        ArrayList respDtoList = Lists.newArrayList();
        for (InspectionReleaseOrderEo inspectionReleaseOrderEo : inspectionReleaseOrderEos) {
            InspectionReleaseOrderRespDto respDto = new InspectionReleaseOrderRespDto();
            BeanUtils.copyProperties((Object)inspectionReleaseOrderEo, (Object)respDto);
            respDtoList.add(respDto);
        }
        return respDtoList;
    }

    @Override
    public PageInfo<InspectionReleaseOrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        InspectionReleaseOrderReqDto inspectionReleaseOrderReqDto = (InspectionReleaseOrderReqDto)JSON.parseObject((String)filter, InspectionReleaseOrderReqDto.class);
        InspectionReleaseOrderEo inspectionReleaseOrderEo = new InspectionReleaseOrderEo();
        DtoHelper.dto2Eo((BaseVo)inspectionReleaseOrderReqDto, (BaseEo)inspectionReleaseOrderEo);
        PageInfo eoPageInfo = this.inspectionReleaseOrderDas.selectPage((BaseEo)inspectionReleaseOrderEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, InspectionReleaseOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<ReleaseOrderErrorRespDto> batchAddInspectionReleaseOrder(List<InspectionReleaseOrderReqDto> dtoList) {
        log.info("\u6279\u91cf\u653e\u884cbatchAddInspectionReleaseOrder\uff1a{}", (Object)JSON.toJSONString(dtoList));
        ArrayList errorList = Lists.newArrayList();
        ArrayList insertEoList = Lists.newArrayList();
        ArrayList inspectionReleaseOrderReqDtoList = Lists.newArrayList();
        List skuCodes = dtoList.stream().map(InspectionReleaseOrderReqDto::getSkuCode).distinct().collect(Collectors.toList());
        List batches = dtoList.stream().map(InspectionReleaseOrderReqDto::getBatch).distinct().collect(Collectors.toList());
        List inspectionReleasePlanEos = new ArrayList();
        BigDecimal planReleaseNum = dtoList.get(0).getPlanReleaseNum();
        if (ObjectUtil.isNotEmpty((Object)planReleaseNum)) {
            log.info("\u4e0a\u6e38\u5df2\u4f20\u5165\u8ba1\u5212\u6570\u91cf\uff0c\u65e0\u9700\u5728\u83b7\u53d6");
        } else {
            log.info("\u8ba1\u5212\u6570\u91cf\u67e5\u8be2");
            inspectionReleasePlanEos = this.inspectionReleasePlanMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleasePlanEo.class).in(InspectionReleasePlanEo::getSkuCode, skuCodes)).in(InspectionReleasePlanEo::getBatch, batches)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        }
        List inspectionReleaseTaskEos = this.inspectionReleaseTaskMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskEo.class).in(InspectionReleaseTaskEo::getSkuCode, skuCodes)).in(InspectionReleaseTaskEo::getBatch, batches)).eq(InspectionReleaseTaskEo::getStatus, (Object)"ing")).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        ArrayList notOrderStatus = Lists.newArrayList((Object[])new Integer[]{-1, 0, -99});
        List preInspectionReleaseOrderEos = this.inspectionReleaseOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseOrderEo.class).in(InspectionReleaseOrderEo::getSkuCode, skuCodes)).in(InspectionReleaseOrderEo::getBatch, batches)).in(InspectionReleaseOrderEo::getOrderStatus, (Collection)notOrderStatus)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        ArrayList logEos = Lists.newArrayList();
        int i = 0;
        for (InspectionReleaseOrderReqDto addReqDto : dtoList) {
            String logDesc;
            if (null != addReqDto.getReportResult() && !"\u5408\u683c".equals(addReqDto.getReportResult())) {
                errorList.add(new ReleaseOrderErrorRespDto(addReqDto.getSkuCode(), addReqDto.getBatch(), "\u8d28\u68c0\u62a5\u544a\u4e0d\u5408\u683c"));
                continue;
            }
            InspectionReleaseTaskEo taskEo = inspectionReleaseTaskEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)addReqDto.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)addReqDto.getBatch())).findFirst().orElse(null);
            if (null != taskEo) {
                errorList.add(new ReleaseOrderErrorRespDto(addReqDto.getSkuCode(), addReqDto.getBatch(), "\u5df2\u5b58\u5728\u6267\u884c\u4e2d\u7684\u4efb\u52a1\uff0c\u4e0d\u53ef\u91cd\u590d\u653e\u884c"));
                continue;
            }
            InspectionReleaseOrderEo notInspectionReleaseOrderEo = preInspectionReleaseOrderEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)addReqDto.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)addReqDto.getBatch()) && notOrderStatus.contains(o.getOrderStatus())).findFirst().orElse(null);
            if (null != notInspectionReleaseOrderEo) {
                if (Objects.equals(notInspectionReleaseOrderEo.getOrderStatus(), 0)) {
                    InspectionReleaseOrderReqDto inspectionReleaseOrderReqDto = new InspectionReleaseOrderReqDto();
                    inspectionReleaseOrderReqDto.setSkuCode(addReqDto.getSkuCode());
                    inspectionReleaseOrderReqDto.setBatch(addReqDto.getBatch());
                    inspectionReleaseOrderReqDto.setReportResult(addReqDto.getReportResult());
                    inspectionReleaseOrderReqDto.setQualityInspectionNo(addReqDto.getQualityInspectionNo());
                    inspectionReleaseOrderReqDto.setQualityInspectionDate(addReqDto.getQualityInspectionDate());
                    inspectionReleaseOrderReqDtoList.add(inspectionReleaseOrderReqDto);
                    continue;
                }
                if (Objects.equals(notInspectionReleaseOrderEo.getOrderStatus(), -99)) {
                    errorList.add(new ReleaseOrderErrorRespDto(addReqDto.getSkuCode(), addReqDto.getBatch(), notInspectionReleaseOrderEo.getRemark()));
                    continue;
                }
                errorList.add(new ReleaseOrderErrorRespDto(addReqDto.getSkuCode(), addReqDto.getBatch(), "\u5df2\u5b58\u5728\u51c6\u5907\u6267\u884c\u7684\u653e\u884c\u5355\uff0c\u4e0d\u518d\u91cd\u590d\u653e\u884c"));
                continue;
            }
            InspectionReleaseOrderEo eo = new InspectionReleaseOrderEo();
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)eo);
            eo.setInspectionReleaseNo(this.codeGenerateUtil.generateNo("FX", 6));
            eo.setInspectionReleaseType(Integer.valueOf(2));
            if ("\u5408\u683c".equals(addReqDto.getReportResult())) {
                eo.setOrderStatus(Integer.valueOf(-1));
                eo.setReleaseTime(new Date());
                logDesc = "\u62a5\u544a\u5408\u683c\uff0c\u66f4\u65b0\u72b6\u6001\u4e3a\u5df2\u653e\u884c";
                int finalI = i++;
                this.transactionAfterService.execute(() -> this.sendCreateTaskMq(eo.getInspectionReleaseNo(), (long)finalI * 20L));
            } else if (StringUtils.isBlank((CharSequence)addReqDto.getReportResult())) {
                List csLogicWarehouseEos = this.logicWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).eq(LogicWarehouseEo::getWarehouseQuality, (Object)CsLogicWarehouseQualityEnum.WAIT_INSPECTION.getCode())).eq(LogicWarehouseEo::getWarehouseClassify, (Object)CsWarehouseClassifyEnum.LOGIC.getCode())).eq(LogicWarehouseEo::getWarehouseStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
                AssertUtils.notEmpty((Collection)csLogicWarehouseEos, (String)"\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u5f85\u68c0\u4ed3\u5e93");
                List logicWarehouseIds = csLogicWarehouseEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                List intransitWarehouseEos = this.logicWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).in(LogicWarehouseEo::getSubordinateLogicWarehouseId, logicWarehouseIds)).eq(LogicWarehouseEo::getWarehouseStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
                List logicWarehouseCodes = csLogicWarehouseEos.stream().map(LogicWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
                List csLogicInventoryEos = this.logicInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryEo.class).in(LogicInventoryEo::getWarehouseCode, logicWarehouseCodes)).eq(LogicInventoryEo::getSkuCode, (Object)eo.getSkuCode())).eq(LogicInventoryEo::getBatch, (Object)eo.getBatch())).eq(BaseEo::getDr, (Object)YesNoHelper.NO)).gt(LogicInventoryEo::getAvailable, (Object)BigDecimal.ZERO));
                List intransitWarehouseIds = intransitWarehouseEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
                List intransitLogicInventoryEos = this.logicInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryEo.class).in(LogicInventoryEo::getWarehouseId, intransitWarehouseIds)).eq(LogicInventoryEo::getSkuCode, (Object)eo.getSkuCode())).eq(LogicInventoryEo::getBatch, (Object)eo.getBatch())).eq(BaseEo::getDr, (Object)YesNoHelper.NO)).gt(LogicInventoryEo::getAvailable, (Object)BigDecimal.ZERO));
                List inventoryPreemptionEos = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryPreemptionEo.class).eq(InventoryPreemptionEo::getSkuCode, (Object)eo.getSkuCode())).eq(InventoryPreemptionEo::getBatch, (Object)eo.getBatch())).in(InventoryPreemptionEo::getWarehouseCode, logicWarehouseCodes)).in(InventoryPreemptionEo::getSourceType, (Collection)Lists.newArrayList((Object[])new String[]{CsPcpBusinessTypeEnum.ALLOT_OUT.getCode(), CsPcpBusinessTypeEnum.MAIYOU_ALLOT_OUT.getCode(), CsPcpBusinessTypeEnum.OTHER_OUT.getCode()}))).eq(InventoryPreemptionEo::getValid, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
                List notReleaseEos = this.inspectionNotReleaseMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionNotReleaseEo.class).eq(InspectionNotReleaseEo::getSkuCode, (Object)eo.getSkuCode())).eq(InspectionNotReleaseEo::getBatch, (Object)eo.getBatch())).eq(InspectionNotReleaseEo::getValid, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
                BigDecimal targetReleaseNum = BigDecimal.ZERO;
                for (LogicInventoryEo csLogicInventoryEo : csLogicInventoryEos) {
                    targetReleaseNum = BigDecimalUtils.add((BigDecimal)targetReleaseNum, (BigDecimal)csLogicInventoryEo.getAvailable());
                }
                for (LogicInventoryEo intransitLogicInventoryEo : intransitLogicInventoryEos) {
                    targetReleaseNum = BigDecimalUtils.add((BigDecimal)targetReleaseNum, (BigDecimal)intransitLogicInventoryEo.getAvailable());
                }
                Map<String, List<InventoryPreemptionEo>> preemptEoMap = inventoryPreemptionEos.stream().collect(Collectors.groupingBy(InventoryPreemptionEo::getSourceType));
                List<InventoryPreemptionEo> transferPreemptList = preemptEoMap.getOrDefault(CsPcpBusinessTypeEnum.ALLOT_OUT.getCode(), Lists.newArrayList());
                if (CollectionUtils.isEmpty(transferPreemptList)) {
                    transferPreemptList = preemptEoMap.getOrDefault(CsPcpBusinessTypeEnum.MAIYOU_ALLOT_OUT.getCode(), Lists.newArrayList());
                }
                for (InventoryPreemptionEo preemptionEo : transferPreemptList) {
                    targetReleaseNum = BigDecimalUtils.add((BigDecimal)targetReleaseNum, (BigDecimal)preemptionEo.getPreemptNum());
                }
                List<InventoryPreemptionEo> outOtherPreemptList = preemptEoMap.getOrDefault(CsPcpBusinessTypeEnum.OTHER_OUT.getCode(), Lists.newArrayList());
                List notReleaseBusinessNoList = notReleaseEos.stream().map(InspectionNotReleaseEo::getBusinessNo).distinct().collect(Collectors.toList());
                log.info("pre release notReleaseBusinessNoList : {}", (Object)LogUtils.buildLogContent(notReleaseBusinessNoList));
                for (InventoryPreemptionEo preemptionEo : outOtherPreemptList) {
                    if (!notReleaseBusinessNoList.contains(preemptionEo.getSourceNo())) continue;
                    targetReleaseNum = BigDecimalUtils.add((BigDecimal)targetReleaseNum, (BigDecimal)preemptionEo.getPreemptNum());
                }
                eo.setPlanTargetReleaseNum(targetReleaseNum);
                eo.setOrderStatus(Integer.valueOf(0));
                eo.setInspectionReleaseType(Integer.valueOf(1));
                logDesc = "\u672a\u51fa\u62a5\u544a\uff0c\u66f4\u65b0\u72b6\u6001\u4e3a\u9884\u653e\u884c";
            } else {
                throw new BizException("\u653e\u884c\u62a5\u544a\u83b7\u53d6\u72b6\u6001\u5f02\u5e38");
            }
            inspectionReleasePlanEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)eo.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)eo.getBatch())).findFirst().ifPresent(inspectionReleasePlanEo -> eo.setPlanReleaseNum(inspectionReleasePlanEo.getPlanReleaseNum()));
            insertEoList.add(eo);
            InspectionReleaseOperateLogEo logEo = new InspectionReleaseOperateLogEo();
            logEo.setSourceNo(eo.getInspectionReleaseNo());
            logEo.setSkuCode(eo.getSkuCode());
            logEo.setSkuName(eo.getSkuName());
            logEo.setBatch(eo.getBatch());
            logEo.setOperate("pass_release");
            logEo.setDescription(logDesc);
            logEos.add(logEo);
        }
        this.inspectionReleaseOrderDas.insertBatch((List)insertEoList);
        this.inspectionReleaseOperateLogDas.insertBatch((List)logEos);
        if (CollectionUtils.isEmpty((Collection)inspectionReleaseOrderReqDtoList)) {
            return errorList;
        }
        List inspectionReleaseOrderEos = this.inspectionReleaseOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseOrderEo.class).eq(InspectionReleaseOrderEo::getOrderStatus, (Object)0)).in(InspectionReleaseOrderEo::getBatch, batches)).in(InspectionReleaseOrderEo::getSkuCode, skuCodes));
        if (CollectionUtils.isEmpty((Collection)inspectionReleaseOrderEos)) {
            return errorList;
        }
        for (InspectionReleaseOrderEo inspectionReleaseOrderEo : inspectionReleaseOrderEos) {
            InspectionReleaseOrderReqDto inspectionReleaseOrderReqDto = dtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)inspectionReleaseOrderEo.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)inspectionReleaseOrderEo.getBatch())).findFirst().orElse(null);
            if (null == inspectionReleaseOrderReqDto) continue;
            InspectionReleaseOrderEo updateInspectionReleaseOrderEo = new InspectionReleaseOrderEo();
            updateInspectionReleaseOrderEo.setId(inspectionReleaseOrderEo.getId());
            if ("\u5408\u683c".equals(inspectionReleaseOrderReqDto.getReportResult())) {
                updateInspectionReleaseOrderEo.setOrderStatus(Integer.valueOf(-1));
                updateInspectionReleaseOrderEo.setReleaseTime(new Date());
                updateInspectionReleaseOrderEo.setRemark("PRE");
            }
            updateInspectionReleaseOrderEo.setQualityInspectionNo(inspectionReleaseOrderReqDto.getQualityInspectionNo());
            updateInspectionReleaseOrderEo.setQualityInspectionDate(inspectionReleaseOrderReqDto.getQualityInspectionDate());
            this.inspectionReleaseOrderDas.updateSelective((BaseEo)updateInspectionReleaseOrderEo);
            String respMsg = this.inspectionReleaseTaskService.createTaskByInspectionReleaseNo(inspectionReleaseOrderEo.getInspectionReleaseNo());
            if (!StringUtils.isNotBlank((CharSequence)respMsg)) continue;
            errorList.add(new ReleaseOrderErrorRespDto(inspectionReleaseOrderEo.getSkuCode(), inspectionReleaseOrderEo.getBatch(), respMsg));
        }
        return errorList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void singleAddInspectionReleaseOrder(InspectionReleaseOrderReqDto dto) {
        List inspectionReleaseTaskEos = this.inspectionReleaseTaskMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskEo.class).eq(InspectionReleaseTaskEo::getTaskNo, (Object)dto.getTaskNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)inspectionReleaseTaskEos)) {
            throw new BizException("\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u653e\u884c\u4efb\u52a1");
        }
        List inspectionReleaseTaskItemEos = this.inspectionReleaseTaskItemMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskItemEo.class).eq(InspectionReleaseTaskItemEo::getTaskItemNo, (Object)dto.getTaskItemNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)inspectionReleaseTaskItemEos)) {
            throw new BizException("\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u653e\u884c\u5b50\u4efb\u52a1");
        }
        InspectionReleaseTaskItemEo taskItemEo = (InspectionReleaseTaskItemEo)inspectionReleaseTaskItemEos.get(0);
        InspectionReleaseTaskEo taskEo = (InspectionReleaseTaskEo)inspectionReleaseTaskEos.get(0);
        List intransitLogicWarehouseEos = this.logicWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).eq(LogicWarehouseEo::getWarehouseCode, (Object)dto.getIntransitWarehouseCode())).eq(LogicWarehouseEo::getWarehouseStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)intransitLogicWarehouseEos)) {
            throw new BizException("\u5f85\u68c0\u5728\u9014\u4ed3\u67e5\u8be2\u4e0d\u5b58\u5728\uff1a\u5728\u9014\u4ed3\u7f16\u7801" + dto.getIntransitWarehouseCode());
        }
        LogicWarehouseEo intransitLogicWarehouseEo = (LogicWarehouseEo)intransitLogicWarehouseEos.get(0);
        if (null == intransitLogicWarehouseEo.getSubordinateLogicWarehouseId()) {
            throw new BizException("\u5728\u9014\u4ed3\u5173\u8054\u903b\u8f91\u4ed3ID\u4e0d\u5b58\u5728\uff1a\u5728\u9014\u4ed3\u7f16\u7801" + dto.getIntransitWarehouseCode());
        }
        LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectById((Serializable)intransitLogicWarehouseEo.getSubordinateLogicWarehouseId());
        if (null == logicWarehouseEo) {
            throw new BizException("\u5f85\u68c0\u4ed3\u67e5\u8be2\u4e0d\u5b58\u5728\uff1a\u5173\u8054\u903b\u8f91\u4ed3ID:" + intransitLogicWarehouseEo.getSubordinateLogicWarehouseId());
        }
        List csLogicInventoryEos = this.logicInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryEo.class).in(LogicInventoryEo::getWarehouseCode, new Object[]{logicWarehouseEo.getWarehouseCode()})).eq(LogicInventoryEo::getSkuCode, (Object)dto.getSkuCode())).eq(LogicInventoryEo::getBatch, (Object)dto.getBatch())).eq(BaseEo::getDr, (Object)YesNoHelper.NO)).gt(LogicInventoryEo::getAvailable, (Object)BigDecimal.ZERO));
        if (CollectionUtils.isEmpty((Collection)csLogicInventoryEos)) {
            log.info("\u5f85\u68c0\u4ed3\u67e5\u8be2\u5e93\u5b58 \u672a\u67e5\u8be2\u5230\u6709\u6548\u5e93\u5b58");
            return;
        }
        LogicInventoryEo csLogicInventoryEo = (LogicInventoryEo)csLogicInventoryEos.get(0);
        InspectionReleaseTaskEo updateTaskEo = new InspectionReleaseTaskEo();
        updateTaskEo.setId(taskEo.getId());
        updateTaskEo.setStatus("ing");
        this.inspectionReleaseTaskDas.updateSelective((BaseEo)updateTaskEo);
        InspectionReleaseTaskItemEo updateTaskItemEo = new InspectionReleaseTaskItemEo();
        updateTaskItemEo.setId(taskItemEo.getId());
        updateTaskItemEo.setStatus("repair");
        this.inspectionReleaseTaskItemDas.updateSelective((BaseEo)updateTaskItemEo);
        InspectionReleaseTaskItemEo itemEo = new InspectionReleaseTaskItemEo();
        itemEo.setInspectionReleaseNo(taskEo.getInspectionReleaseNo());
        itemEo.setTaskNo(taskEo.getTaskNo());
        itemEo.setTaskItemNo(this.codeGenerateUtil.generateNo("FXJL", 6));
        itemEo.setTaskType("inspection");
        itemEo.setWarehouseCode(csLogicInventoryEo.getWarehouseCode());
        itemEo.setSkuCode(taskEo.getSkuCode());
        itemEo.setSkuName(taskEo.getSkuName());
        itemEo.setBatch(taskEo.getBatch());
        itemEo.setStep("execute_transfer");
        itemEo.setEndStep("execute_transfer");
        itemEo.setPlanReleaseNum(csLogicInventoryEo.getAvailable());
        itemEo.setReleaseNum(csLogicInventoryEo.getAvailable());
        itemEo.setStatus("ing");
        itemEo.setRemark(csLogicInventoryEo.getRemark());
        this.inspectionReleaseTaskItemDas.insert((BaseEo)itemEo);
        this.transactionAfterService.execute(() -> this.sendDoTaskMq(taskEo.getTaskNo()));
    }

    private void sendDoTaskMq(String taskNo) {
        log.info("sendDoTaskMq: {}", (Object)taskNo);
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)taskNo);
        this.commonsMqService.sendSingleMessage("INSPECTION_RELEASE_BUSINESS_TOPIC", "DO_INSPECTION_RELEASE_TASK", (Object)messageVo);
    }

    @Override
    public void sendCreateTaskMq(String inspectionReleaseNo, Long delay) {
        if (null == delay) {
            delay = 1L;
        }
        log.info("sendCreateTaskMq: {}", (Object)inspectionReleaseNo);
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)inspectionReleaseNo);
        this.commonsMqService.sendDelaySingleMessageAsync("INSPECTION_RELEASE_BUSINESS_TOPIC", "CREATE_INSPECTION_RELEASE_TASK", (Object)messageVo, delay);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancel(Long id) {
        if (null == id) {
            throw new CsInventoryException("\u653e\u884c\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        InspectionReleaseOrderEo inspectionReleaseOrderEo = (InspectionReleaseOrderEo)this.inspectionReleaseOrderMapper.selectById((Serializable)id);
        if (null == inspectionReleaseOrderEo) {
            throw new CsInventoryException("12580", "\u67e5\u8be2\u653e\u884c\u5355\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[]{id});
        }
        ArrayList statusList = Lists.newArrayList((Object[])new Integer[]{0, -99});
        if (!statusList.contains(inspectionReleaseOrderEo.getOrderStatus())) {
            throw new CsInventoryException("\u5f53\u524d\u72b6\u6001\u4e0d\u5904\u4e8e\u9884\u653e\u884c\u6216\u8005\u653e\u884c\u5931\u8d25\u72b6\u6001\uff0c\u653e\u884c\u5355\u5355\u53f7\u64a4\u9500\u5931\u8d25", new Object[0]);
        }
        InspectionReleaseOrderEo updateInspectionReleaseOrderEo = new InspectionReleaseOrderEo();
        updateInspectionReleaseOrderEo.setId(inspectionReleaseOrderEo.getId());
        updateInspectionReleaseOrderEo.setOrderStatus(Integer.valueOf(3));
        this.inspectionReleaseOrderDas.updateSelective((BaseEo)updateInspectionReleaseOrderEo);
        InspectionReleaseOperateLogEo logEo = new InspectionReleaseOperateLogEo();
        logEo.setSourceNo(inspectionReleaseOrderEo.getInspectionReleaseNo());
        logEo.setSkuCode(inspectionReleaseOrderEo.getSkuCode());
        logEo.setSkuName(inspectionReleaseOrderEo.getSkuName());
        logEo.setBatch(inspectionReleaseOrderEo.getBatch());
        logEo.setOperate("cancel_release");
        logEo.setDescription("\u64a4\u56de\u653e\u884c\u6210\u529f");
        this.inspectionReleaseOperateLogDas.insert((BaseEo)logEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void receiveInspectionReport(List<InspectionReleaseOrderReqDto> dtoList) {
        List skuCodes = dtoList.stream().map(InspectionReleaseOrderReqDto::getSkuCode).distinct().collect(Collectors.toList());
        List batches = dtoList.stream().map(InspectionReleaseOrderReqDto::getBatch).distinct().collect(Collectors.toList());
        List inspectionReleaseOrderEos = this.inspectionReleaseOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseOrderEo.class).eq(InspectionReleaseOrderEo::getOrderStatus, (Object)0)).in(InspectionReleaseOrderEo::getBatch, batches)).in(InspectionReleaseOrderEo::getSkuCode, skuCodes));
        if (CollectionUtils.isEmpty((Collection)inspectionReleaseOrderEos)) {
            return;
        }
        int i = 0;
        for (InspectionReleaseOrderEo inspectionReleaseOrderEo : inspectionReleaseOrderEos) {
            InspectionReleaseOrderReqDto inspectionReleaseOrderReqDto = dtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)inspectionReleaseOrderEo.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)inspectionReleaseOrderEo.getBatch())).findFirst().orElse(null);
            if (null == inspectionReleaseOrderReqDto) continue;
            InspectionReleaseOrderEo updateInspectionReleaseOrderEo = new InspectionReleaseOrderEo();
            updateInspectionReleaseOrderEo.setId(inspectionReleaseOrderEo.getId());
            if ("\u5408\u683c".equals(inspectionReleaseOrderReqDto.getReportResult())) {
                updateInspectionReleaseOrderEo.setOrderStatus(Integer.valueOf(-1));
                updateInspectionReleaseOrderEo.setReleaseTime(new Date());
                updateInspectionReleaseOrderEo.setRemark("PRE");
                int finalI = i++;
                this.transactionAfterService.execute(() -> this.sendCreateTaskMq(inspectionReleaseOrderEo.getInspectionReleaseNo(), (long)finalI * 20L));
            } else {
                updateInspectionReleaseOrderEo.setOrderStatus(Integer.valueOf(2));
                InspectionReleaseOperateLogEo logEo = new InspectionReleaseOperateLogEo();
                logEo.setSourceNo(inspectionReleaseOrderEo.getInspectionReleaseNo());
                logEo.setSkuCode(inspectionReleaseOrderEo.getSkuCode());
                logEo.setSkuName(inspectionReleaseOrderEo.getSkuName());
                logEo.setBatch(inspectionReleaseOrderEo.getBatch());
                logEo.setOperate("receive_report_pass");
                logEo.setDescription("\u62a5\u544a\u4e0d\u5408\u683c\uff0c\u9884\u653e\u884c\u81ea\u52a8\u66f4\u65b0\u4e3a\u4e0d\u5408\u683c, \u653e\u884c\u5355\u53f7: " + inspectionReleaseOrderEo.getInspectionReleaseNo());
                this.inspectionReleaseOperateLogDas.insert((BaseEo)logEo);
            }
            updateInspectionReleaseOrderEo.setQualityInspectionNo(inspectionReleaseOrderReqDto.getQualityInspectionNo());
            updateInspectionReleaseOrderEo.setQualityInspectionDate(inspectionReleaseOrderReqDto.getQualityInspectionDate());
            this.inspectionReleaseOrderDas.updateSelective((BaseEo)updateInspectionReleaseOrderEo);
        }
    }
}

