/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.CsBasicsExternalStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.ICsBasicsExternalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInOutOrderExtService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsReceiveReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsWmsBasicsDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.message.CsOrderCancelQimenMessageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsBaseOrderAddressAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInOutOrderGenerateDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInOutOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInOutOrderTriggerReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.bd.GenerateInNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsExternalStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderItemStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.CsOutNoticePushStatusEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.data.DataDictDto;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IBaseOrderAddressDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.inventory.proxy.data.IPcpDictApiProxy;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderCommonCancelBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CsInOutOrderExtServiceImpl
implements ICsInOutOrderExtService {
    private static Logger logger = LoggerFactory.getLogger(CsInOutOrderExtServiceImpl.class);
    @Value(value="${ignore.batch.flag:false}")
    protected Boolean ignoreBatch;
    @Autowired
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    IRelWarehouseDomain relWarehouseDomain;
    @Autowired
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Autowired
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Autowired
    IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Autowired
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Autowired
    IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Autowired
    ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    IPcpDictApiProxy pcpDictApiProxy;
    @Resource
    CsCommonService commonService;
    @Autowired
    IBaseOrderAddressDomain baseOrderAddressDomain;
    @Autowired
    IWarehouseAddressDomain warehouseAddressDomain;
    @Autowired
    ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    protected BaseOrderFacade baseOrderFacade;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean triggerInOutOrder(CsInOutOrderTriggerReqDto inOutOrderTriggerReqDto) {
        String documentType;
        String orderNo;
        logger.info("triggerInOutOrder==>\u53d6\u6d88/\u6062\u590d\u51fa\u5e93\u901a\u77e5\u5355,inOutOrderTriggerReqDto:{}", (Object)LogUtils.buildLogContent(inOutOrderTriggerReqDto));
        this.checkParams(inOutOrderTriggerReqDto);
        QueryWrapper InOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        InOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        String documentNo = inOutOrderTriggerReqDto.getDocumentNo();
        if (StringUtils.isNotBlank((CharSequence)documentNo)) {
            InOutNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        }
        if (StringUtils.isNotBlank((CharSequence)(orderNo = inOutOrderTriggerReqDto.getOrderNo()))) {
            InOutNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)orderNo);
        }
        if (StringUtils.isNotBlank((CharSequence)(documentType = inOutOrderTriggerReqDto.getDocumentType()))) {
            InOutNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)documentType);
        }
        List InOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)InOutNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)InOutNoticeOrderEoList), "\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5355\u636e\u4fe1\u606f");
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)InOutNoticeOrderEoList.get(0);
        String orderType = inOutNoticeOrderEo.getOrderType();
        String triggerType = inOutOrderTriggerReqDto.getTriggerType();
        Boolean checkFlag = this.checkWms(inOutNoticeOrderEo.getRelevanceNo());
        if (!checkFlag.booleanValue()) {
            return Boolean.FALSE;
        }
        if ("cancel".equals(triggerType)) {
            BaseOrderCommonCancelBo build = BaseOrderCommonCancelBo.builder().documentNo(inOutNoticeOrderEo.getPreOrderNo()).sourceType(inOutNoticeOrderEo.getDisplayBusinessType()).businessType(inOutNoticeOrderEo.getDisplayBusinessType()).build();
            if ("out".equals(orderType)) {
                this.baseOrderFacade.deliveryNoticeOrderCancel(build);
            } else if ("in".equals(orderType)) {
                this.baseOrderFacade.receiveNoticeOrderCancel(build);
            }
            return Boolean.TRUE;
        }
        if ("out".equals(orderType)) {
            inOutNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.ONO_WAIT_OUT.getCode());
        } else if ("in".equals(orderType)) {
            inOutNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.INO_WAIT_IN.getCode());
        }
        InOutNoticeOrderEoQueryWrapper.clear();
        InOutNoticeOrderEoQueryWrapper.eq((Object)"id", (Object)inOutNoticeOrderEo.getId());
        this.inOutNoticeOrderDomain.getMapper().update((Object)inOutNoticeOrderEo, (Wrapper)InOutNoticeOrderEoQueryWrapper);
        return Boolean.TRUE;
    }

    private Boolean checkWms(String sourceNo) {
        logger.info("checkWms==>\u9006\u5411\u9000\u8d27\u9000\u6b3e\u76f8\u5173,\u8c03\u7528\u5947\u95e8\u63a5\u53e3\u53d6\u6d88\u5355\u636e,sourceNo:{}", (Object)sourceNo);
        QueryWrapper InOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        InOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)sourceNo);
        ArrayList orderStatusList = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_WAIT_OUT.getCode(), BaseOrderStatusEnum.INO_WAIT_IN.getCode()});
        InOutNoticeOrderEoQueryWrapper.in((Object)"order_status", (Collection)orderStatusList);
        List InOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)InOutNoticeOrderEoQueryWrapper);
        logger.info("checkWms==>\u9006\u5411\u9000\u8d27\u9000\u6b3e\u76f8\u5173,\u8c03\u7528\u5947\u95e8\u63a5\u53e3\u53d6\u6d88\u5355\u636e,InOutNoticeOrderEoList:{}", (Object)LogUtils.buildLogContent(InOutNoticeOrderEoList));
        if (CollectionUtils.isEmpty((Collection)InOutNoticeOrderEoList)) {
            return Boolean.TRUE;
        }
        InOutNoticeOrderEo InOutNoticeOrderEo2 = (InOutNoticeOrderEo)InOutNoticeOrderEoList.get(0);
        String pushStatus = InOutNoticeOrderEo2.getPushStatus();
        if (CsOutNoticePushStatusEnum.PUSHING.getCode().equals(InOutNoticeOrderEo2.getPushStatus())) {
            throw new BizException(String.format("\u3010%s\u3011\u51fa\u5e93\u901a\u77e5\u5355\u6b63\u5728\u63a8\u9001\u4e2d\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c", InOutNoticeOrderEo2.getDocumentNo()));
        }
        if (CsOutNoticePushStatusEnum.WITHOUT_PUSH.getCode().equals(InOutNoticeOrderEo2.getPushStatus())) {
            return Boolean.TRUE;
        }
        logger.info("checkWms==>\u9006\u5411\u9000\u8d27\u9000\u6b3e\u76f8\u5173,\u8c03\u7528\u5947\u95e8\u63a5\u53e3\u53d6\u6d88\u5355\u636eInOutNoticeOrderEo:{}", (Object)LogUtils.buildLogContent(InOutNoticeOrderEo2));
        String outLogicWarehouseCode = InOutNoticeOrderEo2.getOutLogicWarehouseCode();
        if ("in".equals(InOutNoticeOrderEo2.getOrderType())) {
            outLogicWarehouseCode = InOutNoticeOrderEo2.getInLogicWarehouseCode();
        }
        QueryWrapper csLogicWarehouseEoQueryWrapper = new QueryWrapper();
        csLogicWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csLogicWarehouseEoQueryWrapper.eq((Object)"warehouse_code", (Object)outLogicWarehouseCode);
        List csLogicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)csLogicWarehouseEoQueryWrapper);
        logger.info("checkWms==>\u9006\u5411\u9000\u8d27\u9000\u6b3e\u76f8\u5173,\u8c03\u7528\u5947\u95e8\u63a5\u53e3\u53d6\u6d88\u5355\u636ecsLogicWarehouseEoList:{}", (Object)LogUtils.buildLogContent(csLogicWarehouseEoList));
        if (CollectionUtils.isEmpty((Collection)csLogicWarehouseEoList)) {
            return Boolean.TRUE;
        }
        LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)csLogicWarehouseEoList.get(0);
        String warehouseCorrespondingSystem = csLogicWarehouseEo.getWarehouseCorrespondingSystem();
        String customerId = this.commonService.getCustomerIdByChannelName(warehouseCorrespondingSystem);
        logger.info("checkWms==>\u9006\u5411\u9000\u8d27\u9000\u6b3e\u76f8\u5173,\u8c03\u7528\u5947\u95e8\u63a5\u53e3\u53d6\u6d88\u5355\u636e,\u67e5\u8be2customerId:{}", (Object)customerId);
        CsOrderCancelQimenMessageReqDto cancelQimenMessageReqDto = new CsOrderCancelQimenMessageReqDto();
        cancelQimenMessageReqDto.setCustomerId(customerId);
        cancelQimenMessageReqDto.setWarehouseCode(csLogicWarehouseEo.getWarehouseCode());
        cancelQimenMessageReqDto.setDocumentNo(InOutNoticeOrderEo2.getDocumentNo());
        cancelQimenMessageReqDto.setOrderType("OUT");
        if ("in".equals(InOutNoticeOrderEo2.getOrderType())) {
            cancelQimenMessageReqDto.setOrderType("IN");
        }
        return false;
    }

    private void checkParams(CsInOutOrderTriggerReqDto inOutOrderTriggerReqDto) {
        AssertUtil.isTrue(null != inOutOrderTriggerReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String orderNo = inOutOrderTriggerReqDto.getOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String documentType = inOutOrderTriggerReqDto.getDocumentType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)documentType) && ("out".equals(documentType) || "in".equals(documentType)), "\u5355\u636e\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
        String triggerType = inOutOrderTriggerReqDto.getTriggerType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)triggerType) && ("cancel".equals(triggerType) || "recover".equals(triggerType)), "\u89e6\u53d1\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String generateInNoticeOrder(CsInOutOrderGenerateReqDto inOutOrderGenerateReqDto, boolean publishEvent) {
        logger.info("generateInNoticeOrder==>\u552e\u540e\u76f8\u5173\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355,inOutOrderGenerateReqDto:{}", (Object)LogUtils.buildLogContent(inOutOrderGenerateReqDto));
        this.checkParams(inOutOrderGenerateReqDto);
        DataDictDto dictDto = this.basicDataInfo(inOutOrderGenerateReqDto.getBasicDataBusinessType());
        logger.info("generateInNoticeOrder==>\u552e\u540e\u76f8\u5173\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355,dictDto:{}", (Object)LogUtils.buildLogContent(dictDto));
        this.createDeliveryNoticeOrder(inOutOrderGenerateReqDto, dictDto);
        List inOutNoticeOrderEos = this.inOutNoticeOrderDomain.queryByRelevanceNo(inOutOrderGenerateReqDto.getOrderNo());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEos), "\u6839\u636e\u5173\u8054\u5355\u53f7" + inOutOrderGenerateReqDto.getOrderNo() + "\u67e5\u8be2\u4e0d\u5230\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        InOutNoticeOrderEo inNoticeOrderNo = (InOutNoticeOrderEo)inOutNoticeOrderEos.get(0);
        return inNoticeOrderNo.getDocumentNo();
    }

    private void saveBaseOrderAddress(ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo2, InOutNoticeOrderEo InOutNoticeOrderEo2, CsInOutOrderGenerateReqDto inOutOrderGenerateReqDto) {
        CsBaseOrderAddressAddReqDto sendPersonAddressInfo;
        BaseOrderAddressEo inCsBaseOrderAddressEo;
        String logicWarehouseCode = ReceiveDeliveryNoticeOrderEo2.getDeliveryLogicWarehouseCode();
        QueryWrapper csWarehouseAddressEoQueryWrapper = new QueryWrapper();
        csWarehouseAddressEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csWarehouseAddressEoQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        csWarehouseAddressEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        csWarehouseAddressEoQueryWrapper.eq((Object)"warehouse_code", (Object)logicWarehouseCode);
        List csWarehouseAddressEoList = this.warehouseAddressDomain.getMapper().selectList((Wrapper)csWarehouseAddressEoQueryWrapper);
        logger.info("saveBaseOrderAddress==>\u552e\u540e\u76f8\u5173\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355\u4fdd\u5b58\u5730\u5740\u4fe1\u606f,csWarehouseAddressEoList:{}", (Object)LogUtils.buildLogContent(csWarehouseAddressEoList));
        if (CollectionUtils.isNotEmpty((Collection)csWarehouseAddressEoList)) {
            WarehouseAddressEo csWarehouseAddressEo = (WarehouseAddressEo)csWarehouseAddressEoList.get(0);
            try {
                BaseOrderAddressEo receiveCsBaseOrderAddressEo = new BaseOrderAddressEo();
                receiveCsBaseOrderAddressEo.setDocumentNo(ReceiveDeliveryNoticeOrderEo2.getDocumentNo());
                receiveCsBaseOrderAddressEo.setContactsType("consignee");
                receiveCsBaseOrderAddressEo.setProvince(csWarehouseAddressEo.getProvince());
                receiveCsBaseOrderAddressEo.setProvinceCode(csWarehouseAddressEo.getProvinceCode());
                receiveCsBaseOrderAddressEo.setCity(csWarehouseAddressEo.getCity());
                receiveCsBaseOrderAddressEo.setCityCode(csWarehouseAddressEo.getCityCode());
                receiveCsBaseOrderAddressEo.setDistrict(csWarehouseAddressEo.getDistrict());
                receiveCsBaseOrderAddressEo.setDistrictCode(csWarehouseAddressEo.getDistrictCode());
                receiveCsBaseOrderAddressEo.setDetailAddress(csWarehouseAddressEo.getDetailAddress());
                receiveCsBaseOrderAddressEo.setContacts(csWarehouseAddressEo.getContacts());
                receiveCsBaseOrderAddressEo.setPhone(csWarehouseAddressEo.getPhone());
                logger.info("saveBaseOrderAddress==>\u552e\u540e,\u6536\u8d27\u5730\u5740\u4fe1\u606f,\u76f8\u5173\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355\u4fdd\u5b58\u5730\u5740\u4fe1\u606f,receiveCsBaseOrderAddressEo:{}", (Object)LogUtils.buildLogContent(receiveCsBaseOrderAddressEo));
                this.baseOrderAddressDomain.insert((BaseEo)receiveCsBaseOrderAddressEo);
                inCsBaseOrderAddressEo = new BaseOrderAddressEo();
                CubeBeanUtils.copyProperties((Object)inCsBaseOrderAddressEo, (Object)receiveCsBaseOrderAddressEo, (String[])new String[0]);
                inCsBaseOrderAddressEo.setId(null);
                inCsBaseOrderAddressEo.setDocumentNo(InOutNoticeOrderEo2.getDocumentNo());
                inCsBaseOrderAddressEo.setOrderType(CsDocumentTypeEnum.IN_NOTICE_ORDER.getCode());
                logger.info("saveBaseOrderAddress==>\u552e\u540e,\u6536\u8d27\u5730\u5740\u4fe1\u606f,\u76f8\u5173\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355\u4fdd\u5b58\u5730\u5740\u4fe1\u606f,inCsBaseOrderAddressEo:{}", (Object)LogUtils.buildLogContent(inCsBaseOrderAddressEo));
                this.baseOrderAddressDomain.insert((BaseEo)inCsBaseOrderAddressEo);
            }
            catch (Exception e) {
                logger.error("saveBaseOrderAddress==>e:{}", (Throwable)e);
            }
        }
        if (null != (sendPersonAddressInfo = inOutOrderGenerateReqDto.getSendPersonAddressInfo())) {
            try {
                BaseOrderAddressEo csBaseOrderAddressEo = new BaseOrderAddressEo();
                csBaseOrderAddressEo.setDocumentNo(ReceiveDeliveryNoticeOrderEo2.getDocumentNo());
                csBaseOrderAddressEo.setOrderType(CsDocumentTypeEnum.RECEIVE_NOTICE_ORDER.getCode());
                csBaseOrderAddressEo.setContactsType("consignor");
                csBaseOrderAddressEo.setProvince(sendPersonAddressInfo.getProvince());
                csBaseOrderAddressEo.setEncryptProvince(sendPersonAddressInfo.getEncryptProvince());
                csBaseOrderAddressEo.setProvinceCode(sendPersonAddressInfo.getProvinceCode());
                csBaseOrderAddressEo.setEncryptProvinceCode(sendPersonAddressInfo.getEncryptProvinceCode());
                csBaseOrderAddressEo.setCity(sendPersonAddressInfo.getCity());
                csBaseOrderAddressEo.setEncryptCity(sendPersonAddressInfo.getEncryptCity());
                csBaseOrderAddressEo.setCityCode(sendPersonAddressInfo.getCityCode());
                csBaseOrderAddressEo.setEncryptCityCode(sendPersonAddressInfo.getEncryptCityCode());
                csBaseOrderAddressEo.setDistrict(sendPersonAddressInfo.getDistrict());
                csBaseOrderAddressEo.setEncryptDistrict(sendPersonAddressInfo.getEncryptDistrict());
                csBaseOrderAddressEo.setDistrictCode(sendPersonAddressInfo.getDistrictCode());
                csBaseOrderAddressEo.setEncryptDistrictCode(sendPersonAddressInfo.getEncryptDistrictCode());
                csBaseOrderAddressEo.setDetailAddress(sendPersonAddressInfo.getDetailAddress());
                csBaseOrderAddressEo.setEncryptDetailAddress(sendPersonAddressInfo.getEncryptDetailAddress());
                csBaseOrderAddressEo.setContacts(sendPersonAddressInfo.getContacts());
                csBaseOrderAddressEo.setEncryptContacts(sendPersonAddressInfo.getEncryptContacts());
                csBaseOrderAddressEo.setPhone(sendPersonAddressInfo.getPhone());
                csBaseOrderAddressEo.setEncryptPhone(sendPersonAddressInfo.getEncryptPhone());
                csBaseOrderAddressEo.setOaid(sendPersonAddressInfo.getOaid());
                logger.info("saveBaseOrderAddress==>\u552e\u540e,\u53d1\u8d27\u5730\u5740\u4fe1\u606f,\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355\u4fdd\u5b58\u5730\u5740\u4fe1\u606f,csBaseOrderAddressEo:{}", (Object)LogUtils.buildLogContent(csBaseOrderAddressEo));
                this.baseOrderAddressDomain.insert((BaseEo)csBaseOrderAddressEo);
                inCsBaseOrderAddressEo = new BaseOrderAddressEo();
                CubeBeanUtils.copyProperties((Object)inCsBaseOrderAddressEo, (Object)csBaseOrderAddressEo, (String[])new String[0]);
                inCsBaseOrderAddressEo.setId(null);
                inCsBaseOrderAddressEo.setDocumentNo(InOutNoticeOrderEo2.getDocumentNo());
                inCsBaseOrderAddressEo.setOrderType(CsDocumentTypeEnum.IN_NOTICE_ORDER.getCode());
                logger.info("saveBaseOrderAddress==>\u552e\u540e,\u53d1\u8d27\u5730\u5740\u4fe1\u606f,\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355\u4fdd\u5b58\u5730\u5740\u4fe1\u606f,inCsBaseOrderAddressEo:{}", (Object)LogUtils.buildLogContent(inCsBaseOrderAddressEo));
                this.baseOrderAddressDomain.insert((BaseEo)inCsBaseOrderAddressEo);
            }
            catch (Exception e) {
                logger.error("saveBaseOrderAddress==>e:{}", (Throwable)e);
            }
        }
    }

    protected DataDictDto basicDataInfo(String basicDataBusinessType) {
        try {
            logger.info("\u9000\u8d27\u9000\u6b3e\u5355\u636e\u4fe1\u606f,basicDataInfo==>basicDataBusinessType:{}", (Object)basicDataBusinessType);
            if (StringUtils.isBlank((CharSequence)basicDataBusinessType)) {
                return new DataDictDto();
            }
            DataDictDto dataDictDto = this.pcpDictApiProxy.basicDataInfo(basicDataBusinessType);
            logger.info("\u9000\u8d27\u9000\u6b3e\u5355\u636e\u4fe1\u606f,basicDataInfo==>dataDictDto:{}", (Object)LogUtils.buildLogContent(dataDictDto));
            return dataDictDto;
        }
        catch (Throwable e) {
            logger.error("basicDataInfo==>e:{}", e);
            return new DataDictDto();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String generateInResultOrder(CsInOutOrderGenerateReqDto inOutOrderGenerateReqDto) {
        logger.info("generateInResultOrder==>\u521b\u5efa\u6536\u8d27\u7ed3\u679c\u5355\u3001\u5165\u5e93\u7ed3\u679c\u5355,inOutOrderGenerateReqDto:{}", (Object)LogUtils.buildLogContent(inOutOrderGenerateReqDto));
        this.checkParams(inOutOrderGenerateReqDto);
        String afterSaleOrderno = inOutOrderGenerateReqDto.getOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)afterSaleOrderno), "\u552e\u540e\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper InOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        InOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)afterSaleOrderno);
        InOutNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)"in");
        InOutNoticeOrderEoQueryWrapper.in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.INO_WAIT_IN.getCode(), BaseOrderStatusEnum.INO_PORTION_IN.getCode()}));
        List InOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)InOutNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)InOutNoticeOrderEoList), "\u67e5\u8be2\u4e0d\u5230\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        logger.info("generateInResultOrder==>\u67e5\u8be2\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f,InOutNoticeOrderEoList:{}", (Object)LogUtils.buildLogContent(InOutNoticeOrderEoList));
        InOutNoticeOrderEo InOutNoticeOrderEo2 = (InOutNoticeOrderEo)InOutNoticeOrderEoList.get(0);
        QueryWrapper InOutNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
        InOutNoticeOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutNoticeOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)InOutNoticeOrderEo2.getDocumentNo());
        List outNoticeOrderDetailEoList = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)InOutNoticeOrderDetailEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)outNoticeOrderDetailEoList), "\u67e5\u8be2\u4e0d\u5230\u5165\u5e93\u901a\u77e5\u5355\u660e\u7ec6\u4fe1\u606f");
        ICsBasicsExternalService wmsExternalService = CsBasicsExternalStrategyUtils.getBasicsOrderOperateService(CsBasicsExternalStrategyEnum.WMS.getCode());
        CsBasicsReceiveReqDto csBasicsReceiveReqDto = new CsBasicsReceiveReqDto();
        csBasicsReceiveReqDto.setPlatformOrderNo(InOutNoticeOrderEo2.getExternalOrderNo());
        csBasicsReceiveReqDto.setInOutNoticeOrderNo(InOutNoticeOrderEo2.getDocumentNo());
        csBasicsReceiveReqDto.setInOutTime(new Date());
        csBasicsReceiveReqDto.setWmsOrderNo(IdUtils.getId() + "");
        csBasicsReceiveReqDto.setOrderAfterSaleFlagCommon(Boolean.FALSE);
        ArrayList wmsBasicsDetailReqDtoList = Lists.newArrayList();
        for (InOutNoticeOrderDetailEo orderDetailEo : outNoticeOrderDetailEoList) {
            CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto = new CsWmsBasicsDetailReqDto();
            csWmsBasicsDetailReqDto.setBatch(orderDetailEo.getBatch());
            csWmsBasicsDetailReqDto.setQuantity(orderDetailEo.getPlanQuantity());
            csWmsBasicsDetailReqDto.setSkuCode(orderDetailEo.getSkuCode());
            csWmsBasicsDetailReqDto.setWarehouseCode(InOutNoticeOrderEo2.getInLogicWarehouseCode());
            csWmsBasicsDetailReqDto.setTradeOrderItemId(orderDetailEo.getPreOrderItemId());
            csWmsBasicsDetailReqDto.setProduceTime(new Date());
            wmsBasicsDetailReqDtoList.add(csWmsBasicsDetailReqDto);
        }
        csBasicsReceiveReqDto.setDetailReqDtoList((List)wmsBasicsDetailReqDtoList);
        ArrayList<CsWmsShippingInfoReqDto> shippingInfoReqDtoList = new ArrayList<CsWmsShippingInfoReqDto>(1);
        CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = new CsWmsShippingInfoReqDto();
        csWmsShippingInfoReqDto.setShippingNo(inOutOrderGenerateReqDto.getShippingCode());
        csWmsShippingInfoReqDto.setShippingCompanyCode(inOutOrderGenerateReqDto.getShipmentEnterpriseCode());
        csWmsShippingInfoReqDto.setShippingCompanyName(inOutOrderGenerateReqDto.getShipmentEnterpriseName());
        shippingInfoReqDtoList.add(csWmsShippingInfoReqDto);
        csBasicsReceiveReqDto.setShippingInfoReqDtoList(shippingInfoReqDtoList);
        csBasicsReceiveReqDto.setShopCode(inOutOrderGenerateReqDto.getShopCode());
        logger.info("generateInResultOrder==>\u5165\u5e93,csBasicsReceiveReqDto:{}", (Object)LogUtils.buildLogContent(csBasicsReceiveReqDto));
        wmsExternalService.receiveIn(csBasicsReceiveReqDto);
        QueryWrapper InOutResultOrderEoQueryWrapper = new QueryWrapper();
        InOutResultOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutResultOrderEoQueryWrapper.eq((Object)"pre_order_no", (Object)InOutNoticeOrderEo2.getDocumentNo());
        InOutResultOrderEoQueryWrapper.eq((Object)"order_type", (Object)"in");
        List InOutResultOrderEoList = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)InOutResultOrderEoQueryWrapper);
        String documentNo = null;
        if (CollectionUtils.isNotEmpty((Collection)InOutResultOrderEoList)) {
            documentNo = ((InOutResultOrderEo)InOutResultOrderEoList.get(0)).getDocumentNo();
        }
        return documentNo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public GenerateInNoticeOrderRespDto generateInNoticeOrderReturnDto(CsInOutOrderGenerateReqDto inOutOrderGenerateReqDto) {
        String inNoticeOrderNo = this.generateInNoticeOrder(inOutOrderGenerateReqDto, false);
        logger.info("\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355:{}", (Object)inNoticeOrderNo);
        GenerateInNoticeOrderRespDto respDto = new GenerateInNoticeOrderRespDto(inNoticeOrderNo);
        QueryWrapper warehouseQueryWrapper = new QueryWrapper();
        warehouseQueryWrapper.eq((Object)"warehouse_code", (Object)inOutOrderGenerateReqDto.getLogicWarehouseCode());
        warehouseQueryWrapper.eq((Object)"dr", (Object)0);
        List warehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)warehouseQueryWrapper);
        logger.info("\u6839\u636e\u903b\u8f91\u4ed3\u7f16\u7801\uff1a{} \u67e5\u8be2warehouseEoList:{}", (Object)inOutOrderGenerateReqDto.getLogicWarehouseCode(), (Object)LogUtils.buildLogContent(warehouseEoList));
        if (CollectionUtils.isNotEmpty((Collection)warehouseEoList)) {
            LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)warehouseEoList.get(0);
            respDto.setSinceTheClosedLoop(Boolean.valueOf(CsValidFlagEnum.ENABLE.getCode().equals(csLogicWarehouseEo.getVirtualMatterFlag())));
        }
        logger.info("\u521b\u5efa\u6536\u8d27\u901a\u77e5\u5355\u3001\u5165\u5e93\u901a\u77e5\u5355\u5e76\u8fd4\u56dedto\u8fd4\u53c2\uff1a{}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)respDto));
        return respDto;
    }

    public String generateInResultOrder1(CsInOutOrderGenerateReqDto inOutOrderGenerateReqDto) {
        logger.info("generateInResultOrder==>\u521b\u5efa\u6536\u8d27\u7ed3\u679c\u5355\u3001\u5165\u5e93\u7ed3\u679c\u5355,inOutOrderGenerateReqDto:{}", (Object)LogUtils.buildLogContent(inOutOrderGenerateReqDto));
        this.checkParams(inOutOrderGenerateReqDto);
        String inNoticeOrderNo = inOutOrderGenerateReqDto.getInNoticeOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inNoticeOrderNo), "\u5165\u5e93\u901a\u77e5\u5355\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper InOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        InOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)inNoticeOrderNo);
        List InOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)InOutNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)InOutNoticeOrderEoList), "\u67e5\u8be2\u4e0d\u5230\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        logger.info("generateInResultOrder==>\u67e5\u8be2\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f,InOutNoticeOrderEoList:{}", (Object)LogUtils.buildLogContent(InOutNoticeOrderEoList));
        InOutNoticeOrderEo InOutNoticeOrderEo2 = (InOutNoticeOrderEo)InOutNoticeOrderEoList.get(0);
        String inResultOrderNo = this.createInResultOrderInfo(inOutOrderGenerateReqDto, InOutNoticeOrderEo2);
        logger.info("generateInResultOrder==>inResultOrderNo:{}", (Object)LogUtils.buildLogContent(inResultOrderNo));
        ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo = new ReceiveDeliveryResultOrderEo();
        String documentNo = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.DELIVERY_RESULT_ORDE.getCode()).getCode();
        csDeliveryResultOrderEo.setDocumentNo(documentNo);
        csDeliveryResultOrderEo.setPreOrderNo(inResultOrderNo);
        csDeliveryResultOrderEo.setRelevanceNo(InOutNoticeOrderEo2.getRelevanceNo());
        csDeliveryResultOrderEo.setBusinessType(CsPcpBusinessTypeEnum.AFTER_SALE.getCode());
        csDeliveryResultOrderEo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_AFTER_SALE.getCode());
        csDeliveryResultOrderEo.setOrderType("delivery");
        csDeliveryResultOrderEo.setOrderStatus(BaseOrderStatusEnum.DRO_DELIVERED.getCode());
        csDeliveryResultOrderEo.setDeliveryPhysicsWarehouseCode(InOutNoticeOrderEo2.getInPhysicsWarehouseCode());
        csDeliveryResultOrderEo.setDeliveryPhysicsWarehouseName(InOutNoticeOrderEo2.getInPhysicsWarehouseName());
        csDeliveryResultOrderEo.setDeliveryLogicWarehouseCode(InOutNoticeOrderEo2.getInLogicWarehouseCode());
        csDeliveryResultOrderEo.setDeliveryLogicWarehouseName(InOutNoticeOrderEo2.getInLogicWarehouseName());
        List detailReqDtoList = inOutOrderGenerateReqDto.getDetailReqDtoList();
        ArrayList deliveryResultOrderDetailEoList = Lists.newArrayList();
        for (CsInOutOrderGenerateDetailReqDto generateDetailReqDto : detailReqDtoList) {
            ReceiveDeliveryResultOrderDetailEo csDeliveryResultOrderDetailEo = new ReceiveDeliveryResultOrderDetailEo();
            csDeliveryResultOrderDetailEo.setDocumentNo(documentNo);
            csDeliveryResultOrderDetailEo.setRelevanceNo(InOutNoticeOrderEo2.getRelevanceNo());
            csDeliveryResultOrderDetailEo.setSkuCode(generateDetailReqDto.getSkuCode());
            csDeliveryResultOrderDetailEo.setSkuCode(generateDetailReqDto.getSkuCode());
            csDeliveryResultOrderDetailEo.setSkuName(generateDetailReqDto.getSkuName());
            csDeliveryResultOrderDetailEo.setOriginPlanQuantity(generateDetailReqDto.getQuantity());
            csDeliveryResultOrderDetailEo.setPlanQuantity(generateDetailReqDto.getQuantity());
            csDeliveryResultOrderDetailEo.setWaitQuantity(generateDetailReqDto.getQuantity());
            csDeliveryResultOrderDetailEo.setDoneQuantity(BigDecimal.ZERO);
            csDeliveryResultOrderDetailEo.setCancelQuantity(BigDecimal.ZERO);
            csDeliveryResultOrderDetailEo.setInitFlag(YesNoEnum.YES.getValue());
            csDeliveryResultOrderDetailEo.setItemStatus(CsPlannedOrderItemStatusEnum.COMMON.getCode());
            deliveryResultOrderDetailEoList.add(csDeliveryResultOrderDetailEo);
        }
        BigDecimal totalQuantity = detailReqDtoList.stream().map(CsInOutOrderGenerateDetailReqDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        csDeliveryResultOrderEo.setTotalQuantity(totalQuantity);
        csDeliveryResultOrderEo.setJumpDocumentType(InOutNoticeOrderEo2.getJumpDocumentType());
        csDeliveryResultOrderEo.setJumpDocumentName(InOutNoticeOrderEo2.getJumpDocumentName());
        csDeliveryResultOrderEo.setDisplayBusinessType(InOutNoticeOrderEo2.getDisplayBusinessType());
        csDeliveryResultOrderEo.setDisplayBusinessName(InOutNoticeOrderEo2.getDisplayBusinessName());
        csDeliveryResultOrderEo.setBusinessType(InOutNoticeOrderEo2.getBusinessType());
        logger.info("createInResultOrderInfo==>csDeliveryResultOrderEo:{},deliveryResultOrderDetailEoList:{}", (Object)LogUtils.buildLogContent(csDeliveryResultOrderEo), (Object)LogUtils.buildLogContent(deliveryResultOrderDetailEoList));
        this.receiveDeliveryResultOrderDomain.insert((BaseEo)csDeliveryResultOrderEo);
        this.receiveDeliveryResultOrderDetailDomain.insertBatch((List)deliveryResultOrderDetailEoList);
        return documentNo;
    }

    private String createInResultOrderInfo(CsInOutOrderGenerateReqDto inOutOrderGenerateReqDto, InOutNoticeOrderEo InOutNoticeOrderEo2) {
        InOutResultOrderEo InOutResultOrderEo2 = new InOutResultOrderEo();
        String documentNo = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.IN_RESULT_ORDER.getCode()).getCode();
        InOutResultOrderEo2.setDocumentNo(documentNo);
        InOutResultOrderEo2.setPreOrderNo(InOutNoticeOrderEo2.getDocumentNo());
        InOutResultOrderEo2.setRelevanceNo(InOutNoticeOrderEo2.getRelevanceNo());
        InOutResultOrderEo2.setBusinessType(CsPcpBusinessTypeEnum.AFTER_SALE.getCode());
        InOutResultOrderEo2.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_AFTER_SALE.getCode());
        InOutResultOrderEo2.setOrderType("in");
        InOutResultOrderEo2.setOrderStatus(BaseOrderStatusEnum.IRO_DONE_IN.getCode());
        InOutResultOrderEo2.setInPhysicsWarehouseCode(InOutNoticeOrderEo2.getInPhysicsWarehouseCode());
        InOutResultOrderEo2.setInPhysicsWarehouseName(InOutNoticeOrderEo2.getInPhysicsWarehouseName());
        InOutResultOrderEo2.setInLogicWarehouseCode(InOutNoticeOrderEo2.getInLogicWarehouseCode());
        InOutResultOrderEo2.setInLogicWarehouseName(InOutNoticeOrderEo2.getInLogicWarehouseName());
        List detailReqDtoList = inOutOrderGenerateReqDto.getDetailReqDtoList();
        ArrayList outResultOrderDetailEoList = Lists.newArrayList();
        for (CsInOutOrderGenerateDetailReqDto generateDetailReqDto : detailReqDtoList) {
            InOutResultOrderDetailEo csOutResultOrderDetailEo = new InOutResultOrderDetailEo();
            csOutResultOrderDetailEo.setDocumentNo(documentNo);
            csOutResultOrderDetailEo.setPreOrderNo(InOutNoticeOrderEo2.getDocumentNo());
            csOutResultOrderDetailEo.setRelevanceNo(InOutNoticeOrderEo2.getRelevanceNo());
            csOutResultOrderDetailEo.setSkuCode(generateDetailReqDto.getSkuCode());
            csOutResultOrderDetailEo.setSkuName(generateDetailReqDto.getSkuName());
            csOutResultOrderDetailEo.setOriginPlanQuantity(generateDetailReqDto.getQuantity());
            csOutResultOrderDetailEo.setPlanQuantity(generateDetailReqDto.getQuantity());
            csOutResultOrderDetailEo.setWaitQuantity(generateDetailReqDto.getQuantity());
            csOutResultOrderDetailEo.setDoneQuantity(BigDecimal.ZERO);
            csOutResultOrderDetailEo.setCancelQuantity(BigDecimal.ZERO);
            csOutResultOrderDetailEo.setInitFlag(YesNoEnum.YES.getValue());
            csOutResultOrderDetailEo.setItemStatus(CsPlannedOrderItemStatusEnum.COMMON.getCode());
            outResultOrderDetailEoList.add(csOutResultOrderDetailEo);
        }
        BigDecimal totalQuantity = detailReqDtoList.stream().map(CsInOutOrderGenerateDetailReqDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        InOutResultOrderEo2.setTotalQuantity(totalQuantity);
        InOutResultOrderEo2.setJumpDocumentType(InOutNoticeOrderEo2.getJumpDocumentType());
        InOutResultOrderEo2.setJumpDocumentName(InOutNoticeOrderEo2.getJumpDocumentName());
        InOutResultOrderEo2.setDisplayBusinessType(InOutNoticeOrderEo2.getDisplayBusinessType());
        InOutResultOrderEo2.setDisplayBusinessName(InOutNoticeOrderEo2.getDisplayBusinessName());
        InOutResultOrderEo2.setBusinessType(InOutNoticeOrderEo2.getBusinessType());
        logger.info("createInResultOrderInfo==>InOutResultOrderEo:{},outResultOrderDetailEoList:{}", (Object)LogUtils.buildLogContent(InOutResultOrderEo2), (Object)LogUtils.buildLogContent(outResultOrderDetailEoList));
        this.inOutResultOrderDomain.insert((BaseEo)InOutResultOrderEo2);
        this.inOutResultOrderDetailDomain.insertBatch((List)outResultOrderDetailEoList);
        return documentNo;
    }

    private void createDeliveryNoticeOrder(final CsInOutOrderGenerateReqDto inOutOrderGenerateReqDto, DataDictDto dictDto) {
        List detailReqDtoList = inOutOrderGenerateReqDto.getDetailReqDtoList();
        ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        receiveDeliveryNoticeOrderFacadeBo.setBusinessType(CsPcpBusinessTypeEnum.AFTER_SALE.getCode());
        receiveDeliveryNoticeOrderFacadeBo.setExternalOrderNo(inOutOrderGenerateReqDto.getPlatformOrderNo());
        receiveDeliveryNoticeOrderFacadeBo.setPreOrderNo(null);
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceNo(inOutOrderGenerateReqDto.getOrderNo());
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_AFTER_SALE);
        receiveDeliveryNoticeOrderFacadeBo.setLogicWarehouseCode(inOutOrderGenerateReqDto.getLogicWarehouseCode());
        receiveDeliveryNoticeOrderFacadeBo.setDisplayBusinessType(inOutOrderGenerateReqDto.getBasicDataBusinessType());
        receiveDeliveryNoticeOrderFacadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                CsBaseOrderAddressAddReqDto sendPersonAddressInfo;
                List baseOrderAddressEoList;
                boolean isInstanceof = context instanceof ReceiveDeliveryNoticeOrderContext;
                logger.info("beforeCallBack->context instanceof ReceiveDeliveryNoticeOrderContext:{}", (Object)JSON.toJSONString((Object)isInstanceof));
                if (!isInstanceof) {
                    return;
                }
                ReceiveDeliveryNoticeOrderContext context1 = (ReceiveDeliveryNoticeOrderContext)context;
                ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = context1.getReceiveDeliveryNoticeOrderEo();
                receiveDeliveryNoticeOrderEo.setShipmentEnterpriseCode(inOutOrderGenerateReqDto.getShipmentEnterpriseCode());
                receiveDeliveryNoticeOrderEo.setShipmentEnterpriseName(inOutOrderGenerateReqDto.getShipmentEnterpriseName());
                receiveDeliveryNoticeOrderEo.setShippingCode(inOutOrderGenerateReqDto.getShippingCode());
                receiveDeliveryNoticeOrderEo.setRepairOrderNo(inOutOrderGenerateReqDto.getOrderNo());
                receiveDeliveryNoticeOrderEo.setShopCode(inOutOrderGenerateReqDto.getShopCode());
                receiveDeliveryNoticeOrderEo.setShopName(inOutOrderGenerateReqDto.getShopName());
                String logicWarehouseCode = receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseCode();
                QueryWrapper csWarehouseAddressEoQueryWrapper = new QueryWrapper();
                csWarehouseAddressEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
                csWarehouseAddressEoQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
                csWarehouseAddressEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
                csWarehouseAddressEoQueryWrapper.eq((Object)"warehouse_code", (Object)logicWarehouseCode);
                List csWarehouseAddressEoList = CsInOutOrderExtServiceImpl.this.warehouseAddressDomain.getMapper().selectList((Wrapper)csWarehouseAddressEoQueryWrapper);
                logger.info("saveBaseOrderAddress==>\u552e\u540e\u76f8\u5173\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355\u4fdd\u5b58\u5730\u5740\u4fe1\u606f,csWarehouseAddressEoList:{}", (Object)LogUtils.buildLogContent(csWarehouseAddressEoList));
                List list = baseOrderAddressEoList = CollectionUtils.isNotEmpty((Collection)context1.getBaseOrderAddressEoList()) ? context1.getBaseOrderAddressEoList() : new ArrayList();
                if (CollectionUtils.isNotEmpty((Collection)csWarehouseAddressEoList)) {
                    WarehouseAddressEo csWarehouseAddressEo = (WarehouseAddressEo)csWarehouseAddressEoList.get(0);
                    BaseOrderAddressEo receiveCsBaseOrderAddressEo = new BaseOrderAddressEo();
                    receiveCsBaseOrderAddressEo.setDocumentNo(receiveDeliveryNoticeOrderEo.getDocumentNo());
                    receiveCsBaseOrderAddressEo.setOrderType(CsDocumentTypeEnum.RECEIVE_NOTICE_ORDER.getCode());
                    receiveCsBaseOrderAddressEo.setContactsType("consignee");
                    receiveCsBaseOrderAddressEo.setProvince(csWarehouseAddressEo.getProvince());
                    receiveCsBaseOrderAddressEo.setProvinceCode(csWarehouseAddressEo.getProvinceCode());
                    receiveCsBaseOrderAddressEo.setCity(csWarehouseAddressEo.getCity());
                    receiveCsBaseOrderAddressEo.setCityCode(csWarehouseAddressEo.getCityCode());
                    receiveCsBaseOrderAddressEo.setDistrict(csWarehouseAddressEo.getDistrict());
                    receiveCsBaseOrderAddressEo.setDistrictCode(csWarehouseAddressEo.getDistrictCode());
                    receiveCsBaseOrderAddressEo.setDetailAddress(csWarehouseAddressEo.getDetailAddress());
                    receiveCsBaseOrderAddressEo.setContacts(csWarehouseAddressEo.getContacts());
                    receiveCsBaseOrderAddressEo.setPhone(csWarehouseAddressEo.getPhone());
                    logger.info("saveBaseOrderAddress==>\u552e\u540e,\u6536\u8d27\u5730\u5740\u4fe1\u606f,\u76f8\u5173\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355\u4fdd\u5b58\u5730\u5740\u4fe1\u606f,receiveCsBaseOrderAddressEo:{}", (Object)LogUtils.buildLogContent(receiveCsBaseOrderAddressEo));
                    baseOrderAddressEoList.add(receiveCsBaseOrderAddressEo);
                }
                if (null != (sendPersonAddressInfo = inOutOrderGenerateReqDto.getSendPersonAddressInfo())) {
                    BaseOrderAddressEo csBaseOrderAddressEo = new BaseOrderAddressEo();
                    csBaseOrderAddressEo.setDocumentNo(receiveDeliveryNoticeOrderEo.getDocumentNo());
                    csBaseOrderAddressEo.setOrderType(CsDocumentTypeEnum.RECEIVE_NOTICE_ORDER.getCode());
                    csBaseOrderAddressEo.setContactsType("consignor");
                    csBaseOrderAddressEo.setProvince(sendPersonAddressInfo.getProvince());
                    csBaseOrderAddressEo.setEncryptProvince(sendPersonAddressInfo.getEncryptProvince());
                    csBaseOrderAddressEo.setProvinceCode(sendPersonAddressInfo.getProvinceCode());
                    csBaseOrderAddressEo.setEncryptProvinceCode(sendPersonAddressInfo.getEncryptProvinceCode());
                    csBaseOrderAddressEo.setCity(sendPersonAddressInfo.getCity());
                    csBaseOrderAddressEo.setEncryptCity(sendPersonAddressInfo.getEncryptCity());
                    csBaseOrderAddressEo.setCityCode(sendPersonAddressInfo.getCityCode());
                    csBaseOrderAddressEo.setEncryptCityCode(sendPersonAddressInfo.getEncryptCityCode());
                    csBaseOrderAddressEo.setDistrict(sendPersonAddressInfo.getDistrict());
                    csBaseOrderAddressEo.setEncryptDistrict(sendPersonAddressInfo.getEncryptDistrict());
                    csBaseOrderAddressEo.setDistrictCode(sendPersonAddressInfo.getDistrictCode());
                    csBaseOrderAddressEo.setEncryptDistrictCode(sendPersonAddressInfo.getEncryptDistrictCode());
                    csBaseOrderAddressEo.setDetailAddress(sendPersonAddressInfo.getDetailAddress());
                    csBaseOrderAddressEo.setEncryptDetailAddress(sendPersonAddressInfo.getEncryptDetailAddress());
                    csBaseOrderAddressEo.setContacts(sendPersonAddressInfo.getContacts());
                    csBaseOrderAddressEo.setEncryptContacts(sendPersonAddressInfo.getEncryptContacts());
                    csBaseOrderAddressEo.setPhone(sendPersonAddressInfo.getPhone());
                    csBaseOrderAddressEo.setEncryptPhone(sendPersonAddressInfo.getEncryptPhone());
                    csBaseOrderAddressEo.setOaid(sendPersonAddressInfo.getOaid());
                    logger.info("saveBaseOrderAddress==>\u552e\u540e,\u53d1\u8d27\u5730\u5740\u4fe1\u606f,\u521b\u5efa\u6536\u8d27\u901a\u77e5\u5355\u4fdd\u5b58\u5730\u5740\u4fe1\u606f,csBaseOrderAddressEo:{}", (Object)LogUtils.buildLogContent(csBaseOrderAddressEo));
                    baseOrderAddressEoList.add(csBaseOrderAddressEo);
                }
                context1.setBaseOrderAddressEoList(baseOrderAddressEoList);
            }

            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
        ArrayList deliveryNoticeOrderDetails = Lists.newArrayList();
        for (CsInOutOrderGenerateDetailReqDto detail : detailReqDtoList) {
            BaseOrderDetailReqDto detailReqDto = new BaseOrderDetailReqDto();
            detailReqDto.setPreOrderItemId(detail.getTradeOrderItemId());
            detailReqDto.setQuantity(BigDecimalUtils.abs((BigDecimal)detail.getQuantity()));
            detailReqDto.setSkuCode(detail.getSkuCode());
            detailReqDto.setSkuName(detail.getSkuName());
            deliveryNoticeOrderDetails.add(detailReqDto);
        }
        receiveDeliveryNoticeOrderFacadeBo.setOrderBasicsDetailReqDtoList((List)deliveryNoticeOrderDetails);
        this.baseOrderFacade.receiveNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
    }

    private RelWarehouseEo getRelPhysicsWarehouse(String logicWarehouseCode) {
        QueryWrapper csRelWarehouseEoQueryWrapper = new QueryWrapper();
        csRelWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csRelWarehouseEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        csRelWarehouseEoQueryWrapper.eq((Object)"warehouse_code", (Object)logicWarehouseCode);
        csRelWarehouseEoQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        csRelWarehouseEoQueryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        List csRelWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)csRelWarehouseEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csRelWarehouseEoList)) {
            return new RelWarehouseEo();
        }
        return (RelWarehouseEo)csRelWarehouseEoList.get(0);
    }

    private void checkParams(CsInOutOrderGenerateReqDto inOutOrderGenerateReqDto) {
        AssertUtil.isTrue(null != inOutOrderGenerateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String orderNo = inOutOrderGenerateReqDto.getOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String logicWarehouseCode = inOutOrderGenerateReqDto.getLogicWarehouseCode();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)logicWarehouseCode), "\u903b\u8f91\u4ed3\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List detailReqDtoList = inOutOrderGenerateReqDto.getDetailReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)detailReqDtoList), "\u5546\u54c1\u660e\u7ec6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (CsInOutOrderGenerateDetailReqDto generateDetailReqDto : detailReqDtoList) {
            String skuCode = generateDetailReqDto.getSkuCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)skuCode), "\u5546\u54c1sku\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal quantity = generateDetailReqDto.getQuantity();
            AssertUtil.isTrue(null != quantity, "\u5546\u54c1\u6570\u91cf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal itemPrice = generateDetailReqDto.getItemPrice();
            AssertUtil.isTrue(null != itemPrice, "\u5546\u54c1\u5355\u4ef7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String shipmentEnterpriseCode = inOutOrderGenerateReqDto.getShipmentEnterpriseCode();
        String shipmentEnterpriseName = inOutOrderGenerateReqDto.getShipmentEnterpriseName();
    }
}

