/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.dto.request.CsBasisOrderBusinessDataReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsBaseOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryResultOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryTotalCartonsRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasisOrderBusinessDataRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsDeliveryResultOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsDeliveryResultOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csDeliveryResultOrderQueryService")
public class CsDeliveryResultOrderQueryServiceImpl
implements ICsDeliveryResultOrderQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsDeliveryResultOrderQueryServiceImpl.class);
    @Autowired
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Autowired
    private IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Autowired
    private IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Autowired
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private CsCommonService csCommonService;
    @Resource
    private ICsBaseOrderQueryService csBaseOrderQueryService;

    @Override
    public ReceiveDeliveryResultOrderEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        return (ReceiveDeliveryResultOrderEo)BeanUtil.copyProperties((Object)this.receiveDeliveryResultOrderDomain.selectByPrimaryKey(id), ReceiveDeliveryResultOrderEo.class, (String[])new String[0]);
    }

    @Override
    public CsDeliveryResultOrderRespDto queryById(Long id) {
        List resultOrderEoList;
        String shippingJson;
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo = (ReceiveDeliveryResultOrderEo)this.receiveDeliveryResultOrderDomain.selectByPrimaryKey(id);
        AssertUtil.isTrue(csDeliveryResultOrderEo != null && csDeliveryResultOrderEo.getId() != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"document_no", (Object)csDeliveryResultOrderEo.getDocumentNo());
        List detailEoList = this.receiveDeliveryResultOrderDetailDomain.getMapper().selectList((Wrapper)wrapper);
        CsDeliveryResultOrderRespDto dto = new CsDeliveryResultOrderRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)csDeliveryResultOrderEo, (String[])new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)detailEoList)) {
            ArrayList orderDetailRespDtoList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)orderDetailRespDtoList, (Collection)detailEoList, CsDeliveryResultOrderDetailRespDto.class);
            dto.setDeliveryResultOrderDetailRespDtoList((List)orderDetailRespDtoList);
        }
        if (StringUtils.isNotBlank((CharSequence)(shippingJson = dto.getShippingJson()))) {
            try {
                List csWmsShippingInfoReqDtoList = JSON.parseArray((String)shippingJson, CsWmsShippingInfoReqDto.class);
                logger.info("queryVersionSecondByDocumentNo==>\u5355\u53f7:{},\u7269\u6d41\u4fe1\u606f\u96c6\u5408,csWmsShippingInfoReqDtoList:{}", (Object)dto.getDocumentNo(), (Object)LogUtils.buildLogContent(csWmsShippingInfoReqDtoList));
                dto.setShippingInfoList(csWmsShippingInfoReqDtoList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)csDeliveryResultOrderEo.getExtension())) {
            try {
                ContactDto contactDto = (ContactDto)JSON.parseObject((String)csDeliveryResultOrderEo.getExtension(), ContactDto.class);
                dto.setContactDto(contactDto);
            }
            catch (Exception ex) {
                logger.info("\u6355\u83b7\u5f02\u5e38\uff0c\u903b\u8f91\u4e0d\u5904\u7406\uff1a\u524d\u7f6e\u5355\u636e\u6536\u8d27\u4fe1\u606f\u9519\u8bef");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(resultOrderEoList = this.receiveDeliveryNoticeOrderDomain.queryDeliveryNotice(csDeliveryResultOrderEo.getRelevanceNo())))) {
            List noticeNo = resultOrderEoList.stream().map(ReceiveDeliveryNoticeOrderEo::getDocumentNo).collect(Collectors.toList());
            dto.setNoticeNo(noticeNo);
        }
        return dto;
    }

    @Override
    public CsDeliveryResultOrderRespDto queryByDocumentNo(String documentNo) {
        List list = this.receiveDeliveryResultOrderDomain.queryByDocumentNo(documentNo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)list), "\u5355\u53f7\u4e0d\u5b58\u5728");
        return this.queryById(((ReceiveDeliveryResultOrderEo)list.get(0)).getId());
    }

    @Override
    public CsDeliveryResultOrderRespDto queryByPreOrderNo(String preOrderNo) {
        List list = this.receiveDeliveryResultOrderDomain.queryByPreOrderNo(preOrderNo);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return this.queryById(((ReceiveDeliveryResultOrderEo)list.get(0)).getId());
    }

    @Override
    public PageInfo<CsDeliveryResultOrderRespDto> queryByPage(CsDeliveryResultOrderQueryDto queryDto) {
        logger.info("\u83b7\u53d6\u53d1\u8d27\u7ed3\u679c\u5355-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        QueryWrapper wrapper = new QueryWrapper();
        Long organizationId = this.csCommonService.getUserOrganizationId();
        if (null != organizationId) {
            wrapper.eq((Object)"organization_id", (Object)organizationId);
        }
        if (StringUtil.isNotBlank((String)queryDto.getBusinessType())) {
            wrapper.eq((Object)"business_type", (Object)queryDto.getBusinessType());
        }
        if (StringUtil.isNotBlank((String)queryDto.getOrderStatus())) {
            wrapper.eq((Object)"order_status", (Object)queryDto.getOrderStatus());
        }
        if (StringUtil.isNotBlank((String)queryDto.getPreOrderNo())) {
            wrapper.eq((Object)"pre_order_no", (Object)queryDto.getPreOrderNo());
        }
        if (StringUtil.isNotBlank((String)queryDto.getExternalOrderNo())) {
            wrapper.eq((Object)"external_order_no", (Object)queryDto.getExternalOrderNo());
        }
        if (StringUtil.isNotBlank((String)queryDto.getDocumentNo())) {
            wrapper.like((Object)"document_no", (Object)queryDto.getDocumentNo());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseName())) {
            wrapper.like((Object)"warehouse_name", (Object)queryDto.getWarehouseName());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseCode())) {
            wrapper.like((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtil.isNotBlank((String)queryDto.getCreateTimeStart()) && StringUtil.isNotBlank((String)queryDto.getCreateTimeEnd())) {
            wrapper.between((Object)"create_time", (Object)queryDto.getCreateTimeStart(), (Object)queryDto.getCreateTimeEnd());
        }
        if (Objects.nonNull(queryDto.getIsExpress())) {
            if (YesNoEnum.NO.getValue().equals(queryDto.getIsExpress())) {
                wrapper.isNull((Object)"shipping_code");
            } else {
                wrapper.isNotNull((Object)"shipping_code");
            }
        }
        wrapper.orderByDesc((Object)queryDto.getOrderByDesc());
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.receiveDeliveryResultOrderDomain.getMapper().selectList((Wrapper)wrapper);
        PageInfo info = new PageInfo(list);
        List rList = list.stream().map(t -> {
            CsDeliveryResultOrderRespDto dto = new CsDeliveryResultOrderRespDto();
            try {
                BeanUtils.copyProperties((Object)t, (Object)dto);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return dto;
        }).collect(Collectors.toList());
        PageInfo result = new PageInfo(rList);
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList(rList);
        logger.info("\u83b7\u53d6\u53d1\u8d27\u7ed3\u679c\u5355-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    @Override
    public List<ReceiveDeliveryResultOrderEo> queryByRelevanceNo(String relevanceNo) {
        List resultOrderEoList = this.receiveDeliveryResultOrderDomain.queryByRelevanceNo(relevanceNo);
        return BeanUtil.copyToList((Collection)resultOrderEoList, ReceiveDeliveryResultOrderEo.class);
    }

    @Override
    public PageInfo<CsDeliveryResultOrderDetailRespDto> queryDetailPage(CsDeliveryResultOrderQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto, "pageNum", "pageSize"));
        AssertUtil.emptyValidated(queryDto, "pageNum", "pageSize");
        if (StringUtil.isNotBlank((String)queryDto.getIdentification()) && queryDto.getIdentification().equals("identification")) {
            List dtoList = this.receiveDeliveryResultOrderDetailDomain.queryPage(queryDto);
            for (CsDeliveryResultOrderDetailRespDto respDto : dtoList) {
                respDto.setCargoCode(respDto.getSkuCode());
                respDto.setLongCode(respDto.getSkuCode());
                respDto.setCargoName(respDto.getSkuName());
            }
            return new PageInfo(dtoList);
        }
        ReceiveDeliveryResultOrderDetailEo eo = new ReceiveDeliveryResultOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)queryDto, (BaseEo)eo);
        PageInfo csDeliveryResultOrderEoPageInfo = this.receiveDeliveryResultOrderDetailDomain.selectPage((BaseEo)eo, queryDto.getPageNum(), queryDto.getPageSize());
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)csDeliveryResultOrderEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List<Object> list = Lists.newArrayList();
        if (Objects.nonNull(csDeliveryResultOrderEoPageInfo) && CollectionUtils.isNotEmpty((Collection)csDeliveryResultOrderEoPageInfo.getList())) {
            list = csDeliveryResultOrderEoPageInfo.getList().stream().map(e -> {
                CsDeliveryResultOrderDetailRespDto respDto = new CsDeliveryResultOrderDetailRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)e, (String[])new String[0]);
                respDto.setCargoCode(e.getSkuCode());
                respDto.setLongCode(e.getSkuCode());
                respDto.setCargoName(e.getSkuName());
                respDto.setSnCodeList((List)(StringUtils.isNotEmpty((CharSequence)e.getSnCode()) ? Arrays.asList(e.getSnCode().split(",")) : Lists.newArrayList()));
                respDto.setShippingCodeList((List)(StringUtils.isNotEmpty((CharSequence)e.getShippingCode()) ? Arrays.asList(e.getShippingCode().split(",")) : Lists.newArrayList()));
                return respDto;
            }).collect(Collectors.toList());
        }
        pageInfo.setList((List)list);
        return pageInfo;
    }

    @Override
    public List<CsDeliveryResultOrderRespDto> queryByOrderNo(String orderNo) {
        AssertUtil.isTrue(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orderNo}), "\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"pre_order_no", (Object)orderNo);
        List eoList = this.receiveDeliveryResultOrderDomain.getMapper().selectList((Wrapper)wrapper);
        ArrayList dtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eoList, (Collection)dtoList, CsDeliveryResultOrderRespDto.class);
        return dtoList;
    }

    @Override
    public CsDeliveryResultOrderRespDto queryVersionSecondByDocumentNo(String documentNo) {
        QueryWrapper deliveryResultOrderQueryWrapper = new QueryWrapper();
        deliveryResultOrderQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        deliveryResultOrderQueryWrapper.eq((Object)"dr", (Object)0);
        deliveryResultOrderQueryWrapper.eq((Object)"order_type", (Object)"delivery");
        List list = this.receiveDeliveryResultOrderDomain.getMapper().selectList((Wrapper)deliveryResultOrderQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)list), "\u5355\u53f7\u4e0d\u5b58\u5728");
        ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo = (ReceiveDeliveryResultOrderEo)list.get(0);
        AssertUtil.isTrue(csDeliveryResultOrderEo != null && csDeliveryResultOrderEo.getId() != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"document_no", (Object)csDeliveryResultOrderEo.getDocumentNo());
        CsDeliveryResultOrderRespDto dto = new CsDeliveryResultOrderRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)csDeliveryResultOrderEo, (String[])new String[0]);
        dto.setWarehouseCode(csDeliveryResultOrderEo.getDeliveryLogicWarehouseCode());
        dto.setWarehouseName(csDeliveryResultOrderEo.getDeliveryLogicWarehouseName());
        dto.setReceiveWarehouseCode(csDeliveryResultOrderEo.getReceiveLogicWarehouseCode());
        dto.setReceiveWarehouseName(csDeliveryResultOrderEo.getReceiveLogicWarehouseName());
        String shippingJson = csDeliveryResultOrderEo.getShippingJson();
        if (StringUtils.isNotBlank((CharSequence)shippingJson)) {
            try {
                List csWmsShippingInfoReqDtoList = JSON.parseArray((String)shippingJson, CsWmsShippingInfoReqDto.class);
                logger.info("queryVersionSecondByDocumentNo==>\u5355\u53f7:{},\u7269\u6d41\u4fe1\u606f\u96c6\u5408,csWmsShippingInfoReqDtoList:{}", (Object)csDeliveryResultOrderEo.getDocumentNo(), (Object)LogUtils.buildLogContent(csWmsShippingInfoReqDtoList));
                dto.setShippingInfoList(csWmsShippingInfoReqDtoList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        CsBasisOrderBusinessDataReqDto dataReqDto = new CsBasisOrderBusinessDataReqDto();
        CubeBeanUtils.copyProperties((Object)dataReqDto, (Object)dto, (String[])new String[0]);
        CsBasisOrderBusinessDataRespDto dataRespDto = this.csBaseOrderQueryService.deliveryReceiveResultBuildRelOrderInfo(dataReqDto, "delivery", "out");
        if (Objects.nonNull(dataRespDto)) {
            dto.setContactDto(dataRespDto.getContactDto());
            dto.setRelOrderInfoList(dataRespDto.getRelOrderInfoList());
        }
        BigDecimal skuNum = this.csBaseOrderQueryService.queryItemMapByDeliveryReceiveResultDocumentNo(dto.getDocumentNo());
        dto.setSkuNum(skuNum);
        this.buildWarehouseInfo(dto);
        return dto;
    }

    @Override
    public CsDeliveryTotalCartonsRespDto queryTotalCartons(String orderNo) {
        logger.info("queryTotalCartons==>\u6839\u636e\u8ba2\u5355\u53f7\u67e5\u8be2\u6536\u8d27\u7ed3\u679c\u5355\u5173\u8054\u7684\u603b\u7bb1\u6570\u3001\u62fc\u7bb1\u6570\u4fe1\u606f,orderNo:{}", (Object)LogUtils.buildLogContent(orderNo));
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        CsDeliveryTotalCartonsRespDto resultDto = new CsDeliveryTotalCartonsRespDto();
        resultDto.setTotalCartons(BigDecimal.ZERO);
        resultDto.setMergeQuantity(BigDecimal.ZERO);
        resultDto.setOrderNo(orderNo);
        QueryWrapper csDeliveryResultOrderEoQueryWrapper = new QueryWrapper();
        csDeliveryResultOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csDeliveryResultOrderEoQueryWrapper.eq((Object)"order_status", (Object)BaseOrderStatusEnum.DRO_DELIVERED.getCode());
        csDeliveryResultOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)orderNo);
        List csDeliveryResultOrderEoList = this.receiveDeliveryResultOrderDomain.getMapper().selectList((Wrapper)csDeliveryResultOrderEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csDeliveryResultOrderEoList)) {
            return resultDto;
        }
        BigDecimal totalCartons = csDeliveryResultOrderEoList.stream().map(ReceiveDeliveryResultOrderEo::getTotalCartons).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalMergeQuantity = csDeliveryResultOrderEoList.stream().map(ReceiveDeliveryResultOrderEo::getMergeQuantity).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        resultDto.setTotalCartons(totalCartons);
        resultDto.setMergeQuantity(totalMergeQuantity);
        logger.info("queryTotalCartons==>\u8ba1\u7b97\u7d2f\u8ba1\u7684\u62fc\u7bb1\u6570\u3001\u603b\u7bb1\u6570,resultDto:{}", (Object)LogUtils.buildLogContent(resultDto));
        return resultDto;
    }

    @Override
    public CsDeliveryReceiveResultRespDto queryDeliveryReceiveResultDetail(CsDeliveryResultOrderQueryDto queryDto) {
        logger.info("\u67e5\u8be2\u6536\u53d1\u8d27\u8d27\u7ed3\u679c\u5355\u4fe1\u606f\u53ca\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        ReceiveDeliveryResultOrderEo params = new ReceiveDeliveryResultOrderEo();
        DtoHelper.dto2Eo((BaseVo)queryDto, (BaseEo)params);
        ReceiveDeliveryResultOrderEo eo = (ReceiveDeliveryResultOrderEo)this.receiveDeliveryResultOrderDomain.selectOne((BaseEo)params);
        if (ObjectUtil.isEmpty((Object)eo)) {
            return null;
        }
        ReceiveDeliveryResultOrderDetailEo detailParams = new ReceiveDeliveryResultOrderDetailEo();
        detailParams.setDocumentNo(eo.getDocumentNo());
        List detailEos = this.receiveDeliveryResultOrderDetailDomain.selectList((BaseEo)detailParams);
        if (CollectionUtil.isEmpty((Collection)detailEos)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u7ed3\u679c\u660e\u7ec6");
        }
        CsDeliveryReceiveResultRespDto csDeliveryReceiveResultRespDto = new CsDeliveryReceiveResultRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)csDeliveryReceiveResultRespDto);
        List deliveryReceiveResultDetails = detailEos.stream().map(e -> {
            CsDeliveryReceiveResultDetailRespDto respDto = new CsDeliveryReceiveResultDetailRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)e, (String[])new String[0]);
            respDto.setCargoCode(e.getSkuCode());
            respDto.setLongCode(e.getSkuCode());
            respDto.setCargoName(e.getSkuName());
            return respDto;
        }).collect(Collectors.toList());
        csDeliveryReceiveResultRespDto.setDeliveryReceiveResultDetailRespDtoList(deliveryReceiveResultDetails);
        return csDeliveryReceiveResultRespDto;
    }

    @Override
    public List<CsDeliveryResultOrderRespDto> queryByParam(CsDeliveryResultOrderQueryDto queryDto) {
        logger.info("\u6536\u53d1\u7ed3\u679c\u5355\u5217\u8868\u67e5\u8be2");
        ReceiveDeliveryResultOrderEo queryEo = new ReceiveDeliveryResultOrderEo();
        DtoHelper.dto2Eo((BaseVo)queryDto, (BaseEo)queryEo);
        if (StringUtil.isBlank((String)queryEo.getRelevanceNo()) && StringUtil.isBlank((String)queryEo.getPreOrderNo()) && StringUtil.isBlank((String)queryEo.getWmsOrderNo())) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
        }
        List select = this.receiveDeliveryResultOrderDomain.selectList((BaseEo)queryEo);
        ArrayList<CsDeliveryResultOrderRespDto> list = new ArrayList<CsDeliveryResultOrderRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            DtoHelper.eoList2DtoList((Collection)select, list, CsDeliveryResultOrderRespDto.class);
        }
        return list;
    }

    private void buildWarehouseInfo(CsDeliveryResultOrderRespDto dto) {
        LogicWarehouseEo receiveLogicWarehouseEo;
        String receiveWarehouseCode;
        ArrayList warehouseList = Lists.newArrayList();
        String warehouseCode = dto.getWarehouseCode();
        if (StringUtils.isNotBlank((CharSequence)warehouseCode)) {
            warehouseList.add(warehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(receiveWarehouseCode = dto.getReceiveWarehouseCode()))) {
            warehouseList.add(receiveWarehouseCode);
        }
        if (CollectionUtils.isEmpty((Collection)warehouseList)) {
            return;
        }
        Map<String, LogicWarehouseEo> logicWarehouseEoMap = this.getLogicWarehouseEoMap(warehouseList);
        LogicWarehouseEo LogicWarehouseEo2 = logicWarehouseEoMap.get(warehouseCode);
        if (null != LogicWarehouseEo2) {
            dto.setWarehouseName(LogicWarehouseEo2.getWarehouseName());
        }
        if (null != (receiveLogicWarehouseEo = logicWarehouseEoMap.get(receiveWarehouseCode))) {
            dto.setReceiveWarehouseName(receiveLogicWarehouseEo.getWarehouseName());
        }
    }

    public Map<String, LogicWarehouseEo> getLogicWarehouseEoMap(List<String> warehouseList) {
        QueryWrapper LogicWarehouseEoQueryWrapper = new QueryWrapper();
        LogicWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        LogicWarehouseEoQueryWrapper.in((Object)"warehouse_code", warehouseList);
        LogicWarehouseEoQueryWrapper.eq((Object)"warehouse_status", (Object)CsValidFlagEnum.ENABLE.getCode());
        List LogicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)LogicWarehouseEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)LogicWarehouseEoList)) {
            return Maps.newHashMap();
        }
        Map<String, LogicWarehouseEo> logicWarehouseEoMap = LogicWarehouseEoList.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity()));
        return logicWarehouseEoMap;
    }
}

