/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.SimpleGenerateCodeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogicInventoryExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.DateUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsTransferOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutNoticeOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.BasicsOrderOperateTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csOutNoticeOrderService")
public class CsOutNoticeOrderServiceImpl
implements ICsOutNoticeOrderService {
    private static final Logger logger = LoggerFactory.getLogger(CsOutNoticeOrderServiceImpl.class);
    @Resource
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    ICalcInventoryService calcInventoryService;
    @Resource
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    ICsDeliveryNoticeOrderQueryService csDeliveryNoticeOrderQueryService;
    @Resource
    ICsRelWarehouseQueryService csRelWarehouseQueryService;
    @Resource
    SimpleGenerateCodeUtil simpleGenerateCodeUtil;
    @Resource
    ICsOutNoticeOrderQueryService csOutNoticeOrderQueryService;
    @Resource
    RepeatFilter repeatFilter;
    @Autowired
    CsTransferOrderMapper csTransferOrderMapper;
    @Autowired
    IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Autowired
    ICsDeliveryNoticeOrderService csDeliveryNoticeOrderService;
    @Autowired
    ICacheService cacheService;
    @Resource
    private ICsLogicInventoryExposedService csLogicInventoryExposedService;

    @Override
    public Long add(CsOutNoticeOrderAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        InOutNoticeOrderEo insertEo = new InOutNoticeOrderEo();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.inOutNoticeOrderDomain.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public void update(Long id, CsOutNoticeOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        InOutNoticeOrderEo updateEo = new InOutNoticeOrderEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.inOutNoticeOrderDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        InOutNoticeOrderEo eo = this.csOutNoticeOrderQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        this.inOutNoticeOrderDomain.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createOutNoticeOrder(String relevanceNo) {
        this.repeatFilter.checkRepeat("OutNotice:" + relevanceNo, () -> this.preValid(relevanceNo), true);
        CsDeliveryNoticeOrderRespDto dto = this.csDeliveryNoticeOrderQueryService.queryByDocumentNo(relevanceNo);
        List<RelWarehouseEo> csRelWarehouseEos = this.csRelWarehouseQueryService.queryByRefWarehouseCode(dto.getWarehouseCode(), dto.getWarehouseClassify());
        for (RelWarehouseEo relWarehouseEo : csRelWarehouseEos) {
            if (CsWarehouseClassifyEnum.PHYSICS.getCode().equals(relWarehouseEo.getWarehouseClassify())) {
                dto.setDeliveryPhysicsWarehouseCode(relWarehouseEo.getWarehouseCode());
                dto.setDeliveryPhysicsWarehouseName(relWarehouseEo.getWarehouseName());
            }
            if (!CsWarehouseClassifyEnum.LOGIC.getCode().equals(relWarehouseEo.getWarehouseClassify())) continue;
            dto.setWarehouseId(relWarehouseEo.getWarehouseId());
            dto.setWarehouseCode(relWarehouseEo.getWarehouseCode());
            dto.setWarehouseName(relWarehouseEo.getWarehouseName());
        }
        InOutNoticeOrderEo InOutNoticeOrderEo2 = new InOutNoticeOrderEo();
        CubeBeanUtils.copyProperties((Object)InOutNoticeOrderEo2, (Object)dto, (String[])new String[]{"id"});
        CsGenerateCodeEnum generateCodeEnum = this.simpleGenerateCodeUtil.pcpGenerateCode("401");
        String documentNo = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.OUT_NOTICE_ORDER.getCode()).getCode();
        String orderStatus = generateCodeEnum.getStatus();
        InOutNoticeOrderEo2.setDocumentNo(documentNo);
        InOutNoticeOrderEo2.setOrderStatus(orderStatus);
        InOutNoticeOrderEo2.setRelevanceNo(relevanceNo);
        InOutNoticeOrderEo2.setExternalOrderNo(dto.getExternalOrderNo());
        InOutNoticeOrderEo2.setExtension(JSON.toJSONString((Object)dto.getContactDto()));
        this.inOutNoticeOrderDomain.insert((BaseEo)InOutNoticeOrderEo2);
        ArrayList detailEoList = Lists.newArrayList();
        for (CsDeliveryNoticeOrderDetailRespDto detailRespDto : dto.getDeliveryNoticeOrderDetailRespDtoList()) {
            InOutNoticeOrderDetailEo detailEo = new InOutNoticeOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)dto, (String[])new String[]{"id"});
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailRespDto, (String[])new String[]{"id"});
            detailEo.setDocumentNo(documentNo);
            detailEo.setRelevanceNo(relevanceNo);
            detailEoList.add(detailEo);
        }
        this.inOutNoticeOrderDetailDomain.insertBatch((List)detailEoList);
        return InOutNoticeOrderEo2.getId();
    }

    @Override
    public void cancelOutNoticeOrderByPreOrderNo(String preOrderNo) {
        QueryWrapper updateWrapper = new QueryWrapper();
        updateWrapper.eq((Object)"relevance_no", (Object)preOrderNo);
        updateWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List inOutNoticeOrderEos = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)updateWrapper);
        if (CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEos)) {
            for (InOutNoticeOrderEo inOutNoticeOrderEo : inOutNoticeOrderEos) {
                inOutNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.ONO_CANCEL.getCode());
                this.inOutNoticeOrderDomain.getMapper().updateById((BaseEo)inOutNoticeOrderEo);
            }
        }
    }

    @Override
    public void cancelOutNoticeOrderByPreOrderNo2(String preOrderNo) {
        List inOutNoticeOrderEos = this.inOutNoticeOrderDomain.queryByPreOrderNo(preOrderNo);
        if (CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEos)) {
            for (InOutNoticeOrderEo inOutNoticeOrderEo : inOutNoticeOrderEos) {
                inOutNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.DELIVERY_CANCEL.getCode());
                this.inOutNoticeOrderDomain.getMapper().updateById((BaseEo)inOutNoticeOrderEo);
            }
        }
    }

    @Override
    public String getConsignmentNo(String transferNo) {
        CsTransferOrderEo csTransferOrderEo = (CsTransferOrderEo)this.csTransferOrderMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"transfer_order_no", (Object)transferNo)).eq((Object)"dr", (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(csTransferOrderEo, "\u8c03\u62e8\u5355\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[0]);
        String physicsWarehouseCode = csTransferOrderEo.getOutPhysicsWarehouseCode();
        AssertUtil.assertNotBlank(physicsWarehouseCode, "\u8c03\u62e8\u5355\u51fa\u5e93\u7269\u7406\u4ed3\u4fe1\u606f\u7f3a\u5931", new Object[0]);
        return this.getConsignmentNoByPhysicsWarehouse(physicsWarehouseCode);
    }

    @Override
    public String getConsignmentNoByPhysicsWarehouse(String physicsWarehouseCode) {
        if (StringUtils.isBlank((CharSequence)physicsWarehouseCode)) {
            logger.info("\u7269\u7406\u4ed3\u7f16\u7801\u4e3a\u7a7a\uff01");
            return "";
        }
        PhysicsWarehouseEo csPhysicsWarehouseEo = (PhysicsWarehouseEo)this.physicsWarehouseDomain.getMapper().selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"warehouse_code", (Object)physicsWarehouseCode)).eq((Object)"dr", (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(csPhysicsWarehouseEo, "\u7269\u7406\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728", new Object[0]);
        String logisticsFlag = csPhysicsWarehouseEo.getLogisticsFlag();
        AssertUtil.assertNotBlank(logisticsFlag, "\u7269\u7406\u4ed3\u7269\u6d41\u6807\u8bb0\u4e3a\u7a7a: %s", physicsWarehouseCode);
        StringBuffer consignmentNoBuffer = new StringBuffer();
        consignmentNoBuffer.append(logisticsFlag);
        String dateStr = DateUtils.formatDate(new Date(), "yyyyMMdd");
        consignmentNoBuffer.append(dateStr);
        String cacheKey = "CsOutNoticeOrderApiImpl_getConsignmentNo_" + logisticsFlag + dateStr;
        Long incur = this.cacheService.incrBy(cacheKey, 1L);
        logger.info("getConsignmentNo: redis key : {}, \u81ea\u589e\u7ed3\u679c: {}", (Object)cacheKey, (Object)incur);
        if (Objects.equals(incur, 1L)) {
            this.cacheService.expire(cacheKey, 86410);
        }
        int appendZeroSize = 7 - incur.toString().length();
        for (int i = 0; i < appendZeroSize; ++i) {
            consignmentNoBuffer.append("0");
        }
        consignmentNoBuffer.append(incur);
        consignmentNoBuffer.append("P");
        return consignmentNoBuffer.toString();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String finishByDocumentNo(String documentNo) {
        ReceiveDeliveryNoticeOrderEo csDeliveryNoticeOrderRespDto = (ReceiveDeliveryNoticeOrderEo)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"document_no", (Object)documentNo)).one();
        if (csDeliveryNoticeOrderRespDto == null) {
            throw new BizException("\u51fa\u5e93\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        }
        if (BasicsOrderOperateTypeEnum.RECEIVE.getCode().equalsIgnoreCase(csDeliveryNoticeOrderRespDto.getOrderType())) {
            AssertUtil.isTrue(BaseOrderStatusEnum.RNO_WAIT_RECEIVE.getCode().equalsIgnoreCase(csDeliveryNoticeOrderRespDto.getOrderStatus()) || BaseOrderStatusEnum.RNO_PORTION_RECEIVE.getCode().equalsIgnoreCase(csDeliveryNoticeOrderRespDto.getOrderStatus()), "\u6536\u8d27\u901a\u77e5\u5355\u72b6\u6001\u4e0d\u6b63\u786e\u53ea\u6709\u5f85\u6536\u8d27/\u90e8\u5206\u6536\u8d27\u624d\u80fd\u5b8c\u7ed3!");
        }
        if (BasicsOrderOperateTypeEnum.DELIVERY.getCode().equalsIgnoreCase(csDeliveryNoticeOrderRespDto.getOrderType())) {
            AssertUtil.isTrue(BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode().equalsIgnoreCase(csDeliveryNoticeOrderRespDto.getOrderStatus()) || BaseOrderStatusEnum.DNO_PORTION_DELIVERY.getCode().equalsIgnoreCase(csDeliveryNoticeOrderRespDto.getOrderStatus()), "\u53d1\u8d27\u901a\u77e5\u5355\u72b6\u6001\u4e0d\u6b63\u786e\u53ea\u6709\u5f85\u51fa\u5e93/\u90e8\u5206\u51fa\u5e93\u624d\u80fd\u5b8c\u7ed3!");
        }
        AssertUtil.isTrue(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equalsIgnoreCase(csDeliveryNoticeOrderRespDto.getRelevanceTableName()), "\u975e\u8c03\u62e8\u5355\u5355\u636e\u4e0d\u5141\u8bb8\u5173\u95ed");
        List inOutNoticeOrderEos = this.inOutNoticeOrderDomain.queryByPreOrderNo(documentNo);
        if (CollectionUtils.isEmpty((Collection)inOutNoticeOrderEos)) {
            throw new BizException("1000", "\u51fa\u5165\u5e93\u5355\u636e\u4e0d\u5b58\u5728");
        }
        InOutNoticeOrderEo csOutNoticeOrderRespDtos = (InOutNoticeOrderEo)inOutNoticeOrderEos.get(0);
        this.csDeliveryNoticeOrderService.cancelByDocumentNo(documentNo);
        return null;
    }

    private void preValid(String relevanceNo) {
        List oldList = this.inOutNoticeOrderDomain.queryByRelevanceNo(relevanceNo);
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (InOutNoticeOrderEo outNoticeOrderEo : oldList) {
                AssertUtil.isTrue(BaseOrderStatusEnum.DELIVERY_CANCEL.getCode().equals(outNoticeOrderEo.getOrderStatus()), "304", outNoticeOrderEo.getPreOrderNo() + "\u5df2\u5b58\u5728\u6d41\u8f6c\u6b63\u5e38\u7684\u524d\u7f6e\u5355\u636e");
            }
        }
    }
}

