/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.SimpleGenerateCodeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryPreemptionService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.IPcpDeliveryResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.IPcpOutResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryCoverInventoryFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsVersionDistinguishEnum;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcpOutResultOrderServiceImpl")
public class PcpOutResultOrderServiceImpl
implements IPcpOutResultOrderService {
    private static Logger logger = LoggerFactory.getLogger(PcpOutResultOrderServiceImpl.class);
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Autowired
    private ICsOutResultOrderQueryService csOutResultOrderQueryService;
    @Resource
    private SimpleGenerateCodeUtil simpleGenerateCodeUtil;
    @Resource
    private RepeatFilter repeatFilter;
    @Resource
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    private ICsInventoryPreemptionService csInventoryPreemptionService;
    @Resource
    private IPcpDeliveryResultOrderService pcpDeliveryResultOrderService;
    @Resource
    private ICsDeliveryResultOrderQueryService csDeliveryResultOrderQueryService;
    @Resource
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CsOutResultOrderAddReqDto addReqDto) {
        logger.info("\u521b\u5efa\u51fa\u5e93\u7ed3\u679c\u5355\uff1a[addReqDto:{}]", (Object)LogUtils.buildLogContent(addReqDto));
        this.repeatFilter.checkRepeat("OutResult:" + addReqDto.getPreOrderNo(), () -> this.preValid(addReqDto), true);
        this.dataValid(addReqDto);
        InOutResultOrderEo outResultOrderEo = new InOutResultOrderEo();
        CubeBeanUtils.copyProperties((Object)outResultOrderEo, (Object)addReqDto, (String[])new String[0]);
        CsGenerateCodeEnum generateCodeEnum = this.simpleGenerateCodeUtil.pcpGenerateCode("402");
        String documentNo = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.OUT_RESULT_ORDER.getCode()).getCode();
        String orderStatus = generateCodeEnum.getStatus();
        outResultOrderEo.setDocumentNo(documentNo);
        if (StringUtils.isBlank((CharSequence)outResultOrderEo.getOrderStatus())) {
            outResultOrderEo.setOrderStatus(orderStatus);
        }
        outResultOrderEo.setExtension(JSON.toJSONString((Object)addReqDto.getContactDto()));
        outResultOrderEo.setOutLogicWarehouseCode(addReqDto.getOutLogicWarehouseCode());
        outResultOrderEo.setOutLogicWarehouseName(addReqDto.getOutLogicWarehouseName());
        outResultOrderEo.setOutPhysicsWarehouseCode(addReqDto.getOutPhysicsWarehouseCode());
        outResultOrderEo.setOutPhysicsWarehouseName(addReqDto.getOutPhysicsWarehouseName());
        outResultOrderEo.setOrderType("out");
        this.inOutResultOrderDomain.insert((BaseEo)outResultOrderEo);
        ArrayList detailEoList = Lists.newArrayList();
        for (CsOutResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            InOutResultOrderDetailEo detailEo = new InOutResultOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)addReqDto, (String[])new String[]{"id"});
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailAddReqDto, (String[])new String[]{"id"});
            detailEo.setDocumentNo(documentNo);
            detailEo.setSkuCode(detailAddReqDto.getLongCode());
            detailEoList.add(detailEo);
        }
        this.inOutResultOrderDetailDomain.insertBatch((List)detailEoList);
        return outResultOrderEo.getId();
    }

    private void preValid(CsOutResultOrderAddReqDto addReqDto) {
        List oldList = this.inOutResultOrderDomain.queryByPreOrderNo(addReqDto.getPreOrderNo());
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (InOutResultOrderEo InOutResultOrderEo2 : oldList) {
                AssertUtil.isTrue(BaseOrderStatusEnum.DELIVERY_CANCEL.getCode().equals(InOutResultOrderEo2.getOrderStatus()), "304", InOutResultOrderEo2.getPreOrderNo() + "\u5df2\u5b58\u5728\u6d41\u8f6c\u6b63\u5e38\u7684\u524d\u7f6e\u5355\u636e");
            }
        }
    }

    private void dataValid(CsOutResultOrderAddReqDto addReqDto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)addReqDto.getWarehouseCode()), "\u672a\u4f20\u5165\u4ed3\u5e93\u7f16\u7801");
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)addReqDto.getPreOrderNo()), "\u672a\u4f20\u5165\u524d\u7f6e\u4e1a\u52a1\u5355\u636e");
        AssertUtil.isTrue(addReqDto.getBusinessType() != null, "\u672a\u4f20\u5165\u7c7b\u578b");
        AssertUtil.isTrue(null != CsPcpBusinessTypeEnum.getByCode((String)addReqDto.getBusinessType()), "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
        List InOutNoticeOrderEos = this.inOutNoticeOrderDomain.queryByPreOrderNo(addReqDto.getPreOrderNo());
        if (BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_SALES_ISSUE.getCode().equals(addReqDto.getBusinessType())) {
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)InOutNoticeOrderEos), "\u524d\u7f6e\u5355\u636e\u4e0d\u5b58\u5728");
            addReqDto.setExternalOrderNo(((InOutNoticeOrderEo)InOutNoticeOrderEos.get(0)).getExternalOrderNo());
            addReqDto.setRelevanceNo(((InOutNoticeOrderEo)InOutNoticeOrderEos.get(0)).getDocumentNo());
        }
        List physicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(addReqDto.getWarehouseCode());
        List longCodeList = addReqDto.getDetailAddReqDtoList().stream().map(CsOutResultOrderDetailAddReqDto::getLongCode).collect(Collectors.toList());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)physicsWarehouseEos), "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(longCodeList), "\u8d27\u54c1\u4e0d\u5b58\u5728");
    }

    @Override
    public void update(Long id, CsOutResultOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        InOutResultOrderEo updateEo = new InOutResultOrderEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.inOutResultOrderDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        InOutResultOrderEo eo = this.csOutResultOrderQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        this.inOutResultOrderDomain.logicDeleteById(id);
    }

    @Override
    public String wmsSendBack(CsOutResultOrderAddReqDto csOutResultOrderAddReqDto) {
        logger.info("WMS\u53d1\u8d27\u56de\u4f20,\u751f\u6210\u51fa\u5e93\u7ed3\u679c\u5355\uff1a[addReqDto:{}]", (Object)LogUtils.buildLogContent(csOutResultOrderAddReqDto));
        csOutResultOrderAddReqDto.setOrderStatus(BaseOrderStatusEnum.ORO_DONE_OUT.getCode());
        csOutResultOrderAddReqDto.setBusinessType(CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode());
        Long id = this.add(csOutResultOrderAddReqDto);
        logger.info("WMS\u53d1\u8d27\u56de\u4f20,\u751f\u6210\u51fa\u5e93\u7ed3\u679c\u5355\uff1a[id:{}]", (Object)id);
        InOutResultOrderEo InOutResultOrderEo2 = (InOutResultOrderEo)this.inOutResultOrderDomain.getMapper().selectById((Serializable)id);
        QueryWrapper noticeOrderEoQueryWrapper = new QueryWrapper();
        noticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)csOutResultOrderAddReqDto.getRelevanceNo());
        List ReceiveDeliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)noticeOrderEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)ReceiveDeliveryNoticeOrderEoList), "\u67e5\u8be2\u4e0d\u5230\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f");
        Long deliveryResultOrderId = this.pcpDeliveryResultOrderService.createDeliveryResultOrder(InOutResultOrderEo2.getDocumentNo(), InOutResultOrderEo2.getRelevanceNo());
        ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo = this.csDeliveryResultOrderQueryService.selectByPrimaryKey(deliveryResultOrderId);
        csDeliveryResultOrderEo.setOrderStatus(BaseOrderStatusEnum.DRO_DELIVERED.getCode());
        csDeliveryResultOrderEo.setBusinessType(CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode());
        UpdateWrapper deliveryResultWrapper = new UpdateWrapper();
        deliveryResultWrapper.eq((Object)"id", (Object)csDeliveryResultOrderEo.getId());
        this.receiveDeliveryResultOrderDomain.getMapper().update((Object)csDeliveryResultOrderEo, (Wrapper)deliveryResultWrapper);
        ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo2 = (ReceiveDeliveryNoticeOrderEo)ReceiveDeliveryNoticeOrderEoList.get(0);
        ReceiveDeliveryNoticeOrderEo2.setOrderStatus(BaseOrderStatusEnum.DNO_TOTAL_DELIVERY.getCode());
        ReceiveDeliveryNoticeOrderEo2.setBusinessType(CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode());
        ReceiveDeliveryNoticeOrderEo2.setWmsOrderNo(csOutResultOrderAddReqDto.getWmsNo());
        UpdateWrapper deliveryNoticeWrapper = new UpdateWrapper();
        deliveryNoticeWrapper.eq((Object)"id", (Object)ReceiveDeliveryNoticeOrderEo2.getId());
        this.receiveDeliveryNoticeOrderDomain.getMapper().update((Object)ReceiveDeliveryNoticeOrderEo2, (Wrapper)deliveryNoticeWrapper);
        InOutNoticeOrderEo InOutNoticeOrderEo2 = new InOutNoticeOrderEo();
        InOutNoticeOrderEo2.setRelevanceNo(ReceiveDeliveryNoticeOrderEo2.getRelevanceNo());
        InOutNoticeOrderEo queryInOutNoticeOrderEo = (InOutNoticeOrderEo)this.inOutNoticeOrderDomain.selectOne((BaseEo)InOutNoticeOrderEo2);
        AssertUtil.isTrue(Objects.nonNull(queryInOutNoticeOrderEo), "\u67e5\u8be2\u4e0d\u5230\u51fa\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        queryInOutNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.ONO_TOTAL_OUT.getCode());
        queryInOutNoticeOrderEo.setWmsOrderNo(csOutResultOrderAddReqDto.getWmsNo());
        this.inOutNoticeOrderDomain.update((BaseEo)queryInOutNoticeOrderEo);
        QueryWrapper InOutNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
        InOutNoticeOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)queryInOutNoticeOrderEo.getDocumentNo());
        List InOutNoticeOrderDetailEos = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)InOutNoticeOrderDetailEoQueryWrapper);
        InOutNoticeOrderDetailEos.stream().forEach(eo -> {
            eo.setDoneQuantity(eo.getPlanQuantity());
            UpdateWrapper detailEoUpdateWrapper = new UpdateWrapper();
            detailEoUpdateWrapper.eq((Object)"id", (Object)eo.getId());
            this.inOutNoticeOrderDetailDomain.getMapper().update(eo, (Wrapper)detailEoUpdateWrapper);
        });
        QueryWrapper ReceiveDeliveryNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
        ReceiveDeliveryNoticeOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)ReceiveDeliveryNoticeOrderEo2.getDocumentNo());
        List ReceiveDeliveryNoticeOrderDetailEos = this.receiveDeliveryNoticeOrderDetailDomain.getMapper().selectList((Wrapper)ReceiveDeliveryNoticeOrderDetailEoQueryWrapper);
        ReceiveDeliveryNoticeOrderDetailEos.stream().forEach(eo -> {
            eo.setWaitQuantity(BigDecimal.ZERO);
            eo.setDoneQuantity(eo.getPlanQuantity());
            UpdateWrapper detailEoUpdateWrapper = new UpdateWrapper();
            detailEoUpdateWrapper.eq((Object)"id", (Object)eo.getId());
            this.receiveDeliveryNoticeOrderDetailDomain.getMapper().update(eo, (Wrapper)detailEoUpdateWrapper);
        });
        this.operateInventory(csOutResultOrderAddReqDto);
        logger.info("WMS\u53d1\u8d27\u56de\u4f20,\u51fa\u5e93\u5b8c\u6210");
        this.csInventoryPreemptionService.updateStatusDisableBySourceNo(csOutResultOrderAddReqDto.getPreOrderNo());
        logger.info("WMS\u53d1\u8d27\u56de\u4f20,\u53d8\u66f4\u9884\u5360\u8bb0\u5f55\u72b6\u6001\u5b8c\u6210");
        return null;
    }

    public void operateInventory(CsOutResultOrderAddReqDto addReqDto) {
        logger.info("operateInventory==>\u6a21\u62dfWMS\u53d1\u8d27\u56de\u4f20,\u51fa\u5e93\u903b\u8f91\u3001\u7269\u7406\u4ed3\u5e93\u5b58,cargoReqDto:{}", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(null != addReqDto, "\u53c2\u6570\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addReqDto.getWarehouseCode()), "\u53c2\u6570\u4e0d\u5b58\u5728");
        List detailAddReqDtoList = addReqDto.getDetailAddReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)detailAddReqDtoList), "\u8d27\u54c1\u4fe1\u606f\u53c2\u6570\u4e0d\u5b58\u5728");
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.PHYSICS.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(YesNoEnum.NO.getValue());
        csInventoryInOutBasicsDto.setSourceNo(addReqDto.getPreOrderNo());
        csInventoryInOutBasicsDto.setSourceType(CsInventorySourceTypeEnum.PCP_OUT_SALE_PREEMPT.getCode());
        csInventoryInOutBasicsDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        csInventoryInOutBasicsDto.setCoverInventoryFlag(CsInventoryCoverInventoryFlagEnum.UPDATE.getCode());
        csInventoryInOutBasicsDto.setUpdateTotalFlag(YesNoEnum.YES.getValue());
        for (CsOutResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setCargoCode(detailAddReqDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.NO.getValue());
            inOutBasicsCargoDto.setBalance(detailAddReqDto.getQuantity().abs().negate());
            inOutBasicsCargoDto.setPreempt(detailAddReqDto.getQuantity().abs().negate());
            inOutBasicsCargoDto.setWarehouseCode(addReqDto.getWarehouseCode());
            inOutBasicsCargoDto.setBatch(detailAddReqDto.getBatch());
            inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        csInventoryInOutBasicsDto.setOperateVersion(CsVersionDistinguishEnum.SECOND.getCode());
    }
}

