/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventoryBasicsService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventoryQueryService;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="inventoryStrategyUtils")
public class CsInventoryStrategyUtils {
    private static Logger logger = LoggerFactory.getLogger(CsInventoryStrategyUtils.class);
    @Autowired
    private List<ICsInventoryQueryService> inventoryQueryServiceList;
    private static Map<String, ICsInventoryBasicsService> inventoryBasicsServiceMap;
    private static Map<String, ICsInventoryQueryService> inventoryQueryServiceMap;
    public static final String PREFIX = "Cs";
    public static final String SUFFIX = "inventoryStrategyService";
    public static final String QUERY_SUFFIX = "inventoryStrategyQueryService";
    public static final String COMMON = "common";
    public static final String PHYSICS = "physics";
    public static final String LOGIC = "logic";
    public static final String VIRTUAL = "virtual";
    public static final String CHANNEL = "channel";
    public static final String ACTIVITY = "activity";

    @PostConstruct
    public void initStrategy() {
        inventoryQueryServiceMap = this.inventoryQueryServiceList.stream().collect(Collectors.toMap(ICsInventoryQueryService::getStrategy, Function.identity()));
    }

    public static ICsInventoryQueryService getInventoryQueryService(String strategy) {
        logger.info("getInventoryService==>\u6839\u636e\u4f20\u5165\u7684\u7b56\u7565\u83b7\u53d6\u5bf9\u5e94\u7684\u5e93\u5b58\u67e5\u8be2\u7b56\u7565\u7c7b,strategy:{}", (Object)strategy);
        if (StringUtils.isBlank((CharSequence)strategy)) {
            return inventoryQueryServiceMap.get(CsInventoryStrategyEnum.COMMON.getCode());
        }
        CsInventoryStrategyEnum inventoryStrategyEnum = CsInventoryStrategyEnum.getByCode((String)strategy);
        if (null == inventoryStrategyEnum) {
            throw new BizException("\u5e93\u5b58\u7b56\u7565\u6709\u8bef~");
        }
        return inventoryQueryServiceMap.get(inventoryStrategyEnum.getCode());
    }

    public static ICsInventoryBasicsService getInventoryService(String strategy) {
        logger.info("getInventoryService==>\u6839\u636e\u4f20\u5165\u7684\u7b56\u7565\u83b7\u53d6\u5bf9\u5e94\u7684\u5e93\u5b58\u64cd\u4f5c\u7b56\u7565\u7c7b,strategy:{}", (Object)strategy);
        if (StringUtils.isBlank((CharSequence)strategy)) {
            return inventoryBasicsServiceMap.get(CsInventoryStrategyEnum.COMMON.getCode());
        }
        CsInventoryStrategyEnum inventoryStrategyEnum = CsInventoryStrategyEnum.getByCode((String)strategy);
        if (null == inventoryStrategyEnum) {
            throw new BizException("\u5e93\u5b58\u7b56\u7565\u6709\u8bef~");
        }
        return inventoryBasicsServiceMap.get(inventoryStrategyEnum.getCode());
    }
}

