/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl;

import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.IConsignmentOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ConsignmentOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ConsignmentSignDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IConsignmentOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.SyncAreaReqDto;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsignmentOrderApiImpl
implements IConsignmentOrderApi {
    @Resource
    private IConsignmentOrderService consignmentOrderService;
    @Autowired
    ILockService lockService;

    public RestResponse<Long> addConsignmentOrder(ConsignmentOrderReqDto addReqDto) {
        return new RestResponse((Object)this.consignmentOrderService.addConsignmentOrder(addReqDto));
    }

    public RestResponse<Void> modifyConsignmentOrder(ConsignmentOrderReqDto modifyReqDto) {
        this.consignmentOrderService.modifyConsignmentOrder(modifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeConsignmentOrder(String ids, Long instanceId) {
        this.consignmentOrderService.removeConsignmentOrder(ids, instanceId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> sign(ConsignmentSignDto signDto) {
        AssertUtil.assertNotBlank(signDto.getWmsConsignmentNo(), "\u6258\u8fd0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        AssertUtil.assertNotNull(signDto.getSignTime(), "\u7b7e\u6536\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Mutex mutex = this.lockService.lock("ConsignmentOrderApiImpl:sign", signDto.getWmsConsignmentNo(), 30, 35, TimeUnit.SECONDS);
        try {
            this.consignmentOrderService.sign(signDto);
        }
        finally {
            this.lockService.unlock(mutex);
        }
        return RestResponse.VOID;
    }

    public RestResponse<Void> syncAreaInfo(final SyncAreaReqDto reqDto) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ConsignmentOrderApiImpl.this.consignmentOrderService.syncAreaInfo(reqDto);
            }
        }).start();
        return RestResponse.VOID;
    }
}

