/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.order.recipt.ITcbjReciptApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.order.ITcbjReciptService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.SimpleRequestDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjNotiGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjResGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.TcbjResDetailCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjReCheckReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.InDraOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.recipt.TcbjReciptAuReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.recipt.TcbjReciptNotiDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.recipt.TcbjReciptNotiReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.recipt.TcbjReciptNotiRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.recipt.TcbjReciptResDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.recipt.TcbjReciptResReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.recipt.TcbjReciptResRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="tcbjReciptApi")
public class TcbjReciptApiImpl
implements ITcbjReciptApi {
    Logger logger = LoggerFactory.getLogger(TcbjReciptApiImpl.class);
    @Resource
    ITcbjReciptService tcbjReciptService;

    public RestResponse<PageInfo<TcbjReciptNotiRespDto>> notiPage(TcbjReciptNotiReqDto queryDto) {
        return this.tcbjReciptService.notiPage(queryDto);
    }

    public RestResponse<TcbjReciptNotiDetailRespDto> notiDetail(SimpleRequestDto dto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)dto.getNo()), "\u672a\u4f20\u5165\u5355\u53f7");
        return this.tcbjReciptService.notiDetail(dto);
    }

    public RestResponse<PageInfo<TcbjReciptResRespDto>> resPage(TcbjReciptResReqDto queryDto) {
        return this.tcbjReciptService.resPage(queryDto);
    }

    public RestResponse<TcbjReciptResDetailRespDto> resDetail(SimpleRequestDto dto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)dto.getNo()), "\u672a\u4f20\u5165\u5355\u53f7");
        return this.tcbjReciptService.resDetail(dto);
    }

    public RestResponse<String> send(TcbjNotiGenReqDto reqDto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)reqDto.getWarehouseCode()), "\u672a\u4f20\u5165\u4ed3\u5e93\u7f16\u7801");
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)reqDto.getPreNo()), "\u672a\u4f20\u5165\u524d\u7f6e\u4e1a\u52a1\u5355\u636e");
        AssertUtil.isTrue(reqDto.getType() != null, "\u672a\u4f20\u5165\u7c7b\u578b");
        return this.tcbjReciptService.send(reqDto);
    }

    public RestResponse<String> sendback(TcbjResGenReqDto reqDto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)reqDto.getWarehouseCode()), "\u672a\u4f20\u5165\u4ed3\u5e93\u7f16\u7801");
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)reqDto.getPreNo()), "\u672a\u4f20\u5165\u524d\u7f6e\u4e1a\u52a1\u5355\u636e");
        AssertUtil.isTrue(reqDto.getType() != null, "\u672a\u4f20\u5165\u7c7b\u578b");
        return this.tcbjReciptService.sendback(reqDto);
    }

    public RestResponse<String> cancel(SimpleRequestDto dto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)dto.getNo()), "\u672a\u4f20\u5165\u5355\u53f7");
        return this.tcbjReciptService.cancel(dto);
    }

    public RestResponse<List<TcbjResDetailCargoRespDto>> inNum(SimpleRequestDto dto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)dto.getNo()), "\u672a\u4f20\u5165\u5355\u53f7");
        return this.tcbjReciptService.inNum(dto);
    }

    public RestResponse<String> audit(TcbjReciptAuReqDto dto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)dto.getPreNo()), "\u672a\u4f20\u5165\u5355\u53f7");
        AssertUtil.isTrue(dto.getStatus() != null, "\u672a\u4f20\u5165\u72b6\u6001");
        return this.tcbjReciptService.audit(dto);
    }

    public RestResponse<List<InDraOrderRespDto>> inOrderQuery(SimpleRequestDto dto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)dto.getPreNo()), "\u672a\u4f20\u5165pre\u5355\u53f7");
        return this.tcbjReciptService.inOrderQuery(dto);
    }

    public RestResponse<Void> refundModifyNotifyStatus(TcbjResGenReqDto resGenReqDto) {
        this.logger.info("refundModifyNotifyStatus==>resGenReqDto:{}", (Object)LogUtils.buildLogContent(resGenReqDto));
        this.tcbjReciptService.refundModifyNotifyStatus(resGenReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> reCheckInInventory(TcbjReCheckReqDto reCheckReqDto) {
        this.logger.info("reCheckInInventory==>\u590d\u6838\u5165\u5e93,reCheckReqDto:{}", (Object)LogUtils.buildLogContent(reCheckReqDto));
        this.tcbjReciptService.reCheckInInventory(reCheckReqDto);
        return RestResponse.VOID;
    }
}

