/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.basics.CsCommonBasicsOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsOrderNextStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsOrderStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CsDeliveryNoticeOrderApiImpl
implements ICsDeliveryNoticeOrderApi {
    private static final Logger log = LoggerFactory.getLogger(CsDeliveryNoticeOrderApiImpl.class);
    @Resource
    protected ICsDeliveryNoticeOrderService csDeliveryNoticeOrderService;
    @Resource
    protected ICsOrderQueryService csOrderQueryService;
    @Resource
    protected ICsDeliveryNoticeOrderQueryService csDeliveryNoticeOrderQueryService;
    @Resource
    protected ICsRelWarehouseQueryService csRelWarehouseQueryService;
    @Resource
    protected ICsOutNoticeOrderService csOutNoticeOrderService;

    public RestResponse<Long> add(CsDeliveryNoticeOrderAddReqDto addReqDto) {
        log.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        return new RestResponse((Object)this.csDeliveryNoticeOrderService.add(addReqDto));
    }

    public RestResponse<Void> update(Long id, CsDeliveryNoticeOrderUpdateReqDto updateReqDto) {
        log.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csDeliveryNoticeOrderService.update(id, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        log.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csDeliveryNoticeOrderService.delete(id);
        return RestResponse.VOID;
    }

    public RestResponse<Void> updateOrderStatus(String preOrderNo, String action) {
        this.csDeliveryNoticeOrderService.updateOrderStatus(preOrderNo, action);
        return RestResponse.VOID;
    }

    public RestResponse<Void> onlyUpdateDocumentStatus(String preOrderNo, String orderStatus) {
        this.csDeliveryNoticeOrderService.onlyUpdateDocumentStatus(preOrderNo, orderStatus);
        return RestResponse.VOID;
    }

    public RestResponse<Void> CreateDeliverInformOrderProcess2(MessageVo messageVo) {
        return RestResponse.VOID;
    }

    public RestResponse<String> updateDetailBatchByPreOrderNo(String preOrderNo) {
        return new RestResponse(null);
    }

    public RestResponse<Integer> updateDetailBatch(CsInventoryOperateReqDto csInventoryOperateReqDto) {
        Integer num = this.csDeliveryNoticeOrderService.updateDetailBatch(csInventoryOperateReqDto);
        return new RestResponse((Object)num);
    }

    public RestResponse<Boolean> createDeliveryByOrderNo(String orderNo) {
        return new RestResponse((Object)true);
    }

    public RestResponse<Boolean> batchUpdateNoticeStatusPass(List<String> preOrderNoList) {
        return new RestResponse((Object)false);
    }

    public RestResponse<Boolean> batchUpdateNoticeStatusNoPass(List<String> preOrderNoList) {
        Boolean statusPass = this.csDeliveryNoticeOrderService.batchUpdateNoticeStatusNoPass(preOrderNoList);
        return new RestResponse((Object)statusPass);
    }

    public RestResponse<Long> addBaseOrder(CsCommonBasicsOrderReqDto addReqDto) {
        return new RestResponse();
    }

    public RestResponse<Boolean> cancelByDocumentNo(String cancelByDocumentNo) {
        return null;
    }

    public RestResponse<String> finishByDocumentNo(String documentNo) {
        return new RestResponse((Object)this.csOutNoticeOrderService.finishByDocumentNo(documentNo));
    }

    private CsBasicsOrderReqDto joinParam(CsCommonBasicsOrderReqDto addReqDto) {
        CsBasicsOrderNextStatusEnum orderNextStatusEnum;
        CsBasicsOrderReqDto csBasicsOrderReqDto = new CsBasicsOrderReqDto();
        CubeBeanUtils.copyProperties((Object)csBasicsOrderReqDto, (Object)addReqDto, (String[])new String[0]);
        csBasicsOrderReqDto.setOrderBasicsDetailReqDtoList(addReqDto.getOrderBasicsDetailReqDtoList());
        List<RelWarehouseEo> csRelWarehouseEoList = this.csRelWarehouseQueryService.queryByWarehouseCode(addReqDto.getLogicWarehouseCode(), CsWarehouseClassifyEnum.LOGIC.getCode());
        if (CollectionUtils.isNotEmpty(csRelWarehouseEoList)) {
            RelWarehouseEo csRelWarehouseEo = csRelWarehouseEoList.get(0);
            csBasicsOrderReqDto.setLogicWarehouseName(csRelWarehouseEo.getWarehouseName());
            csBasicsOrderReqDto.setInLogicWarehouseCode(csRelWarehouseEo.getWarehouseCode());
            csBasicsOrderReqDto.setInLogicWarehouseName(csRelWarehouseEo.getWarehouseName());
            csBasicsOrderReqDto.setPhysicsWarehouseCode(csRelWarehouseEo.getRefWarehouseCode());
            csBasicsOrderReqDto.setPhysicsWarehouseName(csRelWarehouseEo.getRefWarehouseName());
            csBasicsOrderReqDto.setInPhysicsWarehouseCode(csRelWarehouseEo.getRefWarehouseCode());
            csBasicsOrderReqDto.setInPhysicsWarehouseName(csRelWarehouseEo.getRefWarehouseName());
        }
        AssertUtil.isTrue(null != (orderNextStatusEnum = CsBasicsOrderNextStatusEnum.getInitStatus((String)addReqDto.getStrategy(), (String)addReqDto.getBasicsOrderOperateType())), "\u57fa\u7840\u5355\u636e\u751f\u6210\u6682\u672a\u914d\u7f6e\uff0c\u656c\u8bf7\u671f\u5f85");
        String orderStatus = orderNextStatusEnum.getOrderStatus();
        csBasicsOrderReqDto.setSourceType(csBasicsOrderReqDto.getBusinessType());
        csBasicsOrderReqDto.setOrderStatus(orderStatus);
        return csBasicsOrderReqDto;
    }

    private void validParam(CsCommonBasicsOrderReqDto addReqDto) {
        CsBasicsOrderStrategyEnum orderStrategyEnum = CsBasicsOrderStrategyEnum.getByCode((String)addReqDto.getStrategy());
        AssertUtil.isTrue(null != orderStrategyEnum, "\u5355\u636e\u64cd\u4f5c\u7b56\u7565\u6709\u8bef");
        String relevanceTableName = CsRelevanceTableNameEnum.getDescByCode((String)addReqDto.getRelevanceTableName());
        AssertUtil.isTrue(null != relevanceTableName, "\u5173\u8054\u5355\u636e\u8868\u6307\u5b9a\u6709\u8bef");
    }

    private CsInventoryOperateReqDto structureParam(CsDeliveryNoticeOrderAddReqDto addReqDto) {
        CsInventoryOperateReqDto dto = new CsInventoryOperateReqDto();
        dto.setSourceNo(addReqDto.getPreOrderNo());
        dto.setSourceType(CsInventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
        dto.setNegativeValidate(YesNoEnum.YES.getValue());
        ArrayList<CsInventoryOperateCargoReqDto> operateCargoReqDtoList = new ArrayList<CsInventoryOperateCargoReqDto>();
        for (CsDeliveryNoticeOrderDetailAddReqDto detailRespDto : addReqDto.getDetailAddReqDtoList()) {
            CsInventoryOperateCargoReqDto cargoReqDto = new CsInventoryOperateCargoReqDto();
            cargoReqDto.setCargoCode(detailRespDto.getCargoCode());
            cargoReqDto.setWarehouseCode(addReqDto.getWarehouseCode());
            cargoReqDto.setBatch(detailRespDto.getBatch());
            cargoReqDto.setActivityId(detailRespDto.getActivityId());
            cargoReqDto.setChangeInventory(detailRespDto.getPlanQuantity());
            operateCargoReqDtoList.add(cargoReqDto);
        }
        dto.setOperateCargoReqDtoList(operateCargoReqDtoList);
        return dto;
    }
}

