/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.IOrderPreemptWrapperHelper;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogicInventoryExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryDateUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryReleasePreemptOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicPreemptInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderCommonCancelBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.transaction.annotation.Transactional;

public abstract class CsLogicInventoryExposedApiImpl
implements ICsLogicInventoryExposedApi {
    private static final Logger log = LoggerFactory.getLogger(CsLogicInventoryExposedApiImpl.class);
    @Autowired
    protected ILogicInventoryTotalDomain logicInventoryTotalDomain;
    @Autowired
    protected BaseOrderFacade baseOrderFacade;
    @Resource
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private CsLogicInventoryExposedApiImpl csLogicInventoryExposedApiImpl;
    @Resource
    private ILockService lockService;
    @Resource
    private IOrderPreemptWrapperHelper orderPreemptWrapperHelper;
    @Resource
    private ICsLogicInventoryExposedService csLogicInventoryExposedService;

    public RestResponse<Boolean> preemptInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        log.info("preemptInventory==>\u903b\u8f91\u4ed3\u5e93\u5b58\u9884\u5360,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        return null;
    }

    public RestResponse<Boolean> preemptOrderInventory(CsLogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        log.info("preemptOrderInventory==>\u5e93\u5b58\u9884\u5360\uff0c\u5305\u542b\u5355\u636e\u64cd\u4f5c-\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,logicPreemptInventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(logicPreemptInventoryOperateReqDto));
        return null;
    }

    public RestResponse<Boolean> cancelOrder(String orderNo) {
        log.info("cancelOrder:{}", (Object)JSON.toJSONString((Object)orderNo));
        return null;
    }

    public RestResponse<Boolean> releaseInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        log.info("releaseInventory==>\u903b\u8f91\u4ed3\u5e93\u5b58\u91ca\u653e,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        return null;
    }

    public RestResponse<Boolean> releaseInventoryByPreemption(CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto) {
        log.info("releaseInventoryByPreemption==>\u6839\u636e\u9884\u5360\u8bb0\u5f55\uff0c\u91ca\u653e\u4e4b\u524d\u9884\u5360\u7684\u5e93\u5b58,releasePreemptOperateReqDto:{}", (Object)LogUtils.buildLogContent(releasePreemptOperateReqDto));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse<CsInventoryOperateRespDto> preemptInventoryBackResult(CsLogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        log.info("preemptInventoryBackResult==>\u9884\u5360\u903b\u8f91\u4ed3\u5e93\u5b58,logicPreemptInventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(logicPreemptInventoryOperateReqDto));
        CsInventoryOperateReqDto inventoryOperateReqDto = logicPreemptInventoryOperateReqDto.getInventoryOperateReqDto();
        ArrayList<CsInventoryBasicsCargoRespDto> basicsCargoRespDtos = new ArrayList<CsInventoryBasicsCargoRespDto>();
        for (CsInventoryOperateCargoReqDto detailReqDto : inventoryOperateReqDto.getOperateCargoReqDtoList()) {
            CsInventoryBasicsCargoRespDto basicsCargoRespDto = new CsInventoryBasicsCargoRespDto();
            basicsCargoRespDto.setCargoCode(StringUtils.isNotBlank((CharSequence)detailReqDto.getCargoCode()) ? detailReqDto.getCargoCode() : detailReqDto.getLongCode());
            basicsCargoRespDto.setLongCode(StringUtils.isNotBlank((CharSequence)detailReqDto.getCargoCode()) ? detailReqDto.getCargoCode() : detailReqDto.getLongCode());
            basicsCargoRespDto.setWarehouseCode(detailReqDto.getWarehouseCode());
            basicsCargoRespDtos.add(basicsCargoRespDto);
        }
        CsInventoryOperateRespDto inventoryOperateRespDto = new CsInventoryOperateRespDto();
        CsInventoryBasicsRespDto inventoryBasicsRespDto = new CsInventoryBasicsRespDto();
        CubeBeanUtils.copyProperties((Object)inventoryBasicsRespDto, (Object)inventoryOperateReqDto, (String[])new String[0]);
        Mutex mutex = this.lockService.lock("preemptInventoryBackResult", inventoryOperateReqDto.getSourceNo(), 20, 25, TimeUnit.SECONDS);
        try {
            this.csLogicInventoryExposedApiImpl.releaseAndPreemptInventoryAddDeliveryNoticeOrder(logicPreemptInventoryOperateReqDto);
            basicsCargoRespDtos.forEach(e -> e.setOperateFlag(Boolean.valueOf(true)));
            inventoryBasicsRespDto.setSuccessList(basicsCargoRespDtos);
        }
        catch (Exception exception) {
            log.info("Exception\u9884\u5360\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)exception.getLocalizedMessage());
            String[] split = exception.getLocalizedMessage().split(";");
            String flag = "\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3\uff0c\u903b\u8f91\u4ed3\u7f16\u7801";
            if (split.length > 0 && split[0].startsWith(flag)) {
                Set failList = Stream.of(split).map(r -> {
                    int skuInx = r.indexOf("SKU\u7f16\u7801");
                    String warehouseCode = r.substring(14, skuInx - 2);
                    String skuCode = r.substring(skuInx + 7, r.indexOf("[\u5f53\u524d\u53ef\u7528\u5e93\u5b58") - 1);
                    return warehouseCode + "_" + skuCode;
                }).collect(Collectors.toSet());
                basicsCargoRespDtos.forEach(e -> e.setOperateFlag(Boolean.valueOf(!failList.contains(e.getWarehouseCode() + "_" + e.getLongCode()))));
            } else {
                basicsCargoRespDtos.forEach(e -> e.setOperateFlag(Boolean.valueOf(false)));
            }
            inventoryBasicsRespDto.setFailList(basicsCargoRespDtos);
        }
        finally {
            this.lockService.unlock(mutex);
        }
        this.buildRespInfo(inventoryOperateRespDto, inventoryBasicsRespDto, inventoryOperateReqDto.getOperateCargoReqDtoList());
        log.info("preemptInventoryBackResult==>\u8fd4\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateRespDto));
        return new RestResponse((Object)inventoryOperateRespDto);
    }

    public RestResponse<Boolean> releaseAndpreemptInventory(CsLogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        log.info("releaseAndpreemptInventory==>\u91ca\u653e\u5355\u636e\u539f\u5df2\u9884\u5360\u7684\u903b\u8f91\u4ed3\u5e93\u5b58\u5e76\u4e14\u6839\u636e\u4fe1\u606f\u91cd\u65b0\u9884\u5360,logicPreemptInventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(logicPreemptInventoryOperateReqDto));
        Mutex mutex = this.lockService.lock("releaseAndpreemptInventory", logicPreemptInventoryOperateReqDto.getInventoryOperateReqDto().getSourceNo(), 20, 25, TimeUnit.SECONDS);
        try {
            this.csLogicInventoryExposedApiImpl.releaseAndPreemptInventoryAddDeliveryNoticeOrder(logicPreemptInventoryOperateReqDto);
        }
        finally {
            this.lockService.unlock(mutex);
        }
        return new RestResponse((Object)Boolean.TRUE);
    }

    @Transactional(rollbackFor={Exception.class})
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public void releaseAndPreemptInventoryAddDeliveryNoticeOrder(final CsLogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo;
        final CsInventoryOperateReqDto inventoryOperateReqDto = logicPreemptInventoryOperateReqDto.getInventoryOperateReqDto();
        List warehouseCodeLongCodeList = inventoryOperateReqDto.getOperateCargoReqDtoList().stream().sorted(Comparator.comparing(CsInventoryOperateCargoReqDto::getWarehouseCode)).sorted(Comparator.comparing(CsInventoryOperateCargoReqDto::getLongCode)).map(e -> e.getWarehouseCode() + "_" + e.getLongCode()).distinct().collect(Collectors.toList());
        log.info("\u6839\u636e\u4ed3\u5e93\u7f16\u7801\u3001\u4ea7\u54c1\u7f16\u7801\u6392\u5e8fwarehouseCodeLongCodeList:{}", (Object)JSON.toJSONString(warehouseCodeLongCodeList));
        LogicWarehouseEo warehouse = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)((CsInventoryOperateCargoReqDto)logicPreemptInventoryOperateReqDto.getInventoryOperateReqDto().getOperateCargoReqDtoList().get(0)).getWarehouseCode())).one();
        AssertUtil.isTrue(Objects.nonNull(warehouse), "\u4ed3\u5e93\u4e0d\u5b58\u5728:{}", inventoryOperateReqDto.getLogicWarehouseCode());
        List deliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.queryByRelevanceNo(inventoryOperateReqDto.getSourceNo());
        log.info("deliveryNoticeOrderEoList:{}", (Object)JSON.toJSONString((Object)deliveryNoticeOrderEoList));
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = deliveryNoticeOrderEo = CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderEoList) ? (ReceiveDeliveryNoticeOrderEo)deliveryNoticeOrderEoList.get(0) : null;
        if (Objects.nonNull(deliveryNoticeOrderEo) && !BaseOrderStatusEnum.DNO_CANCEL.getCode().equals(deliveryNoticeOrderEo.getOrderStatus())) {
            String sourceType = StringUtils.isNotBlank((CharSequence)inventoryOperateReqDto.getSourceType()) ? inventoryOperateReqDto.getSourceType() : CsInventorySourceTypeEnum.PCP_OUT_SALE_PREEMPT.getCode();
            BaseOrderCommonCancelBo commonCancelBo = BaseOrderCommonCancelBo.builder().documentNo(deliveryNoticeOrderEo.getDocumentNo()).sourceType(sourceType).build();
            log.info("\u8c03\u7528\u57fa\u7ebf\u53d6\u6d88\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)commonCancelBo));
            this.baseOrderFacade.deliveryNoticeOrderCancel(commonCancelBo);
        }
        ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo = this.orderPreemptWrapperHelper.getPreemptFacadeBo(inventoryOperateReqDto);
        receiveDeliveryNoticeOrderFacadeBo.setSourceType(CsInventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_SALE);
        receiveDeliveryNoticeOrderFacadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                ReceiveDeliveryNoticeOrderContext context1 = (ReceiveDeliveryNoticeOrderContext)context;
                context1.setGenerateInOut(Boolean.valueOf(false));
                CsLogicInventoryExposedApiImpl.this.orderPreemptWrapperHelper.wrapperOrderInfo(context1, inventoryOperateReqDto, logicPreemptInventoryOperateReqDto);
                log.info("releaseAndPreemptInventoryAddDeliveryNoticeOrder\u8bbe\u7f6eReceiveDeliveryNoticeOrderContext\u5b8c\u6210\uff1a{}", (Object)JSON.toJSONString((Object)context1));
            }

            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
        this.baseOrderFacade.deliveryNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
    }

    private void buildRespInfo(CsInventoryOperateRespDto inventoryOperateRespDto, CsInventoryBasicsRespDto inventoryBasicsRespDto, List<CsInventoryOperateCargoReqDto> operateCargoList) {
        List failList;
        inventoryOperateRespDto.setInventoryStrategy(inventoryBasicsRespDto.getInventoryStrategy());
        inventoryOperateRespDto.setBusinessType(inventoryBasicsRespDto.getBusinessType());
        inventoryOperateRespDto.setSourceNo(inventoryBasicsRespDto.getSourceNo());
        inventoryOperateRespDto.setSourceType(inventoryBasicsRespDto.getSourceType());
        inventoryOperateRespDto.setPlatformOrderNo(inventoryBasicsRespDto.getPlatformOrderNo());
        inventoryOperateRespDto.setPortionSuccessFlag(Boolean.valueOf(CollectionUtils.isNotEmpty((Collection)inventoryBasicsRespDto.getFailList())));
        inventoryOperateRespDto.setOperateCargoReqDtoList(operateCargoList);
        List successList = inventoryBasicsRespDto.getSuccessList();
        if (CollectionUtils.isNotEmpty((Collection)successList)) {
            ArrayList successRespList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)successRespList, (Collection)successList, CsInventoryOperateCargoRespDto.class);
            inventoryOperateRespDto.setSuccessList((List)successRespList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(failList = inventoryBasicsRespDto.getFailList()))) {
            ArrayList failRespList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)failRespList, (Collection)failList, CsInventoryOperateCargoRespDto.class);
            inventoryOperateRespDto.setFailList((List)failRespList);
            this.queryFailAvailableInventory(inventoryOperateRespDto);
        }
    }

    private void queryFailAvailableInventory(CsInventoryOperateRespDto inventoryOperateRespDto) {
        List failList = inventoryOperateRespDto.getFailList();
        if (CollectionUtils.isEmpty((Collection)failList)) {
            return;
        }
        log.info("queryAvailableInventory==>\u67e5\u8be2\u5931\u8d25\u7684sku\u96c6\u5408\u7684\u53ef\u7528\u5e93\u5b58\u4fe1\u606f,failList:{}", (Object)LogUtils.buildLogContent(failList));
        List longCodeList = failList.stream().map(CsInventoryOperateCargoRespDto::getLongCode).collect(Collectors.toList());
        List warehouseCodeList = failList.stream().map(CsInventoryOperateCargoRespDto::getWarehouseCode).collect(Collectors.toList());
        QueryWrapper csLogicInventoryEoQueryWrapper = new QueryWrapper();
        csLogicInventoryEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csLogicInventoryEoQueryWrapper.in((Object)"sku_code", longCodeList);
        csLogicInventoryEoQueryWrapper.in((Object)"warehouse_code", warehouseCodeList);
        List logicInventoryEoList = this.logicInventoryTotalDomain.getMapper().selectList((Wrapper)csLogicInventoryEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)logicInventoryEoList)) {
            return;
        }
        Map csLogicInventoryEoMap = logicInventoryEoList.stream().collect(Collectors.toMap(eo -> eo.getSkuCode() + "_" + eo.getWarehouseCode(), Function.identity()));
        for (CsInventoryOperateCargoRespDto cargoRespDto : failList) {
            String key = cargoRespDto.getLongCode() + "_" + cargoRespDto.getWarehouseCode();
            cargoRespDto.setAvailable(BigDecimal.ZERO);
            LogicInventoryTotalEo csLogicInventoryEo = (LogicInventoryTotalEo)csLogicInventoryEoMap.get(key);
            if (null == csLogicInventoryEo) continue;
            cargoRespDto.setAvailable(csLogicInventoryEo.getAvailable());
        }
        log.info("queryAvailableInventory==>\u67e5\u8be2\u5931\u8d25\u7684sku\u96c6\u5408\u7684\u53ef\u7528\u5e93\u5b58\u4fe1\u606f,\u5904\u7406\u5b8c\u6210\u53ef\u7528\u4fe1\u606f\u540e,failList:{}", (Object)LogUtils.buildLogContent(failList));
    }

    public RestResponse<Boolean> batchUpdateInventoryDate(List<CsInventoryDateUpdateReqDto> inventoryDateUpdateReqDtoList) {
        Boolean releaseFlag = this.csLogicInventoryExposedService.batchUpdateInventoryDate(inventoryDateUpdateReqDtoList);
        return new RestResponse((Object)releaseFlag);
    }
}

