/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.receive.IReceiveStrategyQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.receive.IReceiveStrategyChannelService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.receive.IReceiveStrategyService;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.receive.ReceiveStrategyPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.receive.ReceiveStrategyParamQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.receive.ReceiveStrategyChannelRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.receive.ReceiveStrategyDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.receive.ReceiveStrategyPageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.receive.ReceiveStrategyRespDto;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;

public abstract class ReceiveStrategyQueryApiImpl
implements IReceiveStrategyQueryApi {
    @Resource
    protected IReceiveStrategyService receiveStrategyService;
    @Resource
    protected IReceiveStrategyChannelService channelService;

    public RestResponse<ReceiveStrategyRespDto> queryById(Long id) {
        PageInfo<ReceiveStrategyChannelRespDto> channelRespDtoPageInfo;
        ReceiveStrategyRespDto dto = this.receiveStrategyService.queryById(id);
        if (Objects.isNull(dto) || Objects.isNull(dto.getChannelScope())) {
            return new RestResponse();
        }
        if (!dto.getChannelScope().equals("all") && CollectionUtil.isNotEmpty((Collection)(channelRespDtoPageInfo = this.channelService.queryByPage("{'strategyCode':'" + dto.getStrategyCode() + "'}", 1, 1000)).getList())) {
            dto.setChannelList(channelRespDtoPageInfo.getList());
        }
        return new RestResponse((Object)dto);
    }

    public RestResponse<PageInfo<ReceiveStrategyRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PageInfo<ReceiveStrategyRespDto> pageInfo = this.receiveStrategyService.queryByPage(filter, pageNum, pageSize);
        pageInfo.getList().stream().forEach(receiveStrategyRespDto -> {
            if (receiveStrategyRespDto.getChannelScope().equals("all")) {
                receiveStrategyRespDto.setChannels("\u5168\u90e8");
            } else {
                PageInfo<ReceiveStrategyChannelRespDto> channelRespDtoPageInfo = this.channelService.queryByPage("{'strategyCode':'" + receiveStrategyRespDto.getStrategyCode() + "'}", 1, 1000);
                if (CollectionUtil.isNotEmpty((Collection)channelRespDtoPageInfo.getList())) {
                    List channelList = channelRespDtoPageInfo.getList().stream().map(ReceiveStrategyChannelRespDto::getChannelName).collect(Collectors.toList());
                    String channels = StringUtils.join(channelList, (String)",");
                    receiveStrategyRespDto.setChannels(channels);
                }
            }
            if (receiveStrategyRespDto.getEndTime().compareTo(new Date()) < 0) {
                receiveStrategyRespDto.setEffectiveTag("\u5df2\u5931\u6548");
            } else if (receiveStrategyRespDto.getEndTime().compareTo((Date)DateUtil.offsetDay((Date)new Date(), (int)30)) < 0) {
                receiveStrategyRespDto.setEffectiveTag("\u5c06\u5931\u6548");
            }
        });
        return new RestResponse(pageInfo);
    }

    public RestResponse<ReceiveStrategyDetailRespDto> queryReceiveStrategyDetail(String strategyCode) {
        ReceiveStrategyDetailRespDto respDto = this.receiveStrategyService.queryReceiveStrategyDetail(strategyCode);
        return new RestResponse((Object)respDto);
    }

    public RestResponse<PageInfo<ReceiveStrategyPageRespDto>> queryPage(ReceiveStrategyPageQueryReqDto relWarehouseShipmentPageQueryDto) {
        PageInfo<ReceiveStrategyPageRespDto> pageInfo = this.receiveStrategyService.queryPage(relWarehouseShipmentPageQueryDto);
        return new RestResponse(pageInfo);
    }

    public RestResponse<List<ReceiveStrategyPageRespDto>> queryParam(ReceiveStrategyParamQueryReqDto receiveStrategyParamQueryReqDto) {
        List<ReceiveStrategyPageRespDto> respDtoList = this.receiveStrategyService.queryParam(receiveStrategyParamQueryReqDto);
        return new RestResponse(respDtoList);
    }
}

