/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsRelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsRelWarehouseRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class RelWarehouseApiImpl
implements ICsRelWarehouseApi {
    private static final Logger log = LoggerFactory.getLogger(RelWarehouseApiImpl.class);
    @Autowired
    protected ICsRelWarehouseService csRelWarehouseService;
    @Autowired
    protected ICsRelWarehouseQueryService csRelWarehouseQueryService;

    public RestResponse<Long> add(CsRelWarehouseAddReqDto addReqDto) {
        log.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        return new RestResponse((Object)this.csRelWarehouseService.add(addReqDto));
    }

    public RestResponse<Void> update(Long id, CsRelWarehouseUpdateReqDto updateReqDto) {
        log.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        this.csRelWarehouseService.update(id, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        log.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        this.csRelWarehouseService.delete(id);
        return RestResponse.VOID;
    }

    public RestResponse<CsRelWarehouseRespDto> queryByPrimaryKey(Long id) {
        log.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        RelWarehouseEo eo = this.csRelWarehouseQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        CsRelWarehouseRespDto dto = new CsRelWarehouseRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)eo, (String[])new String[0]);
        return new RestResponse((Object)dto);
    }

    public RestResponse<PageInfo<CsRelWarehouseRespDto>> queryByPage(CsRelWarehouseQueryDto queryDto) {
        PageInfo<CsRelWarehouseRespDto> pageInfo = this.csRelWarehouseQueryService.queryByPage(queryDto);
        return new RestResponse(pageInfo);
    }

    public RestResponse<List<CsRelWarehouseRespDto>> queryWarehouseByConditions(CsRelWarehouseQueryDto queryDto) {
        return new RestResponse(this.csRelWarehouseQueryService.queryWarehouseByConditions(queryDto));
    }

    public RestResponse<List<CsRelWarehouseRespDto>> queryList(CsRelWarehouseQueryDto queryDto) {
        return new RestResponse(this.csRelWarehouseQueryService.queryList(queryDto));
    }
}

